/*
 * Decompiled with CFR 0.152.
 */
package com.hardwire.dymix;

import com.hardwire.dymix.CollisionProxy;
import com.hardwire.dymix.DynamicWorld;
import com.hardwire.dymix.PhysicsException;
import com.hardwire.utils.Matrix2x2;
import com.hardwire.utils.Vector2;

public abstract class PhysicalObject {
    protected DynamicWorld world = null;
    private CollisionProxy collisionProxy;
    private int[] boundingBox = new int[4];
    private Vector2 centerPos;
    private byte rayMask = (byte)-1;
    private short coefOfFriction;
    private short coefOfRestitution;
    public int userType;
    public boolean isDynamic;

    protected void _initBody(DynamicWorld pWorld, CollisionProxy pProxy, int pCoF, int pCoR) throws PhysicsException {
        this.world = pWorld;
        this.coefOfFriction = (short)pCoF;
        this.coefOfRestitution = (short)pCoR;
        this.collisionProxy = pProxy;
        if (this.collisionProxy == null) {
            this.collisionProxy = CollisionProxy.getDummyCollisionProxy();
        }
    }

    public void spawnBody(Vector2 pPosition, int pAngle) throws PhysicsException {
        if (this.world == null) {
            DynamicWorld._error((byte)6);
        }
        this.centerPos = new Vector2(pPosition);
        this._recomputeBoundingBox();
    }

    public abstract void despawnBody() throws PhysicsException;

    public Vector2 getPosition() {
        return this.centerPos;
    }

    public void _setPosition(Vector2 pNewPos) {
        if (this.centerPos == null) {
            this.centerPos = new Vector2();
        }
        this.centerPos.copy(pNewPos);
        this._recomputeBoundingBox();
    }

    public Vector2 getPosition_shiftedRight() {
        return new Vector2(this.centerPos).shiftRight();
    }

    public int[] getBoundingBox() {
        return this.boundingBox;
    }

    public void _recomputeBoundingBox() {
        if (this.isDynamic) {
            this.boundingBox[1] = Integer.MAX_VALUE;
            this.boundingBox[0] = Integer.MAX_VALUE;
            this.boundingBox[3] = Integer.MIN_VALUE;
            this.boundingBox[2] = Integer.MIN_VALUE;
            Vector2[] poly = this.collisionProxy.getData();
            Matrix2x2 orient = this.getOrientation();
            for (int i = 0; i < poly.length; ++i) {
                Vector2 v = poly[i];
                int pt_x = (int)((long)v.x * (long)orient.data[0][0] + (long)v.y * (long)orient.data[0][1] >> 10) + this.centerPos.x;
                int pt_y = (int)((long)v.x * (long)orient.data[1][0] + (long)v.y * (long)orient.data[1][1] >> 10) + this.centerPos.y;
                if (pt_x < this.boundingBox[0]) {
                    this.boundingBox[0] = pt_x;
                }
                if (pt_y < this.boundingBox[1]) {
                    this.boundingBox[1] = pt_y;
                }
                if (pt_x > this.boundingBox[2]) {
                    this.boundingBox[2] = pt_x;
                }
                if (pt_y <= this.boundingBox[3]) continue;
                this.boundingBox[3] = pt_y;
            }
        } else {
            int[] tmpBox = this.collisionProxy.getBoundingBox();
            this.boundingBox[0] = this.centerPos.x + tmpBox[0];
            this.boundingBox[1] = this.centerPos.y + tmpBox[1];
            this.boundingBox[2] = this.centerPos.x + tmpBox[2];
            this.boundingBox[3] = this.centerPos.y + tmpBox[3];
        }
        if (this.isBullet()) {
            Vector2 vel = this.getLinearVelocity();
            if (vel.x < 0) {
                this.boundingBox[0] = this.boundingBox[0] + vel.x;
            }
            if (vel.y < 0) {
                this.boundingBox[1] = this.boundingBox[1] + vel.y;
            }
            if (vel.x > 0) {
                this.boundingBox[2] = this.boundingBox[2] + vel.x;
            }
            if (vel.y > 0) {
                this.boundingBox[3] = this.boundingBox[3] + vel.y;
            }
        }
    }

    public abstract boolean isBullet();

    public CollisionProxy getCollisionProxy() {
        return this.collisionProxy;
    }

    public abstract Vector2 getLinearVelocity();

    public abstract int getAngularVelocity_shifted();

    public abstract int getAngle_shifted();

    public abstract Matrix2x2 getOrientation();

    public abstract int getInvMass_shifted2();

    public abstract int getInvInertia_shifted2();

    public abstract int getMass_shiftedRight();

    public abstract int getInertia_shiftedRight();

    public boolean canCollideWith(PhysicalObject pOther) {
        return true;
    }

    protected void notifyAfterCollisionResponse(PhysicalObject pOther, int[][] pCollPoints1, int[][] pCollPoints2, int pNumPoints, int pNormal_x, int pNormal_y, int pMTD) {
    }

    protected boolean notifyBeforeCollisionResponse(PhysicalObject pOther, int pNormal_x, int pNormal_y, int pMTD) {
        return true;
    }

    public short getCoefOfFriction() {
        return this.coefOfFriction;
    }

    public void setCoefOfFriction(int coefOfFriction) {
        this.coefOfFriction = (short)coefOfFriction;
    }

    public short getCoefOfRestitution() {
        return this.coefOfRestitution;
    }

    public void setCoefOfRestitution(int coefOfRestitution) {
        this.coefOfRestitution = (short)coefOfRestitution;
    }

    public byte getRayMask() {
        return this.rayMask;
    }

    public void setRayMask(byte pNew) {
        this.rayMask = pNew;
    }

    public int testRayIntersect(int pStart_x, int pStart_y, int pDirection_x, int pDirection_y) throws PhysicsException {
        Vector2[] poly = this.getCollisionProxy().getData();
        if (poly.length < 2) {
            return -1;
        }
        int tnear = 0;
        int tfar = Integer.MAX_VALUE;
        Vector2 pos = this.getPosition();
        Matrix2x2 orient = this.getOrientation();
        int X = pStart_x - pos.x;
        int Y = pStart_y - pos.y;
        int relPos_x = (int)((long)X * (long)orient.data[0][0] + (long)Y * (long)orient.data[1][0] >> 10);
        int relPos_y = (int)((long)X * (long)orient.data[0][1] + (long)Y * (long)orient.data[1][1] >> 10);
        int relDir_x = (int)((long)pDirection_x * (long)orient.data[0][0] + (long)pDirection_y * (long)orient.data[1][0] >> 10);
        int relDir_y = (int)((long)pDirection_x * (long)orient.data[0][1] + (long)pDirection_y * (long)orient.data[1][1] >> 10);
        int j = poly.length - 1;
        int i = 0;
        while (i < poly.length) {
            int edgeNormal_x = poly[j].y - poly[i].y;
            int edgeNormal_y = poly[i].x - poly[j].x;
            long numer = (long)(poly[j].x - relPos_x) * (long)edgeNormal_x + (long)(poly[j].y - relPos_y) * (long)edgeNormal_y >> 10;
            long denom = (long)relDir_x * (long)edgeNormal_x + (long)relDir_y * (long)edgeNormal_y >> 10;
            if (denom == 0L) {
                if (numer > 0L) {
                    return -1;
                }
            } else {
                int tclip = (int)((numer << 10) / denom);
                if (denom > 0L) {
                    if (tclip > tfar) {
                        return -1;
                    }
                    if (tclip > tnear) {
                        tnear = tclip;
                    }
                } else {
                    if (tclip < tnear) {
                        return -1;
                    }
                    if (tclip < tfar) {
                        tfar = tclip;
                    }
                }
            }
            j = i++;
        }
        return tnear;
    }
}

