/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.efw.ui;

import com.jarbull.efw.text.TextWriter;
import com.jarbull.efw.ui.Component;
import com.jarbull.efw.ui.IFocusable;
import javax.microedition.lcdui.Graphics;

public class TextBox
extends Component
implements IFocusable {
    private int charOffsetX;
    private int charOffsetY;
    private int textCharSetOffsetY;
    private int charWidth;
    private int charHeight;
    private int rowNo;
    private int columnNo;
    private int maxTextSize;
    private int selectionColor;
    private boolean incSelectionColor;
    private boolean hasInitialText;
    private String[] charSet = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "1", "2", "3", "4", "5", "6", "7", "8", "9", "0", " ", "c", "OK"};
    private int[] xPositions;
    private int[] yPositions;
    private String text;
    private int selectedIndex;
    private boolean focused;
    private boolean selected;

    public TextBox(String id) {
        super(id);
        if (TextWriter.getInstance().getFont() == null) {
            TextWriter.getInstance().setWriterType(2);
        }
        this.selected = false;
        this.focused = false;
        this.x = 0;
        this.y = 0;
        this.hasInitialText = false;
        this.fgColor = 0;
        this.borderColor = 0xFF0000;
        this.width = 145;
        this.autoResize = true;
        this.charOffsetX = 5;
        this.charOffsetY = 5;
        this.selectionColor = 0;
        this.incSelectionColor = true;
        this.textCharSetOffsetY = 40;
        this.charWidth = 0;
        this.charHeight = 0;
        this.rowNo = 0;
        this.columnNo = 0;
        this.maxTextSize = 8;
        this.text = "";
        this.selectedIndex = 0;
    }

    public void setCharOffsetX(int charOffsetX) {
        this.charOffsetX = charOffsetX;
        this.initializePositions();
    }

    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.initializePositions();
    }

    public void setCharOffsetY(int charOffsetY) {
        this.charOffsetY = charOffsetY;
    }

    public void setCharSet(String[] charSet) {
        String[] tempArray = new String[charSet.length + 2];
        System.arraycopy(charSet, 0, tempArray, 0, charSet.length);
        tempArray[tempArray.length - 3] = " ";
        tempArray[tempArray.length - 2] = "c";
        tempArray[tempArray.length - 1] = "OK";
        this.charSet = tempArray;
    }

    public void setMaxTextSize(int maxTextLength) {
        this.maxTextSize = maxTextLength;
    }

    public void setSelectedIndex(int selectedIndex) {
        this.selectedIndex = selectedIndex;
    }

    public void setText(String text) {
        this.hasInitialText = true;
        this.text = text;
    }

    public void setTextCharSetOffsetY(int textCharSetOffsetY) {
        this.textCharSetOffsetY = textCharSetOffsetY;
    }

    public char[] getCharSet() {
        char[] tempArray = new char[this.charSet.length - 3];
        System.arraycopy(this.charSet, 0, tempArray, 0, tempArray.length);
        return tempArray;
    }

    public int getMaxTextLength() {
        return this.maxTextSize;
    }

    public String getText() {
        return this.text;
    }

    public int getTextCharSetOffsetY() {
        return this.textCharSetOffsetY;
    }

    public void initializePositions() {
        int diffX;
        this.xPositions = new int[this.charSet.length];
        this.yPositions = new int[this.charSet.length];
        for (int i = 0; i < this.charSet.length; ++i) {
            if (TextWriter.getInstance().getTextWidth(this.charSet[i]) <= this.charWidth || this.charSet[i].length() != 1) continue;
            this.charWidth = TextWriter.getInstance().getTextWidth(this.charSet[i]);
        }
        this.charHeight = TextWriter.getInstance().getTextHeight(this.charSet[0]);
        this.columnNo = this.width / (this.charWidth + this.charOffsetX);
        this.rowNo = this.charSet.length % this.columnNo == 0 ? this.charSet.length / this.columnNo : this.charSet.length / this.columnNo + 1;
        int tempIndex = 0;
        block1: for (int i = 0; i < this.rowNo; ++i) {
            for (int j = 0; j < this.columnNo; ++j) {
                this.xPositions[tempIndex] = j * (this.charWidth + this.charOffsetX);
                this.yPositions[tempIndex] = this.textCharSetOffsetY + i * (this.charHeight + this.charOffsetY);
                if (++tempIndex == this.charSet.length) continue block1;
            }
        }
        if (this.autoResize) {
            super.setSize(this.width, this.yPositions[this.charSet.length - 1] + this.charHeight + this.charOffsetY);
        }
        if (this.columnNo < this.xPositions.length && (diffX = this.width - this.xPositions[this.columnNo - 1] - this.charWidth) != 0) {
            int i = 0;
            while (i < this.xPositions.length) {
                int n = i++;
                this.xPositions[n] = this.xPositions[n] + diffX / 2;
            }
        }
    }

    public void keyPressed(int keyCode) {
        if (!this.enabled) {
            return;
        }
        switch (keyCode) {
            case 206: 
            case 224: {
                ++this.selectedIndex;
                this.selectedIndex %= this.charSet.length;
                break;
            }
            case 204: 
            case 223: {
                this.selectedIndex = --this.selectedIndex < 0 ? this.charSet.length - 1 : this.selectedIndex;
                break;
            }
            case 208: 
            case 222: {
                if (this.selectedIndex + this.columnNo < this.charSet.length) {
                    this.selectedIndex += this.columnNo;
                    break;
                }
                this.selectedIndex %= this.columnNo;
                break;
            }
            case 202: 
            case 221: {
                if (this.selectedIndex - this.columnNo >= 0) {
                    this.selectedIndex -= this.columnNo;
                    break;
                }
                if (this.selectedIndex < this.charSet.length % this.columnNo) {
                    this.selectedIndex = this.charSet.length - this.charSet.length % this.columnNo + this.selectedIndex;
                    break;
                }
                this.selectedIndex = this.charSet.length - this.charSet.length % this.columnNo - this.columnNo + this.selectedIndex;
                break;
            }
            case -203: 
            case 205: 
            case 225: {
                if (this.hasInitialText) {
                    this.text = "";
                    this.hasInitialText = false;
                }
                if (this.selectedIndex == this.charSet.length - 2) {
                    if (this.text.length() == 0) break;
                    this.text = this.text.substring(0, this.text.length() - 1);
                    break;
                }
                if (this.selectedIndex == this.charSet.length - 1) {
                    this.setFocused(false);
                    break;
                }
                if (this.text.length() >= this.maxTextSize) break;
                this.text = this.text + this.charSet[this.selectedIndex];
            }
        }
    }

    public void paint(Graphics g) {
        int i;
        if (!this.visible) {
            return;
        }
        g.translate(this.x, this.y);
        this.saveClip(g);
        if (this.clipRegionActivated) {
            g.setClip(this.compClipX, this.compClipY, this.compClipW, this.compClipH);
        } else {
            g.setClip(0, 0, this.width, this.height);
        }
        if (this.bgColor != -1) {
            g.setColor(this.bgColor);
            g.fillRect(0, 0, this.width, this.height);
        }
        g.setColor(this.fgColor);
        if (this.bg != null) {
            this.bg.paint(g);
        }
        TextWriter.getInstance().drawText(g, this.text, this.width / 2 - TextWriter.getInstance().getTextWidth(this.text) / 2 - this.charOffsetX, 0);
        for (i = 0; i < this.charSet.length; ++i) {
            g.setColor(this.fgColor);
            TextWriter.getInstance().drawText(g, this.charSet[i], this.xPositions[i], this.yPositions[i]);
            if (!this.enabled || !this.focused || i != this.selectedIndex) continue;
            this.selectionColor += this.incSelectionColor ? 50 : -50;
            if (this.selectionColor >= 255) {
                this.selectionColor = 255;
                this.incSelectionColor = false;
            } else if (this.selectionColor <= 0) {
                this.selectionColor = 0;
                this.incSelectionColor = true;
            }
            g.setColor(0xFF0000 + (this.selectionColor << 8) + this.selectionColor);
            g.drawRect(this.xPositions[i], this.yPositions[i], TextWriter.getInstance().getTextWidth(this.charSet[i]), this.charHeight);
            this.restoreClip(g);
        }
        if (this.enabled && this.focused && this.text.length() < this.maxTextSize) {
            g.setColor(0xFF0000 + (this.selectionColor << 8) + this.selectionColor);
            g.drawLine((this.width + TextWriter.getInstance().getTextWidth(this.text)) / 2, 0, (this.width + TextWriter.getInstance().getTextWidth(this.text)) / 2, this.charHeight);
        }
        if (this.fg != null) {
            this.fg.paint(g);
        }
        g.setColor(this.borderColor);
        for (i = 0; i < this.borderSize; ++i) {
            g.drawRect(i, i, this.width - 2 * i - 1, this.height - 2 * i - 1);
        }
        if (this.selected && !this.focused) {
            g.setStrokeStyle(1);
            g.setColor(0x797777);
            g.drawRect(0, 0, this.width - 1, this.height - 1);
        }
        this.restoreClip(g);
        g.translate(-this.x, -this.y);
    }

    public void setFocused(boolean focused) {
        this.focused = focused;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public void setSelected(boolean selected) {
        if (this.actionListener != null && this.selected != selected) {
            if (selected) {
                this.actionListener.onSelected();
            } else {
                this.actionListener.onDeselected();
            }
        }
        this.selected = selected;
    }

    public boolean isSelected() {
        return this.selected;
    }
}

