/*
 * Decompiled with CFR 0.152.
 */
package com.hardwire.dymix;

import com.hardwire.dymix.CollisionProxy;
import com.hardwire.dymix.DynamicWorld;
import com.hardwire.dymix.PhysicalObject;
import com.hardwire.dymix.PhysicsException;
import com.hardwire.utils.Matrix2x2;
import com.hardwire.utils.Vector2;

public class StaticObject
extends PhysicalObject {
    public int _id;
    private static int[] oldAABB = new int[4];

    public void initBody(DynamicWorld pWorld, CollisionProxy pProxy) throws PhysicsException {
        this.initBody(pWorld, pProxy, 512, 0);
    }

    public void initBody(DynamicWorld pWorld, CollisionProxy pProxy, int pCoF, int pCoR) throws PhysicsException {
        super._initBody(pWorld, pProxy, pCoF, pCoR);
        this.isDynamic = false;
        this._setPosition(new Vector2());
    }

    public void spawnBody(Vector2 pPosition, int pAngle) throws PhysicsException {
        super.spawnBody(pPosition, pAngle);
        this.world._addObject(this, false);
    }

    public void despawnBody() throws PhysicsException {
        this.world._removeObject(this, false);
    }

    public void recomputeBoundingBox() throws PhysicsException {
        if (this.world != null && this.world.getType() == 0) {
            int[] aabb = this.getBoundingBox();
            StaticObject.oldAABB[0] = aabb[0];
            StaticObject.oldAABB[1] = aabb[1];
            StaticObject.oldAABB[2] = aabb[2];
            StaticObject.oldAABB[3] = aabb[3];
        }
        this._recomputeBoundingBox();
        if (this.world != null && this.world.getType() == 0) {
            this.world._bp_grid_static.updateObject(this._id, oldAABB, this.getBoundingBox());
        }
    }

    public boolean isBullet() {
        return false;
    }

    public int getAngle_shifted() {
        return 0;
    }

    public int getAngularVelocity_shifted() {
        return 0;
    }

    public int getInertia_shiftedRight() {
        return 0;
    }

    public int getInvInertia_shifted2() {
        return 0;
    }

    public int getInvMass_shifted2() {
        return 0;
    }

    public Vector2 getLinearVelocity() {
        return Vector2.ZERO;
    }

    public int getMass_shiftedRight() {
        return 0;
    }

    public Matrix2x2 getOrientation() {
        return Matrix2x2.IDENTITY;
    }
}

