/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.platform.data;

import com.jarbull.efw.io.KeyValuePair;
import com.jarbull.efw.manager.EMidlet;

public class DataManager {
    private static final DataManager instance = new DataManager();
    private static final String moneyId = "currmoney";
    private static final String totalMoneyId = "totalmoney";
    private static final String doublejumpId = "djump";
    private static final String boombasId = "boombas";
    private static final String armorsId = "armors";
    private static final String updateX2Id = "updateX2";
    private static final String locationId = "location2";
    private static final String newGameId = "newgame";
    private static int locationCnt;
    private static int updateX2;
    private static int boombasCnt;
    private static int armorsCnt;
    private static int doublejumpFlag;
    private static int moneyCnt;
    private static int currMoneyCnt;

    public static DataManager getInstance() {
        return instance;
    }

    public void saveDataForUpgrades() {
        boombasCnt = boombasCnt == 0 ? 0 : boombasCnt;
        EMidlet.getInstance().getSettings().add(new KeyValuePair(boombasId, Integer.toString(boombasCnt)));
        EMidlet.getInstance().getSettings().add(new KeyValuePair(armorsId, Integer.toString(armorsCnt)));
        EMidlet.getInstance().getSettings().add(new KeyValuePair(updateX2Id, Integer.toString(updateX2)));
        EMidlet.getInstance().getSettings().add(new KeyValuePair(doublejumpId, Integer.toString(doublejumpFlag)));
    }

    public void loadDataForUpgrades() {
        if (EMidlet.getInstance().getSettings().get(boombasId) == null) {
            EMidlet.getInstance().getSettings().add(new KeyValuePair(boombasId, "1"));
        }
        if (EMidlet.getInstance().getSettings().get(armorsId) == null) {
            EMidlet.getInstance().getSettings().add(new KeyValuePair(armorsId, "0"));
        }
        if (EMidlet.getInstance().getSettings().get(doublejumpId) == null) {
            EMidlet.getInstance().getSettings().add(new KeyValuePair(doublejumpId, "0"));
        }
        if (EMidlet.getInstance().getSettings().get(updateX2Id) == null) {
            EMidlet.getInstance().getSettings().add(new KeyValuePair(updateX2Id, "0"));
        }
        try {
            boombasCnt = Integer.parseInt(EMidlet.getInstance().getSettings().get(boombasId));
            armorsCnt = Integer.parseInt(EMidlet.getInstance().getSettings().get(armorsId));
            updateX2 = Integer.parseInt(EMidlet.getInstance().getSettings().get(updateX2Id));
            doublejumpFlag = Integer.parseInt(EMidlet.getInstance().getSettings().get(doublejumpId));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadDataForLocation() {
        if (EMidlet.getInstance().getSettings().get(locationId) == null) {
            EMidlet.getInstance().getSettings().add(new KeyValuePair(locationId, "1"));
        }
        try {
            locationCnt = Integer.parseInt(EMidlet.getInstance().getSettings().get(locationId));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void saveDataForLocation() {
        locationCnt = locationCnt == 0 ? 1 : locationCnt;
        EMidlet.getInstance().getSettings().add(new KeyValuePair(locationId, Integer.toString(locationCnt)));
    }

    public void loadDataForMoney() {
        if (EMidlet.getInstance().getSettings().get(totalMoneyId) == null) {
            EMidlet.getInstance().getSettings().add(new KeyValuePair(totalMoneyId, "0"));
        }
        if (EMidlet.getInstance().getSettings().get(moneyId) == null) {
            EMidlet.getInstance().getSettings().add(new KeyValuePair(moneyId, "0"));
        }
        try {
            currMoneyCnt = Integer.parseInt(EMidlet.getInstance().getSettings().get(moneyId));
            moneyCnt = Integer.parseInt(EMidlet.getInstance().getSettings().get(totalMoneyId));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void saveDataForMoney() {
        moneyCnt = moneyCnt == 0 ? 1 : moneyCnt;
        EMidlet.getInstance().getSettings().add(new KeyValuePair(moneyId, Integer.toString(currMoneyCnt)));
        EMidlet.getInstance().getSettings().add(new KeyValuePair(totalMoneyId, Integer.toString(moneyCnt)));
    }

    public void resetAllData() {
        boombasCnt = 1;
        armorsCnt = 0;
        doublejumpFlag = 0;
        currMoneyCnt = 0;
        moneyCnt = 0;
        updateX2 = 0;
        locationCnt = 1;
        this.saveDataForUpgrades();
        this.saveDataForLocation();
        this.saveDataForMoney();
    }

    public static boolean checkNewGameFlag() {
        if (EMidlet.getInstance().getSettings().get(newGameId) == null || Integer.parseInt(EMidlet.getInstance().getSettings().get(newGameId)) == 0) {
            EMidlet.getInstance().getSettings().add(new KeyValuePair(newGameId, "1"));
            return true;
        }
        return false;
    }

    public int getLocationCnt() {
        return locationCnt;
    }

    public void setLocationCnt(int locationCnt) {
        DataManager.locationCnt = locationCnt;
    }

    public int getArmorsCnt() {
        return armorsCnt;
    }

    public void setArmorsCnt(int armorsCnt) {
        DataManager.armorsCnt = armorsCnt;
    }

    public int getBoombasCnt() {
        return boombasCnt;
    }

    public void setBoombasCnt(int boombasCnt) {
        DataManager.boombasCnt = boombasCnt;
    }

    public int getDoublejumpFlag() {
        return doublejumpFlag;
    }

    public void setDoublejumpFlag(int doublejumpFlag) {
        DataManager.doublejumpFlag = doublejumpFlag;
    }

    public int getUpdateX2() {
        return updateX2;
    }

    public void setUpdateX2(int updateX2) {
        DataManager.updateX2 = updateX2;
    }

    public int getMoneyCnt() {
        return moneyCnt;
    }

    public void setMoneyCnt(int moneyCnt) {
        DataManager.moneyCnt = moneyCnt;
    }

    public void addMoney(int money) {
        moneyCnt += money;
    }

    public void setCurrMoney(int money) {
        currMoneyCnt = money;
    }
}

