/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.platform.domain;

import com.hardwire.dymix.CollisionProxy;
import com.hardwire.dymix.DynamicWorld;
import com.hardwire.dymix.PhysicalObject;
import com.hardwire.dymix.PhysicsException;
import com.hardwire.dymix.StaticObject;
import com.hardwire.utils.MathUtils;
import com.hardwire.utils.Vector2;
import com.jarbull.efw.controller.ImageHandler;
import com.jarbull.platform.domain.PhysicObject;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Bonus
extends StaticObject
implements PhysicObject {
    private Image[] bonusImage;
    private boolean enabled;
    private int height;
    private int uniqueId;
    private int frame;
    private int tickCounter;
    private boolean despawn;

    public Bonus(DynamicWorld world, int x, int y, int id) {
        try {
            int width = 9;
            this.height = 13;
            this.despawn = false;
            this.enabled = false;
            this.uniqueId = id;
            this.frame = 0;
            this.tickCounter = 0;
            this.bonusImage = new Image[13];
            for (int i = 0; i < this.bonusImage.length; ++i) {
                this.bonusImage[i] = ImageHandler.getInstance().getImage("/res/game/images/objects/bonus" + i + ".png");
            }
            Vector2[] baseData = MathUtils.createBlock(width, this.height);
            this.initBody(world, new CollisionProxy(baseData, false), 512, 0);
            this.spawnBody(new Vector2(x + width / 2, y + this.height / 2).shiftLeft(), 0);
        }
        catch (PhysicsException ex) {
            ex.printStackTrace();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(int uniqueId) {
        this.uniqueId = uniqueId;
    }

    public void draw(Graphics pGraph) {
        pGraph.drawImage(this.bonusImage[this.frame], this.getPosition_shiftedRight().x - 4, this.getPosition_shiftedRight().y - 6, 0);
    }

    protected void notifyAfterCollisionResponse(PhysicalObject pOther, int[][] pCollPoints1, int[][] pCollPoints2, int pNumPoints, int pNormal_x, int pNormal_y, int pMTD) {
        if (this.enabled) {
            // empty if block
        }
    }

    public boolean isDespawn() {
        return this.despawn;
    }

    public void tick() {
        if (this.enabled) {
            if (this.tickCounter % 1 == 0) {
                if (this.frame >= 7 && this.frame < 11) {
                    ++this.frame;
                } else if (this.frame < 7) {
                    this.frame = 7;
                } else if (this.frame >= 11) {
                    this.despawn = true;
                }
            }
        } else if (this.tickCounter % 3 == 0) {
            if (this.frame >= 0 && this.frame < 6) {
                ++this.frame;
            } else if (this.frame < 0 || this.frame >= 6) {
                this.frame = 0;
            }
        }
        ++this.tickCounter;
    }

    public boolean isActive() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setIsActive(boolean flag) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

