/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.platform.domain;

import com.hardwire.dymix.CollisionProxy;
import com.hardwire.dymix.DynamicObject;
import com.hardwire.dymix.DynamicWorld;
import com.hardwire.dymix.PhysicalObject;
import com.hardwire.dymix.PhysicsException;
import com.hardwire.utils.MathUtils;
import com.hardwire.utils.Vector2;
import com.jarbull.efw.controller.ImageHandler;
import com.jarbull.efw.game.LevelHolder;
import com.jarbull.efw.manager.Action;
import com.jarbull.platform.data.DataManager;
import com.jarbull.platform.domain.Bonus;
import com.jarbull.platform.domain.PhyObjManager;
import com.jarbull.platform.domain.PhysicObject;
import com.jarbull.platform.domain.PlayersManager;
import com.jarbull.platform.main.BoombaCanvas;
import com.jarbull.platform.main.GameStateController;
import com.jarbull.platform.util.RandomGenerator;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Player
extends DynamicObject
implements PhysicObject {
    private Image[] playerImage;
    private Image[] playerShieldImage;
    private boolean collided;
    private int tickCounter;
    private int tickShieldCounter;
    public int state;
    public int direction;
    public int condition;
    public boolean alive;
    public boolean electrified;
    public boolean isRemoved;
    public boolean isActive;
    public int frame;
    public int frameShield;
    private boolean waiting;
    private int waitCount;
    private int waitSeqPlay;
    private Vector2 startPos;
    private int uniqueId;
    private boolean isShield;
    private boolean isJumpEnabled;
    private boolean isJump1Enabled;
    private boolean isJump2Enabled;
    private int jumpCnt;
    private int overTime1;
    private int overTime2;

    public Player(DynamicWorld pWorld, int pX, int pY, boolean shield, int id) {
        try {
            int i;
            this.uniqueId = id;
            Vector2[] dynamicData = MathUtils.createBlock(10, 30);
            this.initBody(pWorld, new CollisionProxy(dynamicData, true), 1024, 2, 1024, false);
            this.startPos = new Vector2(pX + 16, pY + 16).shiftLeft();
            this.spawnBody(this.startPos, 0);
            this.setBullet(true);
            this.setCanSleep(false);
            this.isShield = shield;
            this.isRemoved = false;
            this.isActive = true;
            this.isJumpEnabled = true;
            this.jumpCnt = 0;
            this.frame = 0;
            this.waitCount = 0;
            this.tickCounter = 0;
            this.waitSeqPlay = 0;
            this.waiting = true;
            this.collided = true;
            this.alive = true;
            this.electrified = false;
            this.state = 1;
            this.direction = 0;
            this.condition = 1;
            this.playerImage = new Image[92];
            for (i = 0; i < this.playerImage.length; ++i) {
                this.playerImage[i] = ImageHandler.getInstance().getImage("/res/game/images/character/Image800" + i + ".png");
            }
            if (this.isShield) {
                this.playerShieldImage = new Image[8];
                for (i = 0; i < this.playerShieldImage.length; ++i) {
                    this.playerShieldImage[i] = ImageHandler.getInstance().getImage("/res/game/images/character/shield/shield" + i + ".png");
                }
            }
        }
        catch (PhysicsException ex) {
            ex.printStackTrace();
        }
    }

    public void moveInStartPos(int dx) {
        this._setPosition(new Vector2(dx, this.getPosition_shiftedRight().y).shiftLeft());
    }

    public void despawnPlayer() {
        try {
            if (this.playerImage != null) {
                for (int i = 0; i < this.playerImage.length; ++i) {
                    this.playerImage[i] = null;
                }
                this.playerImage = null;
            }
            this.despawnBody();
        }
        catch (PhysicsException ex) {
            ex.printStackTrace();
        }
    }

    public void setIsShield(boolean isShield) {
        this.isShield = isShield;
    }

    public boolean isShield() {
        return this.isShield;
    }

    public boolean isAlive() {
        return this.alive;
    }

    public void setAlive(boolean isAlive) {
        this.alive = isAlive;
    }

    protected void notifyAfterCollisionResponse(PhysicalObject pOther, int[][] pCollPoints1, int[][] pCollPoints2, int pNumPoints, int pNormal_x, int pNormal_y, int pMTD) {
        if (pCollPoints1 == null) {
            return;
        }
        for (int i = 0; i < pCollPoints1.length; ++i) {
            if (pCollPoints1[i] != null) continue;
        }
        this.state = 1;
    }

    public int getCondition() {
        return this.condition;
    }

    public int getDirection() {
        return this.direction;
    }

    public int getState() {
        return this.state;
    }

    private void checkJumpAnim() {
        if (this.isJump1Enabled) {
            this.overTime1 -= 50;
        }
        if (this.isJump2Enabled) {
            this.overTime2 -= 50;
        }
        if (!this.isJump1Enabled && !this.isJump2Enabled) {
            this.isJumpEnabled = true;
            return;
        }
        if (this.isJump1Enabled && this.overTime1 <= 0) {
            if (this.state != 0 && this.state != 2 && this.alive) {
                this.wakeUp();
                this.getLinearVelocity().set(this.getLinearVelocity().x, -6500);
                this.condition = 0;
                this.state = 0;
            } else if (this.state != 2 && this.state == 0 && this.alive && DataManager.getInstance().getDoublejumpFlag() == 1) {
                this.wakeUp();
                this.getLinearVelocity().set(this.getLinearVelocity().x, -6500);
                this.condition = 0;
                this.state = 2;
                this.jumpCnt = 0;
            }
            this.isJump1Enabled = false;
        }
        if (this.isJump2Enabled && this.overTime2 <= 0) {
            if (this.state != 0 && this.state != 2 && this.alive) {
                this.wakeUp();
                this.getLinearVelocity().set(this.getLinearVelocity().x, -6500);
                this.condition = 0;
                this.state = 0;
            } else if (this.state != 2 && this.state == 0 && this.alive && DataManager.getInstance().getDoublejumpFlag() == 1) {
                this.wakeUp();
                this.getLinearVelocity().set(this.getLinearVelocity().x, -6500);
                this.condition = 0;
                this.state = 2;
                this.jumpCnt = 0;
            }
            this.isJump2Enabled = false;
        }
    }

    public void jump(int overTime) {
        ++this.jumpCnt;
        if (this.jumpCnt > 1) {
            this.isJumpEnabled = false;
            this.overTime2 = overTime;
            this.isJump2Enabled = true;
            this.jumpCnt = 0;
            return;
        }
        this.overTime1 = overTime;
        this.isJump1Enabled = true;
    }

    public void tick() {
        this.setAngularVelocity_shifted(0);
        if (this.alive) {
            this.checkJumpAnim();
            this.wakeUp();
            this.condition = 0;
            this.direction = 0;
            if (this.getLinearVelocity().y > 9000) {
                this.getLinearVelocity().set(this.getLinearVelocity().x, 9000);
            }
            System.out.println("getLinearVelocity().y = " + this.getLinearVelocity().y);
            if (this.condition == 0) {
                this.waitCount = 0;
                this.waiting = false;
                if (this.state == 1) {
                    if (this.tickCounter % 3 == 0) {
                        if (this.frame >= 0 && this.frame < 7) {
                            ++this.frame;
                        } else if (this.frame < 0 || this.frame >= 7) {
                            this.frame = 0;
                        }
                    }
                } else if (this.state == 0) {
                    if (this.tickCounter % 3 == 0) {
                        if (this.getLinearVelocity().y < 0) {
                            if (this.frame == 72) {
                                this.frame = 69;
                            }
                            if (this.frame >= 68 && this.frame < 72) {
                                ++this.frame;
                            } else if (this.frame < 68 || this.frame > 72) {
                                this.frame = 68;
                            }
                        } else {
                            if (this.frame == 91) {
                                this.frame = 89;
                            }
                            if (this.frame >= 84 && this.frame < 91) {
                                ++this.frame;
                            } else if (this.frame < 84 || this.frame > 91) {
                                this.frame = 84;
                            }
                        }
                    }
                } else if (this.state == 2 && this.tickCounter % 3 == 0) {
                    if (this.getLinearVelocity().y < 0) {
                        if (this.frame == 20) {
                            this.frame = 18;
                        }
                        if (this.frame >= 8 && this.frame < 20) {
                            ++this.frame;
                        } else if (this.frame < 8 || this.frame > 20) {
                            this.frame = 8;
                        }
                    } else {
                        if (this.frame == 91) {
                            this.frame = 89;
                        }
                        if (this.frame >= 84 && this.frame < 91) {
                            ++this.frame;
                        } else if (this.frame < 84 || this.frame > 91) {
                            this.frame = 84;
                        }
                    }
                }
            } else if (this.condition == 1) {
                this.frame = 0;
                ++this.waitCount;
            }
        } else if (this.electrified) {
            if (this.tickCounter % 3 == 0) {
                if (this.frame >= 76 && this.frame < 83) {
                    if (this.frame == 78) {
                        // empty if block
                    }
                    ++this.frame;
                } else if (this.frame < 76 || this.frame >= 83) {
                    this.frame = 76;
                }
            }
        } else if (!this.electrified && this.tickCounter % 3 == 0) {
            if (this.frame >= 76 && this.frame < 83) {
                if (this.frame == 78) {
                    this.isActive = false;
                    int rand = RandomGenerator.getInstance().generateRandomBetween(1, 3);
                }
                ++this.frame;
            } else if (this.frame < 76 || this.frame > 83) {
                this.frame = 76;
            } else if (this.frame == 83) {
                if (PlayersManager.getInstance().getPlayersObjList().size() > 1) {
                    this.isRemoved = true;
                } else {
                    DataManager.getInstance().addMoney(BoombaCanvas.bonusCnt);
                    DataManager.getInstance().setCurrMoney(BoombaCanvas.bonusCnt);
                    DataManager.getInstance().saveDataForMoney();
                    LevelHolder.getInstance().getLevel(LevelHolder.getInstance().getCurrentLevel()).setCurrentScore(BoombaCanvas.distanceTotal / 20);
                    LevelHolder.getInstance().getLevel(LevelHolder.getInstance().getCurrentLevel()).saveLevelInfo();
                    Action action = new Action(this, "OPENMENU", "gameoverscreen");
                    action.doAction();
                    Action act1 = new Action(this, "SETRESULTTEXT", "gameoverscreen|resultlabel");
                    act1.doAction();
                    Action act2 = new Action(this, "SETMONEYTEXT", "gameoverscreen|moneylabel");
                    act2.doAction();
                    Action act3 = new Action(this, "SETSCORETEXT", "gameoverscreen|bestresultlabel");
                    act3.doAction();
                    Action act4 = new Action(this, "SETTOTALMONEYTEXT", "gameoverscreen|totalmoneylabel");
                    act4.doAction();
                    Action act5 = new Action(this, "SETCURRSCORETEXT", "gameoverscreen|currbestresultlabel");
                    act5.doAction();
                    GameStateController.getInstance().setState((byte)5);
                    return;
                }
            }
        }
        ++this.tickCounter;
        if (this.playerShieldImage != null) {
            this.animateShield();
        }
    }

    private void animateShield() {
        if (this.isShield) {
            if (this.tickShieldCounter % 3 == 0) {
                if (this.frameShield >= 0 && this.frameShield < 3) {
                    ++this.frameShield;
                } else if (this.frameShield < 0) {
                    this.frameShield = 0;
                } else if (this.frameShield >= 3) {
                    this.frameShield = 0;
                }
            }
        } else if (this.playerShieldImage != null && this.tickShieldCounter % 3 == 0) {
            if (this.frameShield >= 4 && this.frameShield < 7) {
                ++this.frameShield;
            } else if (this.frameShield < 4) {
                this.frameShield = 4;
            } else if (this.frameShield >= 7) {
                this.playerShieldImage = null;
            }
        }
        ++this.tickShieldCounter;
    }

    public void draw(Graphics pGraph) {
        if (this.playerShieldImage != null) {
            pGraph.drawImage(this.playerShieldImage[this.frameShield], this.getPosition_shiftedRight().x - 16, this.getPosition_shiftedRight().y - 16, 0);
        }
        pGraph.drawImage(this.playerImage[this.frame], this.getPosition_shiftedRight().x - 16, this.getPosition_shiftedRight().y - 16, 0);
    }

    public boolean canCollideWith(PhysicalObject obj) {
        int a;
        this.collided = true;
        for (a = PhyObjManager.getInstance().getPhysicList().size() - 1; a >= 0; --a) {
            if (!(PhyObjManager.getInstance().getPhysicList().elementAt(a) instanceof Bonus) && !(PhyObjManager.getInstance().getPhysicList().elementAt(a) instanceof Player)) {
                if (!this.alive || !obj.equals(PhyObjManager.getInstance().getPhysicList().elementAt(a))) continue;
                this.collided = false;
                if (!((PhysicObject)((Object)obj)).isActive()) continue;
                if (!this.isShield) {
                    this.alive = false;
                } else {
                    this.isShield = false;
                }
                ((PhysicObject)((Object)obj)).setIsActive(false);
                ((PhysicObject)((Object)obj)).setEnabled(true);
                continue;
            }
            if (!(PhyObjManager.getInstance().getPhysicList().elementAt(a) instanceof Bonus) || !this.alive || !obj.equals((Bonus)PhyObjManager.getInstance().getPhysicList().elementAt(a))) continue;
            Bonus bonus = (Bonus)PhyObjManager.getInstance().getPhysicList().elementAt(a);
            if (!bonus.isEnabled()) {
                bonus.setEnabled(true);
                ++BoombaCanvas.bonusCnt;
            }
            this.collided = false;
        }
        for (a = PlayersManager.getInstance().getPlayersObjList().size() - 1; a >= 0; --a) {
            if (!obj.equals((Player)PlayersManager.getInstance().getPlayersObjList().elementAt(a))) continue;
            this.collided = false;
        }
        return this.collided;
    }

    public int getUniqueId() {
        return this.uniqueId;
    }

    public boolean isDespawn() {
        return false;
    }

    public boolean isActive() {
        return true;
    }

    public void setIsActive(boolean flag) {
    }

    public void setEnabled(boolean flag) {
    }
}

