/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.platform.main;

import com.hardwire.dymix.DynamicWorld;
import com.hardwire.dymix.PhysicsException;
import com.hardwire.utils.MathUtils;
import com.hardwire.utils.Vector2;
import com.jarbull.efw.controller.ResolutionHandler;
import com.jarbull.efw.game.EFLiteSprite;
import com.jarbull.efw.game.GameObjectHolder;
import com.jarbull.efw.game.LevelHolder;
import com.jarbull.efw.manager.Action;
import com.jarbull.efw.manager.EGameCanvas;
import com.jarbull.efw.manager.EMidlet;
import com.jarbull.efw.text.LocalizationSupport;
import com.jarbull.efw.text.TextWriter;
import com.jarbull.efw.ui.Label;
import com.jarbull.platform.data.DataManager;
import com.jarbull.platform.domain.PhyObjManager;
import com.jarbull.platform.domain.PlayersManager;
import com.jarbull.platform.main.GameStateController;
import com.jarbull.platform.screens.ScreenLevelSelection;
import com.jarbull.platform.screens.SelectGameScreen;
import com.jarbull.platform.shop.ItemsObservable;
import com.jarbull.platform.shop.Shop;
import com.jarbull.platform.util.PatternManager;
import com.jarbull.platform.util.TopBar;
import javax.microedition.lcdui.Graphics;

public class BoombaCanvas
extends EGameCanvas {
    public static double translateX;
    public static int translateY;
    private DynamicWorld world;
    public ScreenLevelSelection levSelectActive;
    private EFLiteSprite sprEFComics;
    private EFLiteSprite sprEFLBg;
    private Shop shop;
    public static int distance;
    public static int distanceTotal;
    public static int bonusCnt;
    public static int levelNo;
    private SelectGameScreen selectGameScreen;
    private static boolean isNextLocationEnable;
    private static int showNextLevelLeftTime;
    private final int[] distForLevelOpen = new int[]{500, 800, 1200, 20000};
    private Label lblComicDesc1;
    private Label lblComicDesc2;
    private Label lblComicDesc3;
    private int keyPressedLeftTime;
    final int speed = MathUtils.shiftRight(4096);

    public BoombaCanvas() {
        if (GameStateController.getInstance().getState() == 5) {
            if (this.selectGameScreen == null) {
                this.selectGameScreen = new SelectGameScreen("levSelect", 2);
                this.selectGameScreen.setActive(true);
            }
            return;
        }
        if (GameStateController.getInstance().getState() == 5) {
            if (this.selectGameScreen == null) {
                this.selectGameScreen = new SelectGameScreen("levSelect", 2);
                this.selectGameScreen.setActive(true);
            }
            return;
        }
    }

    private void reset() {
        levelNo = 0;
        distance = 0;
        distanceTotal = 0;
        translateX = 0.0;
        translateY = 0;
        isNextLocationEnable = false;
        showNextLevelLeftTime = 0;
        distance = 0;
        bonusCnt = 0;
        distanceTotal = 0;
        if (this.selectGameScreen != null) {
            this.selectGameScreen = null;
        }
        if (this.shop != null) {
            this.shop = null;
        }
        if (this.levSelectActive != null) {
            this.levSelectActive = null;
        }
        if (this.lblComicDesc1 != null) {
            this.lblComicDesc1 = null;
        }
        if (this.lblComicDesc2 != null) {
            this.lblComicDesc2 = null;
        }
        if (this.lblComicDesc3 != null) {
            this.lblComicDesc3 = null;
        }
        if (this.world != null) {
            this.world = null;
        }
        if (this.sprEFComics != null) {
            this.sprEFComics = null;
        }
        if (this.sprEFLBg != null) {
            this.sprEFLBg = null;
        }
    }

    public void levelChanged(int newLevel) {
        this.reset();
        DataManager.getInstance().loadDataForLocation();
        DataManager.getInstance().loadDataForUpgrades();
        DataManager.getInstance().loadDataForMoney();
        if (GameStateController.getInstance().getState() == 5) {
            if (this.selectGameScreen == null) {
                this.selectGameScreen = new SelectGameScreen("levSelect", 2);
                this.selectGameScreen.setActive(true);
            }
            return;
        }
        if (GameStateController.getInstance().getState() == 3) {
            this.selectGameScreen = null;
            if (this.shop == null) {
                this.shop = new Shop();
            }
            return;
        }
        PatternManager.getInstance().removeAll();
        PlayersManager.getInstance().despawnPlayers();
        PhyObjManager.getInstance().getPhysicList().removeAllElements();
        if (GameStateController.getInstance().getState() == 1) {
            if (newLevel == 0 && this.levSelectActive == null) {
                this.levSelectActive = new ScreenLevelSelection();
            }
            return;
        }
        if (GameStateController.getInstance().getState() == 2) {
            if (this.levSelectActive != null) {
                this.levSelectActive = null;
            }
            if (!this.getIsScreenStory(LevelHolder.getInstance().getCurrentLevel())) {
                levelNo = LevelHolder.getInstance().getCurrentLevel() < 4 ? 0 : (LevelHolder.getInstance().getCurrentLevel() < 6 ? 1 : (LevelHolder.getInstance().getCurrentLevel() < 8 ? 2 : 3));
                this.world = new DynamicWorld();
                this.world.cleanUp();
                GameObjectHolder.getInstance().clearAll();
                try {
                    this.world.init((byte)0, -1, 658839, 5);
                    this.world.initUniformGrid(0, 2000, 500, 60, 100, 50, 25);
                    this.world.setGravity(new Vector2(0, 800).shiftLeft());
                }
                catch (PhysicsException ex) {
                    ex.printStackTrace();
                }
            }
            if (this.getIsScreenStory(LevelHolder.getInstance().getCurrentLevel())) {
                this.sprEFLBg = new EFLiteSprite("/res/framework/images/page.png");
                this.sprEFLBg.setPosition(0, 0);
                GameObjectHolder.getInstance().addGameObject(this.sprEFLBg);
                this.sprEFComics = new EFLiteSprite("/res/game/images/comics/comic" + newLevel + ".png");
                this.sprEFComics.setPosition(ResolutionHandler.getInstance().getScreenWidth() / 2 - this.sprEFComics.getWidth() / 2, ResolutionHandler.getInstance().getScreenHeight() / 2 - this.sprEFComics.getHeight() / 2);
                GameObjectHolder.getInstance().addGameObject(this.sprEFComics);
            }
            if (!this.getIsScreenStory(LevelHolder.getInstance().getCurrentLevel())) {
                PlayersManager.getInstance().initialize(this.world);
                distance = 0;
                translateY = Math.min(ResolutionHandler.getInstance().getScreenHeight() / 2 - PlayersManager.getInstance().getY() + 20, 0);
            }
        }
    }

    private boolean getIsScreenStory(int currLevel) {
        switch (currLevel) {
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public void paint(Graphics g) {
        if (GameStateController.getInstance().getState() == 4) {
            return;
        }
        if (GameStateController.getInstance().getState() == 5) {
            if (this.selectGameScreen != null) {
                this.selectGameScreen.paint(g);
            }
            return;
        }
        if (GameStateController.getInstance().getState() == 3) {
            if (this.shop != null) {
                this.shop.paint(g);
            }
            return;
        }
        if (GameStateController.getInstance().getState() == 1) {
            this.levSelectActive.paint(g);
            return;
        }
        if (this.getIsScreenStory(LevelHolder.getInstance().getCurrentLevel())) {
            this.sprEFLBg.paint(g);
            this.sprEFComics.paint(g);
            this.checkShowComics(g);
        } else {
            if (EMidlet.getInstance().isGamePaused()) {
                g.translate(0, 0);
                return;
            }
            translateX = distance;
            if (PlayersManager.getInstance().getY() < 400 - ResolutionHandler.getInstance().getScreenHeight() / 2 - 16) {
                translateY = Math.min(ResolutionHandler.getInstance().getScreenHeight() / 2 - PlayersManager.getInstance().getY(), 0);
            }
            if (GameStateController.getInstance().getState() != 4) {
                g.translate((int)(-translateX), translateY);
            }
            TopBar.getInstance().setPosition((int)translateX, -translateY);
            PatternManager.getInstance().paint(g);
            PlayersManager.getInstance().draw(g);
            PhyObjManager.getInstance().draw(g);
            TopBar.getInstance().paint(g);
            this.checkShowNextLevelInfo(g);
        }
    }

    private void checkShowComics(Graphics g) {
        if (this.lblComicDesc1 == null) {
            this.lblComicDesc1 = new Label("1", "task");
        }
        if (this.lblComicDesc2 == null) {
            this.lblComicDesc2 = new Label("1", "task");
        }
        if (this.lblComicDesc3 == null) {
            this.lblComicDesc3 = new Label("1", "task");
        }
        switch (LevelHolder.getInstance().getCurrentLevel()) {
            case 1: {
                this.lblComicDesc1.setText("descLoc1_1_1", true);
                this.lblComicDesc2.setText("descLoc1_1_2", true);
                this.lblComicDesc3.setText("descLoc1_1_3", true);
                break;
            }
            case 2: {
                this.lblComicDesc1.setText("descLoc1_2_1", true);
                this.lblComicDesc2.setText("descLoc1_2_2", true);
                this.lblComicDesc3.setText("descLoc1_2_3", true);
                break;
            }
            case 4: {
                this.lblComicDesc1.setText("descLoc2_1", true);
                this.lblComicDesc2.setText("descLoc2_2", true);
                this.lblComicDesc3.setText("descLoc2_3", true);
                break;
            }
            case 6: {
                this.lblComicDesc1.setText("descLoc3_1", true);
                this.lblComicDesc2.setText("descLoc3_2", true);
                this.lblComicDesc3.setText("descLoc3_3", true);
                break;
            }
            case 8: {
                this.lblComicDesc1.setText("descLoc4_1", true);
                this.lblComicDesc2.setText("descLoc4_2", true);
                this.lblComicDesc3.setText("descLoc4_3", true);
                break;
            }
        }
        this.lblComicDesc1.setMarginBetweenLines(-5);
        this.lblComicDesc1.setBgColor(-1);
        this.lblComicDesc1.setFgColor(-1);
        this.lblComicDesc1.setBorderSize(0);
        this.lblComicDesc1.setSize((int)((double)this.sprEFComics.getWidth() / 100.0 * 47.0), (int)((double)this.sprEFComics.getHeight() / 100.0 * 26.0));
        this.lblComicDesc1.setAlignment(0);
        this.lblComicDesc2.setMarginBetweenLines(-3);
        this.lblComicDesc2.setBgColor(-1);
        this.lblComicDesc2.setFgColor(-1);
        this.lblComicDesc2.setBorderSize(0);
        this.lblComicDesc2.setSize((int)((double)this.sprEFComics.getWidth() / 100.0 * 47.0), (int)((double)this.sprEFComics.getHeight() / 100.0 * 11.0));
        this.lblComicDesc2.setAlignment(0);
        this.lblComicDesc3.setMarginBetweenLines(-3);
        this.lblComicDesc3.setBgColor(-1);
        this.lblComicDesc3.setFgColor(-1);
        this.lblComicDesc3.setBorderSize(0);
        this.lblComicDesc3.setSize((int)((double)this.sprEFComics.getWidth() / 100.0 * 48.0), (int)((double)this.sprEFComics.getHeight() / 100.0 * 11.0));
        this.lblComicDesc3.setAlignment(0);
        switch (LevelHolder.getInstance().getCurrentLevel()) {
            case 1: 
            case 4: 
            case 8: {
                this.lblComicDesc1.setPosition(this.sprEFComics.getX() + this.sprEFComics.getWidth() / 100 * 4, this.sprEFComics.getY() + this.sprEFComics.getHeight() / 100 * 4);
                this.lblComicDesc2.setPosition(this.sprEFComics.getX() + (int)((double)this.sprEFComics.getWidth() / 100.0 * 48.0), this.sprEFComics.getY() + (int)((double)this.sprEFComics.getHeight() / 100.0 * 44.0));
                this.lblComicDesc3.setPosition(this.sprEFComics.getX() + (int)((double)this.sprEFComics.getWidth() / 100.0 * 48.0), this.sprEFComics.getY() + (int)((double)this.sprEFComics.getHeight() / 100.0 * 88.0));
                break;
            }
            default: {
                this.lblComicDesc1.setPosition(this.sprEFComics.getX() + (int)((double)this.sprEFComics.getWidth() / 100.0 * 54.0), this.sprEFComics.getY() + (int)((double)this.sprEFComics.getHeight() / 100.0 * 4.0));
                this.lblComicDesc2.setPosition(this.sprEFComics.getX() + (int)((double)this.sprEFComics.getWidth() / 100.0 * 5.0), this.sprEFComics.getY() + (int)((double)this.sprEFComics.getHeight() / 100.0 * 44.0));
                this.lblComicDesc3.setPosition(this.sprEFComics.getX() + (int)((double)this.sprEFComics.getWidth() / 100.0 * 6.0), this.sprEFComics.getY() + (int)((double)this.sprEFComics.getHeight() / 100.0 * 85.0));
            }
        }
        this.lblComicDesc1.paint(g);
        this.lblComicDesc2.paint(g);
        this.lblComicDesc3.paint(g);
    }

    private void checkShowNextLevelInfo(Graphics g) {
        if (showNextLevelLeftTime > 0 && --showNextLevelLeftTime / 10 % 2 == 0) {
            int xx = ResolutionHandler.getInstance().getCurrentWidth() / 2 - TextWriter.getInstance().getTextWidth(LocalizationSupport.getMessage("locIsOpen")) / 2;
            int yy = ResolutionHandler.getInstance().getCurrentHeight() / 4;
            TextWriter.getInstance().drawText(g, LocalizationSupport.getMessage("locIsOpen"), (int)translateX + xx, -translateY + yy);
        }
    }

    public void tick() {
        if (GameStateController.getInstance().getState() == 4) {
            return;
        }
        if (GameStateController.getInstance().getState() == 5) {
            return;
        }
        if (GameStateController.getInstance().getState() == 3) {
            if (this.shop != null) {
                this.shop.tick();
            }
            return;
        }
        if (GameStateController.getInstance().getState() == 1) {
            this.levSelectActive.tick();
            return;
        }
        if (this.getIsScreenStory(LevelHolder.getInstance().getCurrentLevel())) {
            return;
        }
        try {
            PhyObjManager.getInstance().tick();
            this.world.tick();
            System.out.println("ss = " + MathUtils.shiftLeft(4));
            System.out.println("speed = " + this.speed);
            distanceTotal += this.speed;
            if (PlayersManager.getInstance().getX() > distance) {
                distance += this.speed;
                if (distanceTotal / 20 > this.distForLevelOpen[levelNo] && !isNextLocationEnable) {
                    isNextLocationEnable = true;
                    System.out.println("levelNo =" + levelNo + " DataManager.getInstance().getLocationCnt() = " + DataManager.getInstance().getLocationCnt());
                    if (levelNo + 1 == DataManager.getInstance().getLocationCnt()) {
                        DataManager.getInstance().setLocationCnt(DataManager.getInstance().getLocationCnt() + 1);
                        DataManager.getInstance().saveDataForLocation();
                        DataManager.getInstance().loadDataForLocation();
                        showNextLevelLeftTime = 100;
                    }
                }
            } else if (PlayersManager.getInstance().getX() + 32 < (distance += this.speed)) {
                DataManager.getInstance().addMoney(bonusCnt);
                DataManager.getInstance().setCurrMoney(bonusCnt);
                DataManager.getInstance().saveDataForMoney();
                LevelHolder.getInstance().getLevel(LevelHolder.getInstance().getCurrentLevel()).setCurrentScore(distanceTotal / 20);
                LevelHolder.getInstance().getLevel(LevelHolder.getInstance().getCurrentLevel()).saveLevelInfo();
                Action act = new Action(this, "OPENMENU", "gameoverscreen");
                act.doAction();
                Action act1 = new Action(this, "SETRESULTTEXT", "gameoverscreen|resultlabel");
                act1.doAction();
                Action act2 = new Action(this, "SETMONEYTEXT", "gameoverscreen|moneylabel");
                act2.doAction();
                Action act3 = new Action(this, "SETSCORETEXT", "gameoverscreen|bestresultlabel");
                act3.doAction();
                Action act4 = new Action(this, "SETTOTALMONEYTEXT", "gameoverscreen|totalmoneylabel");
                act4.doAction();
                Action act5 = new Action(this, "SETCURRSCORETEXT", "gameoverscreen|currbestresultlabel");
                act5.doAction();
                GameStateController.getInstance().setState((byte)5);
            }
            PatternManager.getInstance().checkCreatePattern(distance, this.world);
            PlayersManager.getInstance().tick();
        }
        catch (PhysicsException ex) {
            ex.printStackTrace();
        }
    }

    public void pointerPressed(int x, int y) {
        if (GameStateController.getInstance().getState() == 4) {
            return;
        }
        if (GameStateController.getInstance().getState() == 5) {
            if (this.selectGameScreen != null) {
                this.selectGameScreen.pointerPressed(x, y);
            }
            return;
        }
        if (GameStateController.getInstance().getState() == 3) {
            if (this.shop != null) {
                this.shop.pointerPressed(x, y);
            }
            return;
        }
        if (GameStateController.getInstance().getState() == 1) {
            this.levSelectActive.pointerPressed(x, y);
            return;
        }
        if (this.getIsScreenStory(LevelHolder.getInstance().getCurrentLevel())) {
            if (!this.getIsScreenStory(LevelHolder.getInstance().getCurrentLevel() + 1)) {
                ItemsObservable.getInstance().removeAllObservers();
                this.shop = null;
                GameStateController.getInstance().setState((byte)3);
            }
            Action act = new Action(this, "SETCURRENTLEVEL", "next");
            act.doAction();
            return;
        }
        TopBar.getInstance().pointerPressed(x, y);
        PlayersManager.getInstance().pointerPressed(x, y);
    }

    public void pointerReleased(int x, int y) {
        if (GameStateController.getInstance().getState() == 4) {
            return;
        }
        if (GameStateController.getInstance().getState() == 5 && this.selectGameScreen != null) {
            this.selectGameScreen.pointerReleased(x, y);
            return;
        }
    }

    public void keyPressed(int keyCode) {
        if (GameStateController.getInstance().getState() == 4) {
            return;
        }
        if (GameStateController.getInstance().getState() == 5) {
            if (this.selectGameScreen != null) {
                this.selectGameScreen.keyPressed(keyCode);
            }
            return;
        }
        if (GameStateController.getInstance().getState() == 3) {
            if (this.shop != null) {
                this.shop.keyPressed(keyCode);
            }
            return;
        }
        if (GameStateController.getInstance().getState() == 1) {
            this.levSelectActive.keyPressed(keyCode);
            return;
        }
        if (this.getIsScreenStory(LevelHolder.getInstance().getCurrentLevel())) {
            switch (keyCode) {
                case -203: 
                case 205: 
                case 225: {
                    LevelHolder.getInstance().getLevel(LevelHolder.getInstance().getCurrentLevel()).setLevelStatus(2);
                    if (!this.getIsScreenStory(LevelHolder.getInstance().getCurrentLevel() + 1)) {
                        ItemsObservable.getInstance().removeAllObservers();
                        this.shop = null;
                        GameStateController.getInstance().setState((byte)3);
                    }
                    Action act = new Action(this, "SETCURRENTLEVEL", "next");
                    act.doAction();
                    break;
                }
            }
            return;
        }
        PlayersManager.getInstance().keyPressed(keyCode);
    }
}

