/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.platform.shop;

import com.jarbull.efw.controller.ImageHandler;
import com.jarbull.efw.controller.ResolutionHandler;
import com.jarbull.efw.game.LevelHolder;
import com.jarbull.efw.manager.Action;
import com.jarbull.efw.text.LocalizationSupport;
import com.jarbull.efw.text.TextWriter;
import com.jarbull.platform.data.Constants;
import com.jarbull.platform.data.DataManager;
import com.jarbull.platform.main.GameStateController;
import com.jarbull.platform.shop.Item;
import com.jarbull.platform.shop.ItemsObservable;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class Shop {
    private static final String[] COST_ITEMS_1 = new String[]{"25", "25", "50", "20", "30", "70", "200", LocalizationSupport.getMessage("cont")};
    private static final String[] COST_ITEMS_2 = new String[]{"100", "200", "400", "150", "300", "600", "200", LocalizationSupport.getMessage("cont")};
    private static final int OFFSET_X = 17;
    private static final int OFFSET_Y = 30;
    private Vector vecItems;
    private static String[] COST_ITEMS;
    private static int START_POS_X;
    private static int START_POS_Y;
    private static int BONUSIMG_POS_X;
    private static int BONUSIMG_POS_Y;
    private static int TILE_SIZE;
    private static int currItem;
    private static final Hashtable NAMES;

    public Shop() {
        int i;
        DataManager.getInstance().loadDataForUpgrades();
        DataManager.getInstance().loadDataForMoney();
        COST_ITEMS = DataManager.getInstance().getUpdateX2() == 0 ? COST_ITEMS_1 : COST_ITEMS_2;
        this.vecItems = new Vector();
        ImageHandler.getInstance().load("/res/framework/images/levelSelectScreen/board.png");
        ImageHandler.getInstance().load("/res/game/images/shop/cursor.png");
        ImageHandler.getInstance().load("/res/game/images/shop/shopbonus.png");
        if (ImageHandler.getInstance().getImage(Constants.IMAGE_DROP_BTN[0]) == null) {
            for (i = 0; i < Constants.IMAGE_DROP_BTN.length; ++i) {
                ImageHandler.getInstance().load(Constants.IMAGE_DROP_BTN[i]);
            }
        }
        if (ImageHandler.getInstance().getImage(Constants.IMAGE_SHIELD_BTN[0]) == null) {
            for (i = 0; i < Constants.IMAGE_SHIELD_BTN.length - 1; ++i) {
                ImageHandler.getInstance().load(Constants.IMAGE_SHIELD_BTN[i]);
            }
        }
        if (ImageHandler.getInstance().getImage(Constants.IMAGE_DOUBLEJUMP_BTN[0]) == null) {
            for (i = 0; i < Constants.IMAGE_DOUBLEJUMP_BTN.length - 1; ++i) {
                ImageHandler.getInstance().load(Constants.IMAGE_DOUBLEJUMP_BTN[i]);
            }
        }
        TILE_SIZE = ImageHandler.getInstance().getImage(Constants.IMAGE_DROP_BTN[0]).getWidth();
        START_POS_X = ResolutionHandler.getInstance().getScreenWidth() / 2 - ImageHandler.getInstance().getImage("/res/framework/images/levelSelectScreen/board.png").getWidth() / 2;
        START_POS_Y = ResolutionHandler.getInstance().getScreenHeight() / 2 - ImageHandler.getInstance().getImage("/res/framework/images/levelSelectScreen/board.png").getHeight() / 2;
        this.createItems();
        currItem = 7;
        ItemsObservable.getInstance().selectedItem(7, true);
    }

    private void createItems() {
        int y = 0;
        int currRow = 0;
        int currCol = 0;
        String name = "drop";
        block5: for (int i = 0; i < 8; ++i) {
            ++currCol;
            if (i % 3 == 0 && i != 0) {
                ++currRow;
                currCol = 1;
            }
            int x = START_POS_X + 17 + i % 3 * TILE_SIZE + i % 3 * 5;
            y = START_POS_Y + 30 + currRow * TILE_SIZE + currRow * 5;
            if (i == 7) {
                BONUSIMG_POS_X = x + 5;
                BONUSIMG_POS_Y = y + 5;
                int xx = START_POS_X + ImageHandler.getInstance().getImage("/res/framework/images/levelSelectScreen/board.png").getWidth() / 2 - ImageHandler.getInstance().getImage("/res/framework/images/button_on.png").getWidth() / 2;
                int yy = START_POS_Y + ImageHandler.getInstance().getImage("/res/framework/images/levelSelectScreen/board.png").getHeight();
                this.createItem(xx, yy, 1, LocalizationSupport.getMessage("cont"), Constants.IMAGE_MAINMENU_BTN, "/res/framework/images/button_on.png", i, currCol);
                break;
            }
            name = i < 6 ? (i > 2 ? "shield" : "drop") : "doublejump";
            switch ((Integer)NAMES.get(name)) {
                case 0: {
                    if (currCol <= DataManager.getInstance().getBoombasCnt()) {
                        this.createItem(x, y, 0, name, Constants.IMAGE_DROP_BTN, "/res/game/images/shop/cursor.png", i, currCol);
                        continue block5;
                    }
                    if (currCol == DataManager.getInstance().getBoombasCnt() + 1) {
                        if (Integer.parseInt(COST_ITEMS[i]) <= DataManager.getInstance().getMoneyCnt()) {
                            this.createItem(x, y, 1, name, Constants.IMAGE_DROP_BTN, "/res/game/images/shop/cursor.png", i, currCol);
                            continue block5;
                        }
                        this.createItem(x, y, 2, name, Constants.IMAGE_DROP_BTN, "/res/game/images/shop/cursor.png", i, currCol);
                        continue block5;
                    }
                    this.createItem(x, y, 2, name, Constants.IMAGE_DROP_BTN, "/res/game/images/shop/cursor.png", i, currCol);
                    continue block5;
                }
                case 1: {
                    if (currCol <= DataManager.getInstance().getArmorsCnt()) {
                        this.createItem(x, y, 0, name, Constants.IMAGE_SHIELD_BTN, "/res/game/images/shop/cursor.png", i, currCol);
                        continue block5;
                    }
                    if (currCol == DataManager.getInstance().getArmorsCnt() + 1) {
                        if (Integer.parseInt(COST_ITEMS[i]) <= DataManager.getInstance().getMoneyCnt()) {
                            if (currCol <= DataManager.getInstance().getBoombasCnt()) {
                                this.createItem(x, y, 1, name, Constants.IMAGE_SHIELD_BTN, "/res/game/images/shop/cursor.png", i, currCol);
                                continue block5;
                            }
                            this.createItem(x, y, 2, name, Constants.IMAGE_SHIELD_BTN, "/res/game/images/shop/cursor.png", i, currCol);
                            continue block5;
                        }
                        this.createItem(x, y, 2, name, Constants.IMAGE_SHIELD_BTN, "/res/game/images/shop/cursor.png", i, currCol);
                        continue block5;
                    }
                    this.createItem(x, y, 2, name, Constants.IMAGE_SHIELD_BTN, "/res/game/images/shop/cursor.png", i, currCol);
                    continue block5;
                }
                case 2: {
                    if (currCol <= DataManager.getInstance().getDoublejumpFlag()) {
                        this.createItem(x, y, 0, name, Constants.IMAGE_DOUBLEJUMP_BTN, "/res/game/images/shop/cursor.png", i, currCol);
                        continue block5;
                    }
                    if (currCol == DataManager.getInstance().getDoublejumpFlag() + 1) {
                        if (Integer.parseInt(COST_ITEMS[i]) <= DataManager.getInstance().getMoneyCnt()) {
                            this.createItem(x, y, 1, name, Constants.IMAGE_DOUBLEJUMP_BTN, "/res/game/images/shop/cursor.png", i, currCol);
                            continue block5;
                        }
                        this.createItem(x, y, 2, name, Constants.IMAGE_DOUBLEJUMP_BTN, "/res/game/images/shop/cursor.png", i, currCol);
                        continue block5;
                    }
                    this.createItem(x, y, 2, name, Constants.IMAGE_DOUBLEJUMP_BTN, "/res/game/images/shop/cursor.png", i, currCol);
                }
            }
        }
    }

    private void createItem(int x, int y, int state, String name, String[] sItemImgsPaths, String sCursorImgPath, int id, int orderNo) {
        Item item = new Item(x, y, state, name, sItemImgsPaths, sCursorImgPath, COST_ITEMS[id], id, orderNo);
        this.vecItems.addElement(item);
    }

    public void paint(Graphics g) {
        TextWriter.getInstance().setFont(TextWriter.getInstance().getFont("lao"));
        TextWriter.getInstance().setWriterType(0);
        g.drawImage(ImageHandler.getInstance().getImage("/res/framework/images/page.png"), 0, 0, 0);
        g.drawImage(ImageHandler.getInstance().getImage("/res/framework/images/levelSelectScreen/board.png"), START_POS_X, START_POS_Y, 0);
        g.drawImage(ImageHandler.getInstance().getImage("/res/game/images/shop/shopbonus.png"), BONUSIMG_POS_X, BONUSIMG_POS_Y, 0);
        int sPoints = DataManager.getInstance().getMoneyCnt();
        TextWriter.getInstance().drawText(g, "" + sPoints, BONUSIMG_POS_X + ImageHandler.getInstance().getImage("/res/game/images/shop/shopbonus.png").getWidth() - TextWriter.getInstance().getTextWidth("" + sPoints), BONUSIMG_POS_Y + TextWriter.getInstance().getTextHeight("" + sPoints) / 2);
        for (int i = this.vecItems.size() - 1; i >= 0; --i) {
            Item item = (Item)this.vecItems.elementAt(i);
            item.paint(g);
        }
        TextWriter.getInstance().drawText(g, LocalizationSupport.getMessage("shop"), ResolutionHandler.getInstance().getScreenWidth() / 2 - TextWriter.getInstance().getTextWidth(LocalizationSupport.getMessage("shop")) / 2, START_POS_Y);
    }

    public void keyPressed(int keyCode) {
        switch (keyCode) {
            case 206: 
            case 224: {
                currItem = currItem < this.vecItems.size() - 1 ? (currItem = currItem + 1) : 0;
                ItemsObservable.getInstance().selectedItem(currItem, true);
                break;
            }
            case 204: 
            case 223: {
                currItem = currItem > 0 ? (currItem = currItem - 1) : this.vecItems.size() - 1;
                ItemsObservable.getInstance().selectedItem(currItem, true);
                break;
            }
            case 202: 
            case 221: {
                currItem = currItem > 2 ? currItem - 3 : this.vecItems.size() - 1;
                ItemsObservable.getInstance().selectedItem(currItem, true);
                break;
            }
            case 208: 
            case 222: {
                currItem = currItem < 4 ? currItem + 3 : (currItem < 6 ? 6 : (currItem < 7 ? 7 : 0));
                ItemsObservable.getInstance().selectedItem(currItem, true);
                break;
            }
            case -203: 
            case 205: 
            case 225: {
                if (currItem == 7) {
                    DataManager.getInstance().saveDataForMoney();
                    DataManager.getInstance().saveDataForUpgrades();
                    Action act = new Action(this, "SETCURRENTLEVEL", "" + LevelHolder.getInstance().getCurrentLevel());
                    act.doAction();
                    GameStateController.getInstance().setState((byte)2);
                    ItemsObservable.getInstance().removeAllObservers();
                    break;
                }
                if (this.checkEnableBuy()) {
                    DataManager.getInstance().setMoneyCnt(DataManager.getInstance().getMoneyCnt() - Integer.parseInt(COST_ITEMS[currItem]));
                    ItemsObservable.getInstance().activeItem(currItem, true);
                    if (((Item)this.vecItems.elementAt(currItem)).getName().equals("drop")) {
                        DataManager.getInstance().setBoombasCnt(DataManager.getInstance().getBoombasCnt() + 1);
                    } else if (((Item)this.vecItems.elementAt(currItem)).getName().equals("shield")) {
                        DataManager.getInstance().setArmorsCnt(DataManager.getInstance().getArmorsCnt() + 1);
                    } else if (((Item)this.vecItems.elementAt(currItem)).getName().equals("doublejump")) {
                        DataManager.getInstance().setDoublejumpFlag(DataManager.getInstance().getDoublejumpFlag() + 1);
                    }
                }
                this.checkStatesOfItems();
            }
        }
    }

    private void checkStatesOfItems() {
        int i;
        int currRow = 0;
        int currCol = 0;
        String name = "drop";
        if (DataManager.getInstance().getUpdateX2() == 0 && DataManager.getInstance().getBoombasCnt() == 3 && DataManager.getInstance().getArmorsCnt() == 3) {
            DataManager.getInstance().setArmorsCnt(0);
            DataManager.getInstance().setBoombasCnt(0);
            DataManager.getInstance().setUpdateX2(1);
            DataManager.getInstance().saveDataForUpgrades();
            COST_ITEMS = COST_ITEMS_2;
            for (i = 0; i < 6; ++i) {
                ((Item)this.vecItems.elementAt(i)).setState(2);
                ((Item)this.vecItems.elementAt(i)).setCost(COST_ITEMS[i]);
            }
        }
        block4: for (i = 0; i < 8; ++i) {
            ++currCol;
            if (i % 3 == 0 && i != 0) {
                ++currRow;
                currCol = 1;
            }
            if (i == 7) break;
            name = i < 6 ? (i > 2 ? "shield" : "drop") : "doublejump";
            switch ((Integer)NAMES.get(name)) {
                case 0: 
                case 1: {
                    if (((Item)this.vecItems.elementAt(i)).getState() == 0) {
                        if (((Item)this.vecItems.elementAt(i)).getOrderNo() >= 3 || ((Item)this.vecItems.elementAt(i + 1)).getState() == 0) continue block4;
                        if (Integer.parseInt(COST_ITEMS[i + 1]) <= DataManager.getInstance().getMoneyCnt()) {
                            if (name.equals("shield")) {
                                if (((Item)this.vecItems.elementAt(i + 1)).getOrderNo() <= DataManager.getInstance().getBoombasCnt()) {
                                    ((Item)this.vecItems.elementAt(i + 1)).setState(1);
                                    continue block4;
                                }
                                ((Item)this.vecItems.elementAt(i + 1)).setState(2);
                                continue block4;
                            }
                            ((Item)this.vecItems.elementAt(i + 1)).setState(1);
                            continue block4;
                        }
                        if (((Item)this.vecItems.elementAt(i + 1)).getState() == 0) continue block4;
                        ((Item)this.vecItems.elementAt(i + 1)).setState(2);
                        continue block4;
                    }
                    if (name.equals("drop") && ((Item)this.vecItems.elementAt(i)).getOrderNo() == 1 && ((Item)this.vecItems.elementAt(i)).getState() > 1 && Integer.parseInt(COST_ITEMS[i]) <= DataManager.getInstance().getMoneyCnt()) {
                        ((Item)this.vecItems.elementAt(i)).setState(((Item)this.vecItems.elementAt(i)).getState() - 1);
                    }
                    if (!name.equals("shield") || ((Item)this.vecItems.elementAt(i)).getOrderNo() != 1 || ((Item)this.vecItems.elementAt(i)).getState() <= 1 || Integer.parseInt(COST_ITEMS[i]) > DataManager.getInstance().getMoneyCnt() || ((Item)this.vecItems.elementAt(i)).getOrderNo() > DataManager.getInstance().getBoombasCnt()) continue block4;
                    ((Item)this.vecItems.elementAt(i)).setState(((Item)this.vecItems.elementAt(i)).getState() - 1);
                }
            }
        }
    }

    private boolean checkEnableBuy() {
        if (((Item)this.vecItems.elementAt(currItem)).getName().equals("drop")) {
            System.out.println("DROP!!!!");
            if (((Item)this.vecItems.elementAt(currItem)).getOrderNo() == DataManager.getInstance().getBoombasCnt() + 1 && Integer.parseInt(((Item)this.vecItems.elementAt(currItem)).getCost()) <= DataManager.getInstance().getMoneyCnt()) {
                return true;
            }
        }
        if (((Item)this.vecItems.elementAt(currItem)).getName().equals("shield") && ((Item)this.vecItems.elementAt(currItem)).getOrderNo() <= DataManager.getInstance().getBoombasCnt() && ((Item)this.vecItems.elementAt(currItem)).getOrderNo() == DataManager.getInstance().getArmorsCnt() + 1 && Integer.parseInt(((Item)this.vecItems.elementAt(currItem)).getCost()) <= DataManager.getInstance().getMoneyCnt()) {
            return true;
        }
        return ((Item)this.vecItems.elementAt(currItem)).getName().equals("doublejump") && ((Item)this.vecItems.elementAt(currItem)).getOrderNo() == DataManager.getInstance().getDoublejumpFlag() + 1 && Integer.parseInt(((Item)this.vecItems.elementAt(currItem)).getCost()) <= DataManager.getInstance().getMoneyCnt();
    }

    public void pointerPressed(int x, int y) {
        for (int i = this.vecItems.size() - 1; i >= 0; --i) {
            Item item = (Item)this.vecItems.elementAt(i);
            if (!item.getIsPointerPressed(x, y)) continue;
            currItem = item.getId();
            if (!item.isSelected()) {
                ItemsObservable.getInstance().selectedItem(item.getId(), true);
                continue;
            }
            if (item.getId() == 7) {
                DataManager.getInstance().saveDataForMoney();
                DataManager.getInstance().saveDataForUpgrades();
                Action act = new Action(this, "SETCURRENTLEVEL", "" + LevelHolder.getInstance().getCurrentLevel());
                act.doAction();
                GameStateController.getInstance().setState((byte)2);
                ItemsObservable.getInstance().removeAllObservers();
                break;
            }
            if (this.checkEnableBuy()) {
                DataManager.getInstance().setMoneyCnt(DataManager.getInstance().getMoneyCnt() - Integer.parseInt(COST_ITEMS[currItem]));
                ItemsObservable.getInstance().activeItem(currItem, true);
                if (((Item)this.vecItems.elementAt(currItem)).getName().equals("drop")) {
                    DataManager.getInstance().setBoombasCnt(DataManager.getInstance().getBoombasCnt() + 1);
                } else if (((Item)this.vecItems.elementAt(currItem)).getName().equals("shield")) {
                    DataManager.getInstance().setArmorsCnt(DataManager.getInstance().getArmorsCnt() + 1);
                } else if (((Item)this.vecItems.elementAt(currItem)).getName().equals("doublejump")) {
                    DataManager.getInstance().setDoublejumpFlag(DataManager.getInstance().getDoublejumpFlag() + 1);
                }
            }
            this.checkStatesOfItems();
        }
    }

    public void tick() {
    }

    static {
        START_POS_X = 0;
        START_POS_Y = 0;
        BONUSIMG_POS_X = 0;
        BONUSIMG_POS_Y = 0;
        TILE_SIZE = 80;
        currItem = 0;
        NAMES = new Hashtable();
        NAMES.put("drop", new Integer(0));
        NAMES.put("shield", new Integer(1));
        NAMES.put("doublejump", new Integer(2));
        NAMES.put("mainmenu", new Integer(3));
    }
}

