/*
 * Decompiled with CFR 0.152.
 */
package com.mobile2win.j2me.animation;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class Sprite {
    public int screenWidth = 0;
    public int screenHeight = 0;
    public Image imgSprite;
    public int x;
    public int y;
    public int xSpeed;
    public int ySpeed;
    public int totalFrames;
    public int currentFrame;
    public int currentFrameCntr;
    protected int[] stripFrameX;
    protected int[] stripFrameY;
    protected int[] stripFrameW;
    protected int[] stripFrameH;
    protected int[] framePaintingTimes;
    protected int[] frameScreenX;
    protected int[] frameScreenY;
    public boolean repeatAnimation;
    protected static final int SPRITE_TYPE_SINGLE = 0;
    public static final int SPRITE_TYPE_STRIP = 1;
    public static final int SPRITE_TYPE_GENERIC = 2;
    public int spriteType = 0;
    public boolean collided = false;

    public abstract void setAnimationParameters();

    public void setScreenWidthHeight(int n, int n2) {
        this.screenWidth = n;
        this.screenHeight = n2;
    }

    public void setFrameParameters(int n) {
        this.totalFrames = this.stripFrameX.length;
        this.currentFrame = 0;
        this.currentFrameCntr = 0;
    }

    public void controlAnimation() throws ArrayIndexOutOfBoundsException {
        ++this.currentFrameCntr;
        switch (this.spriteType) {
            case 0: {
                if (this.currentFrameCntr != this.framePaintingTimes[0]) break;
                this.currentFrameCntr = 0;
                ++this.currentFrame;
                if (this.currentFrame != this.totalFrames || !this.repeatAnimation) break;
                this.currentFrame = 0;
                break;
            }
            case 1: {
                if (this.currentFrameCntr != this.framePaintingTimes[0]) break;
                this.currentFrameCntr = 0;
                ++this.currentFrame;
                if (this.currentFrame != this.totalFrames || !this.repeatAnimation) break;
                this.currentFrame = 0;
                break;
            }
            case 2: {
                if (this.currentFrameCntr != this.framePaintingTimes[this.currentFrame]) break;
                this.currentFrameCntr = 0;
                ++this.currentFrame;
                if (this.currentFrame != this.totalFrames || !this.repeatAnimation) break;
                this.currentFrame = 0;
            }
        }
    }

    public void paint(Graphics graphics) throws ArrayIndexOutOfBoundsException {
        try {
            if (this.frameScreenX != null) {
                this.x = this.frameScreenX[this.currentFrame];
            }
            if (this.frameScreenY != null) {
                this.y = this.frameScreenY[this.currentFrame];
            }
            switch (this.spriteType) {
                case 0: {
                    graphics.setClip(this.x, this.y, this.stripFrameW[0], this.stripFrameH[0]);
                    graphics.drawImage(this.imgSprite, this.x - this.stripFrameX[0], this.y - this.stripFrameY[0], 20);
                    break;
                }
                case 1: {
                    graphics.setClip(this.x, this.y, this.stripFrameW[0], this.stripFrameH[0]);
                    graphics.drawImage(this.imgSprite, this.x - this.stripFrameX[this.currentFrame], this.y - this.stripFrameY[0], 20);
                    break;
                }
                case 2: {
                    graphics.setClip(this.x, this.y, this.stripFrameW[this.currentFrame], this.stripFrameH[this.currentFrame]);
                    graphics.drawImage(this.imgSprite, this.x - this.stripFrameX[this.currentFrame], this.y - this.stripFrameY[this.currentFrame], 20);
                }
            }
            graphics.setClip(0, 0, this.screenWidth, this.screenHeight);
        }
        catch (Exception exception) {
            System.out.println("error in sprite paint");
        }
    }

    public boolean isCollided(Sprite sprite) throws ArrayIndexOutOfBoundsException {
        switch (this.spriteType) {
            case 0: 
            case 1: {
                if (this.x + this.stripFrameW[0] >= sprite.x && this.x <= sprite.x + sprite.stripFrameW[0] && this.y + this.stripFrameH[0] >= sprite.y && this.y <= sprite.y + sprite.stripFrameH[0]) {
                    sprite.collided = true;
                    return true;
                }
                sprite.collided = false;
                return false;
            }
            case 2: {
                if (this.x + this.stripFrameW[this.currentFrame] >= sprite.x && this.x <= sprite.x + sprite.stripFrameW[sprite.currentFrame] && this.y + this.stripFrameH[this.currentFrame] >= sprite.y && this.y <= sprite.y + sprite.stripFrameH[sprite.currentFrame]) {
                    sprite.collided = true;
                    this.collided = true;
                    return true;
                }
                sprite.collided = false;
                return false;
            }
        }
        return false;
    }
}

