/*
 * Decompiled with CFR 0.152.
 */
package gameboy.core;

import gameboy.core.Interrupt;
import gameboy.core.Memory;

public final class CPU {
    public static final int Z_FLAG = 128;
    public static final int N_FLAG = 64;
    public static final int H_FLAG = 32;
    public static final int C_FLAG = 16;
    private int a;
    private int f;
    private int b;
    private int c;
    private int d;
    private int e;
    private int h;
    private int l;
    private int sp;
    private int pc;
    private boolean ime;
    private boolean halted;
    private int cycles;
    private Interrupt interrupt;
    private Memory memory;
    private byte[] rom;

    public CPU(Interrupt interrupt, Memory memory) {
        this.interrupt = interrupt;
        this.memory = memory;
        this.reset();
    }

    public void setState(int[] cpuState) {
        this.a = cpuState[0];
        this.f = cpuState[1];
        this.b = cpuState[2];
        this.c = cpuState[3];
        this.d = cpuState[4];
        this.e = cpuState[5];
        this.h = cpuState[6];
        this.l = cpuState[7];
        this.sp = cpuState[8];
        this.pc = cpuState[9];
        this.ime = cpuState[10] == 1;
        this.halted = cpuState[11] == 1;
    }

    public int[] getState() {
        int[] state = new int[]{this.a, this.f, this.b, this.c, this.d, this.e, this.h, this.l, this.sp, this.pc, this.ime ? 1 : 0, this.halted ? 1 : 0};
        return state;
    }

    public final int getBC() {
        return (this.b << 8) + this.c;
    }

    public final int getDE() {
        return (this.d << 8) + this.e;
    }

    public final int getHL() {
        return (this.h << 8) + this.l;
    }

    public final int getSP() {
        return this.sp;
    }

    public final int getPC() {
        return this.pc;
    }

    public final int getAF() {
        return (this.a << 8) + this.f;
    }

    public final int getIF() {
        return (this.ime ? 1 : 0) + (this.halted ? 128 : 0);
    }

    public final void setROM(byte[] banks) {
        this.rom = banks;
    }

    public final void reset() {
        this.a = 1;
        this.f = 128;
        this.b = 0;
        this.c = 19;
        this.d = 0;
        this.e = 216;
        this.h = 1;
        this.l = 77;
        this.sp = 65534;
        this.pc = 256;
        this.ime = false;
        this.halted = false;
        this.cycles = 0;
    }

    public final void emulate(int ticks) {
        this.cycles += ticks;
        this.interrupt();
        while (this.cycles > 0) {
            this.execute();
        }
    }

    public final void interrupt() {
        if (this.halted) {
            if (this.interrupt.isPending()) {
                this.halted = false;
                this.cycles -= 4;
            } else if (this.cycles > 0) {
                this.cycles = 0;
            }
        }
        if (this.ime && this.interrupt.isPending()) {
            if (this.interrupt.isPending(1)) {
                this.interrupt(64);
                this.interrupt.lower(1);
            } else if (this.interrupt.isPending(2)) {
                this.interrupt(72);
                this.interrupt.lower(2);
            } else if (this.interrupt.isPending(16)) {
                this.interrupt(96);
                this.interrupt.lower(16);
            }
        }
    }

    private final void interrupt(int address) {
        this.ime = false;
        this.call(address);
    }

    private final void execute() {
        this.execute(this.fetch());
    }

    private final void execute(int opcode) {
        switch (opcode) {
            case 42: {
                this.ldi_A_HLi();
                break;
            }
            case 32: {
                this.jr_NZ_nn();
                break;
            }
            case 12: {
                this.inc_C();
                break;
            }
            case 2: {
                this.ld_BCi_A();
                break;
            }
            case 240: {
                this.ldh_A_mem();
                break;
            }
            case 40: {
                this.jr_Z_nn();
                break;
            }
            case 34: {
                this.ldi_HLi_A();
                break;
            }
            case 19: {
                this.inc_DE();
                break;
            }
            case 224: {
                this.ldh_mem_A();
                break;
            }
            case 167: {
                this.and_A_A();
                break;
            }
            case 61: {
                this.dec_A();
                break;
            }
            case 18: {
                this.ld_DEi_A();
                break;
            }
            case 254: {
                this.cp_A_nn();
                break;
            }
            case 203: {
                switch (this.fetch()) {
                    case 63: {
                        this.srl_A();
                        break;
                    }
                    case 127: {
                        this.bit_A(7);
                        break;
                    }
                    case 111: {
                        this.bit_A(5);
                        break;
                    }
                    case 55: {
                        this.swap_A();
                        break;
                    }
                    case 124: {
                        this.bit_H(7);
                        break;
                    }
                    case 60: {
                        this.srl_H();
                        break;
                    }
                    case 123: {
                        this.bit_E(7);
                        break;
                    }
                    case 7: {
                        this.rlc_A();
                        break;
                    }
                    case 70: {
                        this.bit_HLi(0);
                        break;
                    }
                    case 94: {
                        this.bit_HLi(3);
                        break;
                    }
                    case 78: {
                        this.bit_HLi(1);
                        break;
                    }
                    case 84: {
                        this.bit_H(2);
                        break;
                    }
                    case 95: {
                        this.bit_A(3);
                        break;
                    }
                    case 67: {
                        this.bit_E(0);
                        break;
                    }
                    case 29: {
                        this.rr_L();
                        break;
                    }
                    case 103: {
                        this.bit_A(4);
                        break;
                    }
                    case 16: {
                        this.rl_B();
                        break;
                    }
                    case 108: {
                        this.bit_H(5);
                        break;
                    }
                    case 79: {
                        this.bit_A(1);
                        break;
                    }
                    case 121: {
                        this.bit_C(7);
                        break;
                    }
                    case 102: {
                        this.bit_HLi(4);
                        break;
                    }
                    case 71: {
                        this.bit_A(0);
                        break;
                    }
                    case 0: {
                        this.rlc_B();
                        break;
                    }
                    case 1: {
                        this.rlc_C();
                        break;
                    }
                    case 2: {
                        this.rlc_D();
                        break;
                    }
                    case 3: {
                        this.rlc_E();
                        break;
                    }
                    case 4: {
                        this.rlc_H();
                        break;
                    }
                    case 5: {
                        this.rlc_L();
                        break;
                    }
                    case 6: {
                        this.rlc_HLi();
                        break;
                    }
                    case 8: {
                        this.rrc_B();
                        break;
                    }
                    case 9: {
                        this.rrc_C();
                        break;
                    }
                    case 10: {
                        this.rrc_D();
                        break;
                    }
                    case 11: {
                        this.rrc_E();
                        break;
                    }
                    case 12: {
                        this.rrc_H();
                        break;
                    }
                    case 13: {
                        this.rrc_L();
                        break;
                    }
                    case 14: {
                        this.rrc_HLi();
                        break;
                    }
                    case 15: {
                        this.rrc_A();
                        break;
                    }
                    case 17: {
                        this.rl_C();
                        break;
                    }
                    case 18: {
                        this.rl_D();
                        break;
                    }
                    case 19: {
                        this.rl_E();
                        break;
                    }
                    case 20: {
                        this.rl_H();
                        break;
                    }
                    case 21: {
                        this.rl_L();
                        break;
                    }
                    case 22: {
                        this.rl_HLi();
                        break;
                    }
                    case 23: {
                        this.rl_A();
                        break;
                    }
                    case 24: {
                        this.rr_B();
                        break;
                    }
                    case 25: {
                        this.rr_C();
                        break;
                    }
                    case 26: {
                        this.rr_D();
                        break;
                    }
                    case 27: {
                        this.rr_E();
                        break;
                    }
                    case 28: {
                        this.rr_H();
                        break;
                    }
                    case 30: {
                        this.rr_HLi();
                        break;
                    }
                    case 31: {
                        this.rr_A();
                        break;
                    }
                    case 32: {
                        this.sla_B();
                        break;
                    }
                    case 33: {
                        this.sla_C();
                        break;
                    }
                    case 34: {
                        this.sla_D();
                        break;
                    }
                    case 35: {
                        this.sla_E();
                        break;
                    }
                    case 36: {
                        this.sla_H();
                        break;
                    }
                    case 37: {
                        this.sla_L();
                        break;
                    }
                    case 38: {
                        this.sla_HLi();
                        break;
                    }
                    case 39: {
                        this.sla_A();
                        break;
                    }
                    case 40: {
                        this.sra_B();
                        break;
                    }
                    case 41: {
                        this.sra_C();
                        break;
                    }
                    case 42: {
                        this.sra_D();
                        break;
                    }
                    case 43: {
                        this.sra_E();
                        break;
                    }
                    case 44: {
                        this.sra_H();
                        break;
                    }
                    case 45: {
                        this.sra_L();
                        break;
                    }
                    case 46: {
                        this.sra_HLi();
                        break;
                    }
                    case 47: {
                        this.sra_A();
                        break;
                    }
                    case 48: {
                        this.swap_B();
                        break;
                    }
                    case 49: {
                        this.swap_C();
                        break;
                    }
                    case 50: {
                        this.swap_D();
                        break;
                    }
                    case 51: {
                        this.swap_E();
                        break;
                    }
                    case 52: {
                        this.swap_H();
                        break;
                    }
                    case 53: {
                        this.swap_L();
                        break;
                    }
                    case 54: {
                        this.swap_HLi();
                        break;
                    }
                    case 56: {
                        this.srl_B();
                        break;
                    }
                    case 57: {
                        this.srl_C();
                        break;
                    }
                    case 58: {
                        this.srl_D();
                        break;
                    }
                    case 59: {
                        this.srl_E();
                        break;
                    }
                    case 61: {
                        this.srl_L();
                        break;
                    }
                    case 62: {
                        this.srl_HLi();
                        break;
                    }
                    case 64: {
                        this.bit_B(0);
                        break;
                    }
                    case 65: {
                        this.bit_C(0);
                        break;
                    }
                    case 66: {
                        this.bit_D(0);
                        break;
                    }
                    case 68: {
                        this.bit_H(0);
                        break;
                    }
                    case 69: {
                        this.bit_L(0);
                        break;
                    }
                    case 72: {
                        this.bit_B(1);
                        break;
                    }
                    case 73: {
                        this.bit_C(1);
                        break;
                    }
                    case 74: {
                        this.bit_D(1);
                        break;
                    }
                    case 75: {
                        this.bit_E(1);
                        break;
                    }
                    case 76: {
                        this.bit_H(1);
                        break;
                    }
                    case 77: {
                        this.bit_L(1);
                        break;
                    }
                    case 80: {
                        this.bit_B(2);
                        break;
                    }
                    case 81: {
                        this.bit_C(2);
                        break;
                    }
                    case 82: {
                        this.bit_D(2);
                        break;
                    }
                    case 83: {
                        this.bit_E(2);
                        break;
                    }
                    case 85: {
                        this.bit_L(2);
                        break;
                    }
                    case 86: {
                        this.bit_HLi(2);
                        break;
                    }
                    case 87: {
                        this.bit_A(2);
                        break;
                    }
                    case 88: {
                        this.bit_B(3);
                        break;
                    }
                    case 89: {
                        this.bit_C(3);
                        break;
                    }
                    case 90: {
                        this.bit_D(3);
                        break;
                    }
                    case 91: {
                        this.bit_E(3);
                        break;
                    }
                    case 92: {
                        this.bit_H(3);
                        break;
                    }
                    case 93: {
                        this.bit_L(3);
                        break;
                    }
                    case 96: {
                        this.bit_B(4);
                        break;
                    }
                    case 97: {
                        this.bit_C(4);
                        break;
                    }
                    case 98: {
                        this.bit_D(4);
                        break;
                    }
                    case 99: {
                        this.bit_E(4);
                        break;
                    }
                    case 100: {
                        this.bit_H(4);
                        break;
                    }
                    case 101: {
                        this.bit_L(4);
                        break;
                    }
                    case 104: {
                        this.bit_B(5);
                        break;
                    }
                    case 105: {
                        this.bit_C(5);
                        break;
                    }
                    case 106: {
                        this.bit_D(5);
                        break;
                    }
                    case 107: {
                        this.bit_E(5);
                        break;
                    }
                    case 109: {
                        this.bit_L(5);
                        break;
                    }
                    case 110: {
                        this.bit_HLi(5);
                        break;
                    }
                    case 112: {
                        this.bit_B(6);
                        break;
                    }
                    case 113: {
                        this.bit_C(6);
                        break;
                    }
                    case 114: {
                        this.bit_D(6);
                        break;
                    }
                    case 115: {
                        this.bit_E(6);
                        break;
                    }
                    case 116: {
                        this.bit_H(6);
                        break;
                    }
                    case 117: {
                        this.bit_L(6);
                        break;
                    }
                    case 118: {
                        this.bit_HLi(6);
                        break;
                    }
                    case 119: {
                        this.bit_A(6);
                        break;
                    }
                    case 120: {
                        this.bit_B(7);
                        break;
                    }
                    case 122: {
                        this.bit_D(7);
                        break;
                    }
                    case 125: {
                        this.bit_L(7);
                        break;
                    }
                    case 126: {
                        this.bit_HLi(7);
                        break;
                    }
                    case 192: {
                        this.set_B(0);
                        break;
                    }
                    case 193: {
                        this.set_C(0);
                        break;
                    }
                    case 194: {
                        this.set_D(0);
                        break;
                    }
                    case 195: {
                        this.set_E(0);
                        break;
                    }
                    case 196: {
                        this.set_H(0);
                        break;
                    }
                    case 197: {
                        this.set_L(0);
                        break;
                    }
                    case 198: {
                        this.set_HLi(0);
                        break;
                    }
                    case 199: {
                        this.set_A(0);
                        break;
                    }
                    case 200: {
                        this.set_B(1);
                        break;
                    }
                    case 201: {
                        this.set_C(1);
                        break;
                    }
                    case 202: {
                        this.set_D(1);
                        break;
                    }
                    case 203: {
                        this.set_E(1);
                        break;
                    }
                    case 204: {
                        this.set_H(1);
                        break;
                    }
                    case 205: {
                        this.set_L(1);
                        break;
                    }
                    case 206: {
                        this.set_HLi(1);
                        break;
                    }
                    case 207: {
                        this.set_A(1);
                        break;
                    }
                    case 208: {
                        this.set_B(2);
                        break;
                    }
                    case 209: {
                        this.set_C(2);
                        break;
                    }
                    case 210: {
                        this.set_D(2);
                        break;
                    }
                    case 211: {
                        this.set_E(2);
                        break;
                    }
                    case 212: {
                        this.set_H(2);
                        break;
                    }
                    case 213: {
                        this.set_L(2);
                        break;
                    }
                    case 214: {
                        this.set_HLi(2);
                        break;
                    }
                    case 215: {
                        this.set_A(2);
                        break;
                    }
                    case 216: {
                        this.set_B(3);
                        break;
                    }
                    case 217: {
                        this.set_C(3);
                        break;
                    }
                    case 218: {
                        this.set_D(3);
                        break;
                    }
                    case 219: {
                        this.set_E(3);
                        break;
                    }
                    case 220: {
                        this.set_H(3);
                        break;
                    }
                    case 221: {
                        this.set_L(3);
                        break;
                    }
                    case 222: {
                        this.set_HLi(3);
                        break;
                    }
                    case 223: {
                        this.set_A(3);
                        break;
                    }
                    case 224: {
                        this.set_B(4);
                        break;
                    }
                    case 225: {
                        this.set_C(4);
                        break;
                    }
                    case 226: {
                        this.set_D(4);
                        break;
                    }
                    case 227: {
                        this.set_E(4);
                        break;
                    }
                    case 228: {
                        this.set_H(4);
                        break;
                    }
                    case 229: {
                        this.set_L(4);
                        break;
                    }
                    case 230: {
                        this.set_HLi(4);
                        break;
                    }
                    case 231: {
                        this.set_A(4);
                        break;
                    }
                    case 232: {
                        this.set_B(5);
                        break;
                    }
                    case 233: {
                        this.set_C(5);
                        break;
                    }
                    case 234: {
                        this.set_D(5);
                        break;
                    }
                    case 235: {
                        this.set_E(5);
                        break;
                    }
                    case 236: {
                        this.set_H(5);
                        break;
                    }
                    case 237: {
                        this.set_L(5);
                        break;
                    }
                    case 238: {
                        this.set_HLi(5);
                        break;
                    }
                    case 239: {
                        this.set_A(5);
                        break;
                    }
                    case 240: {
                        this.set_B(6);
                        break;
                    }
                    case 241: {
                        this.set_C(6);
                        break;
                    }
                    case 242: {
                        this.set_D(6);
                        break;
                    }
                    case 243: {
                        this.set_E(6);
                        break;
                    }
                    case 244: {
                        this.set_H(6);
                        break;
                    }
                    case 245: {
                        this.set_L(6);
                        break;
                    }
                    case 246: {
                        this.set_HLi(6);
                        break;
                    }
                    case 247: {
                        this.set_A(6);
                        break;
                    }
                    case 248: {
                        this.set_B(7);
                        break;
                    }
                    case 249: {
                        this.set_C(7);
                        break;
                    }
                    case 250: {
                        this.set_D(7);
                        break;
                    }
                    case 251: {
                        this.set_E(7);
                        break;
                    }
                    case 252: {
                        this.set_H(7);
                        break;
                    }
                    case 253: {
                        this.set_L(7);
                        break;
                    }
                    case 254: {
                        this.set_HLi(7);
                        break;
                    }
                    case 255: {
                        this.set_A(7);
                        break;
                    }
                    case 128: {
                        this.res_B(0);
                        break;
                    }
                    case 129: {
                        this.res_C(0);
                        break;
                    }
                    case 130: {
                        this.res_D(0);
                        break;
                    }
                    case 131: {
                        this.res_E(0);
                        break;
                    }
                    case 132: {
                        this.res_H(0);
                        break;
                    }
                    case 133: {
                        this.res_L(0);
                        break;
                    }
                    case 134: {
                        this.res_HLi(0);
                        break;
                    }
                    case 135: {
                        this.res_A(0);
                        break;
                    }
                    case 136: {
                        this.res_B(1);
                        break;
                    }
                    case 137: {
                        this.res_C(1);
                        break;
                    }
                    case 138: {
                        this.res_D(1);
                        break;
                    }
                    case 139: {
                        this.res_E(1);
                        break;
                    }
                    case 140: {
                        this.res_H(1);
                        break;
                    }
                    case 141: {
                        this.res_L(1);
                        break;
                    }
                    case 142: {
                        this.res_HLi(1);
                        break;
                    }
                    case 143: {
                        this.res_A(1);
                        break;
                    }
                    case 144: {
                        this.res_B(2);
                        break;
                    }
                    case 145: {
                        this.res_C(2);
                        break;
                    }
                    case 146: {
                        this.res_D(2);
                        break;
                    }
                    case 147: {
                        this.res_E(2);
                        break;
                    }
                    case 148: {
                        this.res_H(2);
                        break;
                    }
                    case 149: {
                        this.res_L(2);
                        break;
                    }
                    case 150: {
                        this.res_HLi(2);
                        break;
                    }
                    case 151: {
                        this.res_A(2);
                        break;
                    }
                    case 152: {
                        this.res_B(3);
                        break;
                    }
                    case 153: {
                        this.res_C(3);
                        break;
                    }
                    case 154: {
                        this.res_D(3);
                        break;
                    }
                    case 155: {
                        this.res_E(3);
                        break;
                    }
                    case 156: {
                        this.res_H(3);
                        break;
                    }
                    case 157: {
                        this.res_L(3);
                        break;
                    }
                    case 158: {
                        this.res_HLi(3);
                        break;
                    }
                    case 159: {
                        this.res_A(3);
                        break;
                    }
                    case 160: {
                        this.res_B(4);
                        break;
                    }
                    case 161: {
                        this.res_C(4);
                        break;
                    }
                    case 162: {
                        this.res_D(4);
                        break;
                    }
                    case 163: {
                        this.res_E(4);
                        break;
                    }
                    case 164: {
                        this.res_H(4);
                        break;
                    }
                    case 165: {
                        this.res_L(4);
                        break;
                    }
                    case 166: {
                        this.res_HLi(4);
                        break;
                    }
                    case 167: {
                        this.res_A(4);
                        break;
                    }
                    case 168: {
                        this.res_B(5);
                        break;
                    }
                    case 169: {
                        this.res_C(5);
                        break;
                    }
                    case 170: {
                        this.res_D(5);
                        break;
                    }
                    case 171: {
                        this.res_E(5);
                        break;
                    }
                    case 172: {
                        this.res_H(5);
                        break;
                    }
                    case 173: {
                        this.res_L(5);
                        break;
                    }
                    case 174: {
                        this.res_HLi(5);
                        break;
                    }
                    case 175: {
                        this.res_A(5);
                        break;
                    }
                    case 176: {
                        this.res_B(6);
                        break;
                    }
                    case 177: {
                        this.res_C(6);
                        break;
                    }
                    case 178: {
                        this.res_D(6);
                        break;
                    }
                    case 179: {
                        this.res_E(6);
                        break;
                    }
                    case 180: {
                        this.res_H(6);
                        break;
                    }
                    case 181: {
                        this.res_L(6);
                        break;
                    }
                    case 182: {
                        this.res_HLi(6);
                        break;
                    }
                    case 183: {
                        this.res_A(6);
                        break;
                    }
                    case 184: {
                        this.res_B(7);
                        break;
                    }
                    case 185: {
                        this.res_C(7);
                        break;
                    }
                    case 186: {
                        this.res_D(7);
                        break;
                    }
                    case 187: {
                        this.res_E(7);
                        break;
                    }
                    case 188: {
                        this.res_H(7);
                        break;
                    }
                    case 189: {
                        this.res_L(7);
                        break;
                    }
                    case 190: {
                        this.res_HLi(7);
                        break;
                    }
                    case 191: {
                        this.res_A(7);
                    }
                }
                break;
            }
            case 44: {
                this.inc_L();
                break;
            }
            case 46: {
                this.ld_L_nn();
                break;
            }
            case 126: {
                this.ld_A_HLi();
                break;
            }
            case 177: {
                this.or_A_C();
                break;
            }
            case 120: {
                this.ld_A_B();
                break;
            }
            case 11: {
                this.dec_BC();
                break;
            }
            case 250: {
                this.ld_A_mem();
                break;
            }
            case 26: {
                this.load_A_DEi();
                break;
            }
            case 205: {
                this.call_nnnn();
                break;
            }
            case 62: {
                this.ld_A_nn();
                break;
            }
            case 135: {
                this.add_A_A();
                break;
            }
            case 111: {
                this.ld_L_A();
                break;
            }
            case 13: {
                this.dec_C();
                break;
            }
            case 28: {
                this.inc_E();
                break;
            }
            case 48: {
                this.jr_NC_nn();
                break;
            }
            case 103: {
                this.ld_H_A();
                break;
            }
            case 201: {
                this.ret();
                break;
            }
            case 79: {
                this.ld_C_A();
                break;
            }
            case 230: {
                this.and_A_nn();
                break;
            }
            case 56: {
                this.jr_C_nn();
                break;
            }
            case 200: {
                this.ret_Z();
                break;
            }
            case 198: {
                this.add_A_nn();
                break;
            }
            case 234: {
                this.ld_mem_A();
                break;
            }
            case 241: {
                this.pop_AF();
                break;
            }
            case 242: {
                this.ldh_A_Ci();
                break;
            }
            case 245: {
                this.push_AF();
                break;
            }
            case 41: {
                this.add_HL_HL();
                break;
            }
            case 5: {
                this.dec_B();
                break;
            }
            case 225: {
                this.pop_HL();
                break;
            }
            case 229: {
                this.push_HL();
                break;
            }
            case 33: {
                this.ld_HL_nnnn();
                break;
            }
            case 17: {
                this.ld_DE_nnnn();
                break;
            }
            case 195: {
                this.jp_nnnn();
                break;
            }
            case 124: {
                this.ld_A_H();
                break;
            }
            case 25: {
                this.add_HL_DE();
                break;
            }
            case 226: {
                this.ldh_Ci_A();
                break;
            }
            case 202: {
                this.jp_Z_nnnn();
                break;
            }
            case 121: {
                this.ld_A_C();
                break;
            }
            case 3: {
                this.inc_BC();
                break;
            }
            case 95: {
                this.ld_E_A();
                break;
            }
            case 24: {
                this.jr_nn();
                break;
            }
            case 35: {
                this.inc_HL();
                break;
            }
            case 123: {
                this.ld_A_E();
                break;
            }
            case 10: {
                this.ld_A_BCi();
                break;
            }
            case 36: {
                this.inc_H();
                break;
            }
            case 134: {
                this.add_A_HLi();
                break;
            }
            case 60: {
                this.inc_A();
                break;
            }
            case 125: {
                this.ld_A_L();
                break;
            }
            case 175: {
                this.xor_A_A();
                break;
            }
            case 192: {
                this.ret_NZ();
                break;
            }
            case 149: {
                this.sub_A_L();
                break;
            }
            case 71: {
                this.ld_B_A();
                break;
            }
            case 119: {
                this.ld_HLi_A();
                break;
            }
            case 1: {
                this.ld_BC_nnnn();
                break;
            }
            case 38: {
                this.ld_H_nn();
                break;
            }
            case 86: {
                this.ld_D_HLi();
                break;
            }
            case 53: {
                this.dec_HLi();
                break;
            }
            case 138: {
                this.adc_A_D();
                break;
            }
            case 87: {
                this.ld_D_A();
                break;
            }
            case 94: {
                this.ld_E_HLi();
                break;
            }
            case 185: {
                this.cp_A_C();
                break;
            }
            case 131: {
                this.add_A_E();
                break;
            }
            case 122: {
                this.ld_A_D();
                break;
            }
            case 208: {
                this.ret_NC();
                break;
            }
            case 128: {
                this.add_A_B();
                break;
            }
            case 190: {
                this.cp_A_HLi();
                break;
            }
            case 214: {
                this.sub_A_nn();
                break;
            }
            case 206: {
                this.adc_A_nn();
                break;
            }
            case 6: {
                this.ld_B_nn();
                break;
            }
            case 113: {
                this.ld_HLi_C();
                break;
            }
            case 197: {
                this.push_BC();
                break;
            }
            case 193: {
                this.pop_BC();
                break;
            }
            case 152: {
                this.sbc_A_B();
                break;
            }
            case 43: {
                this.dec_HL();
                break;
            }
            case 112: {
                this.ld_HLi_B();
                break;
            }
            case 150: {
                this.sub_A_HLi();
                break;
            }
            case 196: {
                this.call_NZ_nnnn();
                break;
            }
            case 143: {
                this.adc_A_A();
                break;
            }
            case 70: {
                this.ld_B_HLi();
                break;
            }
            case 14: {
                this.ld_C_nn();
                break;
            }
            case 204: {
                this.call_Z_nnnn();
                break;
            }
            case 213: {
                this.push_DE();
                break;
            }
            case 145: {
                this.sub_A_C();
                break;
            }
            case 184: {
                this.cp_A_B();
                break;
            }
            case 209: {
                this.pop_DE();
                break;
            }
            case 140: {
                this.adc_A_H();
                break;
            }
            case 194: {
                this.jp_NZ_nnnn();
                break;
            }
            case 133: {
                this.add_A_L();
                break;
            }
            case 22: {
                this.ld_D_nn();
                break;
            }
            case 78: {
                this.ld_C_HLi();
                break;
            }
            case 147: {
                this.sub_A_E();
                break;
            }
            case 129: {
                this.add_A_C();
                break;
            }
            case 54: {
                this.ld_HLi_nn();
                break;
            }
            case 118: {
                this.halt();
                break;
            }
            case 217: {
                this.reti();
                break;
            }
            case 246: {
                this.or_A_nn();
                break;
            }
            case 47: {
                this.cpl();
                break;
            }
            case 216: {
                this.ret_C();
                break;
            }
            case 102: {
                this.ld_H_HLi();
                break;
            }
            case 222: {
                this.sbc_A_nn();
                break;
            }
            case 176: {
                this.or_A_B();
                break;
            }
            case 9: {
                this.add_HL_BC();
                break;
            }
            case 98: {
                this.ld_H_D();
                break;
            }
            case 231: {
                this.rst(32);
                break;
            }
            case 0: {
                this.nop();
                break;
            }
            case 8: {
                this.load_mem_SP();
                break;
            }
            case 16: {
                this.stop();
                break;
            }
            case 49: {
                this.ld_SP_nnnn();
                break;
            }
            case 57: {
                this.add_HL_SP();
                break;
            }
            case 50: {
                this.ldd_HLi_A();
                break;
            }
            case 58: {
                this.ldd_A_HLi();
                break;
            }
            case 51: {
                this.inc_SP();
                break;
            }
            case 27: {
                this.dec_DE();
                break;
            }
            case 59: {
                this.dec_SP();
                break;
            }
            case 4: {
                this.inc_B();
                break;
            }
            case 20: {
                this.inc_D();
                break;
            }
            case 52: {
                this.inc_HLi();
                break;
            }
            case 21: {
                this.dec_D();
                break;
            }
            case 29: {
                this.dec_E();
                break;
            }
            case 37: {
                this.dec_H();
                break;
            }
            case 45: {
                this.dec_L();
                break;
            }
            case 30: {
                this.ld_E_nn();
                break;
            }
            case 7: {
                this.rlca();
                break;
            }
            case 15: {
                this.rrca();
                break;
            }
            case 23: {
                this.rla();
                break;
            }
            case 31: {
                this.rra();
                break;
            }
            case 39: {
                this.daa();
                break;
            }
            case 55: {
                this.scf();
                break;
            }
            case 63: {
                this.ccf();
                break;
            }
            case 64: {
                this.ld_B_B();
                break;
            }
            case 65: {
                this.ld_B_C();
                break;
            }
            case 66: {
                this.ld_B_D();
                break;
            }
            case 67: {
                this.ld_B_E();
                break;
            }
            case 68: {
                this.ld_B_H();
                break;
            }
            case 69: {
                this.ld_B_L();
                break;
            }
            case 72: {
                this.ld_C_B();
                break;
            }
            case 73: {
                this.ld_C_C();
                break;
            }
            case 74: {
                this.ld_C_D();
                break;
            }
            case 75: {
                this.ld_C_E();
                break;
            }
            case 76: {
                this.ld_C_H();
                break;
            }
            case 77: {
                this.ld_C_L();
                break;
            }
            case 80: {
                this.ld_D_B();
                break;
            }
            case 81: {
                this.ld_D_C();
                break;
            }
            case 82: {
                this.ld_D_D();
                break;
            }
            case 83: {
                this.ld_D_E();
                break;
            }
            case 84: {
                this.ld_D_H();
                break;
            }
            case 85: {
                this.ld_D_L();
                break;
            }
            case 88: {
                this.ld_E_B();
                break;
            }
            case 89: {
                this.ld_E_C();
                break;
            }
            case 90: {
                this.ld_E_D();
                break;
            }
            case 91: {
                this.ld_E_E();
                break;
            }
            case 92: {
                this.ld_E_H();
                break;
            }
            case 93: {
                this.ld_E_L();
                break;
            }
            case 96: {
                this.ld_H_B();
                break;
            }
            case 97: {
                this.ld_H_C();
                break;
            }
            case 99: {
                this.ld_H_E();
                break;
            }
            case 100: {
                this.ld_H_H();
                break;
            }
            case 101: {
                this.ld_H_L();
                break;
            }
            case 104: {
                this.ld_L_B();
                break;
            }
            case 105: {
                this.ld_L_C();
                break;
            }
            case 106: {
                this.ld_L_D();
                break;
            }
            case 107: {
                this.ld_L_E();
                break;
            }
            case 108: {
                this.ld_L_H();
                break;
            }
            case 109: {
                this.ld_L_L();
                break;
            }
            case 110: {
                this.ld_L_HLi();
                break;
            }
            case 114: {
                this.ld_HLi_D();
                break;
            }
            case 115: {
                this.ld_HLi_E();
                break;
            }
            case 116: {
                this.ld_HLi_H();
                break;
            }
            case 117: {
                this.ld_HLi_L();
                break;
            }
            case 127: {
                this.ld_A_A();
                break;
            }
            case 130: {
                this.add_A_D();
                break;
            }
            case 132: {
                this.add_A_H();
                break;
            }
            case 136: {
                this.adc_A_B();
                break;
            }
            case 137: {
                this.adc_A_C();
                break;
            }
            case 139: {
                this.adc_A_E();
                break;
            }
            case 141: {
                this.adc_A_L();
                break;
            }
            case 142: {
                this.adc_A_HLi();
                break;
            }
            case 144: {
                this.sub_A_B();
                break;
            }
            case 146: {
                this.sub_A_D();
                break;
            }
            case 148: {
                this.sub_A_H();
                break;
            }
            case 151: {
                this.sub_A_A();
                break;
            }
            case 153: {
                this.sbc_A_C();
                break;
            }
            case 154: {
                this.sbc_A_D();
                break;
            }
            case 155: {
                this.sbc_A_E();
                break;
            }
            case 156: {
                this.sbc_A_H();
                break;
            }
            case 157: {
                this.sbc_A_L();
                break;
            }
            case 158: {
                this.sbc_A_HLi();
                break;
            }
            case 159: {
                this.sbc_A_A();
                break;
            }
            case 160: {
                this.and_A_B();
                break;
            }
            case 161: {
                this.and_A_C();
                break;
            }
            case 162: {
                this.and_A_D();
                break;
            }
            case 163: {
                this.and_A_E();
                break;
            }
            case 164: {
                this.and_A_H();
                break;
            }
            case 165: {
                this.and_A_L();
                break;
            }
            case 166: {
                this.and_A_HLi();
                break;
            }
            case 168: {
                this.xor_A_B();
                break;
            }
            case 169: {
                this.xor_A_C();
                break;
            }
            case 170: {
                this.xor_A_D();
                break;
            }
            case 171: {
                this.xor_A_E();
                break;
            }
            case 172: {
                this.xor_A_H();
                break;
            }
            case 173: {
                this.xor_A_L();
                break;
            }
            case 174: {
                this.xor_A_HLi();
                break;
            }
            case 178: {
                this.or_A_D();
                break;
            }
            case 179: {
                this.or_A_E();
                break;
            }
            case 180: {
                this.or_A_H();
                break;
            }
            case 181: {
                this.or_A_L();
                break;
            }
            case 182: {
                this.or_A_HLi();
                break;
            }
            case 183: {
                this.or_A_A();
                break;
            }
            case 186: {
                this.cp_A_D();
                break;
            }
            case 187: {
                this.cp_A_E();
                break;
            }
            case 188: {
                this.cp_A_H();
                break;
            }
            case 189: {
                this.cp_A_L();
                break;
            }
            case 191: {
                this.cp_A_A();
                break;
            }
            case 232: {
                this.add_SP_nn();
                break;
            }
            case 248: {
                this.ld_HP_SP_nn();
                break;
            }
            case 233: {
                this.ld_PC_HL();
                break;
            }
            case 249: {
                this.ld_SP_HL();
                break;
            }
            case 210: {
                this.jp_NC_nnnn();
                break;
            }
            case 218: {
                this.jp_C_nnnn();
                break;
            }
            case 243: {
                this.di();
                break;
            }
            case 251: {
                this.ei();
                break;
            }
            case 212: {
                this.call_NC_nnnn();
                break;
            }
            case 220: {
                this.call_C_nnnn();
                break;
            }
            case 238: {
                this.xor_A_nn();
                break;
            }
            case 199: {
                this.rst(0);
                break;
            }
            case 207: {
                this.rst(8);
                break;
            }
            case 215: {
                this.rst(16);
                break;
            }
            case 223: {
                this.rst(24);
                break;
            }
            case 239: {
                this.rst(40);
                break;
            }
            case 247: {
                this.rst(48);
                break;
            }
            case 255: {
                this.rst(56);
                break;
            }
            default: {
                throw new RuntimeException("Invalid operation");
            }
        }
    }

    private final int read(int address) {
        return this.memory.read(address);
    }

    private final void write(int address, int data) {
        this.memory.write(address, data);
    }

    private final int read(int hi, int lo) {
        return this.read((hi << 8) + lo);
    }

    private final void write(int hi, int lo, int data) {
        this.write((hi << 8) + lo, data);
    }

    private final int fetch() {
        if (this.pc <= 16383) {
            return this.rom[this.pc++] & 0xFF;
        }
        int data = this.memory.read(this.pc);
        this.pc = this.pc + 1 & 0xFFFF;
        return data;
    }

    private final void push(int data) {
        this.sp = this.sp - 1 & 0xFFFF;
        this.memory.write(this.sp, data);
    }

    private final int pop() {
        int data = this.memory.read(this.sp);
        this.sp = this.sp + 1 & 0xFFFF;
        return data;
    }

    private final void call(int address) {
        this.push(this.pc >> 8);
        this.push(this.pc & 0xFF);
        this.pc = address;
    }

    private final void add(int data) {
        int s = this.a + data & 0xFF;
        this.f = (s == 0 ? 128 : 0) + (s < this.a ? 16 : 0) + ((s & 0xF) < (this.a & 0xF) ? 32 : 0);
        this.a = s;
    }

    private final void adc(int data) {
        int s = this.a + data + ((this.f & 0x10) >> 4);
        this.f = ((s & 0xFF) == 0 ? 128 : 0) + (s >= 256 ? 16 : 0) + (((s ^ this.a ^ data) & 0x10) != 0 ? 32 : 0);
        this.a = s & 0xFF;
    }

    private final void sub(int data) {
        int s = this.a - data & 0xFF;
        this.f = (s == 0 ? 128 : 0) + (s > this.a ? 16 : 0) + ((s & 0xF) > (this.a & 0xF) ? 32 : 0) + 64;
        this.a = s;
    }

    private final void sbc(int data) {
        int s = this.a - data - ((this.f & 0x10) >> 4);
        this.f = ((s & 0xFF) == 0 ? 128 : 0) + ((s & 0xFF00) != 0 ? 16 : 0) + (((s ^ this.a ^ data) & 0x10) != 0 ? 32 : 0) + 64;
        this.a = s & 0xFF;
    }

    private final void and(int data) {
        this.a &= data;
        this.f = this.a == 0 ? 128 : 0;
    }

    private final void xor(int data) {
        this.a ^= data;
        this.f = this.a == 0 ? 128 : 0;
    }

    private final void or(int data) {
        this.a |= data;
        this.f = this.a == 0 ? 128 : 0;
    }

    private final void cp(int data) {
        int s = this.a - data & 0xFF;
        this.f = (s == 0 ? 128 : 0) + (s > this.a ? 16 : 0) + ((s & 0xF) > (this.a & 0xF) ? 32 : 0) + 64;
    }

    private final int inc(int data) {
        this.f = ((data = data + 1 & 0xFF) == 0 ? 128 : 0) + ((data & 0xF) == 0 ? 32 : 0) + (this.f & 0x10);
        return data;
    }

    private final int dec(int data) {
        this.f = ((data = data - 1 & 0xFF) == 0 ? 128 : 0) + ((data & 0xF) == 15 ? 32 : 0) + (this.f & 0x10) + 64;
        return data;
    }

    private final int rlc(int data) {
        int s = ((data & 0x7F) << 1) + ((data & 0x80) >> 7);
        this.f = (s == 0 ? 128 : 0) + ((data & 0x80) != 0 ? 16 : 0);
        return s;
    }

    private final int rl(int data) {
        int s = ((data & 0x7F) << 1) + ((this.f & 0x10) != 0 ? 1 : 0);
        this.f = (s == 0 ? 128 : 0) + ((data & 0x80) != 0 ? 16 : 0);
        return s;
    }

    private final int rrc(int data) {
        int s = (data >> 1) + ((data & 1) << 7);
        this.f = (s == 0 ? 128 : 0) + ((data & 1) != 0 ? 16 : 0);
        return s;
    }

    private final int rr(int data) {
        int s = (data >> 1) + ((this.f & 0x10) << 3);
        this.f = (s == 0 ? 128 : 0) + ((data & 1) != 0 ? 16 : 0);
        return s;
    }

    private final int sla(int data) {
        int s = data << 1 & 0xFF;
        this.f = (s == 0 ? 128 : 0) + ((data & 0x80) != 0 ? 16 : 0);
        return s;
    }

    private final int sra(int data) {
        int s = (data >> 1) + (data & 0x80);
        this.f = (s == 0 ? 128 : 0) + ((data & 1) != 0 ? 16 : 0);
        return s;
    }

    private final int srl(int data) {
        int s = data >> 1;
        this.f = (s == 0 ? 128 : 0) + ((data & 1) != 0 ? 16 : 0);
        return s;
    }

    private final int swap(int data) {
        int s = (data << 4 & 0xF0) + (data >> 4 & 0xF);
        this.f = s == 0 ? 128 : 0;
        return s;
    }

    private final void bit(int n, int data) {
        this.f = (this.f & 0x10) + 32 + ((data & 1 << n) == 0 ? 128 : 0);
    }

    private final void add(int hi, int lo) {
        int s = (this.h << 8) + this.l + (hi << 8) + lo & 0xFFFF;
        this.f = (this.f & 0x80) + ((s >> 8 & 0xF) < (this.h & 0xF) ? 32 : 0) + (s < (this.h << 8) + this.l ? 16 : 0);
        this.l = s & 0xFF;
        this.h = s >> 8;
    }

    private final void ld_B_B() {
        --this.cycles;
    }

    private final void ld_B_C() {
        this.b = this.c;
        --this.cycles;
    }

    private final void ld_B_D() {
        this.b = this.d;
        --this.cycles;
    }

    private final void ld_B_E() {
        this.b = this.e;
        --this.cycles;
    }

    private final void ld_B_H() {
        this.b = this.h;
        --this.cycles;
    }

    private final void ld_B_L() {
        this.b = this.l;
        --this.cycles;
    }

    private final void ld_B_A() {
        this.b = this.a;
        --this.cycles;
    }

    private final void ld_C_B() {
        this.c = this.b;
        --this.cycles;
    }

    private final void ld_C_C() {
        --this.cycles;
    }

    private final void ld_C_D() {
        this.c = this.d;
        --this.cycles;
    }

    private final void ld_C_E() {
        this.c = this.e;
        --this.cycles;
    }

    private final void ld_C_H() {
        this.c = this.h;
        --this.cycles;
    }

    private final void ld_C_L() {
        this.c = this.l;
        --this.cycles;
    }

    private final void ld_C_A() {
        this.c = this.a;
        --this.cycles;
    }

    private final void ld_D_B() {
        this.d = this.b;
        --this.cycles;
    }

    private final void ld_D_C() {
        this.d = this.c;
        --this.cycles;
    }

    private final void ld_D_D() {
        --this.cycles;
    }

    private final void ld_D_E() {
        this.d = this.e;
        --this.cycles;
    }

    private final void ld_D_H() {
        this.d = this.h;
        --this.cycles;
    }

    private final void ld_D_L() {
        this.d = this.l;
        --this.cycles;
    }

    private final void ld_D_A() {
        this.d = this.a;
        --this.cycles;
    }

    private final void ld_E_B() {
        this.e = this.b;
        --this.cycles;
    }

    private final void ld_E_C() {
        this.e = this.c;
        --this.cycles;
    }

    private final void ld_E_D() {
        this.e = this.d;
        --this.cycles;
    }

    private final void ld_E_E() {
        --this.cycles;
    }

    private final void ld_E_H() {
        this.e = this.h;
        --this.cycles;
    }

    private final void ld_E_L() {
        this.e = this.l;
        --this.cycles;
    }

    private final void ld_E_A() {
        this.e = this.a;
        --this.cycles;
    }

    private final void ld_H_B() {
        this.h = this.b;
        --this.cycles;
    }

    private final void ld_H_C() {
        this.h = this.c;
        --this.cycles;
    }

    private final void ld_H_D() {
        this.h = this.d;
        --this.cycles;
    }

    private final void ld_H_E() {
        this.h = this.e;
        --this.cycles;
    }

    private final void ld_H_H() {
        --this.cycles;
    }

    private final void ld_H_L() {
        this.h = this.l;
        --this.cycles;
    }

    private final void ld_H_A() {
        this.h = this.a;
        --this.cycles;
    }

    private final void ld_L_B() {
        this.l = this.b;
        --this.cycles;
    }

    private final void ld_L_C() {
        this.l = this.c;
        --this.cycles;
    }

    private final void ld_L_D() {
        this.l = this.d;
        --this.cycles;
    }

    private final void ld_L_E() {
        this.l = this.e;
        --this.cycles;
    }

    private final void ld_L_H() {
        this.l = this.h;
        --this.cycles;
    }

    private final void ld_L_L() {
        --this.cycles;
    }

    private final void ld_L_A() {
        this.l = this.a;
        --this.cycles;
    }

    private final void ld_A_B() {
        this.a = this.b;
        --this.cycles;
    }

    private final void ld_A_C() {
        this.a = this.c;
        --this.cycles;
    }

    private final void ld_A_D() {
        this.a = this.d;
        --this.cycles;
    }

    private final void ld_A_E() {
        this.a = this.e;
        --this.cycles;
    }

    private final void ld_A_H() {
        this.a = this.h;
        --this.cycles;
    }

    private final void ld_A_L() {
        this.a = this.l;
        --this.cycles;
    }

    private final void ld_A_A() {
        --this.cycles;
    }

    private final void ld_B_nn() {
        this.b = this.fetch();
        this.cycles -= 2;
    }

    private final void ld_C_nn() {
        this.c = this.fetch();
        this.cycles -= 2;
    }

    private final void ld_D_nn() {
        this.d = this.fetch();
        this.cycles -= 2;
    }

    private final void ld_E_nn() {
        this.e = this.fetch();
        this.cycles -= 2;
    }

    private final void ld_H_nn() {
        this.h = this.fetch();
        this.cycles -= 2;
    }

    private final void ld_L_nn() {
        this.l = this.fetch();
        this.cycles -= 2;
    }

    private final void ld_A_nn() {
        this.a = this.fetch();
        this.cycles -= 2;
    }

    private final void ld_B_HLi() {
        this.b = this.read(this.h, this.l);
        this.cycles -= 2;
    }

    private final void ld_C_HLi() {
        this.c = this.read(this.h, this.l);
        this.cycles -= 2;
    }

    private final void ld_D_HLi() {
        this.d = this.read(this.h, this.l);
        this.cycles -= 2;
    }

    private final void ld_E_HLi() {
        this.e = this.read(this.h, this.l);
        this.cycles -= 2;
    }

    private final void ld_H_HLi() {
        this.h = this.read(this.h, this.l);
        this.cycles -= 2;
    }

    private final void ld_L_HLi() {
        this.l = this.read(this.h, this.l);
        this.cycles -= 2;
    }

    private final void ld_A_HLi() {
        this.a = this.read(this.h, this.l);
        this.cycles -= 2;
    }

    private final void ld_HLi_B() {
        this.write(this.h, this.l, this.b);
        this.cycles -= 2;
    }

    private final void ld_HLi_C() {
        this.write(this.h, this.l, this.c);
        this.cycles -= 2;
    }

    private final void ld_HLi_D() {
        this.write(this.h, this.l, this.d);
        this.cycles -= 2;
    }

    private final void ld_HLi_E() {
        this.write(this.h, this.l, this.e);
        this.cycles -= 2;
    }

    private final void ld_HLi_H() {
        this.write(this.h, this.l, this.h);
        this.cycles -= 2;
    }

    private final void ld_HLi_L() {
        this.write(this.h, this.l, this.l);
        this.cycles -= 2;
    }

    private final void ld_HLi_A() {
        this.write(this.h, this.l, this.a);
        this.cycles -= 2;
    }

    private final void ld_HLi_nn() {
        this.write(this.h, this.l, this.fetch());
        this.cycles -= 3;
    }

    private final void ld_A_BCi() {
        this.a = this.read(this.b, this.c);
        this.cycles -= 2;
    }

    private final void load_A_DEi() {
        this.a = this.read(this.d, this.e);
        this.cycles -= 2;
    }

    private final void ld_A_mem() {
        int lo = this.fetch();
        int hi = this.fetch();
        this.a = this.read(hi, lo);
        this.cycles -= 4;
    }

    private final void ld_BCi_A() {
        this.write(this.b, this.c, this.a);
        this.cycles -= 2;
    }

    private final void ld_DEi_A() {
        this.write(this.d, this.e, this.a);
        this.cycles -= 2;
    }

    private final void load_mem_SP() {
        int lo = this.fetch();
        int hi = this.fetch();
        int address = (hi << 8) + lo;
        this.write(address, this.sp & 0xFF);
        this.write(address + 1 & 0xFFFF, this.sp >> 8);
        this.cycles -= 5;
    }

    private final void ld_mem_A() {
        int lo = this.fetch();
        int hi = this.fetch();
        this.write(hi, lo, this.a);
        this.cycles -= 4;
    }

    private final void ldh_A_mem() {
        this.a = this.read(65280 + this.fetch());
        this.cycles -= 3;
    }

    private final void ldh_mem_A() {
        this.write(65280 + this.fetch(), this.a);
        this.cycles -= 3;
    }

    private final void ldh_A_Ci() {
        this.a = this.read(65280 + this.c);
        this.cycles -= 2;
    }

    private final void ldh_Ci_A() {
        this.write(65280 + this.c, this.a);
        this.cycles -= 2;
    }

    private final void ldi_HLi_A() {
        this.write(this.h, this.l, this.a);
        this.l = this.l + 1 & 0xFF;
        if (this.l == 0) {
            this.h = this.h + 1 & 0xFF;
        }
        this.cycles -= 2;
    }

    private final void ldi_A_HLi() {
        this.a = this.read(this.h, this.l);
        this.l = this.l + 1 & 0xFF;
        if (this.l == 0) {
            this.h = this.h + 1 & 0xFF;
        }
        this.cycles -= 2;
    }

    private final void ldd_HLi_A() {
        this.write(this.h, this.l, this.a);
        this.l = this.l - 1 & 0xFF;
        if (this.l == 255) {
            this.h = this.h - 1 & 0xFF;
        }
        this.cycles -= 2;
    }

    private final void ldd_A_HLi() {
        this.a = this.read(this.h, this.l);
        this.l = this.l - 1 & 0xFF;
        if (this.l == 255) {
            this.h = this.h - 1 & 0xFF;
        }
        this.cycles -= 2;
    }

    private final void ld_BC_nnnn() {
        this.c = this.fetch();
        this.b = this.fetch();
        this.cycles -= 3;
    }

    private final void ld_DE_nnnn() {
        this.e = this.fetch();
        this.d = this.fetch();
        this.cycles -= 3;
    }

    private final void ld_HL_nnnn() {
        this.l = this.fetch();
        this.h = this.fetch();
        this.cycles -= 3;
    }

    private final void ld_SP_nnnn() {
        int lo = this.fetch();
        int hi = this.fetch();
        this.sp = (hi << 8) + lo;
        this.cycles -= 3;
    }

    private final void ld_SP_HL() {
        this.sp = (this.h << 8) + this.l;
        this.cycles -= 2;
    }

    private final void push_BC() {
        this.push(this.b);
        this.push(this.c);
        this.cycles -= 4;
    }

    private final void push_DE() {
        this.push(this.d);
        this.push(this.e);
        this.cycles -= 4;
    }

    private final void push_HL() {
        this.push(this.h);
        this.push(this.l);
        this.cycles -= 4;
    }

    private final void push_AF() {
        this.push(this.a);
        this.push(this.f);
        this.cycles -= 4;
    }

    private final void pop_BC() {
        this.c = this.pop();
        this.b = this.pop();
        this.cycles -= 3;
    }

    private final void pop_DE() {
        this.e = this.pop();
        this.d = this.pop();
        this.cycles -= 3;
    }

    private final void pop_HL() {
        this.l = this.pop();
        this.h = this.pop();
        this.cycles -= 3;
    }

    private final void pop_AF() {
        this.f = this.pop();
        this.a = this.pop();
        this.cycles -= 3;
    }

    private final void add_A_B() {
        this.add(this.b);
        --this.cycles;
    }

    private final void add_A_C() {
        this.add(this.c);
        --this.cycles;
    }

    private final void add_A_D() {
        this.add(this.d);
        --this.cycles;
    }

    private final void add_A_E() {
        this.add(this.e);
        --this.cycles;
    }

    private final void add_A_H() {
        this.add(this.h);
        --this.cycles;
    }

    private final void add_A_L() {
        this.add(this.l);
        --this.cycles;
    }

    private final void add_A_A() {
        this.add(this.a);
        --this.cycles;
    }

    private final void add_A_nn() {
        this.add(this.fetch());
        this.cycles -= 2;
    }

    private final void add_A_HLi() {
        this.add(this.read(this.h, this.l));
        this.cycles -= 2;
    }

    private final void adc_A_B() {
        this.adc(this.b);
        --this.cycles;
    }

    private final void adc_A_C() {
        this.adc(this.c);
        --this.cycles;
    }

    private final void adc_A_D() {
        this.adc(this.d);
        --this.cycles;
    }

    private final void adc_A_E() {
        this.adc(this.e);
        --this.cycles;
    }

    private final void adc_A_H() {
        this.adc(this.h);
        --this.cycles;
    }

    private final void adc_A_L() {
        this.adc(this.l);
        --this.cycles;
    }

    private final void adc_A_A() {
        this.adc(this.a);
        --this.cycles;
    }

    private final void adc_A_nn() {
        this.adc(this.fetch());
        this.cycles -= 2;
    }

    private final void adc_A_HLi() {
        this.adc(this.read(this.h, this.l));
        this.cycles -= 2;
    }

    private final void sub_A_B() {
        this.sub(this.b);
        --this.cycles;
    }

    private final void sub_A_C() {
        this.sub(this.c);
        --this.cycles;
    }

    private final void sub_A_D() {
        this.sub(this.d);
        --this.cycles;
    }

    private final void sub_A_E() {
        this.sub(this.e);
        --this.cycles;
    }

    private final void sub_A_H() {
        this.sub(this.h);
        --this.cycles;
    }

    private final void sub_A_L() {
        this.sub(this.l);
        --this.cycles;
    }

    private final void sub_A_A() {
        this.sub(this.a);
        --this.cycles;
    }

    private final void sub_A_nn() {
        this.sub(this.fetch());
        this.cycles -= 2;
    }

    private final void sub_A_HLi() {
        this.sub(this.read(this.h, this.l));
        this.cycles -= 2;
    }

    private final void sbc_A_B() {
        this.sbc(this.b);
        --this.cycles;
    }

    private final void sbc_A_C() {
        this.sbc(this.c);
        --this.cycles;
    }

    private final void sbc_A_D() {
        this.sbc(this.d);
        --this.cycles;
    }

    private final void sbc_A_E() {
        this.sbc(this.e);
        --this.cycles;
    }

    private final void sbc_A_H() {
        this.sbc(this.h);
        --this.cycles;
    }

    private final void sbc_A_L() {
        this.sbc(this.l);
        --this.cycles;
    }

    private final void sbc_A_A() {
        this.sbc(this.a);
        --this.cycles;
    }

    private final void sbc_A_nn() {
        this.sbc(this.fetch());
        this.cycles -= 2;
    }

    private final void sbc_A_HLi() {
        this.sbc(this.read(this.h, this.l));
        this.cycles -= 2;
    }

    private final void and_A_B() {
        this.and(this.b);
        --this.cycles;
    }

    private final void and_A_C() {
        this.and(this.c);
        --this.cycles;
    }

    private final void and_A_D() {
        this.and(this.d);
        --this.cycles;
    }

    private final void and_A_E() {
        this.and(this.e);
        --this.cycles;
    }

    private final void and_A_H() {
        this.and(this.h);
        --this.cycles;
    }

    private final void and_A_L() {
        this.and(this.l);
        --this.cycles;
    }

    private final void and_A_A() {
        this.and(this.a);
        --this.cycles;
    }

    private final void and_A_nn() {
        this.and(this.fetch());
        this.cycles -= 2;
    }

    private final void and_A_HLi() {
        this.and(this.read(this.h, this.l));
        this.cycles -= 2;
    }

    private final void xor_A_B() {
        this.xor(this.b);
        --this.cycles;
    }

    private final void xor_A_C() {
        this.xor(this.c);
        --this.cycles;
    }

    private final void xor_A_D() {
        this.xor(this.d);
        --this.cycles;
    }

    private final void xor_A_E() {
        this.xor(this.e);
        --this.cycles;
    }

    private final void xor_A_H() {
        this.xor(this.h);
        --this.cycles;
    }

    private final void xor_A_L() {
        this.xor(this.l);
        --this.cycles;
    }

    private final void xor_A_A() {
        this.xor(this.a);
        --this.cycles;
    }

    private final void xor_A_nn() {
        this.xor(this.fetch());
        this.cycles -= 2;
    }

    private final void xor_A_HLi() {
        this.xor(this.read(this.h, this.l));
        this.cycles -= 2;
    }

    private final void or_A_B() {
        this.or(this.b);
        --this.cycles;
    }

    private final void or_A_C() {
        this.or(this.c);
        --this.cycles;
    }

    private final void or_A_D() {
        this.or(this.d);
        --this.cycles;
    }

    private final void or_A_E() {
        this.or(this.e);
        --this.cycles;
    }

    private final void or_A_H() {
        this.or(this.h);
        --this.cycles;
    }

    private final void or_A_L() {
        this.or(this.l);
        --this.cycles;
    }

    private final void or_A_A() {
        this.or(this.a);
        --this.cycles;
    }

    private final void or_A_nn() {
        this.or(this.fetch());
        this.cycles -= 2;
    }

    private final void or_A_HLi() {
        this.or(this.read(this.h, this.l));
        this.cycles -= 2;
    }

    private final void cp_A_B() {
        this.cp(this.b);
        --this.cycles;
    }

    private final void cp_A_C() {
        this.cp(this.c);
        --this.cycles;
    }

    private final void cp_A_D() {
        this.cp(this.d);
        --this.cycles;
    }

    private final void cp_A_E() {
        this.cp(this.e);
        --this.cycles;
    }

    private final void cp_A_H() {
        this.cp(this.h);
        --this.cycles;
    }

    private final void cp_A_L() {
        this.cp(this.l);
        --this.cycles;
    }

    private final void cp_A_A() {
        this.cp(this.a);
        --this.cycles;
    }

    private final void cp_A_nn() {
        this.cp(this.fetch());
        this.cycles -= 2;
    }

    private final void cp_A_HLi() {
        this.cp(this.read(this.h, this.l));
        this.cycles -= 2;
    }

    private final void inc_B() {
        this.b = this.inc(this.b);
        --this.cycles;
    }

    private final void inc_C() {
        this.c = this.inc(this.c);
        --this.cycles;
    }

    private final void inc_D() {
        this.d = this.inc(this.d);
        --this.cycles;
    }

    private final void inc_E() {
        this.e = this.inc(this.e);
        --this.cycles;
    }

    private final void inc_H() {
        this.h = this.inc(this.h);
        --this.cycles;
    }

    private final void inc_L() {
        this.l = this.inc(this.l);
        --this.cycles;
    }

    private final void inc_A() {
        this.a = this.inc(this.a);
        --this.cycles;
    }

    private final void inc_HLi() {
        this.write(this.h, this.l, this.inc(this.read(this.h, this.l)));
        this.cycles -= 3;
    }

    private final void dec_B() {
        this.b = this.dec(this.b);
        --this.cycles;
    }

    private final void dec_C() {
        this.c = this.dec(this.c);
        --this.cycles;
    }

    private final void dec_D() {
        this.d = this.dec(this.d);
        --this.cycles;
    }

    private final void dec_E() {
        this.e = this.dec(this.e);
        --this.cycles;
    }

    private final void dec_H() {
        this.h = this.dec(this.h);
        --this.cycles;
    }

    private final void dec_L() {
        this.l = this.dec(this.l);
        --this.cycles;
    }

    private final void dec_A() {
        this.a = this.dec(this.a);
        --this.cycles;
    }

    private final void dec_HLi() {
        this.write(this.h, this.l, this.dec(this.read(this.h, this.l)));
        this.cycles -= 3;
    }

    private final void cpl() {
        this.a ^= 0xFF;
        this.f |= 0x60;
    }

    private final void daa() {
        int delta = 0;
        if ((this.f & 0x20) != 0 || (this.a & 0xF) > 9) {
            delta |= 6;
        }
        if ((this.f & 0x10) != 0 || (this.a & 0xF0) > 144) {
            delta |= 0x60;
        }
        if ((this.a & 0xF0) > 128 && (this.a & 0xF) > 9) {
            delta |= 0x60;
        }
        this.a = (this.f & 0x40) == 0 ? this.a + delta & 0xFF : this.a - delta & 0xFF;
        this.f = (this.f & 0x40) + (delta >= 96 ? 16 : 0) + (this.a == 0 ? 128 : 0);
        --this.cycles;
    }

    private final void add_HL_BC() {
        this.add(this.b, this.c);
        this.cycles -= 2;
    }

    private final void add_HL_DE() {
        this.add(this.d, this.e);
        this.cycles -= 2;
    }

    private final void add_HL_HL() {
        this.add(this.h, this.l);
        this.cycles -= 2;
    }

    private final void add_HL_SP() {
        this.add(this.sp >> 8, this.sp & 0xFF);
        this.cycles -= 2;
    }

    private final void inc_BC() {
        this.c = this.c + 1 & 0xFF;
        if (this.c == 0) {
            this.b = this.b + 1 & 0xFF;
        }
        this.cycles -= 2;
    }

    private final void inc_DE() {
        this.e = this.e + 1 & 0xFF;
        if (this.e == 0) {
            this.d = this.d + 1 & 0xFF;
        }
        this.cycles -= 2;
    }

    private final void inc_HL() {
        this.l = this.l + 1 & 0xFF;
        if (this.l == 0) {
            this.h = this.h + 1 & 0xFF;
        }
        this.cycles -= 2;
    }

    private final void inc_SP() {
        this.sp = this.sp + 1 & 0xFFFF;
        this.cycles -= 2;
    }

    private final void dec_BC() {
        this.c = this.c - 1 & 0xFF;
        if (this.c == 255) {
            this.b = this.b - 1 & 0xFF;
        }
        this.cycles -= 2;
    }

    private final void dec_DE() {
        this.e = this.e - 1 & 0xFF;
        if (this.e == 255) {
            this.d = this.d - 1 & 0xFF;
        }
        this.cycles -= 2;
    }

    private final void dec_HL() {
        this.l = this.l - 1 & 0xFF;
        if (this.l == 255) {
            this.h = this.h - 1 & 0xFF;
        }
        this.cycles -= 2;
    }

    private final void dec_SP() {
        this.sp = this.sp - 1 & 0xFFFF;
        this.cycles -= 2;
    }

    private final void add_SP_nn() {
        byte offset = (byte)this.fetch();
        int s = this.sp + offset & 0xFFFF;
        this.f = offset >= 0 ? (s < this.sp ? 16 : 0) + ((s & 0xF00) < (this.sp & 0xF00) ? 32 : 0) : (s > this.sp ? 16 : 0) + ((s & 0xF00) > (this.sp & 0xF00) ? 32 : 0);
        this.sp = s;
        this.cycles -= 4;
    }

    private final void ld_HP_SP_nn() {
        byte offset = (byte)this.fetch();
        int s = this.sp + offset & 0xFFFF;
        this.f = offset >= 0 ? (s < this.sp ? 16 : 0) + ((s & 0xF00) < (this.sp & 0xF00) ? 32 : 0) : (s > this.sp ? 16 : 0) + ((s & 0xF00) > (this.sp & 0xF00) ? 32 : 0);
        this.l = s & 0xFF;
        this.h = s >> 8;
        this.cycles -= 3;
    }

    private final void rlca() {
        this.f = (this.a & 0x80) != 0 ? 16 : 0;
        this.a = ((this.a & 0x7F) << 1) + ((this.a & 0x80) >> 7);
        --this.cycles;
    }

    private final void rla() {
        int s = ((this.a & 0x7F) << 1) + ((this.f & 0x10) != 0 ? 1 : 0);
        this.f = (this.a & 0x80) != 0 ? 16 : 0;
        this.a = s;
        --this.cycles;
    }

    private final void rrca() {
        this.f = (this.a & 1) != 0 ? 16 : 0;
        this.a = (this.a >> 1 & 0x7F) + (this.a << 7 & 0x80);
        --this.cycles;
    }

    private final void rra() {
        int s = (this.a >> 1 & 0x7F) + ((this.f & 0x10) != 0 ? 128 : 0);
        this.f = (this.a & 1) != 0 ? 16 : 0;
        this.a = s;
        --this.cycles;
    }

    private final void rlc_B() {
        this.b = this.rlc(this.b);
        this.cycles -= 2;
    }

    private final void rlc_C() {
        this.c = this.rlc(this.c);
        this.cycles -= 2;
    }

    private final void rlc_D() {
        this.d = this.rlc(this.d);
        this.cycles -= 2;
    }

    private final void rlc_E() {
        this.e = this.rlc(this.e);
        this.cycles -= 2;
    }

    private final void rlc_H() {
        this.h = this.rlc(this.h);
        this.cycles -= 2;
    }

    private final void rlc_L() {
        this.l = this.rlc(this.l);
        this.cycles -= 2;
    }

    private final void rlc_A() {
        this.a = this.rlc(this.a);
        this.cycles -= 2;
    }

    private final void rlc_HLi() {
        this.write(this.h, this.l, this.rlc(this.read(this.h, this.l)));
        this.cycles -= 4;
    }

    private final void rl_B() {
        this.b = this.rl(this.b);
        this.cycles -= 2;
    }

    private final void rl_C() {
        this.c = this.rl(this.c);
        this.cycles -= 2;
    }

    private final void rl_D() {
        this.d = this.rl(this.d);
        this.cycles -= 2;
    }

    private final void rl_E() {
        this.e = this.rl(this.e);
        this.cycles -= 2;
    }

    private final void rl_H() {
        this.h = this.rl(this.h);
        this.cycles -= 2;
    }

    private final void rl_L() {
        this.l = this.rl(this.l);
        this.cycles -= 2;
    }

    private final void rl_A() {
        this.a = this.rl(this.a);
        this.cycles -= 2;
    }

    private final void rl_HLi() {
        this.write(this.h, this.l, this.rl(this.read(this.h, this.l)));
        this.cycles -= 4;
    }

    private final void rrc_B() {
        this.b = this.rrc(this.b);
        this.cycles -= 2;
    }

    private final void rrc_C() {
        this.c = this.rrc(this.c);
        this.cycles -= 2;
    }

    private final void rrc_D() {
        this.d = this.rrc(this.d);
        this.cycles -= 2;
    }

    private final void rrc_E() {
        this.e = this.rrc(this.e);
        this.cycles -= 2;
    }

    private final void rrc_H() {
        this.h = this.rrc(this.h);
        this.cycles -= 2;
    }

    private final void rrc_L() {
        this.l = this.rrc(this.l);
        this.cycles -= 2;
    }

    private final void rrc_A() {
        this.a = this.rrc(this.a);
        this.cycles -= 2;
    }

    private final void rrc_HLi() {
        this.write(this.h, this.l, this.rrc(this.read(this.h, this.l)));
        this.cycles -= 4;
    }

    private final void rr_B() {
        this.b = this.rr(this.b);
        this.cycles -= 2;
    }

    private final void rr_C() {
        this.c = this.rr(this.c);
        this.cycles -= 2;
    }

    private final void rr_D() {
        this.d = this.rr(this.d);
        this.cycles -= 2;
    }

    private final void rr_E() {
        this.e = this.rr(this.e);
        this.cycles -= 2;
    }

    private final void rr_H() {
        this.h = this.rr(this.h);
        this.cycles -= 2;
    }

    private final void rr_L() {
        this.l = this.rr(this.l);
        this.cycles -= 2;
    }

    private final void rr_A() {
        this.a = this.rr(this.a);
        this.cycles -= 2;
    }

    private final void rr_HLi() {
        this.write(this.h, this.l, this.rr(this.read(this.h, this.l)));
        this.cycles -= 4;
    }

    private final void sla_B() {
        this.b = this.sla(this.b);
        this.cycles -= 2;
    }

    private final void sla_C() {
        this.c = this.sla(this.c);
        this.cycles -= 2;
    }

    private final void sla_D() {
        this.d = this.sla(this.d);
        this.cycles -= 2;
    }

    private final void sla_E() {
        this.e = this.sla(this.e);
        this.cycles -= 2;
    }

    private final void sla_H() {
        this.h = this.sla(this.h);
        this.cycles -= 2;
    }

    private final void sla_L() {
        this.l = this.sla(this.l);
        this.cycles -= 2;
    }

    private final void sla_A() {
        this.a = this.sla(this.a);
        this.cycles -= 2;
    }

    private final void sla_HLi() {
        this.write(this.h, this.l, this.sla(this.read(this.h, this.l)));
        this.cycles -= 4;
    }

    private final void swap_B() {
        this.b = this.swap(this.b);
        this.cycles -= 2;
    }

    private final void swap_C() {
        this.c = this.swap(this.c);
        this.cycles -= 2;
    }

    private final void swap_D() {
        this.d = this.swap(this.d);
        this.cycles -= 2;
    }

    private final void swap_E() {
        this.e = this.swap(this.e);
        this.cycles -= 2;
    }

    private final void swap_H() {
        this.h = this.swap(this.h);
        this.cycles -= 2;
    }

    private final void swap_L() {
        this.l = this.swap(this.l);
        this.cycles -= 2;
    }

    private final void swap_A() {
        this.a = this.swap(this.a);
        this.cycles -= 2;
    }

    private final void swap_HLi() {
        this.write(this.h, this.l, this.swap(this.read(this.h, this.l)));
        this.cycles -= 4;
    }

    private final void sra_B() {
        this.b = this.sra(this.b);
        this.cycles -= 2;
    }

    private final void sra_C() {
        this.c = this.sra(this.c);
        this.cycles -= 2;
    }

    private final void sra_D() {
        this.d = this.sra(this.d);
        this.cycles -= 2;
    }

    private final void sra_E() {
        this.e = this.sra(this.e);
        this.cycles -= 2;
    }

    private final void sra_H() {
        this.h = this.sra(this.h);
        this.cycles -= 2;
    }

    private final void sra_L() {
        this.l = this.sra(this.l);
        this.cycles -= 2;
    }

    private final void sra_A() {
        this.a = this.sra(this.a);
        this.cycles -= 2;
    }

    private final void sra_HLi() {
        this.write(this.h, this.l, this.sra(this.read(this.h, this.l)));
        this.cycles -= 4;
    }

    private final void srl_B() {
        this.b = this.srl(this.b);
        this.cycles -= 2;
    }

    private final void srl_C() {
        this.c = this.srl(this.c);
        this.cycles -= 2;
    }

    private final void srl_D() {
        this.d = this.srl(this.d);
        this.cycles -= 2;
    }

    private final void srl_E() {
        this.e = this.srl(this.e);
        this.cycles -= 2;
    }

    private final void srl_H() {
        this.h = this.srl(this.h);
        this.cycles -= 2;
    }

    private final void srl_L() {
        this.l = this.srl(this.l);
        this.cycles -= 2;
    }

    private final void srl_A() {
        this.a = this.srl(this.a);
        this.cycles -= 2;
    }

    private final void srl_HLi() {
        this.write(this.h, this.l, this.srl(this.read(this.h, this.l)));
        this.cycles -= 4;
    }

    private final void bit_B(int n) {
        this.bit(n, this.b);
        this.cycles -= 2;
    }

    private final void bit_C(int n) {
        this.bit(n, this.c);
        this.cycles -= 2;
    }

    private final void bit_D(int n) {
        this.bit(n, this.d);
        this.cycles -= 2;
    }

    private final void bit_E(int n) {
        this.bit(n, this.e);
        this.cycles -= 2;
    }

    private final void bit_H(int n) {
        this.bit(n, this.h);
        this.cycles -= 2;
    }

    private final void bit_L(int n) {
        this.bit(n, this.l);
        this.cycles -= 2;
    }

    private final void bit_A(int n) {
        this.bit(n, this.a);
        this.cycles -= 2;
    }

    private final void bit_HLi(int n) {
        this.bit(n, this.read(this.h, this.l));
        this.cycles -= 3;
    }

    private final void set_B(int n) {
        this.b |= 1 << n;
        this.cycles -= 2;
    }

    private final void set_C(int n) {
        this.c |= 1 << n;
        this.cycles -= 2;
    }

    private final void set_D(int n) {
        this.d |= 1 << n;
        this.cycles -= 2;
    }

    private final void set_E(int n) {
        this.e |= 1 << n;
        this.cycles -= 2;
    }

    private final void set_H(int n) {
        this.h |= 1 << n;
        this.cycles -= 2;
    }

    private final void set_L(int n) {
        this.l |= 1 << n;
        this.cycles -= 2;
    }

    private final void set_A(int n) {
        this.a |= 1 << n;
        this.cycles -= 2;
    }

    private final void set_HLi(int n) {
        this.write(this.h, this.l, this.read(this.h, this.l) | 1 << n);
        this.cycles -= 4;
    }

    private final void res_B(int n) {
        this.b &= ~(1 << n);
        this.cycles -= 2;
    }

    private final void res_C(int n) {
        this.c &= ~(1 << n);
        this.cycles -= 2;
    }

    private final void res_D(int n) {
        this.d &= ~(1 << n);
        this.cycles -= 2;
    }

    private final void res_E(int n) {
        this.e &= ~(1 << n);
        this.cycles -= 2;
    }

    private final void res_H(int n) {
        this.h &= ~(1 << n);
        this.cycles -= 2;
    }

    private final void res_L(int n) {
        this.l &= ~(1 << n);
        this.cycles -= 2;
    }

    private final void res_A(int n) {
        this.a &= ~(1 << n);
        this.cycles -= 2;
    }

    private final void res_HLi(int n) {
        this.write(this.h, this.l, this.read(this.h, this.l) & ~(1 << n));
        this.cycles -= 4;
    }

    private final void ccf() {
        this.f = this.f & 0x90 ^ 0x10;
    }

    private final void scf() {
        this.f = this.f & 0x80 | 0x10;
    }

    private final void nop() {
        --this.cycles;
    }

    private final void jp_nnnn() {
        int lo = this.fetch();
        int hi = this.fetch();
        this.pc = (hi << 8) + lo;
        this.cycles -= 4;
    }

    private final void ld_PC_HL() {
        this.pc = (this.h << 8) + this.l;
        --this.cycles;
    }

    private final void jp_cc_nnnn(boolean cc) {
        if (cc) {
            int lo = this.fetch();
            int hi = this.fetch();
            this.pc = (hi << 8) + lo;
            this.cycles -= 4;
        } else {
            this.pc = this.pc + 2 & 0xFFFF;
            this.cycles -= 3;
        }
    }

    private final void jp_NZ_nnnn() {
        this.jp_cc_nnnn((this.f & 0x80) == 0);
    }

    private final void jp_NC_nnnn() {
        this.jp_cc_nnnn((this.f & 0x10) == 0);
    }

    private final void jp_Z_nnnn() {
        this.jp_cc_nnnn((this.f & 0x80) != 0);
    }

    private final void jp_C_nnnn() {
        this.jp_cc_nnnn((this.f & 0x10) != 0);
    }

    private final void jr_nn() {
        byte offset = (byte)this.fetch();
        this.pc = this.pc + offset & 0xFFFF;
        this.cycles -= 3;
    }

    private final void jr_cc_nn(boolean cc) {
        if (cc) {
            byte offset = (byte)this.fetch();
            this.pc = this.pc + offset & 0xFFFF;
            this.cycles -= 3;
        } else {
            this.pc = this.pc + 1 & 0xFFFF;
            this.cycles -= 2;
        }
    }

    private final void jr_NZ_nn() {
        this.jr_cc_nn((this.f & 0x80) == 0);
    }

    private final void jr_Z_nn() {
        this.jr_cc_nn((this.f & 0x80) != 0);
    }

    private final void jr_NC_nn() {
        this.jr_cc_nn((this.f & 0x10) == 0);
    }

    private final void jr_C_nn() {
        this.jr_cc_nn((this.f & 0x10) != 0);
    }

    private final void call_nnnn() {
        int lo = this.fetch();
        int hi = this.fetch();
        this.call((hi << 8) + lo);
        this.cycles -= 6;
    }

    private final void call_cc_nnnn(boolean cc) {
        if (cc) {
            int lo = this.fetch();
            int hi = this.fetch();
            this.call((hi << 8) + lo);
            this.cycles -= 6;
        } else {
            this.pc = this.pc + 2 & 0xFFFF;
            this.cycles -= 3;
        }
    }

    private final void call_NZ_nnnn() {
        this.call_cc_nnnn((this.f & 0x80) == 0);
    }

    private final void call_NC_nnnn() {
        this.call_cc_nnnn((this.f & 0x10) == 0);
    }

    private final void call_Z_nnnn() {
        this.call_cc_nnnn((this.f & 0x80) != 0);
    }

    private final void call_C_nnnn() {
        this.call_cc_nnnn((this.f & 0x10) != 0);
    }

    private final void ret() {
        int lo = this.pop();
        int hi = this.pop();
        this.pc = (hi << 8) + lo;
        this.cycles -= 4;
    }

    private final void ret_cc(boolean cc) {
        if (cc) {
            int lo = this.pop();
            int hi = this.pop();
            this.pc = (hi << 8) + lo;
            this.cycles -= 5;
        } else {
            this.cycles -= 2;
        }
    }

    private final void ret_NZ() {
        this.ret_cc((this.f & 0x80) == 0);
    }

    private final void ret_NC() {
        this.ret_cc((this.f & 0x10) == 0);
    }

    private final void ret_Z() {
        this.ret_cc((this.f & 0x80) != 0);
    }

    private final void ret_C() {
        this.ret_cc((this.f & 0x10) != 0);
    }

    private final void rst(int nn) {
        this.call(nn);
        this.cycles -= 4;
    }

    private final void reti() {
        int lo = this.pop();
        int hi = this.pop();
        this.pc = (hi << 8) + lo;
        this.ime = true;
        this.cycles -= 4;
        this.execute();
        this.interrupt();
    }

    private final void di() {
        this.ime = false;
        --this.cycles;
    }

    private final void ei() {
        this.ime = true;
        --this.cycles;
        this.execute();
        this.interrupt();
    }

    private final void halt() {
        this.halted = true;
        if (!this.ime && this.interrupt.isPending()) {
            this.execute(this.memory.read(this.pc));
        }
        this.interrupt();
    }

    private final void stop() {
        this.fetch();
    }
}

