/*
 * Decompiled with CFR 0.152.
 */
package gameboy.core.cartridge;

import gameboy.core.cartridge.MBC;
import gameboy.core.driver.ClockDriver;

public class HuC3
implements MBC {
    private ClockDriver clock;
    private byte[] rom;
    private byte[] ram;
    private int romBank;
    private int ramBank;
    private int romSize;
    private int ramSize;
    private int ramFlag;
    private int ramValue;
    private int clockRegister;
    private int clockShift;
    private long clockTime;

    public HuC3(byte[] rom, byte[] ram, ClockDriver clock) {
        this.clock = clock;
        this.setROM(rom);
        this.setRAM(ram);
    }

    public final void reset() {
        this.romBank = 16384;
        this.ramBank = 0;
        this.ramFlag = 0;
        this.ramValue = 0;
        this.clockRegister = 0;
        this.clockShift = 0;
        this.clockTime = this.clock.getTime();
    }

    public final int read(int address) {
        if (address <= 16383) {
            return this.rom[address] & 0xFF;
        }
        if (address <= Short.MAX_VALUE) {
            return this.rom[this.romBank + (address & 0x3FFF)] & 0xFF;
        }
        if (address >= 40960 && address <= 49151) {
            if (this.ramFlag == 12) {
                return this.ramValue;
            }
            if (this.ramFlag == 13) {
                return 1;
            }
            if ((this.ramFlag == 10 || this.ramFlag == 0) && this.ramSize > 0) {
                return this.ram[this.ramBank + (address & 0x1FFF)] & 0xFF;
            }
        }
        return 255;
    }

    public final void write(int address, int data) {
        if (address <= 8191) {
            this.ramFlag = data;
        } else if (address <= 16383) {
            if ((data & 0x7F) == 0) {
                data = 1;
            }
            this.romBank = (data & 0x7F) << 14 & this.romSize;
        } else if (address <= 24575) {
            this.ramBank = (data & 0xF) << 13 & this.ramSize;
        } else if (address >= 40960 && address <= 49151) {
            if (this.ramFlag == 11) {
                if ((data & 0xF0) == 16) {
                    if (this.clockShift <= 24) {
                        this.ramValue = this.clockRegister >> this.clockShift & 0xF;
                        this.clockShift += 4;
                    }
                } else if ((data & 0xF0) == 48) {
                    if (this.clockShift <= 24) {
                        this.clockRegister &= ~(15 << this.clockShift);
                        this.clockRegister |= (data & 0xF) << this.clockShift;
                        this.clockShift += 4;
                    }
                } else if ((data & 0xF0) == 64) {
                    this.updateClock();
                    if ((data & 0xF) == 0) {
                        this.clockShift = 0;
                    } else if ((data & 0xF) == 3) {
                        this.clockShift = 0;
                    } else if ((data & 0xF) == 7) {
                        this.clockShift = 0;
                    }
                } else if ((data & 0xF0) != 80 && (data & 0xF0) == 96) {
                    this.ramValue = 1;
                }
            } else if ((this.ramFlag < 12 || this.ramFlag > 14) && this.ramFlag == 10 && this.ramSize > 0) {
                this.ram[this.ramBank + (address & 0x1FFF)] = (byte)data;
            }
        }
    }

    private final void updateClock() {
        long elapsed;
        long now = this.clock.getTime();
        for (elapsed = now - this.clockTime; elapsed >= 31536000L; elapsed -= 31536000L) {
            this.clockRegister += 0x1000000;
        }
        while (elapsed >= 86400L) {
            this.clockRegister += 4096;
            elapsed -= 86400L;
        }
        while (elapsed >= 60L) {
            ++this.clockRegister;
            elapsed -= 60L;
        }
        if ((this.clockRegister & 0xFFF) >= 1440) {
            this.clockRegister += 2656;
        }
        if ((this.clockRegister & 0xFFF000) >= 1495040) {
            this.clockRegister += 15282176;
        }
        this.clockTime = now - elapsed;
    }

    private void setROM(byte[] buffer) {
        int banks = buffer.length / 16384;
        if (banks < 2 || banks > 128) {
            throw new RuntimeException("Invalid HuC3 ROM size");
        }
        this.rom = buffer;
        this.romSize = 16384 * banks - 1;
    }

    private void setRAM(byte[] buffer) {
        int banks = buffer.length / 8192;
        if (banks < 0 || banks > 4) {
            throw new RuntimeException("Invalid HuC3 RAM size");
        }
        this.ram = buffer;
        this.ramSize = 8192 * banks - 1;
    }
}

