/*
 * Decompiled with CFR 0.152.
 */
package gameboy.core;

import gameboy.core.Interrupt;

public class Timer {
    private static final int GAMEBOY_CLOCK = 0x100000;
    private static final int DIV_CLOCK = 64;
    private static final int[] TIMER_CLOCK = new int[]{256, 4, 16, 64};
    public static final int DIV = 65284;
    public static final int TIMA = 65285;
    public static final int TMA = 65286;
    public static final int TAC = 65287;
    private int div;
    private int tima;
    private int tma;
    private int tac;
    private int dividerCycles;
    private int timerCycles;
    private int timerClock;
    private Interrupt interrupt;

    public Timer(Interrupt interrupt) {
        this.interrupt = interrupt;
        this.reset();
    }

    public final void reset() {
        this.div = 0;
        this.dividerCycles = 64;
        this.tac = 0;
        this.tma = 0;
        this.tima = 0;
        this.timerCycles = this.timerClock = TIMER_CLOCK[this.tac & 3];
    }

    public final void write(int address, int data) {
        switch (address) {
            case 65284: {
                this.setDivider(data);
                break;
            }
            case 65285: {
                this.setTimerCounter(data);
                break;
            }
            case 65286: {
                this.setTimerModulo(data);
                break;
            }
            case 65287: {
                this.setTimerControl(data);
            }
        }
    }

    public final int read(int address) {
        switch (address) {
            case 65284: {
                return this.getDivider();
            }
            case 65285: {
                return this.getTimerCounter();
            }
            case 65286: {
                return this.getTimerModulo();
            }
            case 65287: {
                return this.getTimerControl();
            }
        }
        return 255;
    }

    private final void setDivider(int data) {
        this.div = 0;
    }

    private final void setTimerCounter(int data) {
        this.tima = data;
    }

    private final void setTimerModulo(int data) {
        this.tma = data;
    }

    private final void setTimerControl(int data) {
        if ((this.tac & 3) != (data & 3)) {
            this.timerCycles = this.timerClock = TIMER_CLOCK[data & 3];
        }
        this.tac = data;
    }

    private final int getDivider() {
        return this.div;
    }

    private final int getTimerCounter() {
        return this.tima;
    }

    private final int getTimerModulo() {
        return this.tma;
    }

    private final int getTimerControl() {
        return 0xF8 | this.tac;
    }

    public final int cycles() {
        if ((this.tac & 4) != 0 && this.timerCycles < this.dividerCycles) {
            return this.timerCycles;
        }
        return this.dividerCycles;
    }

    public final void emulate(int ticks) {
        this.emulateDivider(ticks);
        this.emulateTimer(ticks);
    }

    private final void emulateDivider(int ticks) {
        this.dividerCycles -= ticks;
        while (this.dividerCycles <= 0) {
            this.div = this.div + 1 & 0xFF;
            this.dividerCycles += 64;
        }
    }

    private final void emulateTimer(int ticks) {
        if ((this.tac & 4) != 0) {
            this.timerCycles -= ticks;
            while (this.timerCycles <= 0) {
                this.tima = this.tima + 1 & 0xFF;
                this.timerCycles += this.timerClock;
                if (this.tima != 0) continue;
                this.tima = this.tma;
                this.interrupt.raise(4);
            }
        }
    }

    public final String toString() {
        return "DIV=" + Integer.toHexString(this.div) + " TIMA=" + Integer.toHexString(this.tima) + " TMA=" + Integer.toHexString(this.tma) + " TAC=" + Integer.toHexString(this.tac);
    }
}

