/*
 * Decompiled with CFR 0.152.
 */
package gameboy.core;

import gameboy.core.Interrupt;
import gameboy.core.Memory;
import gameboy.core.driver.VideoDriver;

public final class Video {
    public static final int LCDC = 65344;
    public static final int STAT = 65345;
    public static final int SCY = 65346;
    public static final int SCX = 65347;
    public static final int LY = 65348;
    public static final int LYC = 65349;
    public static final int DMA = 65350;
    public static final int BGP = 65351;
    public static final int OBP0 = 65352;
    public static final int OBP1 = 65353;
    public static final int WY = 65354;
    public static final int WX = 65355;
    public static final int OAM_ADDR = 65024;
    public static final int OAM_SIZE = 160;
    public static final int VRAM_ADDR = 32768;
    public static final int VRAM_SIZE = 8192;
    public static final int VRAM_DATA_A = 0;
    public static final int VRAM_DATA_B = 2048;
    public static final int VRAM_MAP_A = 6144;
    public static final int VRAM_MAP_B = 7168;
    public static final int GAMEBOY_CLOCK = 0x100000;
    private static final int MODE_0_TICKS = 50;
    private static final int MODE_1_TICKS = 114;
    private static final int MODE_2_TICKS = 20;
    private static final int MODE_3_BEGIN_TICKS = 12;
    private static final int MODE_3_END_TICKS = 32;
    private static final int MODE_1_BEGIN_TICKS = 8;
    private static final int MODE_1_END_TICKS = 1;
    private static final int OBJECTS_PER_LINE = 10;
    private static final int[] COLOR_MAP = new int[]{10270998, 9218580, 3171376, 1064720};
    private byte[] oam = new byte[160];
    private byte[] vram = new byte[8192];
    private int[] pixels;
    private int drawOffset;
    private int driverWidth;
    private int driverHeight;
    private int lcdc;
    private int stat;
    private int scy;
    private int scx;
    private int ly;
    private int lyc;
    private int dma;
    private int bgp;
    private int obp0;
    private int obp1;
    private int wy;
    private int wx;
    private int wly;
    private int cycles;
    private int frames;
    private int frameSkip;
    private boolean transfer;
    private boolean display;
    private boolean vblank;
    private boolean dirty;
    private int[] line = new int[176];
    private int[] objects = new int[10];
    private int[] palette = new int[1024];
    private VideoDriver driver;
    private Interrupt interrupt;
    private Memory memory;

    public Video(VideoDriver driver, Interrupt interrupt, Memory memory) {
        this.driver = driver;
        this.interrupt = interrupt;
        this.memory = memory;
        this.pixels = driver.getPixels();
        this.driverWidth = driver.getWidth();
        this.driverHeight = driver.getHeight();
        this.reset();
    }

    public final void setRegVideoState(int[] regVideoState) {
        this.drawOffset = regVideoState[0];
        this.lcdc = regVideoState[1];
        this.stat = regVideoState[2];
        this.scy = regVideoState[3];
        this.scx = regVideoState[4];
        this.ly = regVideoState[5];
        this.lyc = regVideoState[6];
        this.dma = regVideoState[7];
        this.bgp = regVideoState[8];
        this.obp0 = regVideoState[9];
        this.obp1 = regVideoState[10];
        this.wy = regVideoState[11];
        this.wx = regVideoState[12];
        this.wly = regVideoState[13];
        this.transfer = regVideoState[14] != 0;
        this.display = regVideoState[15] != 0;
        this.vblank = regVideoState[16] != 0;
        this.dirty = regVideoState[17] != 0;
    }

    public final void setBasicVideoState(byte[] basicVideoState) {
        System.arraycopy(basicVideoState, 0, this.oam, 0, 10);
        System.arraycopy(basicVideoState, 10, this.vram, 0, 8192);
    }

    public final void setAdvVideoState(int[] advVideoState) {
        System.arraycopy(advVideoState, 0, this.line, 0, 176);
        System.arraycopy(advVideoState, 176, this.objects, 0, 10);
        System.arraycopy(advVideoState, 186, this.palette, 0, 1024);
    }

    public final int[] getRegVideoState() {
        int[] state = new int[72];
        state[0] = this.drawOffset;
        state[1] = this.lcdc;
        state[2] = this.stat;
        state[3] = this.scy;
        state[4] = this.scx;
        state[5] = this.ly;
        state[6] = this.lyc;
        state[7] = this.dma;
        state[8] = this.bgp;
        state[9] = this.obp0;
        state[10] = this.obp1;
        state[11] = this.wy;
        state[12] = this.wx;
        state[13] = this.wly;
        state[14] = this.transfer ? 1 : 0;
        state[15] = this.display ? 1 : 0;
        state[16] = this.vblank ? 1 : 0;
        state[17] = this.dirty ? 1 : 0;
        return state;
    }

    public final byte[] getBasicVideoState() {
        byte[] state = new byte[8202];
        System.arraycopy(this.oam, 0, state, 0, 10);
        System.arraycopy(this.vram, 0, state, 10, 8192);
        return state;
    }

    public final int[] getAdvVideoState() {
        int[] state = new int[1210];
        System.arraycopy(this.line, 0, state, 0, 176);
        System.arraycopy(this.objects, 0, state, 176, 10);
        System.arraycopy(this.palette, 0, state, 186, 1024);
        return state;
    }

    public final int getFrameSkip() {
        return this.frameSkip;
    }

    public final void setFrameSkip(int frameSkip) {
        this.frameSkip = frameSkip;
    }

    public final void reset() {
        int index;
        this.cycles = 20;
        this.lcdc = 145;
        this.stat = 2;
        this.ly = 0;
        this.lyc = 0;
        this.dma = 255;
        this.scy = 0;
        this.scx = 0;
        this.wly = 0;
        this.wy = 0;
        this.wx = 0;
        this.bgp = 252;
        this.obp1 = 255;
        this.obp0 = 255;
        this.transfer = true;
        this.display = true;
        this.vblank = true;
        this.dirty = true;
        for (index = 0; index < this.vram.length; ++index) {
            this.vram[index] = 0;
        }
        for (index = 0; index < this.oam.length; ++index) {
            this.oam[index] = 0;
        }
    }

    public final void write(int address, int data) {
        switch (address) {
            case 65344: {
                this.setControl(data);
                break;
            }
            case 65345: {
                this.setStatus(data);
                break;
            }
            case 65346: {
                this.setScrollY(data);
                break;
            }
            case 65347: {
                this.setScrollX(data);
                break;
            }
            case 65348: {
                break;
            }
            case 65349: {
                this.setLYCompare(data);
                break;
            }
            case 65350: {
                this.setDMA(data);
                break;
            }
            case 65351: {
                this.setBackgroundPalette(data);
                break;
            }
            case 65352: {
                this.setObjectPalette0(data);
                break;
            }
            case 65353: {
                this.setObjectPalette1(data);
                break;
            }
            case 65354: {
                this.setWindowY(data);
                break;
            }
            case 65355: {
                this.setWindowX(data);
                break;
            }
            default: {
                if (address >= 65024 && address < 65184) {
                    this.oam[address - 65024] = (byte)data;
                    break;
                }
                if (address < 32768 || address >= 40960) break;
                this.vram[address - 32768] = (byte)data;
            }
        }
    }

    public final int read(int address) {
        switch (address) {
            case 65344: {
                return this.getControl();
            }
            case 65345: {
                return this.getStatus();
            }
            case 65346: {
                return this.getScrollY();
            }
            case 65347: {
                return this.getScrollX();
            }
            case 65348: {
                return this.getLineY();
            }
            case 65349: {
                return this.getLineYCompare();
            }
            case 65350: {
                return this.getDMA();
            }
            case 65351: {
                return this.getBackgroundPalette();
            }
            case 65352: {
                return this.getObjectPalette0();
            }
            case 65353: {
                return this.getObjectPalette1();
            }
            case 65354: {
                return this.getWindowY();
            }
            case 65355: {
                return this.getWindowX();
            }
        }
        if (address >= 65024 && address < 65184) {
            return this.oam[address - 65024] & 0xFF;
        }
        if (address >= 32768 && address < 40960) {
            return this.vram[address - 32768] & 0xFF;
        }
        return 255;
    }

    public final int cycles() {
        return this.cycles;
    }

    public final void emulate(int ticks) {
        if ((this.lcdc & 0x80) != 0) {
            this.cycles -= ticks;
            while (this.cycles <= 0) {
                switch (this.stat & 3) {
                    case 0: {
                        this.emulateHBlank();
                        break;
                    }
                    case 1: {
                        this.emulateVBlank();
                        break;
                    }
                    case 2: {
                        this.emulateOAM();
                        break;
                    }
                    case 3: {
                        this.emulateTransfer();
                    }
                }
            }
        }
    }

    private final int getControl() {
        return this.lcdc;
    }

    private final int getStatus() {
        return 0x80 | this.stat;
    }

    private final int getScrollY() {
        return this.scy;
    }

    private final int getScrollX() {
        return this.scx;
    }

    private final int getLineY() {
        return this.ly;
    }

    private final int getLineYCompare() {
        return this.lyc;
    }

    private final int getDMA() {
        return this.dma;
    }

    private final int getBackgroundPalette() {
        return this.bgp;
    }

    private final int getObjectPalette0() {
        return this.obp0;
    }

    private final int getObjectPalette1() {
        return this.obp1;
    }

    private final int getWindowY() {
        return this.wy;
    }

    private final int getWindowX() {
        return this.wx;
    }

    private final void setControl(int data) {
        if ((this.lcdc & 0x80) != (data & 0x80)) {
            if ((data & 0x80) != 0) {
                this.stat = this.stat & 0xFC | 2;
                this.cycles = 20;
                this.ly = 0;
                this.display = false;
            } else {
                this.stat = this.stat & 0xFC | 0;
                this.cycles = 114;
                this.ly = 0;
                this.clearFrame();
            }
        }
        if ((this.lcdc & 0x20) == 0 && (data & 0x20) != 0 && this.wly == 0 && this.ly > this.wy) {
            this.wly = 144;
        }
        this.lcdc = data;
    }

    private final void setStatus(int data) {
        this.stat = this.stat & 0x87 | data & 0x78;
        if ((this.lcdc & 0x80) != 0 && (this.stat & 3) == 1 && (this.stat & 0x44) != 68) {
            this.interrupt.raise(2);
        }
    }

    private final void setScrollY(int data) {
        this.scy = data;
    }

    private final void setScrollX(int data) {
        this.scx = data;
    }

    private final void setLYCompare(int data) {
        this.lyc = data;
        if ((this.lcdc & 0x80) != 0) {
            if (this.ly == this.lyc) {
                if ((this.stat & 4) == 0) {
                    this.stat |= 4;
                    if ((this.stat & 0x40) != 0) {
                        this.interrupt.raise(2);
                    }
                }
            } else {
                this.stat &= 0xFB;
            }
        }
    }

    private final void setDMA(int data) {
        this.dma = data;
        for (int index = 0; index < 160; ++index) {
            this.oam[index] = (byte)this.memory.read((this.dma << 8) + index);
        }
    }

    private final void setBackgroundPalette(int data) {
        if (this.bgp != data) {
            this.bgp = data;
            this.dirty = true;
        }
    }

    private final void setObjectPalette0(int data) {
        if (this.obp0 != data) {
            this.obp0 = data;
            this.dirty = true;
        }
    }

    private final void setObjectPalette1(int data) {
        if (this.obp1 != data) {
            this.obp1 = data;
            this.dirty = true;
        }
    }

    private final void setWindowY(int data) {
        this.wy = data;
    }

    private final void setWindowX(int data) {
        this.wx = data;
    }

    private final void emulateOAM() {
        this.stat = this.stat & 0xFC | 3;
        this.cycles += 12;
        this.transfer = true;
    }

    private final void emulateTransfer() {
        if (this.transfer) {
            if (this.display) {
                this.drawLine();
            }
            this.stat = this.stat & 0xFC | 3;
            this.cycles += 32;
            this.transfer = false;
        } else {
            this.stat = this.stat & 0xFC | 0;
            this.cycles += 50;
            if ((this.stat & 8) != 0 && (this.stat & 0x44) != 68) {
                this.interrupt.raise(2);
            }
        }
    }

    private final void emulateHBlank() {
        ++this.ly;
        if (this.ly == this.lyc) {
            this.stat |= 4;
            if ((this.stat & 0x40) != 0) {
                this.interrupt.raise(2);
            }
        } else {
            this.stat &= 0xFB;
        }
        if (this.ly < 144) {
            this.stat = this.stat & 0xFC | 2;
            this.cycles += 20;
            if ((this.stat & 0x20) != 0 && (this.stat & 0x44) != 68) {
                this.interrupt.raise(2);
            }
        } else {
            if (this.display) {
                this.drawFrame();
            }
            if (this.frames++ >= this.frameSkip) {
                this.display = true;
                this.frames = 0;
            } else {
                this.display = false;
            }
            this.stat = this.stat & 0xFC | 1;
            this.cycles += 8;
            this.vblank = true;
        }
    }

    private final void emulateVBlank() {
        if (this.vblank) {
            this.vblank = false;
            this.stat = this.stat & 0xFC | 1;
            this.cycles += 106;
            if ((this.stat & 0x10) != 0) {
                this.interrupt.raise(2);
            }
            this.interrupt.raise(1);
        } else if (this.ly == 0) {
            this.stat = this.stat & 0xFC | 2;
            this.cycles += 20;
            if ((this.stat & 0x20) != 0 && (this.stat & 0x44) != 68) {
                this.interrupt.raise(2);
            }
        } else {
            if (this.ly < 153) {
                ++this.ly;
                this.stat = this.stat & 0xFC | 1;
                this.cycles = this.ly == 153 ? ++this.cycles : (this.cycles += 114);
            } else {
                this.wly = 0;
                this.ly = 0;
                this.stat = this.stat & 0xFC | 1;
                this.cycles += 113;
            }
            if (this.ly == this.lyc) {
                this.stat |= 4;
                if ((this.stat & 0x40) != 0) {
                    this.interrupt.raise(2);
                }
            } else {
                this.stat &= 0xFB;
            }
        }
    }

    private final void drawFrame() {
        this.driver.display();
    }

    private final void clearFrame() {
        this.clearPixels();
        this.driver.display();
    }

    private final void drawLine() {
        if ((this.lcdc & 1) != 0) {
            this.drawBackground();
        } else {
            this.drawCleanBackground();
        }
        if ((this.lcdc & 0x20) != 0) {
            this.drawWindow();
        }
        if ((this.lcdc & 2) != 0) {
            this.drawObjects();
        }
        this.drawPixels();
    }

    private final void drawCleanBackground() {
        for (int x = 0; x < 176; ++x) {
            this.line[x] = 0;
        }
    }

    private final void drawBackground() {
        int y = this.scy + this.ly & 0xFF;
        int x = this.scx & 0xFF;
        int tileMap = (this.lcdc & 8) != 0 ? 7168 : 6144;
        int tileData = (this.lcdc & 0x10) != 0 ? 0 : 2048;
        this.drawTiles(8 - (x & 7), tileMap += (y >> 3 << 5) + (x >> 3), tileData += (y & 7) << 1);
    }

    private final void drawWindow() {
        if (this.ly >= this.wy && this.wx < 167 && this.wly < 144) {
            int tileMap = (this.lcdc & 0x40) != 0 ? 7168 : 6144;
            int tileData = (this.lcdc & 0x10) != 0 ? 0 : 2048;
            this.drawTiles(this.wx + 1, tileMap += this.wly >> 3 << 5, tileData += (this.wly & 7) << 1);
            ++this.wly;
        }
    }

    private final void drawObjects() {
        int count = this.scanObjects();
        int lastx = 176;
        for (int index = 0; index < count; ++index) {
            int data = this.objects[index];
            int x = data >> 24 & 0xFF;
            int flags = data >> 12 & 0xFF;
            int address = data & 0xFFF;
            if (x + 8 <= lastx) {
                this.drawObjectTile(x, address, flags);
            } else {
                this.drawOverlappedObjectTile(x, address, flags);
            }
            lastx = x;
        }
    }

    private final int scanObjects() {
        int count = 0;
        for (int offset = 0; offset < 160; offset += 4) {
            int y = this.oam[offset + 0] & 0xFF;
            int x = this.oam[offset + 1] & 0xFF;
            if (y <= 0 || y >= 160 || x <= 0 || x >= 168) continue;
            int tile = this.oam[offset + 2] & 0xFF;
            int flags = this.oam[offset + 3] & 0xFF;
            y = this.ly - y + 16;
            if ((this.lcdc & 4) != 0) {
                if (y < 0 || y > 15) continue;
                if ((flags & 0x40) != 0) {
                    y = 15 - y;
                }
                tile &= 0xFE;
            } else {
                if (y < 0 || y > 7) continue;
                if ((flags & 0x40) != 0) {
                    y = 7 - y;
                }
            }
            this.objects[count] = (x << 24) + (count << 20) + (flags << 12) + ((tile << 4) + (y << 1));
            if (++count >= 10) break;
        }
        for (int index = 0; index < count; ++index) {
            int rightmost = index;
            for (int number = index + 1; number < count; ++number) {
                if (this.objects[number] >> 20 <= this.objects[rightmost] >> 20) continue;
                rightmost = number;
            }
            if (rightmost == index) continue;
            int data = this.objects[index];
            this.objects[index] = this.objects[rightmost];
            this.objects[rightmost] = data;
        }
        return count;
    }

    private final void drawTiles(int x, int tileMap, int tileData) {
        if ((this.lcdc & 0x10) != 0) {
            while (x < 168) {
                int tile = this.vram[tileMap] & 0xFF;
                this.drawTile(x, tileData + (tile << 4));
                tileMap = (tileMap & 0x1FE0) + (tileMap + 1 & 0x1F);
                x += 8;
            }
        } else {
            while (x < 168) {
                int tile = (this.vram[tileMap] ^ 0x80) & 0xFF;
                this.drawTile(x, tileData + (tile << 4));
                tileMap = (tileMap & 0x1FE0) + (tileMap + 1 & 0x1F);
                x += 8;
            }
        }
    }

    private final void drawTile(int x, int address) {
        int pattern = (this.vram[address] & 0xFF) + ((this.vram[address + 1] & 0xFF) << 8);
        this.line[x + 0] = pattern >> 7 & 0x101;
        this.line[x + 1] = pattern >> 6 & 0x101;
        this.line[x + 2] = pattern >> 5 & 0x101;
        this.line[x + 3] = pattern >> 4 & 0x101;
        this.line[x + 4] = pattern >> 3 & 0x101;
        this.line[x + 5] = pattern >> 2 & 0x101;
        this.line[x + 6] = pattern >> 1 & 0x101;
        this.line[x + 7] = pattern >> 0 & 0x101;
    }

    private final void drawObjectTile(int x, int address, int flags) {
        int pattern = (this.vram[address] & 0xFF) + ((this.vram[address + 1] & 0xFF) << 8);
        int mask = 0;
        if ((flags & 0x80) != 0) {
            mask |= 8;
        }
        if ((flags & 0x10) != 0) {
            mask |= 4;
        }
        if ((flags & 0x20) != 0) {
            int color = pattern << 1 & 0x202;
            if (color != 0) {
                int n = x + 0;
                this.line[n] = this.line[n] | (color | mask);
            }
            if ((color = pattern >> 0 & 0x202) != 0) {
                int n = x + 1;
                this.line[n] = this.line[n] | (color | mask);
            }
            if ((color = pattern >> 1 & 0x202) != 0) {
                int n = x + 2;
                this.line[n] = this.line[n] | (color | mask);
            }
            if ((color = pattern >> 2 & 0x202) != 0) {
                int n = x + 3;
                this.line[n] = this.line[n] | (color | mask);
            }
            if ((color = pattern >> 3 & 0x202) != 0) {
                int n = x + 4;
                this.line[n] = this.line[n] | (color | mask);
            }
            if ((color = pattern >> 4 & 0x202) != 0) {
                int n = x + 5;
                this.line[n] = this.line[n] | (color | mask);
            }
            if ((color = pattern >> 5 & 0x202) != 0) {
                int n = x + 6;
                this.line[n] = this.line[n] | (color | mask);
            }
            if ((color = pattern >> 6 & 0x202) != 0) {
                int n = x + 7;
                this.line[n] = this.line[n] | (color | mask);
            }
        } else {
            int color = pattern >> 6 & 0x202;
            if (color != 0) {
                int n = x + 0;
                this.line[n] = this.line[n] | (color | mask);
            }
            if ((color = pattern >> 5 & 0x202) != 0) {
                int n = x + 1;
                this.line[n] = this.line[n] | (color | mask);
            }
            if ((color = pattern >> 4 & 0x202) != 0) {
                int n = x + 2;
                this.line[n] = this.line[n] | (color | mask);
            }
            if ((color = pattern >> 3 & 0x202) != 0) {
                int n = x + 3;
                this.line[n] = this.line[n] | (color | mask);
            }
            if ((color = pattern >> 2 & 0x202) != 0) {
                int n = x + 4;
                this.line[n] = this.line[n] | (color | mask);
            }
            if ((color = pattern >> 1 & 0x202) != 0) {
                int n = x + 5;
                this.line[n] = this.line[n] | (color | mask);
            }
            if ((color = pattern >> 0 & 0x202) != 0) {
                int n = x + 6;
                this.line[n] = this.line[n] | (color | mask);
            }
            if ((color = pattern << 1 & 0x202) != 0) {
                int n = x + 7;
                this.line[n] = this.line[n] | (color | mask);
            }
        }
    }

    private final void drawOverlappedObjectTile(int x, int address, int flags) {
        int pattern = (this.vram[address] & 0xFF) + ((this.vram[address + 1] & 0xFF) << 8);
        int mask = 0;
        if ((flags & 0x80) != 0) {
            mask |= 8;
        }
        if ((flags & 0x10) != 0) {
            mask |= 4;
        }
        if ((flags & 0x20) != 0) {
            int color = pattern << 1 & 0x202;
            if (color != 0) {
                this.line[x + 0] = this.line[x + 0] & 0x101 | color | mask;
            }
            if ((color = pattern >> 0 & 0x202) != 0) {
                this.line[x + 1] = this.line[x + 1] & 0x101 | color | mask;
            }
            if ((color = pattern >> 1 & 0x202) != 0) {
                this.line[x + 2] = this.line[x + 2] & 0x101 | color | mask;
            }
            if ((color = pattern >> 2 & 0x202) != 0) {
                this.line[x + 3] = this.line[x + 3] & 0x101 | color | mask;
            }
            if ((color = pattern >> 3 & 0x202) != 0) {
                this.line[x + 4] = this.line[x + 4] & 0x101 | color | mask;
            }
            if ((color = pattern >> 4 & 0x202) != 0) {
                this.line[x + 5] = this.line[x + 5] & 0x101 | color | mask;
            }
            if ((color = pattern >> 6 & 0x202) != 0) {
                this.line[x + 7] = this.line[x + 7] & 0x101 | color | mask;
            }
            if ((color = pattern >> 5 & 0x202) != 0) {
                this.line[x + 6] = this.line[x + 6] & 0x101 | color | mask;
            }
        } else {
            int color = pattern >> 6 & 0x202;
            if (color != 0) {
                this.line[x + 0] = this.line[x + 0] & 0x101 | color | mask;
            }
            if ((color = pattern >> 5 & 0x202) != 0) {
                this.line[x + 1] = this.line[x + 1] & 0x101 | color | mask;
            }
            if ((color = pattern >> 4 & 0x202) != 0) {
                this.line[x + 2] = this.line[x + 2] & 0x101 | color | mask;
            }
            if ((color = pattern >> 3 & 0x202) != 0) {
                this.line[x + 3] = this.line[x + 3] & 0x101 | color | mask;
            }
            if ((color = pattern >> 2 & 0x202) != 0) {
                this.line[x + 4] = this.line[x + 4] & 0x101 | color | mask;
            }
            if ((color = pattern >> 1 & 0x202) != 0) {
                this.line[x + 5] = this.line[x + 5] & 0x101 | color | mask;
            }
            if ((color = pattern >> 0 & 0x202) != 0) {
                this.line[x + 6] = this.line[x + 6] & 0x101 | color | mask;
            }
            if ((color = pattern << 1 & 0x202) != 0) {
                this.line[x + 7] = this.line[x + 7] & 0x101 | color | mask;
            }
        }
    }

    private final void drawPixels() {
        this.updatePalette();
        this.drawOffset = this.ly * this.driverWidth;
        for (int x = 8; x < 168; x += 4) {
            int pattern0 = this.line[x + 0];
            int pattern1 = this.line[x + 1];
            int pattern2 = this.line[x + 2];
            int pattern3 = this.line[x + 3];
            this.pixels[this.drawOffset + 0] = this.palette[pattern0];
            this.pixels[this.drawOffset + 1] = this.palette[pattern1];
            this.pixels[this.drawOffset + 2] = this.palette[pattern2];
            this.pixels[this.drawOffset + 3] = this.palette[pattern3];
            this.drawOffset += 4;
        }
    }

    private final void clearPixels() {
        int length = this.driverWidth * this.driverHeight;
        for (int offset = 0; offset < length; ++offset) {
            this.pixels[offset] = COLOR_MAP[0];
        }
    }

    private final void updatePalette() {
        if (this.dirty) {
            for (int pattern = 0; pattern < 64; ++pattern) {
                int color = (pattern & 0x22) == 0 || (pattern & 8) != 0 && (pattern & 0x11) != 0 ? this.bgp >> ((pattern >> 3 & 2) + (pattern & 1) << 1) & 3 : ((pattern & 4) == 0 ? this.obp0 >> ((pattern >> 4 & 2) + (pattern >> 1 & 1) << 1) & 3 : this.obp1 >> ((pattern >> 4 & 2) + (pattern >> 1 & 1) << 1) & 3);
                this.palette[((pattern & 0x30) << 4) + (pattern & 0xF)] = COLOR_MAP[color];
            }
            this.dirty = false;
        }
    }

    public final String toString() {
        return "LCDC=" + Integer.toHexString(this.lcdc) + " STAT=" + Integer.toHexString(this.stat) + " SCY=" + Integer.toHexString(this.scy) + " SCX=" + Integer.toHexString(this.scx) + " LY=" + Integer.toHexString(this.ly) + " LYC=" + Integer.toHexString(this.lyc) + " DMA=" + Integer.toHexString(this.dma) + " BGP=" + Integer.toHexString(this.bgp) + " OBP=" + Integer.toHexString(this.obp0) + "/" + Integer.toHexString(this.obp1) + " WY=" + Integer.toHexString(this.wy) + " WX=" + Integer.toHexString(this.wx) + " WLY=" + Integer.toHexString(this.wly) + " cycles=" + this.cycles;
    }
}

