/*
 * Decompiled with CFR 0.152.
 */
package gameboy.ui;

import gameboy.core.Cartridge;
import gameboy.ui.About;
import gameboy.ui.Emulator;
import gameboy.ui.KeysGrabber;
import gameboy.utils.Properties;
import gameboy.utils.Utils;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.TimeZone;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotFoundException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class Main
extends MIDlet
implements ItemCommandListener,
CommandListener {
    private static final String GAMES_TXT_PATH = "/games/games.txt";
    private static final String GAMES_PATH = "/games/";
    private static final String LANG_PROP_PATH = "/lang/language";
    private static final String SETTINGS_RS = "settings";
    private static final String SAVEDGAMES_RS = "saved_games";
    private static final int FRAME_SKIP = 3;
    private static final int CPU_THREAD_PRIORITY = 1;
    private static final boolean FULLSCREEN_MODE = false;
    private static final boolean CENTER_HORIZONTAL = false;
    private static final boolean CENTER_VERTICAL = false;
    private static final boolean FS_ACCESS = true;
    private static final boolean VERIFY_CART_HEADER = true;
    private KeysGrabber keysGrabber;
    private Vector savedGames;
    private String lastUsedSaveGame = "";
    private Displayable previousDisplayable;
    private Properties langProp;
    private Alert alert;
    private Display display = Display.getDisplay((MIDlet)this);
    private Emulator emulator;
    private Thread gamesListThread;
    private List mainMenuList;
    private List gamesMenuList;
    private List saveGameList;
    private List loadGameList;
    private Form settingsForm;
    private Vector rawGamesList;
    private TextField skipFrameInput;
    private ChoiceGroup cpuThreadPriorityInput;
    private ChoiceGroup verifyHeaderInput;
    private ChoiceGroup fullscreenModeInput;
    private ChoiceGroup centerInput;
    private ChoiceGroup fileSystemAccessInput;
    private StringItem defaultsInput;
    private StringItem confKeysInput;
    private StringItem showKeysInput;
    private long playStartTime;
    private long playEndTime;
    private int skipFrames = 3;
    private int cpuThreadPriority = 1;
    private boolean verifyHeader = true;
    private boolean fullscreenMode = false;
    private boolean centerHorizontal = false;
    private boolean centerVertical = false;
    private boolean fileSystemAccess = true;
    private static Form logForm;

    public Main() {
        this.keysGrabber = new KeysGrabber();
        this.langProp = new Properties(LANG_PROP_PATH, 1);
        this.keysGrabber.setPressKeyLabel(this.langProp.getProperty("label.press_key_for"));
        this.keysGrabber.setPressJoystickLabel(this.langProp.getProperty("label.press_joystick"));
        this.setupLogForm();
        Main.log(this.langProp.getProperty("app.name"));
        Main.log("Platform: " + Properties.getSystemProperty("microedition.platform", "?"));
        Main.log("FC API: " + Properties.getSystemProperty("microedition.io.file.FileConnection.version", "?"));
        Main.log("Language: " + this.langProp.getFilePath());
        this.updateGamesMenuList();
        this.discoverSavedGames();
        this.setupMainMenu();
        this.setupSettingsForm();
        this.loadSettings();
        Main.logMemoryStats();
    }

    public static void logMemoryStats() {
        System.gc();
        long totalMemory = Runtime.getRuntime().totalMemory();
        long freeMemory = Runtime.getRuntime().freeMemory();
        long usedMemory = totalMemory - freeMemory;
        Main.log("Memory: " + Utils.bytes2unit(freeMemory, false) + " free, " + Utils.bytes2unit(usedMemory, false) + " used, " + Utils.bytes2unit(totalMemory, false) + " total");
    }

    public void logPlayTime() {
        long playTime = this.playEndTime - this.playStartTime;
        if (playTime > 0L) {
            Main.log("Play time: " + Utils.millisTimeToString(playTime, false, false, false, true));
        }
        this.playStartTime = 0L;
        this.playEndTime = 0L;
    }

    public void startApp() {
        if (this.emulator == null) {
            this.showMainMenu();
        }
    }

    public void pauseApp() {
        if (this.emulator != null) {
            this.emulator.pause();
            this.showMainMenu();
        }
    }

    public void destroyApp(boolean unconditional) {
        if (this.emulator != null) {
            this.emulator.resume();
            this.emulator.stop();
        }
        this.saveSettings();
        this.display.setCurrent(null);
    }

    private final void discoverSavedGames() {
        RecordStore rs = null;
        try {
            rs = RecordStore.openRecordStore((String)SAVEDGAMES_RS, (boolean)true);
            this.savedGames = new Vector();
            RecordEnumeration re = rs.enumerateRecords(null, null, false);
            while (re.hasNextElement()) {
                int rid = re.nextRecordId();
                byte[] bytes = rs.getRecord(rid);
                this.savedGames.addElement(this.savegameEntry2String(new String(bytes)));
            }
            rs.closeRecordStore();
        }
        catch (Exception x) {
            Main.log(x.toString());
            try {
                if (rs != null) {
                    rs.closeRecordStore();
                }
                RecordStore.deleteRecordStore((String)SAVEDGAMES_RS);
            }
            catch (RecordStoreException ex) {
                Main.log(ex.toString());
            }
        }
    }

    public static void log(String s) {
        if (Utils.isEmptyString(s)) {
            return;
        }
        if (s.charAt(s.length() - 1) == '\n') {
            logForm.append(s);
            System.out.print(s);
        } else {
            logForm.append(s + '\n');
            System.out.print(s + '\n');
        }
        System.out.flush();
    }

    private final Vector reverseVector(Vector v) {
        Vector nv = new Vector(v.size());
        if (v.size() == 0) {
            return nv;
        }
        for (int i = v.size(); i > 0; --i) {
            nv.addElement(v.elementAt(i - 1));
        }
        return nv;
    }

    private final int byteArrayToInt(byte[] b, int offset) {
        int value = 0;
        int shift = 0;
        for (int i = 0; i < 4; ++i) {
            shift = (3 - i) * 8;
            value += (b[i + offset] & 0xFF) << shift;
        }
        return value;
    }

    private final int[] byteArrayToIntArray(byte[] b, int fromOffset) {
        int len = b.length - fromOffset;
        if (len < 4 || len % 4 != 0) {
            return null;
        }
        int count = len / 4;
        int[] ints = new int[count];
        int i = fromOffset;
        int j = 0;
        while (i < b.length) {
            ints[j] = this.byteArrayToInt(b, i);
            i += 4;
            ++j;
        }
        return ints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void loadSettings() {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)SETTINGS_RS, (boolean)false);
            if (rs.getNumRecords() == 0) {
                rs.closeRecordStore();
                this.setDefaultSettings();
                return;
            }
            RecordEnumeration re = rs.enumerateRecords(null, null, false);
            while (re.hasNextElement()) {
                byte[] data = re.nextRecord();
                String value = new String(data);
                int pos = value.indexOf(58);
                if (pos < 0 || pos == value.length()) continue;
                if (value.indexOf("skipFrames:") == 0) {
                    value = value.substring(pos + 1);
                    this.skipFrames = Integer.parseInt(value);
                    continue;
                }
                if (value.indexOf("cpuThreadPriority:") == 0) {
                    value = value.substring(pos + 1);
                    this.cpuThreadPriority = Integer.parseInt(value);
                    continue;
                }
                if (value.indexOf("verifyHeader:") == 0) {
                    this.verifyHeader = (value = value.substring(pos + 1)).equals("true");
                    Cartridge.verifyHeader = this.verifyHeader;
                    continue;
                }
                if (value.indexOf("fullscreen:") == 0) {
                    if ((value = value.substring(pos + 1)).equals("true")) {
                        this.fullscreenMode = true;
                        continue;
                    }
                    this.fullscreenMode = false;
                    continue;
                }
                if (value.indexOf("centerHorizontal:") == 0) {
                    if ((value = value.substring(pos + 1)).equals("true")) {
                        this.centerHorizontal = true;
                        continue;
                    }
                    this.centerHorizontal = false;
                    continue;
                }
                if (value.indexOf("centerVertical:") == 0) {
                    if ((value = value.substring(pos + 1)).equals("true")) {
                        this.centerVertical = true;
                        continue;
                    }
                    this.centerVertical = false;
                    continue;
                }
                if (value.indexOf("fileSystemAccess:") == 0) {
                    if ((value = value.substring(pos + 1)).equals("true")) {
                        this.fileSystemAccess = true;
                        continue;
                    }
                    this.fileSystemAccess = false;
                    continue;
                }
                if (value.indexOf("keys:") != 0) continue;
                int[] codes = this.byteArrayToIntArray(data, pos + 1);
                this.keysGrabber.setKeyCodes(codes);
            }
            rs.closeRecordStore();
        }
        catch (RecordStoreException ex) {
            Main.log(ex.toString());
        }
        finally {
            System.gc();
        }
    }

    private final byte[] getFullGameBoyStateByIndex(int index) {
        RecordStore rs = null;
        int count = 0;
        try {
            rs = RecordStore.openRecordStore((String)SAVEDGAMES_RS, (boolean)true);
            RecordEnumeration re = rs.enumerateRecords(null, null, false);
            while (re.hasNextElement()) {
                byte[] bytes = re.nextRecord();
                if (count == index) {
                    String str = new String(bytes);
                    int offset = str.indexOf(124);
                    if (offset != -1) {
                        str = null;
                        System.gc();
                        byte[] cloned = new byte[bytes.length - offset - 1];
                        System.arraycopy(bytes, offset + 1, cloned, 0, bytes.length - offset - 1);
                        System.gc();
                        return cloned;
                    }
                    return bytes;
                }
                ++count;
            }
            rs.closeRecordStore();
        }
        catch (Exception x) {
            Main.log(x.toString());
            try {
                if (rs != null) {
                    rs.closeRecordStore();
                }
            }
            catch (RecordStoreException ex) {
                Main.log(ex.toString());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void loadSelectedGame() {
        int index = this.loadGameList.getSelectedIndex();
        if (index < 0) {
            return;
        }
        System.gc();
        String str = (String)this.savedGames.elementAt(index);
        String cartridgePath = this.savegameEntry2RomShortName(str);
        try {
            this.updateCartridgeSettings();
            this.setupEmulator();
            this.emulator.load(GAMES_PATH + cartridgePath);
            this.emulator.setTitle(this.cartridgePath2GameTitle(cartridgePath));
            this.emulator.reset();
            this.emulator.setFullGameBoyState(this.getFullGameBoyStateByIndex(index), 0);
            System.gc();
            this.emulator.setRestored(true);
            this.showEmulator();
        }
        catch (Exception x) {
            Main.log(x.toString());
            this.emulator = null;
            this.showAlert(x.toString(), AlertType.ERROR, (Displayable)this.gamesMenuList);
        }
        finally {
            System.gc();
        }
    }

    private final String savegameEntry2String(String savegameEntry) {
        if (Utils.isEmptyString(savegameEntry)) {
            return "";
        }
        int pos = savegameEntry.indexOf(124);
        if (pos != -1) {
            return savegameEntry.substring(0, ++pos);
        }
        return "";
    }

    private final String savegameEntry2Title(String savegameEntry) {
        int pos2;
        if (Utils.isEmptyString(savegameEntry)) {
            return "";
        }
        int pos1 = savegameEntry.indexOf(58);
        if (pos1 != -1 && (pos1 = savegameEntry.indexOf(44, pos1)) != -1 && (pos2 = savegameEntry.indexOf(44, pos1 + 1)) != -1) {
            ++pos1;
            String date = savegameEntry.substring(pos1, pos2);
            if ((pos1 = date.indexOf(GAMES_PATH)) != -1) {
                date = date.substring(GAMES_PATH.length());
            }
            return date;
        }
        return "";
    }

    private final String savegameEntry2Date(String savegameEntry) {
        int pos2;
        if (Utils.isEmptyString(savegameEntry)) {
            return "";
        }
        int pos1 = savegameEntry.indexOf(58);
        if (pos1 != -1 && (pos1 = savegameEntry.indexOf(44, pos1)) != -1 && (pos1 = savegameEntry.indexOf(44, pos1 + 1)) != -1 && (pos2 = savegameEntry.indexOf(124, pos1 + 1)) != -1) {
            ++pos1;
            String date = savegameEntry.substring(pos1, pos2);
            if ((pos1 = date.indexOf(GAMES_PATH)) != -1) {
                date = date.substring(GAMES_PATH.length());
            }
            return date;
        }
        return "";
    }

    private final String savegameEntry2RomShortName(String savegameEntry) {
        int pos2;
        if (Utils.isEmptyString(savegameEntry)) {
            return "";
        }
        int pos1 = savegameEntry.indexOf(58);
        if (pos1 != -1 && (pos2 = savegameEntry.indexOf(44, pos1)) != -1) {
            ++pos1;
            String romName = savegameEntry.substring(pos1, pos2);
            if ((pos1 = romName.indexOf(GAMES_PATH)) != -1) {
                romName = romName.substring(GAMES_PATH.length());
            }
            return romName;
        }
        return "";
    }

    private final int savegameEntry2Index(String savegameEntry) {
        if (Utils.isEmptyString(savegameEntry)) {
            return -1;
        }
        int pos = savegameEntry.indexOf(44);
        if (pos != -1) {
            int index;
            try {
                index = Integer.parseInt(savegameEntry.substring(0, pos));
            }
            catch (NumberFormatException x) {
                Main.log(x.toString());
                return -1;
            }
            return index;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void deleteAllSavedGames() {
        RecordStore rs = null;
        Main.log("Deleting all saved games");
        try {
            RecordStore.deleteRecordStore((String)SAVEDGAMES_RS);
            rs = RecordStore.openRecordStore((String)SAVEDGAMES_RS, (boolean)true);
            rs.closeRecordStore();
        }
        catch (Exception ex) {
            Main.log(ex.toString());
            if (rs != null) {
                try {
                    rs.closeRecordStore();
                }
                catch (RecordStoreNotOpenException ex2) {
                    Main.log(ex.toString());
                }
                catch (RecordStoreException ex3) {
                    Main.log(ex.toString());
                }
            }
        }
        finally {
            this.savedGames.removeAllElements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void saveCurrentGame() {
        RecordStore rs = null;
        if (this.emulator != null) {
            int index = this.saveGameList.getSelectedIndex();
            if (index < 0) {
                return;
            }
            System.gc();
            try {
                rs = RecordStore.openRecordStore((String)SAVEDGAMES_RS, (boolean)true);
                Calendar cal = Calendar.getInstance();
                cal.setTimeZone(TimeZone.getTimeZone("GMT"));
                String data = "savegame,res:" + this.emulator.getCartridgeName() + "," + this.cartridgePath2GameTitle(this.emulator.getCartridgeName()) + "," + (cal.get(10) + 2) + ":" + cal.get(12) + '.' + cal.get(13) + ' ' + cal.get(5) + "." + cal.get(2) + "." + cal.get(1) + "|";
                if (this.savedGames == null) {
                    this.savedGames = new Vector();
                }
                byte[] gameboyState = this.emulator.getFullGameBoyState();
                if (this.savedGames.size() <= index) {
                    data = String.valueOf(this.savedGames.size()) + ',' + data;
                    this.lastUsedSaveGame = this.savegameEntry2Title(data) + ", " + this.savegameEntry2Date(data);
                    byte[] bytes = new byte[data.getBytes().length + gameboyState.length];
                    System.arraycopy(data.getBytes(), 0, bytes, 0, data.getBytes().length);
                    System.arraycopy(gameboyState, 0, bytes, data.getBytes().length, gameboyState.length);
                    Main.log("Saving: " + this.savegameEntry2Index(data) + ',' + this.savegameEntry2Title(data));
                    rs.addRecord(bytes, 0, bytes.length);
                } else {
                    data = String.valueOf(index) + ',' + data;
                    this.lastUsedSaveGame = this.savegameEntry2Title(data) + ", " + this.savegameEntry2Date(data);
                    byte[] bytes = new byte[data.getBytes().length + gameboyState.length];
                    System.arraycopy(data.getBytes(), 0, bytes, 0, data.getBytes().length);
                    System.arraycopy(gameboyState, 0, bytes, data.getBytes().length, gameboyState.length);
                    RecordEnumeration re = rs.enumerateRecords(null, null, true);
                    Main.log("Searching for index: " + this.savegameEntry2Index(data));
                    for (int rindex = 0; re.hasNextElement() && rindex <= index; ++rindex) {
                        int rid = re.nextRecordId();
                        if (rindex != index) continue;
                        Main.log("Record: " + rid + ", " + rindex + "/" + index);
                        Main.log("Saving: " + this.savegameEntry2Index(data) + ',' + this.savegameEntry2Title(data));
                        rs.setRecord(rid, bytes, 0, bytes.length);
                        break;
                    }
                }
                rs.closeRecordStore();
            }
            catch (Exception ex) {
                if (rs != null) {
                    try {
                        rs.closeRecordStore();
                    }
                    catch (RecordStoreNotOpenException ex2) {
                        Main.log(ex.toString());
                    }
                    catch (RecordStoreException ex3) {
                        Main.log(ex.toString());
                    }
                }
                Main.log(ex.toString());
            }
            finally {
                System.gc();
                this.discoverSavedGames();
            }
        }
    }

    private final void fetchSettingsFromForm() {
        this.skipFrames = Integer.parseInt(this.skipFrameInput.getString());
        this.cpuThreadPriority = this.cpuThreadPriorityInput.getSelectedIndex();
        this.verifyHeader = this.verifyHeaderInput.getSelectedIndex() != 0;
        this.fullscreenMode = this.fullscreenModeInput.getSelectedIndex() != 0;
        this.centerHorizontal = this.centerInput.isSelected(0);
        this.centerVertical = this.centerInput.isSelected(1);
        this.fileSystemAccess = this.fileSystemAccessInput.isSelected(1);
    }

    private final byte[] intArray2ByteArray(int[] ia) {
        byte[] ba = new byte[ia.length * 4];
        int i = 0;
        int j = 0;
        while (i < ia.length) {
            byte[] b = this.int2ByteArray(ia[i]);
            System.arraycopy(b, 0, ba, j, 4);
            ++i;
            j += 4;
        }
        return ba;
    }

    private final byte[] int2ByteArray(int i) {
        byte[] dword = new byte[]{(byte)(i >> 24 & 0xFF), (byte)(i >> 16 & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i & 0xFF)};
        return dword;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void saveSettings() {
        this.fetchSettingsFromForm();
        try {
            try {
                RecordStore.deleteRecordStore((String)SETTINGS_RS);
            }
            catch (RecordStoreNotFoundException x) {
                Main.log(x.toString());
            }
            RecordStore rs = RecordStore.openRecordStore((String)SETTINGS_RS, (boolean)true);
            String value = "skipFrames:" + String.valueOf(this.skipFrames);
            rs.addRecord(value.getBytes(), 0, value.length());
            value = "cpuThreadPriority:" + String.valueOf(this.cpuThreadPriority);
            rs.addRecord(value.getBytes(), 0, value.length());
            value = "verifyHeader:" + String.valueOf(this.verifyHeader);
            rs.addRecord(value.getBytes(), 0, value.length());
            value = "fullscreen:" + String.valueOf(this.fullscreenMode);
            rs.addRecord(value.getBytes(), 0, value.length());
            value = "centerHorizontal:" + String.valueOf(this.centerHorizontal);
            rs.addRecord(value.getBytes(), 0, value.length());
            value = "centerVertical:" + String.valueOf(this.centerVertical);
            rs.addRecord(value.getBytes(), 0, value.length());
            value = "fileSystemAccess:" + String.valueOf(this.fileSystemAccess);
            rs.addRecord(value.getBytes(), 0, value.length());
            value = "keys:";
            byte[] codes = this.intArray2ByteArray(this.keysGrabber.getKeyCodes());
            byte[] bytes = new byte[value.getBytes().length + codes.length];
            System.arraycopy(value.getBytes(), 0, bytes, 0, value.getBytes().length);
            System.arraycopy(codes, 0, bytes, value.getBytes().length, codes.length);
            rs.addRecord(bytes, 0, bytes.length);
            rs.closeRecordStore();
        }
        catch (RecordStoreException ex) {
            Main.log(ex.toString());
        }
        finally {
            this.updateEmulatorSettings();
            this.updateVideoSettings();
        }
    }

    private final void updateSettingsForm() {
        if (this.settingsForm == null) {
            this.setupSettingsForm();
        }
        this.skipFrameInput.setString(String.valueOf(this.skipFrames));
        this.cpuThreadPriorityInput.setSelectedIndex(this.cpuThreadPriority, true);
        this.fullscreenModeInput.setSelectedIndex(this.fullscreenMode ? 1 : 0, true);
        this.verifyHeaderInput.setSelectedIndex(this.verifyHeader ? 1 : 0, true);
        this.centerInput.setSelectedIndex(0, this.centerHorizontal);
        this.centerInput.setSelectedIndex(1, this.centerVertical);
        this.fileSystemAccessInput.setSelectedIndex(this.fileSystemAccess ? 1 : 0, true);
    }

    private final void setupSettingsForm() {
        this.settingsForm = new Form(this.langProp.getProperty("settings.form.name"));
        this.confKeysInput = new StringItem(this.langProp.getProperty("label.button.configure_keys"), "", 2);
        this.confKeysInput.setDefaultCommand(new Command(this.langProp.getProperty("label.button.configure_keys"), 4, 0));
        this.confKeysInput.setItemCommandListener((ItemCommandListener)this);
        this.settingsForm.append((Item)this.confKeysInput);
        this.showKeysInput = new StringItem(this.langProp.getProperty("label.button.show_keys"), "", 2);
        this.showKeysInput.setDefaultCommand(new Command(this.langProp.getProperty("label.button.show_keys"), 4, 0));
        this.showKeysInput.setItemCommandListener((ItemCommandListener)this);
        this.settingsForm.append((Item)this.showKeysInput);
        this.skipFrameInput = new TextField(this.langProp.getProperty("label.skip_frames"), String.valueOf(this.skipFrames), 2, 2);
        this.settingsForm.append((Item)this.skipFrameInput);
        this.fullscreenModeInput = new ChoiceGroup(this.langProp.getProperty("label.fullscreen"), 1);
        this.fullscreenModeInput.append(this.langProp.getProperty("label.no"), null);
        this.fullscreenModeInput.append(this.langProp.getProperty("label.yes"), null);
        this.settingsForm.append((Item)this.fullscreenModeInput);
        this.centerInput = new ChoiceGroup(this.langProp.getProperty("label.center_screen"), 2);
        this.centerInput.append(this.langProp.getProperty("label.horizontal"), null);
        this.centerInput.append(this.langProp.getProperty("label.vertical"), null);
        this.settingsForm.append((Item)this.centerInput);
        this.fileSystemAccessInput = new ChoiceGroup(this.langProp.getProperty("label.file_system_access"), 1);
        this.fileSystemAccessInput.append(this.langProp.getProperty("label.no"), null);
        this.fileSystemAccessInput.append(this.langProp.getProperty("label.yes"), null);
        this.settingsForm.append((Item)this.fileSystemAccessInput);
        this.cpuThreadPriorityInput = new ChoiceGroup(this.langProp.getProperty("label.cpu.thread.priority"), 1);
        this.cpuThreadPriorityInput.append(this.langProp.getProperty("cpu.thread.priority.max"), null);
        this.cpuThreadPriorityInput.append(this.langProp.getProperty("cpu.thread.priority.normal"), null);
        this.cpuThreadPriorityInput.append(this.langProp.getProperty("cpu.thread.priority.min"), null);
        this.settingsForm.append((Item)this.cpuThreadPriorityInput);
        this.verifyHeaderInput = new ChoiceGroup(this.langProp.getProperty("label.verify_header"), 1);
        this.verifyHeaderInput.append(this.langProp.getProperty("label.no"), null);
        this.verifyHeaderInput.append(this.langProp.getProperty("label.yes"), null);
        this.settingsForm.append((Item)this.verifyHeaderInput);
        this.defaultsInput = new StringItem(this.langProp.getProperty("label.button.defaults"), "", 2);
        this.defaultsInput.setDefaultCommand(new Command(this.langProp.getProperty("label.button.defaults"), 4, 0));
        this.defaultsInput.setItemCommandListener((ItemCommandListener)this);
        this.settingsForm.append((Item)this.defaultsInput);
        this.settingsForm.addCommand(new Command(this.langProp.getProperty("command.cancel"), 2, 1));
        this.settingsForm.addCommand(new Command(this.langProp.getProperty("command.save"), 4, 0));
        this.settingsForm.setCommandListener((CommandListener)this);
    }

    private final void updateCartridgeSettings() {
        Cartridge.verifyHeader = this.verifyHeader;
    }

    private final void setupLogForm() {
        logForm = new Form(this.langProp.getProperty("log.form.name"));
        logForm.addCommand(new Command(this.langProp.getProperty("command.back"), 2, 1));
        logForm.setCommandListener((CommandListener)this);
    }

    private final void setupEmulator() {
        this.emulator = new Emulator(this);
        this.emulator.setTitle(this.langProp.getProperty("app.name"));
        this.emulator.addCommand(new Command(this.langProp.getProperty("command.pause"), 2, 1));
        this.emulator.setCommandListener(this);
        this.updateEmulatorSettings();
        this.updateVideoSettings();
    }

    private final void appendSavedGames2List(List list) {
        Enumeration e = this.savedGames.elements();
        while (e.hasMoreElements()) {
            String dataStr = (String)e.nextElement();
            String save = this.savegameEntry2Title(dataStr) + ", " + this.savegameEntry2Date(dataStr);
            list.append(save, null);
        }
        if (!Utils.isEmptyString(this.lastUsedSaveGame)) {
            int len = list.size();
            for (int i = 0; i < len; ++i) {
                if (this.lastUsedSaveGame.equals(list.getString(i))) {
                    list.setSelectedIndex(i, true);
                    continue;
                }
                list.setSelectedIndex(i, false);
            }
        }
        System.gc();
    }

    private final void setupLoadGameList() {
        this.loadGameList = new List(this.langProp.getProperty("load.game.list.name"), 3);
        this.appendSavedGames2List(this.loadGameList);
        this.loadGameList.addCommand(new Command(this.langProp.getProperty("command.back"), 2, 1));
        this.loadGameList.addCommand(new Command(this.langProp.getProperty("command.load"), 4, 0));
        this.loadGameList.addCommand(new Command(this.langProp.getProperty("command.delete_all"), 1, 2));
        this.loadGameList.setCommandListener((CommandListener)this);
    }

    private final void setupSaveGameList() {
        String title;
        this.saveGameList = this.emulator != null ? ((title = this.emulator.getTitle()) != null ? new List(title + " - " + this.langProp.getProperty("save.game.list.name"), 3) : new List(this.langProp.getProperty("save.game.list.name"), 3)) : new List(this.langProp.getProperty("save.game.list.name"), 3);
        this.appendSavedGames2List(this.saveGameList);
        this.saveGameList.append("---", null);
        this.saveGameList.addCommand(new Command(this.langProp.getProperty("command.back"), 2, 1));
        this.saveGameList.addCommand(new Command(this.langProp.getProperty("command.save"), 4, 0));
        this.saveGameList.setCommandListener((CommandListener)this);
    }

    private final void setupMainMenu() {
        String title;
        this.mainMenuList = this.emulator != null ? ((title = this.emulator.getTitle()) != null ? new List(title + " - " + this.langProp.getProperty("app.name"), 3) : new List(this.langProp.getProperty("app.name"), 3)) : new List(this.langProp.getProperty("app.name"), 3);
        this.mainMenuList.append(this.langProp.getProperty("command.new_game"), null);
        if (this.emulator != null) {
            this.mainMenuList.append(this.langProp.getProperty("command.save_game"), null);
        }
        if (this.savedGames.size() > 0) {
            this.mainMenuList.append(this.langProp.getProperty("command.load_game"), null);
        }
        this.mainMenuList.append(this.langProp.getProperty("command.settings"), null);
        if (this.emulator != null) {
            this.mainMenuList.append(this.langProp.getProperty("command.unload"), null);
            this.mainMenuList.append(this.langProp.getProperty("command.reset"), null);
            this.mainMenuList.addCommand(new Command(this.langProp.getProperty("command.resume"), 2, 1));
        } else {
            this.mainMenuList.addCommand(new Command(this.langProp.getProperty("command.exit"), 2, 1));
        }
        this.mainMenuList.append(this.langProp.getProperty("command.about"), null);
        this.mainMenuList.append(this.langProp.getProperty("command.log"), null);
        this.mainMenuList.append(this.langProp.getProperty("command.exit"), null);
        this.mainMenuList.addCommand(new Command(this.langProp.getProperty("command.ok"), 4, 0));
        this.mainMenuList.setCommandListener((CommandListener)this);
    }

    private final String cartridgePath2GameTitle(String cartridgePath) {
        if (Utils.isEmptyString(cartridgePath)) {
            return "";
        }
        Enumeration gamesEnum = this.rawGamesList.elements();
        int pos = (cartridgePath = cartridgePath.trim() + ':').indexOf(GAMES_PATH);
        if (pos != -1) {
            cartridgePath = cartridgePath.substring(GAMES_PATH.length());
        }
        while (gamesEnum.hasMoreElements()) {
            String rawGameData = (String)gamesEnum.nextElement();
            pos = (rawGameData = rawGameData.trim()).indexOf(cartridgePath);
            if (pos == -1) continue;
            String title = rawGameData.substring(cartridgePath.length(), rawGameData.length());
            return title;
        }
        return "";
    }

    private final String gameTitle2CartridgePath(String gameTitle) {
        if (Utils.isEmptyString(gameTitle)) {
            return "";
        }
        Enumeration gamesEnum = this.rawGamesList.elements();
        gameTitle = ':' + gameTitle.trim();
        while (gamesEnum.hasMoreElements()) {
            String rawGameData = (String)gamesEnum.nextElement();
            int pos = (rawGameData = rawGameData.trim()).indexOf(gameTitle);
            if (pos == -1) continue;
            String path = rawGameData.substring(0, pos);
            if (path.charAt(0) != '/') {
                path = GAMES_PATH + path;
            }
            return path;
        }
        return "";
    }

    private final void updateGamesMenuList() {
        try {
            this.rawGamesList = new Vector();
            this.gamesMenuList = new List(this.langProp.getProperty("games.menu.list.name"), 3);
            InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(GAMES_TXT_PATH);
            while (is.available() > 0) {
                String line = "";
                int c = 32;
                while ((c = is.read()) > 0 && c != 10) {
                    if (c == 10) continue;
                    line = line + (char)c;
                }
                line = line.trim();
                int pos = line.indexOf(58);
                if (Utils.isEmptyString(line)) continue;
                this.rawGamesList.addElement(line.trim());
                if (pos + 1 < line.length()) {
                    this.gamesMenuList.append(line.substring(pos + 1, line.length()), null);
                    continue;
                }
                if (pos >= 0) continue;
                this.gamesMenuList.append(line, null);
            }
            is.close();
        }
        catch (Exception x) {
            this.rawGamesList = null;
            this.gamesMenuList = null;
            Main.log(x.toString());
        }
        if (!Utils.isEmptyMenuList(this.gamesMenuList)) {
            this.gamesMenuList.addCommand(new Command(this.langProp.getProperty("command.back"), 2, 1));
            this.gamesMenuList.addCommand(new Command(this.langProp.getProperty("command.ok"), 4, 0));
            this.gamesMenuList.setCommandListener((CommandListener)this);
        }
    }

    public final void commandAction(Command command, Item item) {
        String selectedCommand = command.getLabel();
        Runtime.getRuntime().gc();
        if (this.display.getCurrent() == this.settingsForm) {
            if (selectedCommand.equals(this.langProp.getProperty("label.button.defaults"))) {
                this.setDefaultSettings();
                this.updateSettingsForm();
            } else if (selectedCommand.equals(this.langProp.getProperty("label.button.configure_keys"))) {
                this.showKeysGrabber(true);
            } else if (selectedCommand.equals(this.langProp.getProperty("label.button.show_keys"))) {
                this.showKeysGrabber(false);
            }
        }
    }

    public final void commandAction(Command command, Displayable displayable) {
        String selectedCommand = command.getLabel();
        Runtime.getRuntime().gc();
        if (this.display.getCurrent() == this.mainMenuList) {
            String selectedOption = this.mainMenuList.getString(this.mainMenuList.getSelectedIndex());
            if (selectedCommand.equals(this.langProp.getProperty("command.back"))) {
                this.doBack();
            } else if (selectedCommand.equals(this.langProp.getProperty("command.resume"))) {
                this.showEmulator();
            } else if (selectedCommand.equals(this.langProp.getProperty("command.exit"))) {
                this.doExit();
            } else if (command.getPriority() == 0) {
                if (selectedOption.equals(this.langProp.getProperty("command.new_game"))) {
                    this.showGamesListThread();
                } else if (selectedOption.equals(this.langProp.getProperty("command.load_game"))) {
                    this.showLoadGameList();
                } else if (selectedOption.equals(this.langProp.getProperty("command.save_game"))) {
                    this.showSaveGameList();
                } else if (selectedOption.equals(this.langProp.getProperty("command.settings"))) {
                    this.showSettingsForm();
                } else if (selectedOption.equals(this.langProp.getProperty("command.unload"))) {
                    this.emulator.resume();
                    this.emulator.stop();
                    this.emulator = null;
                    this.showMainMenu();
                    Main.logMemoryStats();
                    if (this.playStartTime > 0L) {
                        this.playEndTime = System.currentTimeMillis();
                        this.logPlayTime();
                    }
                } else if (selectedOption.equals(this.langProp.getProperty("command.reset"))) {
                    this.emulator.resume();
                    this.emulator.reset();
                    this.showEmulator();
                    Main.logMemoryStats();
                    if (this.playStartTime > 0L) {
                        this.playEndTime = System.currentTimeMillis();
                        this.logPlayTime();
                    }
                } else if (selectedOption.equals(this.langProp.getProperty("command.about"))) {
                    this.doAbout();
                } else if (selectedOption.equals(this.langProp.getProperty("command.log"))) {
                    this.showLog();
                } else if (selectedOption.equals(this.langProp.getProperty("command.exit"))) {
                    this.doExit();
                }
            }
        } else if (this.display.getCurrent() == this.gamesMenuList) {
            String selectedOption = this.gamesMenuList.getString(this.gamesMenuList.getSelectedIndex());
            if (selectedCommand.equals(this.langProp.getProperty("command.back"))) {
                this.doBack();
            } else if (command.getPriority() == 0) {
                if (!Utils.isEmptyString(selectedOption)) {
                    this.doNewGame(this.gameTitle2CartridgePath(selectedOption));
                } else {
                    this.showMainMenu();
                }
            }
        } else if (this.display.getCurrent() == this.settingsForm) {
            if (selectedCommand.equals(this.langProp.getProperty("command.cancel"))) {
                if (this.emulator != null && this.previousDisplayable == this.emulator) {
                    this.updateVideoSettings();
                    this.emulator.resume();
                } else if (this.previousDisplayable == this.settingsForm) {
                    if (this.emulator != null) {
                        this.emulator.resume();
                        this.previousDisplayable = this.emulator;
                    } else {
                        this.previousDisplayable = this.mainMenuList;
                    }
                }
                this.doBack();
            } else if (selectedCommand.equals(this.langProp.getProperty("command.save"))) {
                this.saveSettings();
                if (this.emulator != null && this.previousDisplayable == this.emulator) {
                    this.emulator.resume();
                } else if (this.previousDisplayable == this.settingsForm) {
                    if (this.emulator != null) {
                        this.emulator.resume();
                        this.previousDisplayable = this.emulator;
                    } else {
                        this.previousDisplayable = this.mainMenuList;
                    }
                }
                this.doBack();
            }
        } else if (this.display.getCurrent() == this.saveGameList) {
            if (command.getPriority() == 0) {
                this.saveCurrentGame();
                this.showEmulator();
            } else if (selectedCommand.equals(this.langProp.getProperty("command.back"))) {
                this.doBack();
            }
        } else if (this.display.getCurrent() == this.loadGameList) {
            if (command.getPriority() == 0) {
                this.loadSelectedGame();
            } else if (selectedCommand.equals(this.langProp.getProperty("command.back"))) {
                this.doBack();
            } else if (selectedCommand.equals(this.langProp.getProperty("command.delete_all"))) {
                this.deleteAllSavedGames();
                this.showMainMenu();
            }
        } else if (this.display.getCurrent() == logForm) {
            if (selectedCommand.equals(this.langProp.getProperty("command.back"))) {
                this.doBack();
            }
        } else if (this.emulator != null && this.display.getCurrent() == this.emulator && selectedCommand.equals(this.langProp.getProperty("command.pause"))) {
            this.emulator.pause();
            this.showMainMenu();
        }
    }

    private final void showAlert(String message, AlertType alertType, Displayable nextDisplayable) {
        this.alert = new Alert("Exception", message, null, alertType);
        this.alert.setTimeout(-2);
        if (nextDisplayable != null) {
            this.changeDisplayable(this.alert, nextDisplayable);
        }
    }

    private final void showEmulator() {
        if (this.alert != null && this.display.getCurrent() == this.alert) {
            return;
        }
        if (this.emulator != null) {
            this.changeDisplayable((Displayable)this.emulator);
            this.emulator.resume();
        } else {
            this.changeDisplayable((Displayable)this.gamesMenuList);
        }
    }

    private final void showLoadGameList() {
        this.discoverSavedGames();
        this.setupLoadGameList();
        this.changeDisplayable((Displayable)this.loadGameList);
    }

    private final void showSaveGameList() {
        this.discoverSavedGames();
        this.setupSaveGameList();
        this.changeDisplayable((Displayable)this.saveGameList);
    }

    public final void showKeysGrabber(boolean grabKeys) {
        this.changeDisplayable((Displayable)this.keysGrabber);
        if (grabKeys) {
            this.keysGrabber.grabKeys(this.previousDisplayable, this.display);
        } else {
            this.keysGrabber.showKeys(this.previousDisplayable, this.display);
        }
    }

    public final void showMainMenu() {
        if (this.alert != null && this.display.getCurrent() == this.alert) {
            return;
        }
        if (this.emulator != null) {
            this.emulator.pause();
        }
        this.setupMainMenu();
        this.changeDisplayable((Displayable)this.mainMenuList);
    }

    public final void showLog() {
        this.changeDisplayable((Displayable)logForm);
    }

    private final void setDefaultSettings() {
        this.skipFrames = 3;
        this.cpuThreadPriority = 1;
        this.verifyHeader = true;
    }

    private final void showSettingsForm() {
        if (this.alert != null && this.display.getCurrent() == this.alert) {
            return;
        }
        this.updateSettingsForm();
        this.changeDisplayable((Displayable)this.settingsForm);
    }

    private final void showGamesListThread() {
        this.gamesListThread = new Thread(){

            public void run() {
                Main.this.showGamesList();
                Main.this.gamesListThread = null;
            }
        };
        this.gamesListThread.setPriority(1);
        this.gamesListThread.start();
    }

    private final void showGamesList() {
        if (this.alert != null && this.display.getCurrent() == this.alert) {
            return;
        }
        this.updateGamesMenuList();
        if (Utils.isEmptyMenuList(this.gamesMenuList)) {
            this.showMainMenu();
        } else {
            this.changeDisplayable((Displayable)this.gamesMenuList);
        }
    }

    private final void updateVideoSettings() {
        if (this.emulator == null) {
            return;
        }
        this.emulator.setFrameSkip(this.skipFrames);
        this.emulator.setFullScreenMode(this.fullscreenMode);
        this.emulator.setCentered(this.centerHorizontal, this.centerVertical);
    }

    private final void updateEmulatorSettings() {
        if (this.emulator == null) {
            return;
        }
        if (this.cpuThreadPriority == 0) {
            this.emulator.setThreadPriority(10);
        } else if (this.cpuThreadPriority == 1) {
            this.emulator.setThreadPriority(5);
        } else if (this.cpuThreadPriority == 2) {
            this.emulator.setThreadPriority(1);
        }
        this.emulator.setKeyCodes(this.keysGrabber.getKeyCodes());
    }

    private final void changeDisplayable(Alert alert, Displayable displayable) {
        this.previousDisplayable = this.display.getCurrent();
        this.display.setCurrent(alert, displayable);
    }

    private final void changeDisplayable(Displayable displayable) {
        this.previousDisplayable = this.display.getCurrent();
        this.display.setCurrent(displayable);
    }

    private final void doBack() {
        if (this.previousDisplayable != null) {
            this.changeDisplayable(this.previousDisplayable);
        } else {
            this.showMainMenu();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doNewGame(String cartridgePath) {
        if (this.emulator != null) {
            this.emulator.resume();
            this.emulator.stop();
            this.emulator = null;
        }
        if (this.playStartTime > 0L) {
            this.playEndTime = System.currentTimeMillis();
            this.logPlayTime();
        }
        System.gc();
        try {
            this.updateCartridgeSettings();
            this.setupEmulator();
            this.emulator.setTitle(this.cartridgePath2GameTitle(cartridgePath));
            this.emulator.load(cartridgePath);
            this.playEndTime = 0L;
            this.playStartTime = System.currentTimeMillis();
            this.showEmulator();
        }
        catch (Exception x) {
            this.emulator = null;
            Main.log(x.toString());
        }
        finally {
            Main.logMemoryStats();
        }
    }

    private final void doExit() {
        System.gc();
        this.destroyApp(false);
        this.notifyDestroyed();
    }

    private final void doAbout() {
        About about = new About();
        System.gc();
        this.changeDisplayable((Displayable)about);
    }
}

