/*
 * Decompiled with CFR 0.152.
 */
package fi.darkwood;

import fi.darkwood.Creature;
import fi.darkwood.Equipment;
import fi.darkwood.equipment.ChestArmour;
import fi.darkwood.equipment.Helmet;
import fi.darkwood.equipment.Shield;
import fi.darkwood.equipment.Weapon;

public abstract class Humanoid
extends Creature {
    public int defence = 0;
    public int[] itemStats = new int[4];
    public Equipment[] equipmentSlots = new Equipment[4];

    public Humanoid(String string, String string2, String string3, int n, int n2) {
        super(string, string3, n, n2);
    }

    public int getDefense() {
        return this.defence;
    }

    public void updateDefense() {
        int n = 0;
        for (int i = 0; i < this.equipmentSlots.length; ++i) {
            if (this.equipmentSlots[i] == null) continue;
            n += this.equipmentSlots[i].getArmorClass();
        }
        this.defence = n;
    }

    public void updateStats() {
        int n;
        int n2 = this.level - 1;
        for (n = 0; n < this.itemStats.length; ++n) {
            this.itemStats[n] = 0;
        }
        for (n = 0; n < this.equipmentSlots.length; ++n) {
            if (this.equipmentSlots[n] == null) continue;
            for (int i = 0; i < 4; ++i) {
                int n3 = i;
                this.itemStats[n3] = this.itemStats[n3] + this.equipmentSlots[n].getStats()[i];
            }
        }
        this.strength = this.itemStats[0] + n2;
        this.dexterity = this.itemStats[1] + n2;
        this.constitution = this.itemStats[2] + n2;
        this.willpower = this.itemStats[3] + n2;
    }

    public double getDamage() {
        if (this.equipmentSlots[2] != null) {
            Weapon weapon = (Weapon)this.equipmentSlots[2];
            int n = weapon.maxDamage - weapon.minDamage;
            int n2 = this.random.nextInt(n) + weapon.minDamage;
            return super.getDamage() + (double)n2;
        }
        return super.getDamage();
    }

    public Equipment equip(Equipment equipment) {
        boolean bl = false;
        int n = equipment.getSlot();
        Equipment equipment2 = this.equipmentSlots[n];
        if (equipment instanceof Helmet) {
            this.equipmentSlots[n] = (Helmet)equipment;
            bl = true;
        }
        if (equipment instanceof ChestArmour) {
            this.equipmentSlots[n] = (ChestArmour)equipment;
            bl = true;
        }
        if (equipment instanceof Weapon) {
            this.equipmentSlots[n] = (Weapon)equipment;
            bl = true;
        }
        if (equipment instanceof Shield) {
            this.equipmentSlots[n] = (Shield)equipment;
            bl = true;
        }
        if (bl) {
            this.updateDefense();
            this.updateStats();
            return equipment2;
        }
        return null;
    }

    public Equipment unequip(Equipment equipment) {
        for (int i = 0; i < this.equipmentSlots.length; ++i) {
            if (equipment != this.equipmentSlots[i]) continue;
            this.equipmentSlots[i] = null;
            return equipment;
        }
        this.updateDefense();
        this.updateStats();
        return null;
    }
}

