/*
 * Decompiled with CFR 0.152.
 */
package fi.darkwood.level.two;

import fi.darkwood.EquipmentFactory;
import fi.darkwood.Game;
import fi.darkwood.GameConstants;
import fi.darkwood.Potion;
import fi.darkwood.Zone;
import fi.darkwood.level.one.eq.ShiningPlateMail;
import fi.darkwood.level.six.quest.QuestKillCurmu;
import fi.darkwood.level.three.quest.QuestKillBaron;
import fi.darkwood.level.two.quest.QuestKillBats;
import fi.darkwood.level.two.quest.QuestKillLich;
import fi.darkwood.room.CityRoom;
import fi.darkwood.room.MapRoom;
import fi.darkwood.room.Room;
import fi.darkwood.room.RoomFactory;
import fi.darkwood.room.ShopRoom;

public class BorderKingdomCapital
extends Zone {
    private RoomFactory a;
    public MapRoom crossroads;

    public BorderKingdomCapital() {
        super("Border Kingdoms Capital", "/images/background/darkwood_town/background.png");
        this.firstQuest = new QuestKillBats();
        this.firstQuest.setReward(new ShiningPlateMail());
        this.allQuestsDoneMessage = Game.player.completedQuests.contains(new QuestKillBaron()) ? (Game.player.completedQuests.contains(new QuestKillCurmu()) ? "You will always be remembered as the hero of the Border Kingdoms!" : "The queen has left to the east to take care of a new rising threat. You are to follow her. You will be given more news on your way.") : "Worrying news have emerged from the County of Ravenstone. Although the baron is my old friend, I fear he might have changed over these years. Travel west and find out what is going on over there.";
        this.a = new RoomFactory();
        System.out.println("Capital instanced: " + this.background);
        Room room = (CityRoom)this.a.constructCityEntrance(this, "center", "/images/background/tier2_city/background_day.png");
        if (Game.player.completedQuests.contains(new QuestKillBaron()) && !Game.player.completedQuests.contains(new QuestKillCurmu())) {
            room.setBackground("/images/background/tier2_city/background_day_empty.png");
        } else if (Game.player.completedQuests.contains(new QuestKillLich()) && Game.player.completedQuests.contains(new QuestKillCurmu())) {
            ((CityRoom)room).setEyesSpriteImage("/images/background/tier2_city/eyes_frames.png", 16, 49, 101);
            ((CityRoom)room).setEyesSpriteFrameTime(new int[]{20, 1, 20, 20});
        }
        if (!Game.player.completedQuests.contains(new QuestKillBaron()) && !Game.player.completedQuests.contains(new QuestKillLich())) {
            ((CityRoom)room).setSpriteImage("/images/background/tier2_city/background_night.png", 176, 0, 29);
            ((CityRoom)room).setSpriteFrameTime(new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1});
        }
        ((CityRoom)room).cityDesc = "Welcome to Border Kingdoms Capital";
        room = this.a.constructMapRoomSouth(this, this.entrance, "maproom");
        this.crossroads = (MapRoom)room;
        this.crossroads.setCoordinates(319, 391, "/images/map/icons/city capital.png");
        this.a.constructStatRoomNorth(this, this.entrance, "Trainer", "trainer");
        this.a.constructTavernRoomEast(this, this.entrance, "Tavern", "tavern");
        room = this.a.constructShopRoomWest(this, this.entrance, "Smithy", "shop");
        ((ShopRoom)room).setWelcomeText("Welcome to the Border Kingdoms Capital smithy. Here you may buy new equipment and replenish potions.");
        int n = GameConstants.getArmorTypeforClass(Game.player.characterClass);
        EquipmentFactory equipmentFactory = EquipmentFactory.getInstance();
        ((ShopRoom)room).addItem(equipmentFactory.createEquipment(6, 1, n, 1));
        ((ShopRoom)room).addItem(equipmentFactory.createEquipment(9, 1, n, 1));
        ((ShopRoom)room).addItem(equipmentFactory.createEquipment(6, 2, n, 1));
        ((ShopRoom)room).addItem(equipmentFactory.createEquipment(10, 2, n, 1));
        ((ShopRoom)room).addItem(equipmentFactory.createEquipment(6, 3, n, 1));
        ((ShopRoom)room).addItem(equipmentFactory.createEquipment(9, 3, n, 1));
        ((ShopRoom)room).addItem(equipmentFactory.createEquipment(5, 0, n, 0));
        ((ShopRoom)room).addItem(equipmentFactory.createEquipment(6, 0, n, 1));
        ((ShopRoom)room).addItem(equipmentFactory.createEquipment(10, 0, n, 1));
        ((ShopRoom)room).addItem(new Potion());
    }

    public void resetZone() {
        this.crossroads.zones.removeAllElements();
        this.crossroads.addZone("/fi/darkwood/level/two/Sewers.xml", 302, 401, this.getClass().getName(), "/images/map/icons/sewers.png");
        if (Game.player.completedQuests.contains(new QuestKillBaron())) {
            this.crossroads.addZone("/fi/darkwood/level/two/RoadToMountains.xml", 401, 289, this.getClass().getName(), "/images/map/icons/mountain pass.png");
        }
        if (Game.player.completedQuests.contains(new QuestKillLich())) {
            this.crossroads.addZone("/fi/darkwood/level/two/RoadToVillage.xml", 174, 345, this.getClass().getName(), "/images/map/icons/village.png");
        }
        this.crossroads.addZone("/fi/darkwood/level/one/ForestRoadBack.xml", 243, 504, this.getClass().getName(), "/images/map/icons/darkwood_hut.png");
        this.crossroads.addZone("/fi/darkwood/level/two/Catacombs.xml", 354, 397, this.getClass().getName(), "/images/map/icons/dungeon (castle).png");
        this.crossroads.addZone("/fi/darkwood/level/two/PartyCrypt.xml", 312, 370, this.getClass().getName(), "/images/map/icons/dungeon (castle).png");
    }

    public String getDescription() {
        return "Border Kingdoms Capital";
    }
}

