/*
 * Decompiled with CFR 0.152.
 */
package ingame;

import component.CSpriteAnimation;
import game.CCanvas;
import javax.microedition.lcdui.Graphics;

public class CPlayerBike {
    private int iFrameCounter = 0;
    public static final int BIKE_NORMAL = 0;
    public static final int BIKE_TURN_R = 1;
    public static final int BIKE_TURN_L = 2;
    public static final int BIKE_FALL_R = 3;
    public static final int BIKE_FALL_L = 4;
    public static final int BIKE_SHIELDED = 5;
    public static final int BIKE_STUMBLING = 6;
    public static final int BIKE_PRIMERY = 0;
    public static final int BIKE_WITH_BULLET = 1;
    public static final int BIKE_WITH_MISSILE = 2;
    public int iPosX;
    public int iPosY;
    public int iWidth;
    public int iHeight;
    private boolean isAnimCycleEnd = false;
    public int iBikeLRSpeed = 8;
    public boolean isPlayerFalling = false;
    public boolean shouldFall = true;
    private int iStumblingState = 0;
    private boolean isShieldedMode = true;
    private CSpriteAnimation animPlayerNormal = new CSpriteAnimation("/character_1.png", 4, 2, false, false);
    private CSpriteAnimation animFallRight;
    private CSpriteAnimation animFallLeft;
    private CSpriteAnimation animTurnLeft;
    private CSpriteAnimation animTurnRight;
    private int iType;
    private int iCurrentState = 0;

    public CPlayerBike() {
        this.iWidth = this.animPlayerNormal.getCurFrameWidth();
        this.iHeight = this.animPlayerNormal.getCurFrameHeight();
        this.iPosX = CCanvas.iScreenW >> 1;
        this.iPosY = CCanvas.iScreenH - this.iHeight;
        this.animFallRight = new CSpriteAnimation("/fall_ani.png", 4, 2, false, false);
        this.animFallLeft = new CSpriteAnimation("/fall_ani.png", 4, 2, true, false);
        this.animTurnLeft = new CSpriteAnimation("/character_side.png", 3, 2, false, false);
        this.animTurnRight = new CSpriteAnimation("/character_side.png", 3, 2, true, false);
    }

    public void setPlayerState(int state) {
        this.isAnimCycleEnd = false;
        this.iCurrentState = state;
        switch (state) {
            case 0: {
                this.isShieldedMode = false;
                break;
            }
            case 6: {
                this.animTurnRight.setFrame(0);
                this.animTurnLeft.setFrame(0);
                this.iStumblingState = 0;
                break;
            }
            case 2: {
                this.animTurnLeft.reset();
                break;
            }
            case 1: {
                this.animTurnRight.reset();
                break;
            }
            case 5: {
                this.isShieldedMode = true;
            }
        }
    }

    public int getPlayerState() {
        return this.iCurrentState;
    }

    public void unload() {
        this.animPlayerNormal = null;
        this.animFallLeft = null;
        this.animFallRight = null;
        this.animTurnLeft = null;
        this.animTurnRight = null;
    }

    public void update() {
        this.isAnimCycleEnd = false;
        switch (this.iCurrentState) {
            case 0: {
                this.animPlayerNormal.update();
                break;
            }
            case 4: {
                this.isAnimCycleEnd = this.animFallLeft.updateOnce(true);
                break;
            }
            case 3: {
                this.isAnimCycleEnd = this.animFallRight.updateOnce(true);
                break;
            }
            case 2: {
                this.animTurnLeft.updateOnce(false);
                break;
            }
            case 1: {
                this.animTurnRight.updateOnce(false);
                break;
            }
            case 5: {
                this.animPlayerNormal.update();
                break;
            }
            case 6: {
                ++this.iFrameCounter;
                this.iFrameCounter %= 100;
                if (this.iFrameCounter % 4 != 0) break;
                this.iStumblingState = 1 - this.iStumblingState;
            }
        }
        if (this.isShieldedMode) {
            ++this.iFrameCounter;
            this.iFrameCounter %= 100;
        }
    }

    public void resetAnimStates() {
        this.animPlayerNormal.reset();
        this.animFallLeft.reset();
        this.animFallRight.reset();
        this.animTurnLeft.reset();
        this.animTurnRight.reset();
    }

    public boolean isAnimEnd() {
        return this.isAnimCycleEnd;
    }

    public void paint(Graphics g2) {
        switch (this.iCurrentState) {
            case 0: {
                this.animPlayerNormal.paint(g2, this.iPosX, this.iPosY, 33);
                break;
            }
            case 4: {
                this.animFallLeft.paint(g2, this.iPosX, this.iPosY, 33);
                break;
            }
            case 3: {
                this.animFallRight.paint(g2, this.iPosX, this.iPosY, 33);
                break;
            }
            case 2: {
                if (this.isShieldedMode) {
                    if (this.iFrameCounter % 4 <= 1) break;
                    this.animTurnLeft.paint(g2, this.iPosX, this.iPosY, 33);
                    break;
                }
                this.animTurnLeft.paint(g2, this.iPosX, this.iPosY, 33);
                break;
            }
            case 1: {
                if (this.isShieldedMode) {
                    if (this.iFrameCounter % 4 <= 1) break;
                    this.animTurnRight.paint(g2, this.iPosX, this.iPosY, 33);
                    break;
                }
                this.animTurnRight.paint(g2, this.iPosX, this.iPosY, 33);
                break;
            }
            case 5: {
                if (this.iFrameCounter % 4 <= 1) break;
                this.animPlayerNormal.paint(g2, this.iPosX, this.iPosY, 33);
                break;
            }
            case 6: {
                if (this.iStumblingState == 0) {
                    this.animTurnRight.paint(g2, this.iPosX, this.iPosY, 33);
                    break;
                }
                this.animTurnLeft.paint(g2, this.iPosX, this.iPosY, 33);
            }
        }
    }
}

