/*
 * Decompiled with CFR 0.152.
 */
package ingame;

import component.CRectangle;
import component.CSpriteAnimation;
import component.CUtility;
import game.CCanvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CCoin {
    private CSpriteAnimation[] animArrCoins;
    private int[][] iCoinPos = null;
    private boolean[] isCollected = null;
    private int iNoOfCoins;
    private int iCoinW;
    private int iCoinH;
    public boolean isAttracting = false;
    public static final int TOTAL_PATTERN = 7;
    public static final int PATTERN_VER_2 = 0;
    public static final int PATTERN_VER_3 = 1;
    public static final int PATTERN_HOR_2 = 2;
    public static final int PATTERN_HOR_3 = 3;
    public static final int PATTERN_HOR_4 = 4;
    public static final int PATTERN_DIA_R = 5;
    public static final int PATTERN_DIA_L = 6;

    public CCoin(Image imgCoin, int iPatternType, int iPosX, int iStartY) {
        try {
            this.iCoinW = imgCoin.getWidth() >> 2;
            this.iCoinH = imgCoin.getHeight();
            CSpriteAnimation tmpAnim = new CSpriteAnimation(imgCoin, 4, 2, false, false);
            switch (iPatternType) {
                case 0: {
                    this.iNoOfCoins = 2;
                    this.animArrCoins = new CSpriteAnimation[this.iNoOfCoins];
                    this.iCoinPos = new int[this.iNoOfCoins][2];
                    this.isCollected = new boolean[this.iNoOfCoins];
                    for (int i2 = 0; i2 < this.iNoOfCoins; ++i2) {
                        this.animArrCoins[i2] = tmpAnim;
                        this.iCoinPos[i2][0] = iPosX;
                        this.iCoinPos[i2][1] = iStartY + i2 * (this.iCoinH + (this.iCoinH >> 1));
                        this.isCollected[i2] = false;
                    }
                    break;
                }
                case 1: {
                    this.iNoOfCoins = 3;
                    this.animArrCoins = new CSpriteAnimation[this.iNoOfCoins];
                    this.iCoinPos = new int[this.iNoOfCoins][2];
                    this.isCollected = new boolean[this.iNoOfCoins];
                    for (int i3 = 0; i3 < this.iNoOfCoins; ++i3) {
                        this.animArrCoins[i3] = tmpAnim;
                        this.iCoinPos[i3][0] = iPosX;
                        this.iCoinPos[i3][1] = iStartY + i3 * (this.iCoinH + (this.iCoinH >> 1));
                        this.isCollected[i3] = false;
                    }
                    break;
                }
                case 2: {
                    this.iNoOfCoins = 2;
                    this.animArrCoins = new CSpriteAnimation[this.iNoOfCoins];
                    this.iCoinPos = new int[this.iNoOfCoins][2];
                    iPosX -= this.iCoinW * this.iNoOfCoins + (this.iCoinW >> 1) * (this.iNoOfCoins - 1) >> 1;
                    this.isCollected = new boolean[this.iNoOfCoins];
                    for (int i4 = 0; i4 < this.iNoOfCoins; ++i4) {
                        this.animArrCoins[i4] = tmpAnim;
                        this.iCoinPos[i4][0] = iPosX + i4 * (this.iCoinW + (this.iCoinW >> 1));
                        this.iCoinPos[i4][1] = iStartY;
                        this.isCollected[i4] = false;
                    }
                    break;
                }
                case 3: {
                    this.iNoOfCoins = 3;
                    this.animArrCoins = new CSpriteAnimation[this.iNoOfCoins];
                    this.iCoinPos = new int[this.iNoOfCoins][2];
                    iPosX -= this.iCoinW * this.iNoOfCoins + (this.iCoinW >> 1) * (this.iNoOfCoins - 1) >> 1;
                    this.isCollected = new boolean[this.iNoOfCoins];
                    for (int i5 = 0; i5 < this.iNoOfCoins; ++i5) {
                        this.animArrCoins[i5] = tmpAnim;
                        this.iCoinPos[i5][0] = iPosX + i5 * (this.iCoinW + (this.iCoinW >> 1));
                        this.iCoinPos[i5][1] = iStartY;
                        this.isCollected[i5] = false;
                    }
                    break;
                }
                case 4: {
                    this.iNoOfCoins = 4;
                    this.animArrCoins = new CSpriteAnimation[this.iNoOfCoins];
                    this.iCoinPos = new int[this.iNoOfCoins][2];
                    iPosX = (CCanvas.iScreenW >> 1) - (this.iCoinW * this.iNoOfCoins + (this.iCoinW >> 1) * (this.iNoOfCoins - 1) >> 1);
                    this.isCollected = new boolean[this.iNoOfCoins];
                    for (int i6 = 0; i6 < this.iNoOfCoins; ++i6) {
                        this.animArrCoins[i6] = tmpAnim;
                        this.iCoinPos[i6][0] = iPosX + i6 * (this.iCoinW + (this.iCoinW >> 1));
                        this.iCoinPos[i6][1] = iStartY;
                        this.isCollected[i6] = false;
                    }
                    break;
                }
                case 5: {
                    this.iNoOfCoins = 4;
                    this.animArrCoins = new CSpriteAnimation[this.iNoOfCoins];
                    this.iCoinPos = new int[this.iNoOfCoins][2];
                    this.isCollected = new boolean[this.iNoOfCoins];
                    for (int i7 = 0; i7 < this.iNoOfCoins; ++i7) {
                        this.animArrCoins[i7] = tmpAnim;
                        this.iCoinPos[i7][0] = iPosX + i7 * this.iCoinW;
                        this.iCoinPos[i7][1] = iStartY + i7 * (this.iCoinH + (this.iCoinH >> 1));
                        this.isCollected[i7] = false;
                    }
                    break;
                }
                case 6: {
                    this.iNoOfCoins = 4;
                    this.animArrCoins = new CSpriteAnimation[this.iNoOfCoins];
                    this.iCoinPos = new int[this.iNoOfCoins][2];
                    this.isCollected = new boolean[this.iNoOfCoins];
                    for (int i8 = 0; i8 < this.iNoOfCoins; ++i8) {
                        this.animArrCoins[i8] = tmpAnim;
                        this.iCoinPos[i8][0] = iPosX - i8 * this.iCoinW;
                        this.iCoinPos[i8][1] = iStartY + i8 * (this.iCoinH + (this.iCoinH >> 1));
                        this.isCollected[i8] = false;
                    }
                    break;
                }
            }
            tmpAnim = null;
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public void update(int iSpeed) {
        for (int i2 = 0; i2 < this.iNoOfCoins; ++i2) {
            int[] nArray = this.iCoinPos[i2];
            nArray[1] = nArray[1] + iSpeed;
        }
        this.animArrCoins[0].update();
    }

    public void attractCoin(int iTargetX, int iYSpeed, int iTargetY) {
        this.isAttracting = true;
        int iSpeed = 0;
        int iTime = (iTargetY - (CCanvas.iScreenH >> 4)) / (iYSpeed + 5);
        if (iTime <= 0) {
            iTime = 1;
        }
        for (int i2 = 0; i2 < this.iNoOfCoins; ++i2) {
            if (this.isCollected[i2] || this.iCoinPos[i2][1] < CCanvas.iScreenH >> 4) continue;
            iSpeed = (iTargetX - this.iCoinPos[i2][0]) / iTime;
            iSpeed = iSpeed < 0 ? --iSpeed : ++iSpeed;
            int[] nArray = this.iCoinPos[i2];
            nArray[0] = nArray[0] + (iSpeed << 1);
            if (this.iCoinPos[i2][1] > iTargetY) {
                int[] nArray2 = this.iCoinPos[i2];
                nArray2[1] = nArray2[1] - (iYSpeed + 5);
                continue;
            }
            if (this.iCoinPos[i2][1] >= iTargetY) continue;
            int[] nArray3 = this.iCoinPos[i2];
            nArray3[1] = nArray3[1] + 5;
        }
    }

    public int getPosY() {
        return this.iCoinPos[0][1];
    }

    public void paint(Graphics g2) {
        for (int i2 = 0; i2 < this.iNoOfCoins; ++i2) {
            if (this.isCollected[i2]) continue;
            this.animArrCoins[i2].paint(g2, this.iCoinPos[i2][0], this.iCoinPos[i2][1], 17);
        }
    }

    public int getCollisionCount(CRectangle rectBike) {
        int iCollCount = 0;
        for (int i2 = 0; i2 < this.iNoOfCoins; ++i2) {
            if (this.isCollected[i2]) continue;
            this.isCollected[i2] = CUtility.isCollideRect(this.iCoinPos[i2][0] - (this.iCoinW >> 1), this.iCoinPos[i2][1], this.iCoinW, this.iCoinH, rectBike.iX, rectBike.iY, rectBike.iW, rectBike.iH);
            if (!this.isCollected[i2]) continue;
            ++iCollCount;
        }
        return iCollCount;
    }
}

