/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;

public class SoundManager
extends Thread {
    private int toPlay = -1;
    private int lastPlayed = -1;
    private Player[] sound = null;
    public static SoundManager instance = null;
    private boolean mute = false;

    public SoundManager() {
        String[] stringArray = Manager.getSupportedContentTypes(null);
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].toLowerCase().indexOf("audio/amr") <= -1) continue;
            bl = true;
        }
        String string = "audio/x-wav";
        String string2 = ".wav";
        if (bl) {
            string = "audio/amr";
            string2 = ".amr";
        }
        this.sound = new Player[Utils.sfxFilename.length];
        try {
            for (int i = 0; i < this.sound.length; ++i) {
                InputStream inputStream = this.getClass().getResourceAsStream("/sounds/".concat(Utils.sfxFilename[i].concat(string2)));
                this.sound[i] = Manager.createPlayer((InputStream)inputStream, (String)string);
                this.sound[i].realize();
                this.sound[i].prefetch();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (MediaException mediaException) {
            mediaException.printStackTrace();
        }
        this.start();
    }

    public static SoundManager getInstance() {
        if (instance == null) {
            instance = new SoundManager();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playSFX(int n) {
        if (this.mute) {
            return;
        }
        this.toPlay = n;
        SoundManager soundManager = this;
        synchronized (soundManager) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            System.out.println("waiting...");
            SoundManager soundManager = this;
            synchronized (soundManager) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            System.out.println("notified...");
            if (this.toPlay < 0) continue;
            try {
                if (this.lastPlayed >= 0 && this.sound[this.lastPlayed] != null) {
                    this.sound[this.lastPlayed].stop();
                    this.sound[this.lastPlayed].deallocate();
                }
                if (this.sound[this.toPlay] != null) {
                    if (this.sound[this.toPlay].getState() == 100) {
                        this.sound[this.toPlay].realize();
                    }
                    if (this.sound[this.toPlay].getState() == 200) {
                        this.sound[this.toPlay].prefetch();
                    }
                    this.sound[this.toPlay].start();
                    this.lastPlayed = this.toPlay;
                }
            }
            catch (MediaException mediaException) {
                mediaException.printStackTrace();
            }
            this.toPlay = -1;
        }
    }

    public void stop() {
        this.stop(false);
    }

    public void stop(boolean bl) {
        try {
            for (int i = 0; i < this.sound.length; ++i) {
                if (this.sound[i] == null) continue;
                this.sound[i].stop();
                this.sound[i].deallocate();
                if (!bl) continue;
                this.sound[i].close();
                this.sound[i] = null;
            }
        }
        catch (MediaException mediaException) {
            mediaException.printStackTrace();
        }
    }

    public void setMute(boolean bl) {
        this.mute = bl;
    }
}

