/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.TextBox;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class GameScreen
extends Canvas
implements Runnable {
    public Main parent;
    public Thread t = new Thread(this);
    public Random r = new Random(System.currentTimeMillis());
    public int screenWidth;
    public int screenHeight;
    public int screenWidthHalf;
    public int screenHeightHalf;
    public Font fontSmall = Font.getFont((int)32, (int)0, (int)8);
    public Font font = Font.getFont((int)32, (int)0, (int)0);
    public Font fontBig = Font.getFont((int)32, (int)0, (int)16);
    public Player bgm;
    public Player[] sfx = new Player[4];
    public boolean isUnicode = true;
    public int language = 0;
    public int fps = 0;
    public int frames = 0;
    public long lastTime;
    public int cheat = 0;
    public boolean showDebug = false;
    public int touchX;
    public int touchY;
    public int touchSX;
    public int touchSY;
    public int touchDX;
    public int touchDY;
    public boolean touched;
    public int press;
    public int release;
    public int held;
    public int key;
    public int[] keys = null;
    public boolean bUp;
    public boolean bDown;
    public boolean bLeft;
    public boolean bRight;
    public boolean bFire;
    public byte gameState;
    public int cur = 0;
    public int mainCur = 0;
    public int counter = 0;
    public long loopCounter = 0L;
    public long splashTimer;
    public long time;
    public long pauseTime;
    public long backlightTime;
    public boolean musicEnabled = true;
    public boolean soundEnabled = true;
    public boolean vibrateEnabled = true;
    public boolean supportsMID = false;
    public boolean supportsWAV = false;
    public boolean supportsAMR = false;
    public boolean supportsMixing = false;
    public boolean bSaving = false;
    public int score;
    public int[] hiscore = null;
    public String[] bestPlayers = null;
    public GameScreen self;
    public TextBox textbox = new TextBox("Enter your initials", "", 6, 0);
    public Image[] imageLibrary = null;
    public String[] wrappedText = null;
    public Image[] bitmapFontBlack = null;
    public Image[] bitmapFontWhite = null;
    public Image[] bitmapFontBlue = null;
    public int[] splashPos = new int[2];
    public int[] splashVel = new int[2];
    public byte splashAction;
    public boolean slideExiting = false;
    public int slideX;
    public int slideVel;
    public int slideAccel;
    public int maxSlideVel;
    public String[] localized = null;
    public static final byte NUM_BG = 10;
    public static final byte BONUS_STAGE = 5;
    public static final byte MAX_BALLOONS = 16;
    public static final byte ANIM_IDLE = 0;
    public static final byte ANIM_WALK = 1;
    public static final byte ANIM_HIT = 2;
    public static final byte VERTICAL_DIR_UP = 0;
    public static final byte VERTICAL_DIR_DOWN = 1;
    public static final byte HORIZONTAL_DIR_LEFT = 0;
    public static final byte HORIZONTAL_DIR_RIGHT = 1;
    public static final int SIZE_SMALL = 0;
    public static final int SIZE_MEDIUM = 1;
    public static final int SIZE_LARGE = 2;
    public static final int SIZE_EXTRA_LARGE = 3;
    public static final int MAX_SIZE = 4;
    public static final int COLOR_RED = 0;
    public static final int COLOR_GREEN = 1;
    public static final int COLOR_BLUE = 2;
    public static final int COLOR_YELLOW = 3;
    public static final int BOUNCE_LIMIT = 30;
    public static final int BOTTOM_HUD_ADJUST = 88;
    public static final byte WEAPON_SPEAR = 0;
    public static final byte WEAPON_PUMP = 1;
    public static final byte WEAPON_PISTOL = 2;
    public static final byte WEAPON_SPEAR2 = 3;
    public static final int[][] BALLOON_VEL = new int[][]{{1, 2}, {2, 4}, {3, 6}, {4, 8}};
    public static final int[][] BALLOON_COUNT = new int[][]{{0, 1}, {0, 0, 1}, {1, 1}, {0, 1, 1}, {1, 1, 1}, {0, 1, 1, 1}, {2}, {0, 2}, {1, 2}, {0, 1, 2}, {0, 0, 1, 2}, {1, 1, 2}, {2, 2}, {0, 2, 2}, {1, 2, 2}, {0, 1, 2, 2}, {0, 1, 1, 2, 2}, {2, 2, 2}, {2, 2, 2, 3}, {3, 3, 3, 3, 3}};
    private Sprite sprHero;
    private Sprite sprPump;
    private Sprite[] sprSpear = new Sprite[2];
    private Sprite[] sprBalloons = new Sprite[16];
    private Sprite[] sprPop = new Sprite[16];
    private Sprite[] sprBullet = new Sprite[3];
    private LayerManager layerMgr = new LayerManager();
    private int heroAnim;
    private int weapon;
    private int numSpears;
    private int live;
    private int nextBonus;
    private int level;
    private int tempInvincibility;
    private int transRectIn;
    private long gameTime;
    private long maxTime;
    private long stopTime;
    private long pumpTime;
    private boolean bulletActive;
    private boolean stuck;
    private boolean shield;
    private boolean bonusStage;
    private boolean cheatEnabled;
    private int transRect = 0;
    private int victoryX;
    private Sprite sprPow;
    private long powTime;
    private byte powType;
    public static final byte POW_TYPE_CANDY = 0;
    public static final byte POW_TYPE_PUMP = 1;
    public static final byte POW_TYPE_TIME = 2;
    public static final byte POW_TYPE_STOP = 3;
    public static final byte POW_TYPE_PISTOL = 4;
    public static final byte POW_TYPE_DOUBLE = 5;
    public static final byte POW_TYPE_SHIELD = 6;
    private int ground;
    private int hudY;
    private int numBalls;
    private int[] balloonVelX = new int[16];
    private int[] balloonVelY = new int[16];
    private int[] balloonSize = new int[16];
    private int[] balloonColor = new int[16];
    private int[] balloonVertDir = new int[16];
    private int[] balloonHorizDir = new int[16];
    private int[] balloonBounce = new int[16];
    private boolean blink = false;
    public boolean bInTextbox = false;
    public boolean isTouchScreen = false;
    public byte lastState = 0;
    boolean force176x220 = false;
    public static final int UP_PRESSED = 2;
    public static final int DOWN_PRESSED = 4;
    public static final int LEFT_PRESSED = 8;
    public static final int RIGHT_PRESSED = 16;
    public static final int FIRE_PRESSED = 32;
    public int keyStates = 0;
    public int igpY = 30;
    public static final int numAds = 2;
    int heroMoveSpeed = 4;
    int objectMoveSpeed = 8;
    public static final int MAX_PARTICLES = 64;
    public static final int PARTICLES_PER_SPAWN = 12;
    public int[] pclX;
    public int[] pclY;
    public int[] pclVelX;
    public int[] pclVelY;
    public int[] pclColor;
    public boolean[] pclActive;
    private static final int[] COLORS = new int[]{0xFF0000, 65280, 255, 0xFFFF00};

    public void unsupportedOrientationUpdate(Graphics graphics) {
        this.clearScreen(graphics, 255);
        graphics.setColor(0xFFFFFF);
        graphics.drawString("Unsupported Orientation", this.screenWidthHalf, this.screenHeightHalf, 33);
        graphics.drawString("Please switch to portrait mode", this.screenWidthHalf, this.screenHeightHalf, 17);
    }

    public void standbyUpdate(Graphics graphics) {
        this.clearScreen(graphics, 255);
        graphics.setColor(0xFFFFFF);
        graphics.drawString("Interrupted!", this.screenWidthHalf, this.screenHeightHalf, 33);
        graphics.drawString(this.isTouchScreen ? "Touch Screen to continue" : "Press Fire to continue", this.screenWidthHalf, this.screenHeightHalf, 17);
        if (this.bFire || this.touched) {
            this.setState(this.lastState);
            this.bFire = false;
            this.touched = false;
        }
    }

    public void trace(String string) {
        System.out.println(string);
    }

    public void showError(String string) {
    }

    public byte[] getFile(String string) {
        try {
            this.trace("Loading resource : " + string);
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            byte[] byArray = new byte[inputStream.available()];
            inputStream.read(byArray, 0, byArray.length);
            inputStream.close();
            return byArray;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public void drawFontChar(Graphics graphics, Image image, char c, int n, int n2) {
        int n3 = graphics.getClipX();
        int n4 = graphics.getClipY();
        int n5 = graphics.getClipWidth();
        int n6 = graphics.getClipHeight();
        graphics.setClip(n, n2, 7, 13);
        graphics.drawImage(image, n - (c - 32) * 7, n2, 4 | 0x10);
        graphics.setClip(n3, n4, n5, n6);
    }

    public void drawFontString(Graphics graphics, Image image, String string, int n, int n2, int n3) {
        if ((n3 & 1) != 0) {
            n -= 7 * string.length() >> 1;
        } else if ((n3 & 8) != 0) {
            n -= 7 * string.length();
        }
        if ((n3 & 2) != 0) {
            n2 -= 6;
        } else if ((n3 & 0x20) != 0) {
            n2 -= 13;
        }
        for (int i = 0; i < string.length(); ++i) {
            this.drawFontChar(graphics, image, string.charAt(i), n + i * 7, n2);
        }
    }

    public int random(int n) {
        return Math.abs(this.r.nextInt() % n);
    }

    public void drawRegion(Graphics graphics, Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = graphics.getClipX();
        int n9 = graphics.getClipY();
        int n10 = graphics.getClipWidth();
        int n11 = graphics.getClipHeight();
        graphics.setClip(n5, n6, n3, n4);
        graphics.drawImage(image, n5 - n, n6 - n2, n7);
        graphics.setClip(n8, n9, n10, n11);
    }

    public boolean collision(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return n + n3 >= n5 && n <= n5 + n7 && n2 + n4 >= n6 && n2 <= n6 + n8;
    }

    public boolean isPointInRect(int n, int n2, int n3, int n4, int n5, int n6) {
        return n >= n3 && n <= n3 + n5 && n2 >= n4 && n2 <= n4 + n6;
    }

    public String leadingZeroes(int n, int n2) {
        String string = new Integer(n).toString();
        while (string.length() < n2) {
            string = "0".concat(string);
        }
        return string;
    }

    public String[] wrapText(Graphics graphics, String string, int n, int n2) {
        int n3;
        String[] stringArray = new String[100];
        String string2 = "";
        int n4 = n2 / 13;
        int n5 = 0;
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            stringArray[n3] = "";
        }
        n3 = 0;
        while (n3 == 0) {
            String string3;
            int n6 = string.indexOf("\n");
            int n7 = string.indexOf(" ");
            if (n6 > -1 && (n7 == -1 || n6 < n7)) {
                n7 = n6;
            }
            if (n7 > -1) {
                string3 = string.substring(0, n7 + 1);
                while (string3.length() * 7 > n) {
                    string3 = string.substring(0, --n7 + 1);
                }
                string = string.substring(n7 + 1);
            } else {
                string3 = string;
                n3 = 1;
            }
            if ((string2 + string3).length() * 7 <= n) {
                string2 = string2 + string3;
            } else {
                stringArray[n5] = string2;
                ++n5;
                string2 = string3;
            }
            if (n7 > -1 && n7 == n6) {
                stringArray[n5] = string2;
                string2 = "";
                ++n5;
                continue;
            }
            if (n3 == 0) continue;
            stringArray[n5] = string2;
            ++n5;
        }
        String[] stringArray2 = new String[n5];
        for (int i = 0; i < n5; ++i) {
            stringArray2[i] = stringArray[i];
        }
        return stringArray2;
    }

    public String[] wrapTextSystemFont(Graphics graphics, Font font, String string, int n, int n2) {
        String[] stringArray = null;
        try {
            Vector<String> vector = new Vector<String>();
            String string2 = "";
            int n3 = n2 / font.getHeight();
            int n4 = 0;
            boolean bl = false;
            while (!bl) {
                String string3;
                int n5 = string.indexOf("\n");
                int n6 = string.indexOf(" ");
                if (n5 > -1 && (n6 == -1 || n5 < n6)) {
                    n6 = n5;
                }
                if (n6 > -1) {
                    string3 = string.substring(0, n6 + 1);
                    while (font.stringWidth(string3) > n) {
                        string3 = string.substring(0, --n6 + 1);
                    }
                    string = string.substring(n6 + 1);
                } else {
                    string3 = string;
                    bl = true;
                }
                if (font.stringWidth(string2 + string3) <= n) {
                    string2 = string2 + string3;
                } else {
                    vector.addElement(string2);
                    ++n4;
                    string2 = string3;
                }
                if (n6 > -1 && n6 == n5) {
                    vector.addElement(string2);
                    string2 = "";
                    ++n4;
                    continue;
                }
                if (!bl) continue;
                vector.addElement(string2);
                ++n4;
            }
            stringArray = new String[vector.size()];
            Enumeration enumeration = vector.elements();
            int n7 = 0;
            while (enumeration.hasMoreElements()) {
                StringBuffer stringBuffer = new StringBuffer();
                String string4 = (String)enumeration.nextElement();
                for (int i = 0; i < string4.length(); ++i) {
                    if (string4.charAt(i) != '\r' && string4.charAt(i) != '\n') {
                        stringBuffer.append(string4.charAt(i));
                        continue;
                    }
                    this.trace("carriage return or line break found at " + i);
                }
                stringArray[n7++] = stringBuffer.toString().trim();
                stringBuffer = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringArray;
    }

    public void pause() {
        this.trace("GOING STANDBY");
        this.stopBGM();
        for (int i = 0; i < 4; ++i) {
            this.stopSFX(i);
        }
        if (!(this.gameState != 3 && this.gameState != 9 || this.bInTextbox)) {
            this.imageLibrary[3] = null;
            System.gc();
            this.imageLibrary[3] = this.getImage("bg.jpg", true);
            this.setState((byte)9);
            this.pauseTime = System.currentTimeMillis();
        }
    }

    public void cleanUp() {
        this.trace("Cleaning up...");
        this.stopBGM(true);
        for (int i = 0; i < 4; ++i) {
            this.stopSFX(i, true);
        }
        this.save(false);
    }

    public void loadSounds() {
        if (this.supportsMixing) {
            for (int i = 0; i < 4; ++i) {
                this.sfx[i] = this.getSound(Utils.sfxFilename[i]);
            }
        }
    }

    public void vibrate(int n) {
        if (!this.vibrateEnabled) {
            return;
        }
        Display.getDisplay((MIDlet)this.parent).vibrate(n);
    }

    public void stopBGM() {
        this.stopBGM(false);
    }

    public void stopBGM(boolean bl) {
        if (this.bgm != null) {
            try {
                this.bgm.stop();
                this.bgm.deallocate();
                this.bgm.close();
                this.bgm = null;
            }
            catch (MediaException mediaException) {
                mediaException.printStackTrace();
            }
        }
    }

    public void playBGM(String string) {
        if (!this.musicEnabled) {
            return;
        }
        this.stopBGM();
        try {
            Object object;
            this.bgm = null;
            if (this.gameState == 3 || this.gameState == 9) {
                object = this.getClass().getResourceAsStream("/sounds/" + string + ".mid");
                this.bgm = Manager.createPlayer((InputStream)object, (String)"audio/midi");
            } else {
                object = "audio/amr";
                String string2 = ".amr";
                InputStream inputStream = this.getClass().getResourceAsStream("/sounds/ingame" + string2);
                this.bgm = Manager.createPlayer((InputStream)inputStream, (String)object);
            }
            if (this.bgm != null) {
                this.bgm.realize();
                this.bgm.prefetch();
                this.bgm.setLoopCount(-1);
                object = (VolumeControl)this.bgm.getControl("VolumeControl");
                if (object != null) {
                    object.setLevel(60);
                }
                this.bgm.start();
            }
        }
        catch (MediaException mediaException) {
            mediaException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            outOfMemoryError.printStackTrace();
        }
    }

    public Player getSound(String string) {
        Player player = null;
        try {
            String string2 = "audio/amr";
            String string3 = ".amr";
            if (this.supportsWAV) {
                string2 = "audio/x-wav";
                string3 = ".wav";
            }
            this.trace("Loading ".concat(string.concat(string3)));
            InputStream inputStream = this.getClass().getResourceAsStream("/sounds/".concat(string).concat(string3));
            player = Manager.createPlayer((InputStream)inputStream, (String)string2);
            player.realize();
            player.prefetch();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (MediaException mediaException) {
            mediaException.printStackTrace();
        }
        return player;
    }

    public void stopSFX() {
        if (this.sfx[0] != null) {
            try {
                this.sfx[0].stop();
                this.sfx[0].deallocate();
                this.sfx[0].close();
                this.sfx[0] = null;
            }
            catch (MediaException mediaException) {
                mediaException.printStackTrace();
            }
        }
    }

    public void playSFX(String string) {
        this.trace("Playing ".concat(string));
        if (!this.soundEnabled) {
            return;
        }
        this.stopSFX();
        try {
            String string2 = "audio/amr";
            String string3 = ".amr";
            if (this.supportsWAV) {
                string2 = "audio/x-wav";
                string3 = ".wav";
            }
            InputStream inputStream = this.getClass().getResourceAsStream("/sounds/".concat(string.concat(string3)));
            this.sfx[0] = Manager.createPlayer((InputStream)inputStream, (String)string2);
            this.sfx[0].realize();
            this.sfx[0].prefetch();
            this.sfx[0].start();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (MediaException mediaException) {
            mediaException.printStackTrace();
        }
    }

    public void stopSFX(int n) {
        this.stopSFX(n, false);
    }

    public void stopSFX(int n, boolean bl) {
        if (this.sfx[n] != null) {
            try {
                this.sfx[n].stop();
                if (bl) {
                    this.sfx[n].deallocate();
                    this.sfx[n].close();
                    this.sfx[n] = null;
                }
            }
            catch (MediaException mediaException) {
                mediaException.printStackTrace();
            }
        }
    }

    public void playSFX(int n) {
        if (!this.soundEnabled) {
            return;
        }
        if (this.supportsMixing) {
            try {
                if (this.sfx[n].getState() == 100) {
                    this.sfx[n].realize();
                }
                if (this.sfx[n].getState() == 200) {
                    this.sfx[n].prefetch();
                }
                if (this.sfx[n].getState() == 400) {
                    this.sfx[n].setMediaTime(0L);
                }
                this.sfx[n].start();
            }
            catch (NullPointerException nullPointerException) {
                nullPointerException.printStackTrace();
            }
            catch (MediaException mediaException) {
                mediaException.printStackTrace();
            }
        } else {
            this.playSFX(Utils.sfxFilename[n]);
        }
    }

    public void clearScreen(Graphics graphics, int n) {
        graphics.setColor(n);
        graphics.fillRect(0, 0, this.screenWidth, this.screenHeight);
    }

    public void clearScreen(Graphics graphics, int n, int n2, int n3) {
        graphics.setColor(n, n2, n3);
        graphics.fillRect(0, 0, this.screenWidth, this.screenHeight);
    }

    public void setState(byte by) {
        this.lastState = this.gameState;
        this.gameState = by;
        this.key = 0;
        this.touched = false;
    }

    public void drawVScrollBar(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n6 > 0 ? n6 : 1;
        int n8 = graphics.getColor();
        graphics.setColor(0xC0C0C0);
        graphics.fillRect(n, n2, n3, n4);
        graphics.setColor(0);
        graphics.fillRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
        graphics.setColor(0x808080);
        graphics.drawRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
        graphics.setColor(0xFAFAFA);
        graphics.drawRect(n, n2, n3, n4);
        graphics.setColor(0xC0C0C0);
        graphics.fillRect(n + 2, n2 + 2 + (n4 - 4) * n5 / n7, n3 - 4, (n4 - 4) / n7);
        graphics.setColor(n8);
    }

    public void drawSoftKeys(Graphics graphics, String string, String string2) {
        this.drawString(graphics, string, 0, this.screenHeight, 36);
        this.drawString(graphics, string2, this.screenWidth, this.screenHeight, 40);
    }

    public void drawSoftKeys(Graphics graphics, int n, int n2) {
        if (n != -1) {
            graphics.drawImage(this.imageLibrary[n], 0, this.screenHeight, 36);
        }
        if (n2 != -1) {
            graphics.drawImage(this.imageLibrary[n2], this.screenWidth, this.screenHeight, 40);
        }
    }

    public void resetVariables(Graphics graphics) {
        this.setState((byte)3);
        this.cur = 0;
        this.loopCounter = 0L;
        this.score = 0;
        this.time = System.currentTimeMillis();
        this.releaseKeys();
        this.imageLibrary[6] = null;
        System.gc();
        this.imageLibrary[62] = this.getImage("game/ground.png", true);
        this.imageLibrary[61] = this.getImage("game/hud.jpg", true);
        this.newGame();
    }

    public void confirmUpdate(Graphics graphics) {
        this.clearScreen(graphics, 0);
        graphics.drawImage(this.imageLibrary[3], this.screenWidthHalf, this.screenHeight, 33);
        graphics.setColor(0xFFFFFF);
        graphics.drawImage(this.imageLibrary[90], this.screenWidthHalf, this.screenHeightHalf, 33);
        this.drawSoftKeys(graphics, 9, 8);
        if (this.key == this.keys[0]) {
            this.setState((byte)2);
            this.key = 0;
        }
        if (this.key == this.keys[1]) {
            this.key = 0;
            this.cleanUp();
            this.parent.notifyDestroyed();
        }
    }

    public void askSoundUpdate(Graphics graphics) {
        graphics.drawImage(this.imageLibrary[3], this.screenWidthHalf, 0, 17);
        graphics.setColor(0xFFFFFF);
        this.drawString(graphics, "Enable Sound?", this.screenWidthHalf, this.screenHeightHalf, 17);
        this.drawSoftKeys(graphics, "Yes", "No");
        if (this.key == this.keys[0]) {
            this.soundEnabled = true;
            this.musicEnabled = true;
            this.setState((byte)2);
        }
        if (this.key == this.keys[1]) {
            this.soundEnabled = false;
            this.musicEnabled = false;
            this.setState((byte)2);
        }
        this.key = 0;
    }

    public void hiscoresUpdate(Graphics graphics) {
        int n = 30;
        int n2 = this.font.getHeight();
        n = this.screenHeightHalf - (this.hiscore.length * n2 >> 1);
        graphics.drawImage(this.imageLibrary[3], this.screenWidthHalf, 0, 17);
        graphics.setColor(0xFFFFFF);
        this.drawString(graphics, this.localized[3], this.screenWidthHalf - this.slideX, 0, 17);
        int n3 = this.font.stringWidth("00. 00000 - ABCDEF") >> 1;
        for (int i = 0; i < this.hiscore.length; ++i) {
            this.drawString(graphics, this.wrappedText[i], this.screenWidthHalf - n3 - this.slideX, i * n2 + n, 20);
        }
        this.drawSoftKeys(graphics, 9, -1);
        if (this.slideExiting) {
            if (this.slideX <= this.screenWidth) {
                if (this.slideVel < this.maxSlideVel) {
                    this.slideVel += this.slideAccel;
                }
                this.slideX += this.slideVel;
                if (this.slideX >= this.screenWidth) {
                    this.slideExiting = false;
                    this.slideVel = 0;
                    this.cur = 0;
                    this.setState((byte)2);
                }
            }
        } else if (this.slideX > 0) {
            if (this.slideVel > -this.maxSlideVel) {
                this.slideVel -= this.slideAccel;
            }
            this.slideX += this.slideVel;
            if (this.slideX <= 0) {
                this.slideX = 0;
                this.slideVel = 0;
            }
        } else if (this.key == this.keys[0] || this.bFire) {
            this.slideExiting = true;
            this.touched = false;
            this.key = 0;
        }
    }

    public void gameoverUpdate(Graphics graphics) {
        this.clearScreen(graphics, 0);
        graphics.drawImage(this.imageLibrary[3], this.screenWidthHalf, this.screenHeight, 33);
        graphics.drawImage(this.imageLibrary[91], this.screenWidthHalf, 0, 17);
        graphics.drawImage(this.imageLibrary[92], this.screenWidthHalf, this.screenHeightHalf, 33);
        String string = this.leadingZeroes(this.score, 5);
        int n = 4;
        this.drawNumbers(graphics, string, this.screenWidth - (string.length() << n) >> 1, this.screenHeightHalf);
        this.drawSoftKeys(graphics, 94, 85);
        if (this.key == this.keys[0]) {
            this.key = 0;
            this.live = 3;
            this.score = 0;
            this.setState((byte)3);
            this.initLevel();
        }
        if (this.key == this.keys[1] || this.bFire) {
            this.key = 0;
            this.touched = false;
            this.playBGM("sunny_morning");
            this.setState((byte)2);
            this.imageLibrary[62] = null;
            this.imageLibrary[61] = null;
            System.gc();
            this.imageLibrary[6] = this.getImage("title.png", true);
        }
    }

    public void instructionsUpdate(Graphics graphics) {
        int n = 0;
        int n2 = this.screenWidth * 10 / 100 - this.slideX;
        int n3 = this.screenHeight * 10 / 100;
        int n4 = this.screenWidth * 80 / 100;
        int n5 = this.screenHeight * 70 / 100;
        this.clearScreen(graphics, 0);
        graphics.drawImage(this.imageLibrary[3], this.screenWidthHalf, this.screenHeight, 33);
        graphics.setColor(0xFFFFFF);
        graphics.drawImage(this.imageLibrary[87], this.screenWidthHalf, 0, 17);
        graphics.setColor(0x3D3D3D);
        graphics.fillRoundRect(n2, n3, n4, n5, 32, 32);
        graphics.setColor(0xFFFFFF);
        graphics.drawRoundRect(n2, n3, n4, n5, 32, 32);
        n = this.wrappedText.length;
        int n6 = n5 / this.font.getHeight();
        int n7 = n6 + this.cur;
        if (n7 > n) {
            n7 = n;
        }
        if (this.wrappedText != null) {
            for (int i = this.cur; i < n7; ++i) {
                if (this.language == 0) {
                    this.drawString(graphics, this.wrappedText[i], n2 + n4 - 10, (i - this.cur) * this.font.getHeight() + n3 + 2, 24);
                    continue;
                }
                this.drawString(graphics, this.wrappedText[i], this.screenWidthHalf - this.slideX, (i - this.cur) * this.font.getHeight() + n3 + 2, 17);
            }
        }
        if (n > n6) {
            this.drawVScrollBar(graphics, n2 + n4, n3, 8, n5, this.cur, n - n6 + 1);
        }
        this.drawSoftKeys(graphics, 9, -1);
        if (this.hasPointerEvents()) {
            // empty if block
        }
        if (this.slideExiting) {
            if (this.slideX <= this.screenWidth) {
                if (this.slideVel < this.maxSlideVel) {
                    this.slideVel += this.slideAccel;
                }
                this.slideX += this.slideVel;
                if (this.slideX >= this.screenWidth) {
                    this.slideExiting = false;
                    this.slideVel = 0;
                    this.cur = 0;
                    this.setState((byte)2);
                }
            }
        } else if (this.slideX > 0) {
            if (this.slideVel > -this.maxSlideVel) {
                this.slideVel -= this.slideAccel;
            }
            this.slideX += this.slideVel;
            if (this.slideX <= 0) {
                this.slideX = 0;
                this.slideVel = 0;
            }
        } else {
            if (this.touched) {
                if (this.pointInRect(this.touchX, this.touchY, n2, n3, n4, n5)) {
                    if (this.touchDY > 0) {
                        this.bUp = true;
                    } else if (this.touchDY < 0) {
                        this.bDown = true;
                    }
                }
                this.touchDY = 0;
                this.touchDX = 0;
            }
            if (this.isPadHeld(2) || this.bUp) {
                if (this.cur > 0) {
                    --this.cur;
                }
            } else if ((this.isPadHeld(4) || this.bDown) && this.cur < n - n6) {
                ++this.cur;
            }
            if (this.key == this.keys[0] || this.bFire) {
                this.cur = 0;
                this.slideExiting = true;
                this.key = 0;
            }
        }
    }

    public void endingUpdate(Graphics graphics) {
        int n = 0;
        int n2 = this.screenWidth * 10 / 100 - this.slideX;
        int n3 = this.screenHeight * 10 / 100;
        int n4 = this.screenWidth * 80 / 100;
        int n5 = this.screenHeight * 70 / 100;
        graphics.drawImage(this.imageLibrary[3], this.screenWidthHalf, 0, 17);
        graphics.setColor(0xFFFFFF);
        this.drawAlphaRect(graphics, n2, n3, n4, n5, -1073741824);
        n = this.wrappedText.length;
        int n6 = n5 / this.font.getHeight();
        int n7 = n6 + this.cur;
        if (n7 > n) {
            n7 = n;
        }
        if (this.wrappedText != null) {
            for (int i = this.cur; i < n7; ++i) {
                if (this.language == 0) {
                    this.drawString(graphics, this.wrappedText[i], n2 + n4 - 10, (i - this.cur) * this.font.getHeight() + n3 + 2, 24);
                    continue;
                }
                this.drawString(graphics, this.wrappedText[i], this.screenWidthHalf - this.slideX, (i - this.cur) * this.font.getHeight() + n3 + 2, 17);
            }
        }
        if (n > n6) {
            this.drawVScrollBar(graphics, n2 + n4, n3, 8, n5, this.cur, n - n6 + 1);
        }
        this.drawSoftKeys(graphics, 9, -1);
        if (this.hasPointerEvents()) {
            // empty if block
        }
        if (this.slideExiting) {
            if (this.slideX <= this.screenWidth) {
                if (this.slideVel < this.maxSlideVel) {
                    this.slideVel += this.slideAccel;
                }
                this.slideX += this.slideVel;
                if (this.slideX >= this.screenWidth) {
                    this.slideExiting = false;
                    this.slideVel = 0;
                    this.cur = 0;
                    this.imageLibrary[3] = null;
                    System.gc();
                    this.imageLibrary[3] = this.getImage("bg.jpg", true);
                    if (this.isNewHiscore()) {
                        Display.getDisplay((MIDlet)this.parent).setCurrent((Displayable)this.textbox);
                    } else {
                        this.setState((byte)2);
                    }
                }
            }
        } else if (this.slideX > 0) {
            if (this.slideVel > -this.maxSlideVel) {
                this.slideVel -= this.slideAccel;
            }
            this.slideX += this.slideVel;
            if (this.slideX <= 0) {
                this.slideX = 0;
                this.slideVel = 0;
            }
        } else {
            if (this.touched) {
                if (this.pointInRect(this.touchX, this.touchY, n2, n3, n4, n5)) {
                    if (this.touchDY > 0) {
                        this.bUp = true;
                    } else if (this.touchDY < 0) {
                        this.bDown = true;
                    }
                }
                this.touchDY = 0;
                this.touchDX = 0;
            }
            if (this.isPadHeld(2) || this.bUp) {
                if (this.cur > 0) {
                    --this.cur;
                }
            } else if ((this.isPadHeld(4) || this.bDown) && this.cur < n - n6) {
                ++this.cur;
            }
            if (this.key == this.keys[0] || this.bFire) {
                this.cur = 0;
                this.slideExiting = true;
                this.key = 0;
            }
        }
    }

    public void aboutUpdate(Graphics graphics) {
        int n = 40;
        int n2 = (this.wrappedText.length - 1) * this.font.getHeight() + n;
        this.clearScreen(graphics, 0);
        graphics.drawImage(this.imageLibrary[3], this.screenWidthHalf, this.screenHeight, 33);
        graphics.setColor(0xFFFFFF);
        graphics.drawImage(this.imageLibrary[67], this.screenWidthHalf, 0, 17);
        int n3 = this.imageLibrary[0].getWidth();
        int n4 = this.imageLibrary[0].getHeight();
        int n5 = this.screenWidth * 10 / 100 - this.slideX;
        int n6 = this.screenHeight * 10 / 100;
        int n7 = this.screenWidth * 80 / 100;
        int n8 = this.screenHeight * 70 / 100;
        graphics.setColor(0x3D3D3D);
        graphics.fillRoundRect(n5, n6, n7, n8, 32, 32);
        graphics.setColor(0xFFFFFF);
        graphics.drawRoundRect(n5, n6, n7, n8, 32, 32);
        graphics.drawImage(this.imageLibrary[0], this.screenWidthHalf - this.slideX, n2, 17);
        graphics.drawImage(this.imageLibrary[7], this.screenWidthHalf - this.slideX, n2 += this.imageLibrary[0].getHeight(), 17);
        n2 += this.imageLibrary[7].getHeight();
        for (int i = 0; i < this.wrappedText.length; ++i) {
            this.drawString(graphics, this.wrappedText[i], this.screenWidthHalf - this.slideX, n + i * this.font.getHeight(), 17);
        }
        this.drawString(graphics, "\u00a9 All rights reserved", this.screenWidthHalf - this.slideX, n2, 17);
        this.drawSoftKeys(graphics, 9, -1);
        if (this.slideExiting) {
            if (this.slideX <= this.screenWidth) {
                if (this.slideVel < this.maxSlideVel) {
                    this.slideVel += this.slideAccel;
                }
                this.slideX += this.slideVel;
                if (this.slideX >= this.screenWidth) {
                    this.slideExiting = false;
                    this.slideVel = 0;
                    this.cur = 0;
                    this.setState((byte)5);
                }
            }
        } else if (this.slideX > 0) {
            if (this.slideVel > -this.maxSlideVel) {
                this.slideVel -= this.slideAccel;
            }
            this.slideX += this.slideVel;
            if (this.slideX <= 0) {
                this.slideX = 0;
                this.slideVel = 0;
            }
        } else if (this.key == this.keys[0] || this.bFire) {
            this.slideExiting = true;
            this.key = 0;
            this.touched = false;
        }
    }

    public void mainmenuUpdate(Graphics graphics) {
        int n;
        String[] stringArray = new String[]{this.localized[2], this.localized[4], this.localized[7]};
        int n2 = 140;
        int n3 = 37;
        this.clearScreen(graphics, 0);
        graphics.drawImage(this.imageLibrary[3], this.screenWidthHalf, this.screenHeight, 33);
        graphics.drawImage(this.imageLibrary[6], this.screenWidthHalf, 0, 17);
        graphics.setColor(0xFFFFFF);
        int n4 = this.imageLibrary[63].getHeight();
        int n5 = stringArray.length - 1;
        for (n = 0; n < n5; ++n) {
            graphics.drawImage(this.imageLibrary[this.mainCur == n ? 63 + n * 2 : 63 + (n * 2 + 1)], n % 2 == 0 ? this.screenWidthHalf - this.slideX : this.screenWidthHalf + this.slideX, n2 + n * n3, 17);
        }
        this.drawSoftKeys(graphics, 11, 12);
        if (this.slideExiting) {
            if (this.slideX <= this.screenWidth) {
                if (this.slideVel < this.maxSlideVel) {
                    this.slideVel += this.slideAccel;
                }
                this.slideX += this.slideVel;
                if (this.slideX >= this.screenWidth) {
                    this.slideExiting = false;
                    this.slideVel = 0;
                    n = this.screenWidth * 10 / 100;
                    int n6 = this.screenHeight * 10 / 100;
                    int n7 = this.screenWidth * 80 / 100;
                    int n8 = this.screenHeight * 80 / 100;
                    String string = null;
                    switch (this.mainCur) {
                        case 0: {
                            this.setState((byte)1);
                            this.cur = 0;
                            break;
                        }
                        case 1: {
                            this.setState((byte)5);
                            break;
                        }
                        case 2: {
                            this.mainCur = 0;
                            this.setState((byte)24);
                            break;
                        }
                        case 3: {
                            this.wrappedText = null;
                            string = this.language == 0 ? this.readUnicodeFile("/text/help_h.txt") : this.readUnicodeFile("/text/help.txt");
                            this.wrappedText = this.wrapTextSystemFont(graphics, this.font, string, n7 - 12, n8 - 16);
                            for (int i = 0; i < this.wrappedText.length; ++i) {
                                this.wrappedText[i] = this.arrangeString(this.wrappedText[i]);
                            }
                            string = null;
                            this.setState((byte)8);
                            this.mainCur = 0;
                        }
                    }
                }
            }
        } else if (this.slideX > 0) {
            if (this.slideVel > -this.maxSlideVel) {
                this.slideVel -= this.slideAccel;
            }
            this.slideX += this.slideVel;
            if (this.slideX <= 0) {
                this.slideX = 0;
                this.slideVel = 0;
            }
        } else {
            if (this.touched) {
                for (n = 0; n < n5; ++n) {
                    if (!this.pointInRect(this.touchX, this.touchY, this.screenWidthHalf - (this.imageLibrary[63].getWidth() >> 1), n2 + n * n3, this.imageLibrary[63].getWidth(), this.imageLibrary[63].getHeight())) continue;
                    if (n != this.mainCur) {
                        this.mainCur = n;
                    } else {
                        this.bFire = true;
                    }
                    this.touched = false;
                    break;
                }
            }
            if (this.bUp) {
                if (--this.mainCur < 0) {
                    this.mainCur = n5 - 1;
                }
            } else if (this.bDown && ++this.mainCur >= n5) {
                this.mainCur = 0;
            }
            if (this.key == this.keys[0]) {
                this.slideExiting = true;
                this.mainCur = n5;
                this.key = 0;
            }
            if (this.key == this.keys[1]) {
                this.slideExiting = true;
                this.mainCur = n5 + 1;
                this.key = 0;
            }
            if (this.bFire) {
                this.slideExiting = true;
                this.key = 0;
            }
        }
    }

    public void optionsUpdate(Graphics graphics) {
        int n;
        String[] stringArray = new String[5];
        stringArray[0] = this.localized[8] + " : " + (this.musicEnabled ? this.localized[11] : this.localized[12]);
        stringArray[1] = this.localized[9] + " : " + (this.soundEnabled ? this.localized[11] : this.localized[12]);
        stringArray[2] = this.localized[10] + " : " + (this.vibrateEnabled ? this.localized[11] : this.localized[12]);
        stringArray[3] = this.localized[6];
        int n2 = 40;
        int n3 = 38;
        n2 = this.screenHeight - stringArray.length * n3 >> 1;
        this.clearScreen(graphics, 0);
        graphics.drawImage(this.imageLibrary[3], this.screenWidthHalf, this.screenHeight, 33);
        graphics.setColor(0xFFFFFF);
        graphics.drawImage(this.imageLibrary[65], this.screenWidthHalf, 0, 17);
        graphics.setColor(0);
        int n4 = this.imageLibrary[63].getHeight();
        for (n = 0; n < stringArray.length; ++n) {
            int n5 = 0;
            n5 = n == 0 ? (this.musicEnabled ? 73 : 75) : (n == 1 ? (this.soundEnabled ? 77 : 79) : (n == 2 ? (this.vibrateEnabled ? 81 : 83) : (n == 3 ? 67 : 85)));
            n5 = this.cur == n ? n5 : n5 + 1;
            graphics.drawImage(this.imageLibrary[n5], n % 2 == 0 ? this.screenWidthHalf - this.slideX : this.screenWidthHalf + this.slideX, n2 + n * n3, 17);
        }
        this.drawSoftKeys(graphics, 9, 8);
        if (this.slideExiting) {
            if (this.slideX <= this.screenWidth) {
                if (this.slideVel < this.maxSlideVel) {
                    this.slideVel += this.slideAccel;
                }
                this.slideX += this.slideVel;
                if (this.slideX >= this.screenWidth) {
                    this.slideExiting = false;
                    this.slideVel = 0;
                    if (this.cur == 3) {
                        this.wrappedText = null;
                        String string = new String(this.getFile("/text/about.txt"));
                        this.wrappedText = this.wrapTextSystemFont(graphics, this.font, string, this.screenWidth, this.screenHeight);
                        string = null;
                        this.setState((byte)7);
                    } else {
                        this.setState((byte)2);
                    }
                    this.cur = 0;
                }
            }
        } else if (this.slideX > 0) {
            if (this.slideVel > -this.maxSlideVel) {
                this.slideVel -= this.slideAccel;
            }
            this.slideX += this.slideVel;
            if (this.slideX <= 0) {
                this.slideX = 0;
                this.slideVel = 0;
            }
        } else {
            if (this.touched) {
                for (n = 0; n < stringArray.length; ++n) {
                    if (!this.pointInRect(this.touchX, this.touchY, this.screenWidthHalf - (this.imageLibrary[63].getWidth() >> 1), n2 + n * n3, this.imageLibrary[63].getWidth(), this.imageLibrary[63].getHeight())) continue;
                    if (n != this.cur) {
                        this.cur = n;
                    } else {
                        this.bFire = true;
                    }
                    this.touched = false;
                    break;
                }
            }
            if (this.bUp) {
                --this.cur;
                if (this.cur < 0) {
                    this.cur = stringArray.length - 1;
                }
            } else if (this.bDown) {
                ++this.cur;
                if (this.cur >= stringArray.length) {
                    this.cur = 0;
                }
            }
            if (this.key == this.keys[0]) {
                this.slideExiting = true;
                this.cur = 0;
                this.key = 0;
            }
            if (this.key == this.keys[1] || this.bFire) {
                switch (this.cur) {
                    case 0: {
                        boolean bl = this.musicEnabled = !this.musicEnabled;
                        if (!this.musicEnabled) {
                            this.stopBGM();
                            break;
                        }
                        this.playBGM("sunny_morning");
                        break;
                    }
                    case 1: {
                        this.soundEnabled = !this.soundEnabled;
                        this.playSFX(1);
                        break;
                    }
                    case 2: {
                        this.vibrateEnabled = !this.vibrateEnabled;
                        this.vibrate(200);
                        break;
                    }
                    case 3: 
                    case 4: {
                        this.slideExiting = true;
                    }
                }
                this.key = 0;
            }
        }
    }

    public void pauseUpdate(Graphics graphics) {
        int n;
        String[] stringArray = new String[this.supportsMixing ? 5 : 4];
        if (this.supportsMixing) {
            if (this.language == 0) {
                stringArray[0] = "RESUME";
                stringArray[1] = (this.musicEnabled ? this.localized[11] : this.localized[12]) + " : " + this.localized[8];
                stringArray[2] = (this.soundEnabled ? this.localized[11] : this.localized[12]) + " : " + this.localized[9];
                stringArray[3] = (this.vibrateEnabled ? this.localized[11] : this.localized[12]) + " : " + this.localized[10];
                stringArray[4] = this.localized[7];
            } else {
                stringArray[0] = "RESUME";
                stringArray[1] = this.localized[8] + " : " + (this.musicEnabled ? this.localized[11] : this.localized[12]);
                stringArray[2] = this.localized[9] + " : " + (this.soundEnabled ? this.localized[11] : this.localized[12]);
                stringArray[3] = this.localized[10] + " : " + (this.vibrateEnabled ? this.localized[11] : this.localized[12]);
                stringArray[4] = this.localized[7];
            }
        } else if (this.language == 0) {
            stringArray[0] = "RESUME";
            stringArray[1] = (this.soundEnabled ? this.localized[11] : this.localized[12]) + " : " + this.localized[9];
            stringArray[2] = (this.vibrateEnabled ? this.localized[11] : this.localized[12]) + " : " + this.localized[10];
            stringArray[3] = this.localized[7];
        } else {
            stringArray[0] = "RESUME";
            stringArray[1] = this.localized[9] + " : " + (this.soundEnabled ? this.localized[11] : this.localized[12]);
            stringArray[2] = this.localized[10] + " : " + (this.vibrateEnabled ? this.localized[11] : this.localized[12]);
            stringArray[3] = this.localized[7];
        }
        int n2 = 40;
        int n3 = 38;
        n2 = this.screenHeight - stringArray.length * n3 >> 1;
        this.clearScreen(graphics, 0);
        graphics.drawImage(this.imageLibrary[3], this.screenWidthHalf, this.screenHeight, 33);
        graphics.setColor(0xFFFFFF);
        graphics.drawImage(this.imageLibrary[88], this.screenWidthHalf, 0, 17);
        graphics.setColor(0);
        int n4 = this.imageLibrary[63].getHeight();
        for (n = 0; n < stringArray.length; ++n) {
            int n5 = 0;
            if (this.supportsMixing) {
                if (n == 0) {
                    n5 = 71;
                } else if (n == 1) {
                    n5 = this.musicEnabled ? 73 : 75;
                } else if (n == 2) {
                    n5 = this.soundEnabled ? 77 : 79;
                } else if (n == 3) {
                    n5 = this.vibrateEnabled ? 81 : 83;
                } else if (n == 4) {
                    n5 = 69;
                }
            } else if (n == 0) {
                n5 = 71;
            } else if (n == 1) {
                n5 = this.soundEnabled ? 77 : 79;
            } else if (n == 2) {
                n5 = this.vibrateEnabled ? 81 : 83;
            } else if (n == 3) {
                n5 = 69;
            }
            n5 = this.cur == n ? n5 : n5 + 1;
            graphics.drawImage(this.imageLibrary[n5], n % 2 == 0 ? this.screenWidthHalf - this.slideX : this.screenWidthHalf + this.slideX, n2 + n * n3, 17);
        }
        this.drawSoftKeys(graphics, 9, 8);
        if (this.slideExiting) {
            if (this.slideX <= this.screenWidth) {
                if (this.slideVel < this.maxSlideVel) {
                    this.slideVel += this.slideAccel;
                }
                this.slideX += this.slideVel;
                if (this.slideX >= this.screenWidth) {
                    this.slideExiting = false;
                    this.slideVel = 0;
                    if (this.cur == stringArray.length - 1) {
                        this.imageLibrary[62] = null;
                        this.imageLibrary[61] = null;
                        System.gc();
                        this.imageLibrary[6] = this.getImage("title.png", true);
                        this.setState((byte)2);
                        this.playBGM("sunny_morning");
                    } else {
                        this.imageLibrary[3] = null;
                        System.gc();
                        this.trace("loading backdrop...");
                        this.imageLibrary[3] = this.getImage("game/bg" + this.level % 10 + ".jpg", true);
                        this.trace("backdrop loaded successfully.");
                        this.setState((byte)3);
                    }
                    this.cur = 0;
                    this.time += System.currentTimeMillis() - this.pauseTime;
                    this.powTime += System.currentTimeMillis() - this.pauseTime;
                    this.stopTime += System.currentTimeMillis() - this.pauseTime;
                    this.pumpTime += System.currentTimeMillis() - this.pauseTime;
                }
            }
        } else if (this.slideX > 0) {
            if (this.slideVel > -this.maxSlideVel) {
                this.slideVel -= this.slideAccel;
            }
            this.slideX += this.slideVel;
            if (this.slideX <= 0) {
                this.slideX = 0;
                this.slideVel = 0;
            }
        } else {
            if (this.touched) {
                for (n = 0; n < stringArray.length; ++n) {
                    if (!this.pointInRect(this.touchX, this.touchY, this.screenWidthHalf - (this.imageLibrary[63].getWidth() >> 1), n2 + n * n3, this.imageLibrary[63].getWidth(), this.imageLibrary[63].getHeight())) continue;
                    if (n != this.cur) {
                        this.cur = n;
                    } else {
                        this.bFire = true;
                    }
                    this.touched = false;
                    break;
                }
            }
            if (this.bUp) {
                --this.cur;
                if (this.cur < 0) {
                    this.cur = stringArray.length - 1;
                }
            } else if (this.bDown) {
                ++this.cur;
                if (this.cur >= stringArray.length) {
                    this.cur = 0;
                }
            }
            if (this.key == this.keys[0]) {
                this.slideExiting = true;
                this.cur = 0;
                this.key = 0;
            }
            if (this.key == this.keys[1] || this.bFire) {
                if (this.supportsMixing) {
                    switch (this.cur) {
                        case 1: {
                            boolean bl = this.musicEnabled = !this.musicEnabled;
                            if (!this.musicEnabled) {
                                this.stopBGM();
                                break;
                            }
                            this.playBGM("sunny_morning");
                            break;
                        }
                        case 2: {
                            this.soundEnabled = !this.soundEnabled;
                            this.playSFX(1);
                            break;
                        }
                        case 3: {
                            this.vibrateEnabled = !this.vibrateEnabled;
                            this.vibrate(200);
                            break;
                        }
                        case 0: 
                        case 4: {
                            this.slideExiting = true;
                        }
                    }
                } else {
                    switch (this.cur) {
                        case 1: {
                            this.soundEnabled = !this.soundEnabled;
                            this.playSFX(1);
                            break;
                        }
                        case 2: {
                            this.vibrateEnabled = !this.vibrateEnabled;
                            this.vibrate(200);
                            break;
                        }
                        case 0: 
                        case 3: {
                            this.slideExiting = true;
                        }
                    }
                }
                this.key = 0;
            }
        }
    }

    public void ingameUpdate(Graphics graphics) {
        ++this.loopCounter;
        if (this.slideExiting) {
            if (this.slideX <= this.screenWidth) {
                if (this.slideVel < this.maxSlideVel) {
                    this.slideVel += this.slideAccel;
                }
                this.slideX += this.slideVel;
                if (this.slideX >= this.screenWidth) {
                    this.slideExiting = false;
                    this.slideVel = 0;
                    this.cur = 0;
                    this.setState((byte)2);
                    for (int i = 0; i < 4; ++i) {
                        this.stopSFX(i);
                    }
                    this.playBGM("sunny_morning");
                }
            }
        } else if (this.slideX > 0) {
            if (this.slideVel > -this.maxSlideVel) {
                this.slideVel -= this.slideAccel;
            }
            this.slideX += this.slideVel;
            if (this.slideX <= 0) {
                this.slideX = 0;
                this.slideVel = 0;
            }
        } else {
            if (this.key == this.keys[1]) {
                this.imageLibrary[3] = null;
                System.gc();
                this.imageLibrary[3] = this.getImage("bg.jpg", true);
                this.setState((byte)9);
                this.pauseTime = System.currentTimeMillis();
                this.key = 0;
            }
            this.pangGameEngine(graphics);
            this.updateParticles(graphics);
        }
        this.drawSoftKeys(graphics, -1, 10);
    }

    public int getSec100(int n) {
        return n % 1000 / 10;
    }

    public int getSeconds(int n) {
        return n / 1000 % 60;
    }

    public int getMinutes(int n) {
        return n / 60000 % 60;
    }

    public int getHours(int n) {
        return this.getMinutes(n) / 60;
    }

    public boolean isNewHiscore() {
        for (int i = 0; i < 5; ++i) {
            if (this.score <= this.hiscore[i]) continue;
            return true;
        }
        return false;
    }

    public void load() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"gamedata", (boolean)true);
            if (recordStore.getNumRecords() > 0) {
                byte[] byArray = recordStore.getRecord(1);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                for (int i = 0; i < 5; ++i) {
                    this.bestPlayers[i] = dataInputStream.readUTF();
                    this.hiscore[i] = dataInputStream.readInt();
                }
                this.musicEnabled = dataInputStream.readBoolean();
                this.soundEnabled = dataInputStream.readBoolean();
                this.vibrateEnabled = dataInputStream.readBoolean();
                dataInputStream.close();
                byteArrayInputStream.close();
            } else {
                for (int i = 0; i < 5; ++i) {
                    this.bestPlayers[i] = "NAME" + i * 1;
                    this.hiscore[i] = 0;
                }
            }
            recordStore.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void save(boolean bl) {
        this.trace("Saving...");
        String string = this.textbox.getString();
        try {
            int n;
            RecordStore recordStore = RecordStore.openRecordStore((String)"gamedata", (boolean)true);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            if (bl) {
                for (n = 0; n < 5; ++n) {
                    if (this.score <= this.hiscore[n]) continue;
                    for (int i = 4; i > n; --i) {
                        this.hiscore[i] = this.hiscore[i - 1];
                        this.bestPlayers[i] = this.bestPlayers[i - 1];
                    }
                    this.bestPlayers[n] = string;
                    this.hiscore[n] = this.score;
                    break;
                }
            }
            for (n = 0; n < 5; ++n) {
                dataOutputStream.writeUTF(this.bestPlayers[n]);
                dataOutputStream.writeInt(this.hiscore[n]);
            }
            dataOutputStream.writeBoolean(this.musicEnabled);
            dataOutputStream.writeBoolean(this.soundEnabled);
            dataOutputStream.writeBoolean(this.vibrateEnabled);
            dataOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            if (recordStore.getNumRecords() > 0) {
                recordStore.setRecord(1, byArray, 0, byArray.length);
            } else {
                recordStore.addRecord(byArray, 0, byArray.length);
            }
            recordStore.closeRecordStore();
            byArray = null;
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public boolean detectUnicode() {
        boolean bl = true;
        InputStream inputStream = null;
        InputStreamReader inputStreamReader = null;
        try {
            inputStream = this.getClass().getResourceAsStream("/text/hebrew.txt");
            inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            this.trace("unicode supported");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            bl = false;
            this.trace("unicode not supported");
        }
        if (inputStreamReader != null) {
            try {
                inputStreamReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            inputStreamReader = null;
        } else if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            inputStream = null;
        }
        return bl;
    }

    public void autoDetectKeys() {
        int n;
        this.key = 0;
        this.keys = new int[7];
        for (n = 0; n < this.keys.length; ++n) {
            this.keys[n] = 0;
        }
        this.keys[0] = -6;
        this.keys[1] = -7;
        this.keys[2] = 1;
        this.keys[3] = 6;
        this.keys[4] = 2;
        this.keys[5] = 5;
        this.keys[6] = 8;
        for (n = -127; n < 127; ++n) {
            try {
                String string = this.getKeyName(n).toUpperCase();
                if (string.indexOf("SOFT") > -1 || string.indexOf("SELECTION") > -1 || string.indexOf("ACTION") > -1) {
                    if (string.indexOf("1") > -1 || string.indexOf("LEFT") > -1) {
                        this.keys[0] = n;
                    }
                    if (string.indexOf("2") > -1 || string.indexOf("RIGHT") > -1) {
                        this.keys[1] = n;
                    }
                }
                if (string.indexOf("UP") > -1) {
                    this.keys[2] = n;
                }
                if (string.indexOf("DOWN") > -1) {
                    this.keys[3] = n;
                }
                if (string.indexOf("LEFT") > -1) {
                    this.keys[4] = n;
                }
                if (string.indexOf("RIGHT") > -1) {
                    this.keys[5] = n;
                }
                if (string.indexOf("SELECT") <= -1 && string.indexOf("FIRE") <= -1 && string.indexOf("OK") <= -1) continue;
                this.keys[6] = n;
                continue;
            }
            catch (NullPointerException nullPointerException) {
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public GameScreen(Main main) {
        this.parent = main;
        this.setFullScreenMode(true);
        String string = this.parent.getAppProperty("Force176x220");
        if (string != null) {
            this.force176x220 = string.equals("true");
        }
        this.screenWidth = this.getWidth();
        this.screenHeight = this.getHeight();
        this.trace("Orig Screen: " + this.screenWidth + "x" + this.screenHeight);
        this.screenWidthHalf = this.screenWidth >> 1;
        this.screenHeightHalf = this.screenHeight >> 1;
        this.trace("Forced Screen: " + this.screenWidth + "x" + this.screenHeight);
        this.trace("Initializing variables...");
        this.setState((byte)0);
        this.splashPos[0] = this.screenWidth >> 1;
        this.splashPos[1] = -100;
        this.splashVel[0] = 0;
        this.splashVel[1] = 0;
        this.splashAction = 0;
        this.touchDY = 0;
        this.touchDX = 0;
        this.touchSY = 0;
        this.touchSX = 0;
        this.touchY = 0;
        this.touchX = 0;
        this.touched = false;
        this.musicEnabled = true;
        this.soundEnabled = true;
        this.vibrateEnabled = true;
        this.hiscore = new int[5];
        this.bestPlayers = new String[5];
        this.self = this;
        this.textbox.addCommand(new Command("Ok", 4, 1));
        this.textbox.setCommandListener(new CommandListener(){

            public void commandAction(Command command, Displayable displayable) {
                if (command.getCommandType() == 4) {
                    GameScreen.this.bSaving = true;
                    Display.getDisplay((MIDlet)GameScreen.this.parent).setCurrent((Displayable)GameScreen.this.self);
                }
            }
        });
        this.load();
        this.isUnicode = this.detectUnicode();
        this.language = this.isUnicode ? 0 : 1;
        this.autoDetectKeys();
        this.splashTimer = System.currentTimeMillis() + 2000L;
        this.bFire = false;
        this.bRight = false;
        this.bLeft = false;
        this.bDown = false;
        this.bUp = false;
        this.lastTime = System.currentTimeMillis();
        this.fontSmall = this.font = Font.getFont((int)64, (int)0, (int)0);
        this.fontBig = Font.getFont((int)64, (int)1, (int)16);
        String[] stringArray = Manager.getSupportedContentTypes(null);
        for (int i = 0; i < stringArray.length; ++i) {
            this.trace(stringArray[i]);
            if (stringArray[i].toLowerCase().indexOf("audio/midi") > -1) {
                this.supportsMID = true;
            }
            if (stringArray[i].toLowerCase().indexOf("audio/x-wav") > -1) {
                this.supportsWAV = true;
            }
            if (stringArray[i].toLowerCase().indexOf("audio/amr") <= -1) continue;
            this.supportsAMR = true;
        }
        String string2 = System.getProperty("supports.mixing");
        if (string2 != null && string2.toLowerCase().indexOf("true") > -1) {
            this.supportsMixing = true;
        }
        this.slideX = this.screenWidth;
        this.slideVel = 0;
        this.slideAccel = 1;
        this.maxSlideVel = 32;
        this.initParticles();
        this.isTouchScreen = this.hasPointerEvents();
        this.t.start();
    }

    public void sizeChanged(int n, int n2) {
        this.screenWidth = n;
        this.screenHeight = n2;
        this.screenWidthHalf = this.screenWidth >> 1;
        this.screenHeightHalf = this.screenHeight >> 1;
        this.trace("size changed " + n + "x" + n2);
    }

    public void hideNotify() {
        this.pause();
    }

    public void showNotify() {
        this.setFullScreenMode(true);
        this.screenWidth = this.getWidth();
        this.screenHeight = this.getHeight();
        this.screenWidthHalf = this.screenWidth >> 1;
        this.screenHeightHalf = this.screenHeight >> 1;
        this.key = 0;
        this.touched = false;
        this.bFire = false;
        this.bRight = false;
        this.bLeft = false;
        this.bDown = false;
        this.bUp = false;
        if (this.gameState != 0 && (this.supportsMixing || this.gameState != 3 && this.gameState != 9)) {
            this.playBGM("sunny_morning");
        }
        this.trace("shown");
    }

    public void paint(Graphics graphics) {
        graphics.setFont(this.font);
        graphics.setClip(0, 0, this.screenWidth, this.screenHeight);
        this.update(graphics);
        if (this.showDebug) {
            ++this.frames;
            if (System.currentTimeMillis() - this.lastTime >= 1000L) {
                this.lastTime = System.currentTimeMillis();
                this.fps = this.frames;
                this.frames = 0;
            }
            int n = graphics.getFont().getHeight();
            if (this.fps > 20) {
                graphics.setColor(65280);
            } else if (this.fps > 15) {
                graphics.setColor(0xFFFF00);
            } else {
                graphics.setColor(0xFF0000);
            }
            graphics.drawString("FPS: " + this.fps, this.screenWidth, this.screenHeight - n, 40);
        }
    }

    protected void keyPressed(int n) {
        this.key = n;
        int n2 = 0;
        try {
            n2 = this.getGameAction(n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (n == 50 || n2 == 1) {
            this.keyStates |= 2;
        }
        if (n == 56 || n2 == 6) {
            this.keyStates |= 4;
        }
        if (n == 52 || n2 == 2) {
            this.keyStates |= 8;
        }
        if (n == 54 || n2 == 5) {
            this.keyStates |= 0x10;
        }
        if (n == 53 || n2 == 8) {
            this.keyStates |= 0x20;
        }
    }

    protected void keyReleased(int n) {
        this.key = 0;
        int n2 = 0;
        try {
            n2 = this.getGameAction(n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (n == 50 || n2 == 1) {
            this.keyStates &= 0xFFFFFFFD;
        }
        if (n == 56 || n2 == 6) {
            this.keyStates &= 0xFFFFFFFB;
        }
        if (n == 52 || n2 == 2) {
            this.keyStates &= 0xFFFFFFF7;
        }
        if (n == 54 || n2 == 5) {
            this.keyStates &= 0xFFFFFFEF;
        }
        if (n == 53 || n2 == 8) {
            this.keyStates &= 0xFFFFFFDF;
        }
    }

    public void releaseKeys() {
        this.key = 0;
        this.keyStates = 0;
        this.touched = false;
    }

    public boolean isPadPressed(int n) {
        return (this.press & n) != 0;
    }

    public boolean isPadReleased(int n) {
        return (this.release & n) != 0;
    }

    public boolean isPadHeld(int n) {
        return (this.held & n) != 0;
    }

    public int getKeyStates() {
        return this.keyStates;
    }

    public void run() {
        this.tweet();
        block0: while (true) {
            int n;
            if (this.screenWidth > this.screenHeight) {
                if (this.gameState != 21 && this.gameState != 20) {
                    this.pause();
                    this.setState((byte)21);
                    this.pauseTime = System.currentTimeMillis();
                }
            } else if (this.gameState == 21) {
                this.setState(this.lastState);
                if (this.gameState == 0) {
                    this.splashPos[0] = this.screenWidthHalf;
                }
                if (this.gameState != 0 && (this.supportsMixing || this.gameState != 3 && this.gameState != 9)) {
                    this.playBGM("sunny_morning");
                }
            }
            long l = System.currentTimeMillis() + 30L;
            int n2 = this.getKeyStates();
            this.press = n2 & (n2 ^ this.held);
            this.release = this.held & (n2 ^ this.held);
            this.held = n2;
            this.bFire = false;
            this.bRight = false;
            this.bLeft = false;
            this.bDown = false;
            this.bUp = false;
            if (this.isPadPressed(8)) {
                this.bLeft = true;
                this.cheat = this.cheat == 4 || this.cheat == 6 ? ++this.cheat : 0;
            } else if (this.isPadPressed(16)) {
                this.bRight = true;
                this.cheat = this.cheat == 5 || this.cheat == 7 ? ++this.cheat : 0;
            }
            if (this.isPadPressed(2)) {
                this.bUp = true;
                this.cheat = this.cheat == 0 || this.cheat == 1 ? ++this.cheat : 0;
            } else if (this.isPadPressed(4)) {
                this.bDown = true;
                this.cheat = this.cheat == 2 || this.cheat == 3 ? ++this.cheat : 0;
            }
            if (this.cheat == 8) {
                this.showDebug = !this.showDebug;
                this.cheat = 0;
            }
            if (this.isPadPressed(32)) {
                this.bFire = true;
            }
            if (this.touched) {
                n = 99;
                int n3 = 36;
                if (this.gameState == 3) {
                    n = 36;
                    n3 = 36;
                }
                if (this.pointInRect(this.touchX, this.touchY, this.screenWidth - n, this.screenHeight - n3, n, n3)) {
                    this.key = this.keys[1];
                }
                if (this.pointInRect(this.touchX, this.touchY, 0, this.screenHeight - n3, n, n3)) {
                    this.key = this.keys[0];
                }
            }
            if (this.bSaving) {
                this.save(true);
                this.bSaving = false;
                this.wrappedText = null;
                this.wrappedText = new String[5];
                for (n = 0; n < this.wrappedText.length; ++n) {
                    this.wrappedText[n] = n + 1 + ". " + this.leadingZeroes(this.hiscore[n], 5) + " - " + this.arrangeString(this.bestPlayers[n]);
                }
                this.setState((byte)10);
            }
            this.repaint();
            while (true) {
                if (System.currentTimeMillis() >= l) continue block0;
                GameScreen gameScreen = this;
                gameScreen.t.yield();
            }
            break;
        }
    }

    public void update(Graphics graphics) {
        switch (this.gameState) {
            case 0: {
                this.splashUpdate(graphics);
                break;
            }
            case 19: {
                this.askSoundUpdate(graphics);
                break;
            }
            case 2: {
                this.mainmenuUpdate(graphics);
                break;
            }
            case 1: {
                this.resetVariables(graphics);
                break;
            }
            case 3: {
                this.ingameUpdate(graphics);
                break;
            }
            case 5: {
                this.optionsUpdate(graphics);
                break;
            }
            case 9: {
                this.pauseUpdate(graphics);
                break;
            }
            case 4: {
                this.gameoverUpdate(graphics);
                break;
            }
            case 8: {
                this.instructionsUpdate(graphics);
                break;
            }
            case 10: {
                this.hiscoresUpdate(graphics);
                break;
            }
            case 7: {
                this.aboutUpdate(graphics);
                break;
            }
            case 21: {
                this.unsupportedOrientationUpdate(graphics);
                break;
            }
            case 20: {
                this.standbyUpdate(graphics);
                break;
            }
            case 22: {
                this.moreGamesUpdate(graphics);
                break;
            }
            case 23: {
                this.endingUpdate(graphics);
                break;
            }
            case 24: {
                this.confirmUpdate(graphics);
            }
        }
    }

    protected void pointerPressed(int n, int n2) {
        this.touchX = this.touchSX = n;
        this.touchY = this.touchSY = n2;
        this.touched = true;
    }

    protected void pointerDragged(int n, int n2) {
        this.touchDX = n - this.touchX;
        this.touchDY = n2 - this.touchY;
        this.touchX = n;
        this.touchY = n2;
        this.trace("delta " + this.touchDX + ":" + this.touchDY);
    }

    protected void pointerReleased(int n, int n2) {
        this.touchX = this.touchSX = n;
        this.touchY = this.touchSY = n2;
        this.touched = false;
        this.releaseKeys();
    }

    public Image getImage(String string) {
        return this.getImage(string, false);
    }

    public Image getImage(String string, boolean bl) {
        Image image = null;
        String string2 = "/240x320/";
        string2 = "/240x320/";
        try {
            this.trace("Loading ".concat(string));
            image = Image.createImage((String)(bl ? string2 : "/").concat(string));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return image;
    }

    public void loadResources(Graphics graphics) {
        switch (this.counter) {
            case 0: {
                this.imageLibrary = new Image[95];
                this.imageLibrary[0] = this.getImage("paz_logo.png");
                this.imageLibrary[7] = this.getImage("cellulup_logo.png");
                this.imageLibrary[1] = this.getImage("font7x13smoothedgesb.png");
                this.imageLibrary[2] = this.getImage("font7x13smoothedges.png");
                break;
            }
            case 1: {
                this.imageLibrary[3] = this.getImage("bg.jpg", true);
                this.imageLibrary[8] = this.getImage("check.png", true);
                this.imageLibrary[9] = this.getImage("back.png", true);
                this.imageLibrary[10] = this.getImage("pause.png", true);
                this.imageLibrary[12] = this.getImage("help.png", true);
                this.imageLibrary[11] = this.getImage("exit.png", true);
                this.imageLibrary[6] = this.getImage("title.png", true);
                break;
            }
            case 2: {
                String[] stringArray = new String[]{"start", "options", "about", "quit", "resume", "bgm_on", "bgm_off", "sfx_on", "sfx_off", "vibe_on", "vibe_off", "back"};
                for (int i = 0; i < stringArray.length; ++i) {
                    this.imageLibrary[63 + i * 2] = this.getImage("menu/" + stringArray[i] + "_lit.png", true);
                    this.imageLibrary[63 + (i * 2 + 1)] = this.getImage("menu/" + stringArray[i] + ".png", true);
                }
                break;
            }
            case 3: {
                int n;
                this.imageLibrary[22] = this.getImage("game/life.png", true);
                this.imageLibrary[25] = this.getImage("game/score.png", true);
                this.imageLibrary[23] = this.getImage("game/live.png", true);
                this.imageLibrary[24] = this.getImage("game/time.png", true);
                this.imageLibrary[26] = this.getImage("game/level.png", true);
                this.imageLibrary[40] = this.getImage("game/devilwon.png", true);
                for (int i = 0; i < 10; ++i) {
                    this.imageLibrary[27 + i] = this.getImage("game/n" + i + ".png", true);
                }
                this.imageLibrary[37] = this.getImage("game/devilidle.png", true);
                this.imageLibrary[38] = this.getImage("game/devilwalk.png", true);
                this.imageLibrary[39] = this.getImage("game/devilhit.png", true);
                this.sprHero = new Sprite(this.imageLibrary[37]);
                this.sprHero.defineReferencePixel(this.sprHero.getWidth() >> 1, this.sprHero.getHeight() >> 1);
                this.layerMgr.append((Layer)this.sprHero);
                Image image = this.getImage("game/spear.png", true);
                for (n = 0; n < 2; ++n) {
                    this.sprSpear[n] = new Sprite(image);
                    this.sprSpear[n].defineReferencePixel(this.sprSpear[n].getWidth() >> 1, this.sprSpear[n].getHeight() >> 1);
                    this.layerMgr.append((Layer)this.sprSpear[n]);
                }
                for (n = 0; n < 4; ++n) {
                    this.imageLibrary[41 + n] = this.getImage("game/r" + n + ".png", true);
                    this.imageLibrary[45 + n] = this.getImage("game/g" + n + ".png", true);
                    this.imageLibrary[49 + n] = this.getImage("game/b" + n + ".png", true);
                    this.imageLibrary[53 + n] = this.getImage("game/y" + n + ".png", true);
                }
                this.imageLibrary[60] = this.getImage("game/balloonpop.png", true);
                for (n = 0; n < 16; ++n) {
                    this.sprPop[n] = new Sprite(this.imageLibrary[60], 16, 16);
                    this.sprPop[n].setVisible(false);
                    this.layerMgr.append((Layer)this.sprPop[n]);
                }
                this.imageLibrary[59] = this.getImage("game/pump.png", true);
                this.sprPump = new Sprite(this.imageLibrary[59]);
                this.layerMgr.append((Layer)this.sprPump);
                this.imageLibrary[57] = this.getImage("game/powerups.png", true);
                this.sprPow = new Sprite(this.imageLibrary[57], 16, 16);
                this.layerMgr.append((Layer)this.sprPow);
                this.imageLibrary[58] = this.getImage("game/bullets.png", true);
                for (n = 0; n < 3; ++n) {
                    this.sprBullet[n] = new Sprite(this.imageLibrary[58], 8, 16);
                    this.layerMgr.append((Layer)this.sprBullet[n]);
                }
                this.imageLibrary[89] = this.getImage("game/ready.png", true);
                this.imageLibrary[87] = this.getImage("game/help.png", true);
                this.imageLibrary[90] = this.getImage("game/reallyquit.png", true);
                this.imageLibrary[88] = this.getImage("game/paused.png", true);
                this.imageLibrary[91] = this.getImage("game/gameover.png", true);
                this.imageLibrary[92] = this.getImage("game/yourscore.png", true);
                this.imageLibrary[93] = this.getImage("game/bonus.png", true);
                this.imageLibrary[94] = this.getImage("continue.png", true);
                break;
            }
            case 4: {
                if (!this.isUnicode) break;
                this.bitmapFontBlack = this.generateBitmapFont(graphics, this.fontSmall, 0, "Black");
                this.bitmapFontWhite = this.generateBitmapFont(graphics, this.fontSmall, 0xFFFFFF, "White");
                this.bitmapFontBlue = this.generateBitmapFont(graphics, this.fontSmall, 255, "Blue");
                System.gc();
                break;
            }
            case 5: {
                this.loadSounds();
                this.playBGM("sunny_morning");
            }
        }
        ++this.counter;
    }

    public void splashUpdate(Graphics graphics) {
        if (this.counter == 0 || this.splashAction == 2 && this.counter < 6) {
            this.loadResources(graphics);
        }
        this.clearScreen(graphics, 0xFFFFFF);
        graphics.drawImage(this.imageLibrary[0], this.splashPos[0] - (this.imageLibrary[0].getWidth() >> 1), this.splashPos[1], 20);
        graphics.drawImage(this.imageLibrary[7], this.splashPos[0] - (this.imageLibrary[7].getWidth() >> 1), this.screenHeight - this.splashPos[1] - 30, 36);
        if (this.splashAction == 0) {
            if (this.splashVel[1] < 10) {
                this.splashVel[1] = this.splashVel[1] + 1;
            }
            this.splashPos[1] = this.splashPos[1] + this.splashVel[1];
            if (this.splashPos[1] >= this.screenHeight >> 1) {
                this.splashAction = 1;
            }
        } else if (this.splashAction == 1) {
            if (this.splashVel[1] > -10) {
                this.splashVel[1] = this.splashVel[1] - 1;
            }
            this.splashPos[1] = this.splashPos[1] + this.splashVel[1];
            if (this.splashPos[1] <= (this.screenHeight >> 1) - this.imageLibrary[0].getHeight()) {
                this.splashPos[1] = (this.screenHeight >> 1) - this.imageLibrary[0].getHeight();
                this.splashAction = (byte)2;
                this.splashTimer = System.currentTimeMillis() + 2000L;
            }
        } else if (this.splashAction == 2) {
            if (this.splashTimer < System.currentTimeMillis()) {
                if (this.splashVel[0] < 10) {
                    this.splashVel[0] = this.splashVel[0] + 1;
                }
                this.splashPos[0] = this.splashPos[0] + this.splashVel[0];
                if (this.splashPos[0] > this.screenWidth + (this.imageLibrary[7].getWidth() >> 1)) {
                    this.splashPos[0] = this.screenWidth;
                    if (this.counter >= 6) {
                        this.counter = 0;
                        this.setState((byte)2);
                        this.setState((byte)2);
                        this.language = 1;
                        this.loadStrings();
                    }
                }
            } else {
                graphics.setColor(10473995);
                graphics.fillRect((this.screenWidth >> 1) - 50, this.screenHeight - 26, 100 * this.counter / 6, 8);
                graphics.setColor(0);
                graphics.drawRect((this.screenWidth >> 1) - 50, this.screenHeight - 26, 100, 8);
                this.drawFontString(graphics, this.imageLibrary[1], "LOADING", this.screenWidth >> 1, this.screenHeight - 39, 17);
                this.drawFontString(graphics, this.imageLibrary[1], "\u00a9 All rights reserved", this.screenWidth >> 1, this.screenHeight - 13, 17);
            }
        }
    }

    public Image createThumbnail(Image image, int n, int n2) {
        int[] nArray = new int[image.getWidth() * image.getHeight()];
        image.getRGB(nArray, 0, image.getWidth(), 0, 0, image.getWidth(), image.getHeight());
        int[] nArray2 = this.rescaleArray(nArray, image.getWidth(), image.getHeight(), n, n2);
        Image image2 = Image.createRGBImage((int[])nArray2, (int)n, (int)n2, (boolean)true);
        return image2;
    }

    public int[] rescaleArray(int[] nArray, int n, int n2, int n3, int n4) {
        int[] nArray2 = new int[n3 * n4];
        for (int i = 0; i < n4; ++i) {
            int n5 = i * n2 / n4;
            for (int j = 0; j < n3; ++j) {
                int n6 = j * n / n3;
                nArray2[n3 * i + j] = nArray[n * n5 + n6];
            }
        }
        return nArray2;
    }

    public boolean pointInRect(int n, int n2, int n3, int n4, int n5, int n6) {
        return n >= n3 && n <= n3 + n5 && n2 >= n4 && n2 <= n4 + n6;
    }

    public int drawWrappedText(Graphics graphics, Image image, String string, int n, int n2, int n3, int n4, int n5, int n6) {
        String string2 = "";
        int n7 = n5 / 13;
        int n8 = 0;
        boolean bl = false;
        while (!bl) {
            String string3;
            int n9 = string.indexOf("\n");
            int n10 = string.indexOf(" ");
            if (n9 > -1 && (n10 == -1 || n9 < n10)) {
                n10 = n9;
            }
            if (n10 > -1) {
                string3 = string.substring(0, n10 + 1);
                while (7 * string3.length() > n4) {
                    string3 = string.substring(0, --n10 + 1);
                }
                string = string.substring(n10 + 1);
            } else {
                string3 = string;
                bl = true;
            }
            if (7 * (string2 + string3).length() <= n4) {
                string2 = string2 + string3;
            } else {
                if (n8 >= n && n8 <= n7 + n) {
                    this.drawFontString(graphics, image, string2, n2, (n8 - n) * 13 + n3, n6);
                }
                ++n8;
                string2 = string3;
            }
            if (n10 > -1 && n10 == n9) {
                if (n8 >= n && n8 <= n7 + n) {
                    this.drawFontString(graphics, image, string2, n2, (n8 - n) * 13 + n3, n6);
                }
                string2 = "";
                ++n8;
                continue;
            }
            if (!bl || n8 < n || n8 > n7 + n) continue;
            this.drawFontString(graphics, image, string2, n2, (n8 - n) * 13 + n3, n6);
        }
        return n8;
    }

    public int drawWrappedText(Graphics graphics, String string, int n, int n2, int n3, int n4, int n5, int n6) {
        String string2 = "";
        int n7 = n5 / this.font.getHeight();
        int n8 = 0;
        boolean bl = false;
        while (!bl) {
            String string3;
            int n9 = string.indexOf("\n");
            int n10 = string.indexOf(" ");
            if (n9 > -1 && (n10 == -1 || n9 < n10)) {
                n10 = n9;
            }
            if (n10 > -1) {
                string3 = string.substring(0, n10 + 1);
                while (this.font.stringWidth(string3) > n4) {
                    string3 = string.substring(0, --n10 + 1);
                }
                string = string.substring(n10 + 1);
            } else {
                string3 = string;
                bl = true;
            }
            if (this.font.stringWidth(string2 + string3) <= n4) {
                string2 = string2 + string3;
            } else {
                if (n8 >= n && n8 <= n7 + n) {
                    this.drawString(graphics, string2, n2, (n8 - n) * this.font.getHeight() + n3, n6);
                }
                ++n8;
                string2 = string3;
            }
            if (n10 > -1 && n10 == n9) {
                if (n8 >= n && n8 <= n7 + n) {
                    this.drawString(graphics, string2, n2, (n8 - n) * this.font.getHeight() + n3, n6);
                }
                string2 = "";
                ++n8;
                continue;
            }
            if (!bl || n8 < n || n8 > n7 + n) continue;
            this.drawString(graphics, string2, n2, (n8 - n) * this.font.getHeight() + n3, n6);
        }
        return n8;
    }

    public byte getIndex(char c) {
        for (byte by = 0; by < Utils.hebrewChars.length; by = (byte)(by + 1)) {
            if (c != Utils.hebrewChars[by]) continue;
            return by;
        }
        return 0;
    }

    public void drawString(Graphics graphics, String string, int n, int n2, int n3) {
        char c;
        int n4;
        int n5 = 0;
        int n6 = this.fontSmall.stringWidth(string);
        int n7 = this.fontSmall.getHeight();
        int n8 = 0;
        for (int i = 0; i < string.length(); ++i) {
            n4 = string.charAt(i);
            if (n4 == 10 || n4 == 13) continue;
            if (n4 >= 1456 && n4 <= 1524) {
                c = this.getIndex((char)n4);
                n8 += this.bitmapFontBlack[c].getWidth();
                continue;
            }
            if (n4 < 32 || n4 > 122) continue;
            c = Utils.hebrewChars.length + (n4 - 32);
            n8 += this.bitmapFontBlack[c].getWidth();
        }
        n6 = n8;
        n7 = this.bitmapFontBlack[0].getHeight();
        if ((n3 & 1) != 0) {
            n -= n6 >> 1;
        } else if ((n3 & 8) != 0) {
            n -= n6;
        }
        if ((n3 & 2) != 0) {
            n2 -= n7 >> 1;
        } else if ((n3 & 0x20) != 0) {
            n2 -= n7;
        }
        Image[] imageArray = null;
        imageArray = graphics.getColor() == 0 ? this.bitmapFontBlack : (graphics.getColor() == 0xFFFFFF ? this.bitmapFontWhite : this.bitmapFontBlue);
        for (n4 = 0; n4 < string.length(); ++n4) {
            int n9;
            c = string.charAt(n4);
            if (c == '\n' || c == '\r') continue;
            if (c >= '\u05b0' && c <= '\u05f4') {
                n9 = this.getIndex(c);
                graphics.drawImage(imageArray[n9], n5 + n, n2, 20);
                n5 += this.bitmapFontBlack[n9].getWidth();
                continue;
            }
            if (c < ' ' || c > 'z') continue;
            n9 = Utils.hebrewChars.length + (c - 32);
            graphics.drawImage(imageArray[n9], n5 + n, n2, 20);
            n5 += this.bitmapFontBlack[n9].getWidth();
        }
    }

    public Image[] generateBitmapFont(Graphics graphics, Font font, int n, String string) {
        Graphics graphics2;
        int n2;
        Object object;
        int n3;
        int n4;
        Vector<Object> vector = new Vector<Object>();
        this.trace("Generating ".concat(string).concat(" bitmap font, please wait..."));
        for (n4 = 0; n4 < Utils.hebrewChars.length; n4 = (int)((char)(n4 + 1))) {
            n3 = font.charWidth(Utils.hebrewChars[n4]);
            int c = font.getHeight();
            if (n3 <= 0) {
                n3 = 1;
            }
            Image image = Image.createImage((int)n3, (int)c);
            Graphics graphics3 = image.getGraphics();
            graphics3.setColor(0xFF00FF);
            graphics3.fillRect(0, 0, n3, c);
            graphics3.setColor(n);
            graphics3.setFont(font);
            graphics3.drawChar(Utils.hebrewChars[n4], n3 >> 1, 0, 17);
            object = new int[n3 * c];
            image.getRGB((int[])object, 0, n3, 0, 0, n3, c);
            for (int i = 0; i < n3 * c; ++i) {
                int n5 = object[i] >> 16 & 0xFF;
                int n6 = object[i] >> 8 & 0xFF;
                n2 = object[i] & 0xFF;
                if (n5 <= 128 || n6 >= 128 || n2 <= 128) continue;
                object[i] = (Image)false;
            }
            graphics2 = Image.createRGBImage((int[])object, (int)n3, (int)c, (boolean)true);
            vector.addElement(graphics2);
        }
        n4 = 91;
        this.trace("last char " + n4);
        for (n3 = 0; n3 < n4; n3 = (int)((char)(n3 + 1))) {
            char c = (char)(32 + n3);
            int n7 = font.charWidth(c);
            int n8 = font.getHeight();
            if (n7 <= 0) {
                n7 = 1;
            }
            if (c == 'f' || c == 'g' || c == 'j' || c == 'p' || c == 'q' || c == 'y') {
                n8 += n8 >> 1;
            }
            object = Image.createImage((int)n7, (int)n8);
            graphics2 = object.getGraphics();
            graphics2.setColor(0xFF00FF);
            graphics2.fillRect(0, 0, n7, n8);
            graphics2.setColor(n);
            graphics2.setFont(font);
            graphics2.drawChar(c, n7 >> 1, 0, 17);
            int[] nArray = new int[n7 * n8];
            object.getRGB(nArray, 0, n7, 0, 0, n7, n8);
            for (int i = 0; i < n7 * n8; ++i) {
                n2 = nArray[i] >> 16 & 0xFF;
                int n9 = nArray[i] >> 8 & 0xFF;
                int n10 = nArray[i] & 0xFF;
                if (n2 <= 128 || n9 >= 128 || n10 <= 128) continue;
                nArray[i] = 0;
            }
            Image image = Image.createRGBImage((int[])nArray, (int)n7, (int)n8, (boolean)true);
            vector.addElement(image);
        }
        this.trace("Total chars: " + vector.size());
        Image[] imageArray = new Image[vector.size()];
        boolean bl = false;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            imageArray[++var8_12] = (Image)enumeration.nextElement();
        }
        return imageArray;
    }

    public String arrangeString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = string.length() - 1; i >= 0; --i) {
            char c = string.charAt(i);
            if (c < '\u05b0') {
                int n;
                int n2 = i;
                for (n = i; n >= 0 && string.charAt(n) < '\u05b0'; --n) {
                }
                for (int j = ++n; j <= n2; ++j) {
                    stringBuffer.append(string.charAt(j));
                }
                i = n;
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public String readUnicodeFile(String string) {
        StringBuffer stringBuffer = null;
        InputStream inputStream = null;
        try {
            int n;
            Class<?> clazz = this.getClass();
            inputStream = clazz.getResourceAsStream(string);
            if (inputStream == null) {
                throw new Exception("File Does Not Exist");
            }
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            stringBuffer = new StringBuffer();
            while ((n = inputStreamReader.read()) > -1) {
                stringBuffer.append((char)n);
            }
            if (inputStreamReader != null) {
                inputStreamReader.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringBuffer.toString().trim();
    }

    public String[] readUnicodeFiles(String string, boolean bl) {
        int n;
        Object object;
        String[] stringArray;
        Vector<String> vector = new Vector<String>();
        StringBuffer stringBuffer = null;
        InputStream inputStream = null;
        try {
            stringArray = this.getClass();
            inputStream = stringArray.getResourceAsStream(string);
            if (inputStream == null) {
                throw new Exception("File Does Not Exist");
            }
            object = new InputStreamReader(inputStream, "UTF-8");
            stringBuffer = new StringBuffer();
            while ((n = ((InputStreamReader)object).read()) > -1) {
                if (n == 13) continue;
                if (n != 10) {
                    if (n == 124) {
                        stringBuffer.append('\n');
                        continue;
                    }
                    stringBuffer.append((char)n);
                    continue;
                }
                vector.addElement(stringBuffer.toString());
                stringBuffer.delete(0, stringBuffer.length());
            }
            vector.addElement(stringBuffer.toString());
            stringBuffer.delete(0, stringBuffer.length());
            if (object != null) {
                ((InputStreamReader)object).close();
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
        }
        stringArray = new String[vector.size()];
        object = vector.elements();
        n = 0;
        while (object.hasMoreElements()) {
            if (bl) {
                stringArray[n++] = this.arrangeString((String)object.nextElement()).trim();
                continue;
            }
            stringArray[n++] = ((String)object.nextElement()).trim();
        }
        return stringArray;
    }

    public int[] createARGBRect(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        int[] nArray = new int[n3 * n4];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = n5 | n6;
        }
        return nArray;
    }

    public void drawAlphaRect(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        int[] nArray = new int[n3 * n4];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = n5 | n6;
        }
        graphics.drawRGB(nArray, 0, n3, n, n2, n3, n4, true);
        nArray = null;
    }

    public void drawAlphaRect(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int[] nArray = new int[n3 * n4];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = n5;
        }
        graphics.drawRGB(nArray, 0, n3, n, n2, n3, n4, true);
        nArray = null;
    }

    public void drawWireRect(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        graphics.setColor(n5);
        for (int i = n2; i < n4; ++i) {
            for (int j = n; j < n3; ++j) {
                graphics.fillRect((j << 1) + (i % 2 == 0 ? 1 : 0), i, 1, 1);
            }
        }
    }

    public Image makeTranslucent(Image image, int n) {
        int[] nArray = new int[image.getWidth() * image.getHeight()];
        image.getRGB(nArray, 0, image.getWidth(), 0, 0, image.getWidth(), image.getHeight());
        for (int i = 0; i < nArray.length; ++i) {
            if ((nArray[i] & 0xFF000000) == 0) continue;
            nArray[i] = nArray[i] & 0xFFFFFF | Integer.MIN_VALUE;
        }
        return Image.createRGBImage((int[])nArray, (int)image.getWidth(), (int)image.getHeight(), (boolean)true);
    }

    public int getRed(int n) {
        return n >> 16 & 0xFF;
    }

    public int getGreen(int n) {
        return n >> 8 & 0xFF;
    }

    public int getBlue(int n) {
        return n & 0xFF;
    }

    public void loadStrings() {
        this.localized = this.language == 0 ? this.readUnicodeFiles("/text/hebrew.txt", true) : this.readUnicodeFiles("/text/english.txt", true);
    }

    public void drawTriangle(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.drawLine(n, n2, n3, n4);
        graphics.drawLine(n3, n4, n5, n6);
        graphics.drawLine(n, n2, n5, n6);
    }

    public Image generateTextInfoAsImage(String[] stringArray, int n, int n2) {
        Image image = Image.createImage((int)n, (int)n2);
        Graphics graphics = image.getGraphics();
        graphics.setColor(0xFF00FF);
        graphics.fillRect(0, 0, n, n2);
        graphics.setColor(255);
        graphics.setFont(this.font);
        for (int i = 0; i < stringArray.length; ++i) {
            this.drawString(graphics, stringArray[this.language == 0 ? stringArray.length - 1 - i : i], n >> 1, i * (this.font.getHeight() + 1) + 0, 17);
        }
        int[] nArray = new int[n * n2];
        image.getRGB(nArray, 0, n, 0, 0, n, n2);
        for (int i = 0; i < n * n2; ++i) {
            int n3 = nArray[i] >> 16 & 0xFF;
            int n4 = nArray[i] >> 8 & 0xFF;
            int n5 = nArray[i] & 0xFF;
            if (n3 <= 128 || n4 >= 128 || n5 <= 128) continue;
            nArray[i] = stringArray[0].length() > 0 ? 0x40FFFFFF : 0;
        }
        Image image2 = Image.createRGBImage((int[])nArray, (int)n, (int)n2, (boolean)true);
        return image2;
    }

    public void drawTextInfo(Graphics graphics, String[] stringArray, int n, int n2, int n3, int n4) {
        this.drawAlphaRect(graphics, 0, 0, n3, n4, 0x40FFFFFF);
        graphics.setFont(this.fontSmall);
        int n5 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            graphics.setColor(0);
            this.drawString(graphics, stringArray[this.language == 0 ? stringArray.length - 1 - i : i], (n3 >> 1) + n, n5 + n2, 17);
            n5 += this.font.getHeight() + 1;
        }
        graphics.setFont(this.font);
    }

    public void moreGamesUpdate(Graphics graphics) {
        String[] stringArray = new String[]{"My Tic Tac Toe", "My Checkers"};
        int n = 30;
        int n2 = 160;
        graphics.drawImage(this.imageLibrary[3], 0, 0, 20);
        graphics.setColor(0xFFFFFF);
        graphics.drawString("More Games", this.screenWidth >> 1, 0, 17);
        for (int i = 0; i < 2; ++i) {
            graphics.drawImage(this.imageLibrary[19 + i], this.screenWidth >> 1, i * n2 + this.igpY, 17);
            graphics.drawString(stringArray[i], this.screenWidth >> 1, i * n2 + this.igpY + 128, 17);
        }
        this.drawSoftKeys(graphics, 9, -1);
        if (this.bUp) {
            if (this.igpY < n) {
                this.igpY += 16;
            }
        } else if (this.bDown && this.igpY > 2 * n2 + n) {
            this.igpY -= 16;
        }
        if (this.key == this.keys[0] || this.bFire) {
            this.setState((byte)2);
            this.key = 0;
        }
    }

    private boolean useBlack() {
        boolean bl = false;
        switch (this.level) {
            case 0: 
            case 3: 
            case 5: 
            case 9: 
            case 10: {
                bl = true;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                bl = false;
            }
        }
        return bl;
    }

    private void initExplosion(int n, int n2, int n3) {
        this.spawnParticles(n, n2, n3);
        for (int i = 0; i < 16; ++i) {
            if (this.sprPop[i].isVisible()) continue;
            this.sprPop[i].setPosition(n, n2);
            this.sprPop[i].setVisible(true);
            this.sprPop[i].setFrame(0);
            break;
        }
    }

    private void updateExplosion() {
        for (int i = 0; i < 16; ++i) {
            if (!this.sprPop[i].isVisible()) continue;
            this.sprPop[i].nextFrame();
            if (this.sprPop[i].getFrame() != 0) continue;
            this.sprPop[i].setVisible(false);
        }
    }

    private void initLevel() {
        int n;
        long[] lArray;
        this.transRect = 0;
        this.victoryX = this.screenWidth;
        this.gameTime = this.maxTime = lArray[this.level < (lArray = new long[]{500L, 1000L, 1500L, 2000L, 2500L, 3000L, 3500L, 4000L, 4500L, 5000L}).length ? this.level : lArray.length - 1];
        this.imageLibrary[3] = null;
        System.gc();
        this.trace("loading backdrop...");
        this.imageLibrary[3] = this.getImage("game/bg" + this.level % 10 + ".jpg", true);
        this.trace("backdrop loaded successfully.");
        this.sprHero.setImage(this.imageLibrary[37], 48, 48);
        this.sprHero.setPosition(this.screenWidth - this.imageLibrary[37].getWidth() >> 1, this.ground - this.sprHero.getHeight());
        for (n = 0; n < 2; ++n) {
            this.sprSpear[n].setVisible(false);
        }
        for (n = 0; n < 3; ++n) {
            this.sprBullet[n].setVisible(false);
        }
        this.bulletActive = false;
        for (n = 0; n < 16; ++n) {
            this.balloonSize[n] = -1;
            if (this.sprBalloons[n] != null) {
                this.sprBalloons[n].setVisible(false);
            }
            this.sprPop[n].setVisible(false);
        }
        this.powTime = 0L;
        this.powType = 0;
        this.weapon = 0;
        this.stopTime = 0L;
        this.sprPow.setVisible(false);
        this.numSpears = 0;
        this.pumpTime = 0L;
        this.transRectIn = this.screenHeight * 15 / 100;
        this.stuck = false;
        this.sprPump.setVisible(false);
        this.shield = false;
        this.tempInvincibility = 0;
        if (this.bonusStage) {
            this.numBalls = 8;
            for (n = 0; n < this.numBalls; ++n) {
                this.spawnBall(this.random(this.screenWidth * 8 / 10) + this.screenWidth / 10, this.random(this.ground * 2 / 10) + this.ground * 3 / 10, this.random(4), n % 2);
            }
            this.gameTime = this.maxTime >>= 1;
        } else {
            this.numBalls = BALLOON_COUNT[this.level].length;
            for (n = 0; n < this.numBalls; ++n) {
                this.spawnBall(this.random(this.screenWidth), this.ground * 15 / 100, BALLOON_COUNT[this.level][n], n % 2);
            }
        }
        if (!this.supportsMixing) {
            this.stopBGM();
        } else {
            this.playBGM("sunny_morning");
        }
        for (n = 0; n < 64; ++n) {
            this.pclActive[n] = false;
        }
    }

    private void newGame() {
        this.heroAnim = 0;
        this.live = 3;
        this.score = 0;
        this.nextBonus = 5000;
        this.level = 0;
        this.bonusStage = false;
        this.ground = this.screenHeight - 88;
        this.hudY = this.ground + 8;
        this.initLevel();
    }

    private void spawnBall(int n, int n2, int n3, int n4) {
        int[] nArray = new int[]{16, 24, 32, 40};
        for (int i = 0; i < 16; ++i) {
            if (this.balloonSize[i] >= 0) continue;
            this.balloonVelX[i] = 0;
            this.balloonVelY[i] = 0;
            this.balloonSize[i] = n3;
            this.balloonColor[i] = this.random(4);
            this.balloonVertDir[i] = 0;
            this.balloonHorizDir[i] = n4;
            this.balloonBounce[i] = 0;
            this.sprBalloons[i] = null;
            this.sprBalloons[i] = new Sprite(this.imageLibrary[41 + this.balloonSize[i] + this.balloonColor[i] * 4], nArray[this.balloonSize[i]], nArray[this.balloonSize[i]]);
            this.sprBalloons[i].setPosition(n, n2);
            this.sprBalloons[i].setVisible(true);
            this.layerMgr.append((Layer)this.sprBalloons[i]);
            break;
        }
    }

    public void drawNumbers(Graphics graphics, String string, int n, int n2) {
        int n3 = 4;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) < '0' || string.charAt(i) > '9') continue;
            graphics.drawImage(this.imageLibrary[27 + (string.charAt(i) - 48)], n + (i << n3) - i * 4, n2, 20);
        }
    }

    private void addScore(int n) {
        this.score += n;
        if (this.score >= this.nextBonus) {
            if (this.live < 3) {
                ++this.live;
            }
            this.nextBonus += 5000;
        }
    }

    private void transition(Graphics graphics) {
        graphics.setColor(0);
        graphics.fillRect(0, 0, this.screenWidth, this.transRect);
        graphics.fillRect(0, this.screenHeight - this.transRect, this.screenWidth, this.transRect);
        if (this.transRect < this.screenHeight * 15 / 100) {
            this.transRect += 2;
        } else if (this.victoryX > this.screenWidth - this.imageLibrary[40].getWidth()) {
            this.victoryX -= 8;
            graphics.drawImage(this.imageLibrary[40], this.victoryX, this.screenHeight - this.transRect, 36);
            this.splashTimer = System.currentTimeMillis() + 2000L;
        } else {
            graphics.drawImage(this.imageLibrary[40], this.victoryX, this.screenHeight - this.transRect, 36);
            graphics.setColor(0xFFFFFF);
            if (this.splashTimer < System.currentTimeMillis()) {
                if (this.level > 0 && (this.level + 1) % 5 == 0 && !this.bonusStage) {
                    this.bonusStage = true;
                } else {
                    this.bonusStage = false;
                    ++this.level;
                    if (this.level >= BALLOON_COUNT.length) {
                        this.level = 0;
                    }
                }
                this.initLevel();
                this.key = 0;
            }
        }
    }

    public void pangGameEngine(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.transRectIn > 0) {
            this.transRectIn -= 2;
        } else {
            if (this.loopCounter % 2L == 0L) {
                this.updateExplosion();
            }
            if (this.heroAnim != 2) {
                if (this.numBalls > 0) {
                    if ((this.isPadHeld(8) || this.touched && this.touchX < this.sprHero.getX()) && this.sprHero.getX() > 0) {
                        this.sprHero.move(-this.heroMoveSpeed, 0);
                        this.sprHero.setTransform(2);
                        if (this.heroAnim != 1) {
                            this.sprHero.setImage(this.imageLibrary[38], 48, 48);
                            this.heroAnim = 1;
                        }
                    } else if ((this.isPadHeld(16) || this.touched && this.touchX > this.sprHero.getX() + this.sprHero.getWidth()) && this.sprHero.getX() < this.screenWidth - this.sprHero.getWidth()) {
                        this.sprHero.move(this.heroMoveSpeed, 0);
                        this.sprHero.setTransform(0);
                        if (this.heroAnim != 1) {
                            this.sprHero.setImage(this.imageLibrary[38], 48, 48);
                            this.heroAnim = 1;
                        }
                    } else if (this.isPadPressed(32) || this.touched && this.isPointInRect(this.touchX, this.touchY, this.sprHero.getX(), this.sprHero.getY(), this.sprHero.getWidth(), this.sprHero.getHeight())) {
                        if (this.weapon == 0 || this.weapon == 3) {
                            for (n4 = 0; n4 < 2; ++n4) {
                                if (this.sprSpear[n4].isVisible() || (this.numSpears >= 1 || this.weapon != 0) && (this.numSpears >= 2 || this.weapon != 3)) continue;
                                this.sprSpear[n4].setPosition(this.sprHero.getX() + (this.sprHero.getWidth() - this.sprSpear[n4].getWidth() >> 1), this.sprHero.getY());
                                this.sprSpear[n4].setVisible(true);
                                ++this.numSpears;
                                break;
                            }
                        } else if (this.weapon == 1) {
                            if (!this.sprPump.isVisible()) {
                                this.sprPump.setPosition(this.sprHero.getX() + (this.sprHero.getWidth() - this.sprPump.getWidth() >> 1), this.sprHero.getY());
                                this.sprPump.setVisible(true);
                                this.stuck = false;
                            }
                        } else if (this.weapon == 2 && !this.bulletActive) {
                            for (n4 = 0; n4 < 3; ++n4) {
                                this.sprBullet[n4].setVisible(true);
                                this.sprBullet[n4].setPosition(this.sprHero.getX() + (this.sprHero.getWidth() - this.sprBullet[n4].getWidth() >> 1), this.sprHero.getY());
                                this.sprBullet[n4].setFrame(n4);
                            }
                            this.bulletActive = true;
                        }
                        this.sprHero.setImage(this.imageLibrary[37], 48, 48);
                        this.heroAnim = 0;
                    } else if (this.heroAnim != 0) {
                        this.sprHero.setImage(this.imageLibrary[37], 48, 48);
                        this.heroAnim = 0;
                    }
                }
                if (this.powTime > System.currentTimeMillis()) {
                    if (this.sprHero.collidesWith(this.sprPow, true)) {
                        switch (this.powType) {
                            case 0: {
                                this.addScore(200);
                                break;
                            }
                            case 1: {
                                this.weapon = 1;
                                break;
                            }
                            case 2: {
                                this.gameTime += 500L;
                                if (this.gameTime <= this.maxTime) break;
                                this.gameTime = this.maxTime;
                                break;
                            }
                            case 3: {
                                this.stopTime = System.currentTimeMillis() + 5000L;
                                break;
                            }
                            case 4: {
                                this.weapon = 2;
                                break;
                            }
                            case 5: {
                                this.weapon = 3;
                                break;
                            }
                            case 6: {
                                this.shield = true;
                            }
                        }
                        this.sprPow.setVisible(false);
                        this.powTime = 0L;
                    }
                    if (this.sprPow.getY() < this.ground - 16) {
                        this.sprPow.move(0, this.objectMoveSpeed);
                        if (this.sprPow.getY() > this.ground - 16) {
                            this.sprPow.setPosition(this.sprPow.getX(), this.ground - 16);
                        }
                    }
                } else if (this.powTime < System.currentTimeMillis()) {
                    this.sprPow.setVisible(false);
                } else if (this.powTime < System.currentTimeMillis() + 1500L) {
                    if (this.loopCounter % 4L == 0L) {
                        this.blink = !this.blink;
                    }
                    this.sprPow.setVisible(this.blink);
                }
            } else {
                this.sprHero.move(0, this.objectMoveSpeed);
                if (this.sprHero.getY() > this.ground) {
                    this.heroAnim = 0;
                    --this.live;
                    if (this.live <= 0) {
                        this.key = 0;
                        this.imageLibrary[3] = null;
                        System.gc();
                        this.imageLibrary[3] = this.getImage("bg.jpg", true);
                        this.setState((byte)4);
                    } else {
                        this.initLevel();
                    }
                }
            }
            for (n4 = 0; n4 < 2; ++n4) {
                if (!this.sprSpear[n4].isVisible()) continue;
                if (this.loopCounter % 4L == 0L) {
                    this.sprSpear[n4].setTransform(2);
                } else {
                    this.sprSpear[n4].setTransform(0);
                }
                this.sprSpear[n4].move(0, -this.objectMoveSpeed);
                if (this.sprSpear[n4].getY() >= 0) continue;
                this.sprSpear[n4].setVisible(false);
                --this.numSpears;
            }
            if (this.bulletActive) {
                for (n4 = 0; n4 < 3; ++n4) {
                    this.sprBullet[n4].move(n4 - 2, -this.objectMoveSpeed);
                    if (this.sprBullet[n4].getY() >= 0) continue;
                    this.bulletActive = false;
                    this.sprBullet[n4].setVisible(false);
                }
            }
            if (this.sprPump.isVisible()) {
                this.sprPump.move(0, -this.objectMoveSpeed);
                if (this.sprPump.getY() <= 0) {
                    this.sprPump.setPosition(this.sprPump.getX(), 0);
                    if (!this.stuck) {
                        this.stuck = true;
                        this.pumpTime = System.currentTimeMillis() + 3000L;
                    } else if (this.pumpTime < System.currentTimeMillis()) {
                        this.sprPump.setVisible(false);
                    } else if (this.pumpTime < System.currentTimeMillis() + 1500L) {
                        if (this.loopCounter % 4L == 0L) {
                            this.blink = !this.blink;
                        }
                        this.sprPump.setVisible(this.blink);
                    }
                }
            }
            if (this.loopCounter % 8L == 0L) {
                this.sprHero.nextFrame();
            }
            for (n4 = 0; n4 < 16; ++n4) {
                if (this.balloonSize[n4] <= -1) continue;
                if (this.stopTime < System.currentTimeMillis()) {
                    this.sprBalloons[n4].setVisible(true);
                    this.sprBalloons[n4].move(this.balloonVelX[n4], this.balloonVelY[n4]);
                    if (this.loopCounter % 2L == 0L) {
                        this.sprBalloons[n4].nextFrame();
                    }
                    if (!this.bonusStage) {
                        if (this.balloonHorizDir[n4] == 0 && this.balloonVelX[n4] > -BALLOON_VEL[this.balloonSize[n4]][0]) {
                            int n5 = n4;
                            this.balloonVelX[n5] = this.balloonVelX[n5] - 1;
                        } else if (this.balloonHorizDir[n4] == 1 && this.balloonVelX[n4] < BALLOON_VEL[this.balloonSize[n4]][0]) {
                            int n6 = n4;
                            this.balloonVelX[n6] = this.balloonVelX[n6] + 1;
                        }
                        if (this.sprBalloons[n4].getX() < 0) {
                            this.balloonHorizDir[n4] = 1;
                        } else if (this.sprBalloons[n4].getX() > this.screenWidth - this.sprBalloons[n4].getWidth()) {
                            this.balloonHorizDir[n4] = 0;
                        }
                        if (this.balloonVertDir[n4] == 0) {
                            int n7 = n4;
                            this.balloonBounce[n7] = this.balloonBounce[n7] + 1;
                            if (this.balloonVelY[n4] > -BALLOON_VEL[this.balloonSize[n4]][1]) {
                                int n8 = n4;
                                this.balloonVelY[n8] = this.balloonVelY[n8] - 1;
                            }
                        } else if (this.balloonVertDir[n4] == 1 && this.balloonVelY[n4] < BALLOON_VEL[this.balloonSize[n4]][1]) {
                            int n9 = n4;
                            this.balloonVelY[n9] = this.balloonVelY[n9] + 1;
                        }
                        if (this.sprBalloons[n4].getY() < 0 || this.balloonBounce[n4] > 30) {
                            this.balloonVertDir[n4] = 1;
                            this.balloonBounce[n4] = 0;
                        } else if (this.sprBalloons[n4].getY() > this.ground - this.sprBalloons[n4].getHeight()) {
                            this.balloonVertDir[n4] = 0;
                            this.balloonVelY[n4] = 0;
                            this.sprBalloons[n4].setPosition(this.sprBalloons[n4].getX(), this.ground - this.sprBalloons[n4].getHeight());
                        }
                    }
                    if (this.sprBalloons[n4].getX() < 0) {
                        this.balloonVelX[n4] = 0;
                        this.sprBalloons[n4].setPosition(0, this.sprBalloons[n4].getY());
                    } else if (this.sprBalloons[n4].getX() > this.screenWidth - this.sprBalloons[n4].getWidth()) {
                        this.balloonVelX[n4] = 0;
                        this.sprBalloons[n4].setPosition(this.screenWidth - this.sprBalloons[n4].getWidth(), this.sprBalloons[n4].getY());
                    }
                    if (this.sprBalloons[n4].getY() < 0) {
                        this.balloonVelY[n4] = 0;
                        this.sprBalloons[n4].setPosition(this.sprBalloons[n4].getX(), 0);
                    }
                } else if (this.stopTime < System.currentTimeMillis() + 1500L) {
                    if (this.loopCounter % 4L == 0L) {
                        this.blink = !this.blink;
                    }
                    this.sprBalloons[n4].setVisible(this.blink);
                } else {
                    this.sprBalloons[n4].setVisible(true);
                }
                if (this.bulletActive) {
                    for (n3 = 0; n3 < 3; ++n3) {
                        if (!this.sprBullet[n3].collidesWith(this.sprBalloons[n4], true)) continue;
                        this.initExplosion(this.sprBalloons[n4].getX(), this.sprBalloons[n4].getY(), this.balloonColor[n4]);
                        this.bulletActive = false;
                        this.playSFX(1);
                        this.addScore(this.balloonColor[n4]);
                        for (n2 = 0; n2 < 3; ++n2) {
                            this.sprBullet[n2].setVisible(false);
                        }
                        this.sprBalloons[n4].setVisible(false);
                        this.layerMgr.remove((Layer)this.sprBalloons[n4]);
                        if (this.random(100) > 90) {
                            this.powTime = System.currentTimeMillis() + 5000L;
                            this.powType = (byte)this.random(7);
                            this.sprPow.setFrame((int)this.powType);
                            this.sprPow.setPosition(this.sprBalloons[n4].getX(), this.sprBalloons[n4].getY());
                            this.sprPow.setVisible(true);
                        }
                        int n10 = n4;
                        this.balloonSize[n10] = this.balloonSize[n10] - 1;
                        if (this.balloonSize[n4] > -1) {
                            for (n2 = 0; n2 < 2; ++n2) {
                                this.spawnBall(this.sprBalloons[n4].getX() + (this.random(16) - 8), this.sprBalloons[n4].getY(), this.balloonSize[n4], n2);
                            }
                            this.balloonSize[n4] = -1;
                            ++this.numBalls;
                            if (this.numBalls < 16) continue;
                            this.numBalls = 15;
                            continue;
                        }
                        --this.numBalls;
                        if (this.numBalls > 0) continue;
                        this.stopBGM();
                        this.playSFX(2);
                    }
                }
                for (n3 = 0; n3 < 2; ++n3) {
                    if (!this.sprSpear[n3].isVisible() || !this.sprSpear[n3].collidesWith(this.sprBalloons[n4], false)) continue;
                    this.initExplosion(this.sprBalloons[n4].getX(), this.sprBalloons[n4].getY(), this.balloonColor[n4]);
                    this.playSFX(1);
                    this.addScore(this.balloonColor[n4]);
                    --this.numSpears;
                    this.sprSpear[n3].setVisible(false);
                    this.sprBalloons[n4].setVisible(false);
                    this.layerMgr.remove((Layer)this.sprBalloons[n4]);
                    if (this.random(100) > 90) {
                        this.powTime = System.currentTimeMillis() + 5000L;
                        this.powType = (byte)this.random(7);
                        this.sprPow.setFrame((int)this.powType);
                        this.sprPow.setPosition(this.sprBalloons[n4].getX(), this.sprBalloons[n4].getY());
                        this.sprPow.setVisible(true);
                    }
                    int n11 = n4;
                    this.balloonSize[n11] = this.balloonSize[n11] - 1;
                    if (this.balloonSize[n4] > -1) {
                        for (n2 = 0; n2 < 2; ++n2) {
                            this.spawnBall(this.sprBalloons[n4].getX() + (this.random(16) - 8), this.sprBalloons[n4].getY(), this.balloonSize[n4], n2);
                        }
                        this.balloonSize[n4] = -1;
                        ++this.numBalls;
                        if (this.numBalls < 16) continue;
                        this.numBalls = 15;
                        continue;
                    }
                    --this.numBalls;
                    if (this.numBalls > 0) continue;
                    this.stopBGM();
                    this.playSFX(2);
                }
                if (this.sprPump.isVisible() && (this.sprPump.collidesWith(this.sprBalloons[n4], true) || this.collision(this.sprPump.getX() + 7, this.sprPump.getY(), 2, this.ground, this.sprBalloons[n4].getX(), this.sprBalloons[n4].getY(), this.sprBalloons[n4].getWidth(), this.sprBalloons[n4].getHeight()))) {
                    this.initExplosion(this.sprBalloons[n4].getX(), this.sprBalloons[n4].getY(), this.balloonColor[n4]);
                    this.playSFX(1);
                    this.addScore(this.balloonColor[n4]);
                    --this.numSpears;
                    this.sprPump.setVisible(false);
                    this.sprBalloons[n4].setVisible(false);
                    this.layerMgr.remove((Layer)this.sprBalloons[n4]);
                    if (this.random(100) > 90) {
                        this.powTime = System.currentTimeMillis() + 5000L;
                        this.powType = (byte)this.random(7);
                        this.sprPow.setFrame((int)this.powType);
                        this.sprPow.setPosition(this.sprBalloons[n4].getX(), this.sprBalloons[n4].getY());
                        this.sprPow.setVisible(true);
                    }
                    int n12 = n4;
                    this.balloonSize[n12] = this.balloonSize[n12] - 1;
                    if (this.balloonSize[n4] > -1) {
                        for (n3 = 0; n3 < 2; ++n3) {
                            this.spawnBall(this.sprBalloons[n4].getX() + (this.random(16) - 8), this.sprBalloons[n4].getY(), this.balloonSize[n4], n3);
                        }
                        this.balloonSize[n4] = -1;
                        ++this.numBalls;
                        if (this.numBalls >= 16) {
                            this.numBalls = 15;
                        }
                    } else {
                        --this.numBalls;
                        if (this.numBalls <= 0) {
                            this.stopBGM();
                            this.playSFX(2);
                        }
                    }
                }
                if (this.heroAnim == 2 || !this.sprHero.collidesWith(this.sprBalloons[n4], true) || this.stopTime >= System.currentTimeMillis() || this.tempInvincibility > 0) continue;
                if (this.shield) {
                    this.shield = false;
                    this.tempInvincibility = 100;
                    this.initExplosion(this.sprBalloons[n4].getX(), this.sprBalloons[n4].getY(), this.balloonColor[n4]);
                    this.sprBalloons[n4].setVisible(false);
                    this.layerMgr.remove((Layer)this.sprBalloons[n4]);
                    int n13 = n4;
                    this.balloonSize[n13] = this.balloonSize[n13] - 1;
                    if (this.balloonSize[n4] > -1) {
                        for (n3 = 0; n3 < 2; ++n3) {
                            this.spawnBall(this.sprBalloons[n4].getX(), this.sprBalloons[n4].getY() - 32, this.balloonSize[n4], n3);
                        }
                        this.balloonSize[n4] = -1;
                        ++this.numBalls;
                        if (this.numBalls < 16) continue;
                        this.numBalls = 15;
                        continue;
                    }
                    --this.numBalls;
                    if (this.numBalls > 0) continue;
                    this.stopBGM();
                    this.playSFX(2);
                    continue;
                }
                this.sprHero.setImage(this.imageLibrary[39], 48, 48);
                this.heroAnim = 2;
                this.stopBGM();
                this.playSFX(3);
                this.vibrate(100);
            }
        }
        graphics.drawImage(this.imageLibrary[3], this.screenWidthHalf, 0, 17);
        graphics.drawImage(this.imageLibrary[62], this.screenWidthHalf, this.hudY, 33);
        if (this.sprPump.isVisible()) {
            graphics.setColor(65535);
            graphics.fillRect(this.sprPump.getX() + 7, this.sprPump.getY() + 16, 2, this.ground);
        }
        graphics.setColor(0x808080);
        for (n4 = 0; n4 < 16; ++n4) {
            if (this.balloonSize[n4] <= -1) continue;
            graphics.fillRoundRect(this.sprBalloons[n4].getX(), this.ground - 4, this.sprBalloons[n4].getWidth(), 8, this.sprBalloons[n4].getWidth(), 8);
        }
        if (this.powTime > System.currentTimeMillis()) {
            graphics.fillRoundRect(this.sprPow.getX(), this.ground - 4, this.sprPow.getWidth(), 8, this.sprPow.getWidth(), 8);
        }
        graphics.fillRoundRect(this.sprHero.getX(), this.ground - 4, this.sprHero.getWidth(), 8, this.sprHero.getWidth(), 8);
        this.layerMgr.setViewWindow(0, 0, this.screenWidth, this.ground);
        this.layerMgr.paint(graphics, 0, 0);
        if (this.shield) {
            graphics.setColor(1048575);
            graphics.drawRoundRect(this.sprHero.getX(), this.sprHero.getY(), 48, 48, 48, 48);
        }
        if (this.tempInvincibility > 0) {
            --this.tempInvincibility;
            if (this.tempInvincibility % 2 == 0) {
                graphics.setColor(1048575);
                graphics.drawRoundRect(this.sprHero.getX(), this.sprHero.getY(), 48, 48, 48, 48);
            }
        }
        n4 = 20;
        n3 = 48;
        n2 = 4;
        int n14 = 2;
        graphics.drawImage(this.imageLibrary[61], 0, this.hudY, 20);
        graphics.drawImage(this.imageLibrary[23], 0, this.hudY + n4, 20);
        for (n = 0; n < this.live; ++n) {
            graphics.drawImage(this.imageLibrary[22], this.imageLibrary[23].getWidth() + n * this.imageLibrary[22].getWidth(), this.hudY + (n4 + n2), 20);
        }
        graphics.drawImage(this.imageLibrary[25], 0, this.hudY + n3, 20);
        this.drawNumbers(graphics, this.leadingZeroes(this.score, 5), this.imageLibrary[25].getWidth(), this.hudY + (n3 + n14));
        graphics.drawImage(this.imageLibrary[26], this.screenWidthHalf, this.hudY + n4, 20);
        this.drawNumbers(graphics, this.leadingZeroes(this.level < 99 ? this.level + 1 : 99, 1), this.screenWidthHalf + this.imageLibrary[26].getWidth(), this.hudY + (n4 + n14));
        graphics.setColor(0xFFAA00);
        n = 5;
        int n15 = 5;
        int n16 = 230;
        int n17 = 10;
        graphics.fillRect(n, n15 + this.hudY, (int)((long)n16 * this.gameTime / this.maxTime), n17);
        graphics.drawImage(this.imageLibrary[10], this.screenWidth, this.screenHeight, 40);
        if (this.transRectIn <= 0) {
            if (this.numBalls > 0) {
                if (this.gameTime > 0L && this.stopTime < System.currentTimeMillis()) {
                    --this.gameTime;
                    if (this.gameTime <= 0L) {
                        if (!this.bonusStage) {
                            this.heroAnim = 2;
                            this.vibrate(100);
                        }
                        this.stopBGM();
                        this.playSFX(3);
                    }
                }
                if (this.gameTime <= 0L && this.bonusStage) {
                    this.transition(graphics);
                }
            } else if (this.gameTime > 0L) {
                this.gameTime -= (long)(3 * (this.level + 1));
                if (this.gameTime < 0L) {
                    this.gameTime = 0L;
                }
                this.addScore(3 * (this.level + 1));
            } else {
                this.transition(graphics);
            }
        } else {
            graphics.setColor(0);
            graphics.fillRect(0, 0, this.screenWidth, this.transRectIn);
            graphics.fillRect(0, this.screenHeight - this.transRectIn, this.screenWidth, this.transRectIn);
            if (this.bonusStage) {
                graphics.drawImage(this.imageLibrary[93], this.screenWidthHalf, this.screenHeightHalf, 33);
            } else {
                int n18 = this.screenWidth - (this.imageLibrary[26].getWidth() + 16) >> 1;
                int n19 = 2;
                graphics.drawImage(this.imageLibrary[26], n18, this.screenHeightHalf, 36);
                this.drawNumbers(graphics, this.leadingZeroes(this.level < 99 ? this.level + 1 : 99, 1), n18 + this.imageLibrary[26].getWidth(), this.screenHeightHalf - this.imageLibrary[26].getHeight() + n19);
            }
            graphics.drawImage(this.imageLibrary[89], this.screenWidthHalf, this.screenHeightHalf, 17);
        }
    }

    public void initParticles() {
        this.pclX = new int[64];
        this.pclY = new int[64];
        this.pclVelX = new int[64];
        this.pclVelY = new int[64];
        this.pclColor = new int[64];
        this.pclActive = new boolean[64];
        for (int i = 0; i < 64; ++i) {
            this.pclActive[i] = false;
        }
    }

    public void spawnParticles(int n, int n2, int n3) {
        int n4 = 0;
        for (int i = 0; i < 64; ++i) {
            if (this.pclActive[i]) continue;
            this.pclColor[i] = COLORS[n3];
            this.pclX[i] = n;
            this.pclY[i] = n2;
            this.pclVelX[i] = this.random(6) - 3;
            this.pclVelY[i] = -(this.random(4) + 4);
            this.pclActive[i] = true;
            if (++n4 >= 12) break;
        }
    }

    public void updateParticles(Graphics graphics) {
        for (int i = 0; i < 64; ++i) {
            if (!this.pclActive[i]) continue;
            graphics.setColor(this.pclColor[i]);
            if (this.pclY[i] < this.ground) {
                int n = i;
                this.pclX[n] = this.pclX[n] + this.pclVelX[i];
            }
            int n = i;
            this.pclY[n] = this.pclY[n] + this.pclVelY[i];
            if (this.loopCounter % 2L == 0L && this.pclVelY[i] < 8) {
                int n2 = i;
                this.pclVelY[n2] = this.pclVelY[n2] + 1;
            }
            if (this.pclY[i] > this.screenHeight) {
                this.pclActive[i] = false;
                continue;
            }
            if (this.pclY[i] > this.ground) {
                graphics.fillRect(this.pclX[i], this.ground, 2, 2);
                continue;
            }
            graphics.fillRect(this.pclX[i], this.pclY[i], 2, 2);
        }
    }

    public void tweet() {
    }
}

