/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class BTWSoundPlayer {
    private InputStream inOwn;
    private InputStream inBGM;
    private InputStream inPlay;
    private InputStream inBos;
    private Player pOwn;
    private Player pBGM;
    private Player pPlay;
    private Player pBos;
    private VolumeControl vc;
    private boolean isMute = false;

    public BTWSoundPlayer() {
        try {
            this.inOwn = this.getClass().getResourceAsStream("/LaguLogoOwnGames.mid");
            this.pOwn = Manager.createPlayer((InputStream)this.inOwn, (String)"audio/midi");
            this.pOwn.realize();
            this.inBGM = this.getClass().getResourceAsStream("/FOLK.MID");
            this.pBGM = Manager.createPlayer((InputStream)this.inBGM, (String)"audio/midi");
            this.pBGM.realize();
            this.pBGM.setLoopCount(-1);
            this.inPlay = this.getClass().getResourceAsStream("/DANCE.MID");
            this.pPlay = Manager.createPlayer((InputStream)this.inPlay, (String)"audio/midi");
            this.pPlay.realize();
            this.pPlay.setLoopCount(-1);
            this.inBos = this.getClass().getResourceAsStream("/TECHNO.MID");
            this.pBos = Manager.createPlayer((InputStream)this.inBos, (String)"audio/midi");
            this.pBos.realize();
            this.pBos.setLoopCount(-1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void playOwn() {
        this.play(this.pOwn);
    }

    public void stopOwn() {
        this.stop(this.pOwn);
    }

    public void playBGM() {
        this.play(this.pBGM);
    }

    public void stopBGM() {
        this.stop(this.pBGM);
    }

    public void playPlay() {
        this.play(this.pPlay);
    }

    public void stopPlay() {
        this.stop(this.pPlay);
    }

    public void playBos() {
        this.play(this.pBos);
    }

    public void stopBos() {
        this.stop(this.pBos);
    }

    public void stopAll() {
        this.stopOwn();
        this.stopBGM();
        this.stopPlay();
        this.stopBos();
    }

    public void muteSound() {
        this.stopAll();
        this.isMute = true;
    }

    public void unMuteSound() {
        this.isMute = false;
    }

    private void play(Player p) {
        try {
            if (p != null && p.getState() == 400) {
                p.stop();
                p.deallocate();
            }
            this.vc = (VolumeControl)p.getControl("VolumeControl");
            if (this.vc != null) {
                if (this.isMute) {
                    this.vc.setLevel(0);
                } else {
                    this.vc.setLevel(50);
                }
            }
            p.realize();
            p.prefetch();
            p.setMediaTime(-1L);
            if (!this.isMute) {
                p.start();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stop(Player p) {
        try {
            if (p != null && p.getState() == 400) {
                p.stop();
                p.deallocate();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

