/*
 * Decompiled with CFR 0.152.
 */
package com.lenin.files.electroid.game;

import com.lenin.files.electroid.game.Resources;
import javax.microedition.lcdui.game.Sprite;

public class Ball
extends Sprite {
    private static final int PADDING = 6;
    private int velocityX;
    private int velocityY;

    public Ball(Resources r) {
        super(r.ball);
        this.setCollisionRectangle(r);
        this.defineReferencePixel((int)((double)this.getWidth() * 0.5 + 0.5), (int)((double)this.getHeight() * 0.5 + 0.5));
    }

    private void setCollisionRectangle(Resources r) {
        int width = this.getWidth();
        int padding = r.scale(6.0);
        this.defineCollisionRectangle(padding, padding, width - padding, width - padding);
    }

    public void move() {
        this.move(this.getVelocityX(), this.getVelocityY());
    }

    public void bounceVertically() {
        this.velocityY *= -1;
    }

    public void bounceHorizontally() {
        this.velocityX *= -1;
    }

    public void bounceLeft() {
        if (this.velocityX > 0) {
            this.bounceHorizontally();
        }
    }

    public void bounceRight() {
        if (this.velocityX < 0) {
            this.bounceHorizontally();
        }
    }

    public void bounceUp() {
        if (this.velocityY > 0) {
            this.bounceVertically();
        }
    }

    public void bounceDown() {
        if (this.velocityY < 0) {
            this.bounceVertically();
        }
    }

    public int getVelocityX() {
        return this.velocityX;
    }

    public int getVelocityY() {
        return this.velocityY;
    }

    public void setVelocityX(int velocity) {
        this.velocityX = velocity;
    }

    public void setVelocityY(int velocity) {
        this.velocityY = velocity;
    }

    public void changeVelocityX(int amount) {
        this.velocityX += amount;
    }
}

