/*
 * Decompiled with CFR 0.152.
 */
package com.lenin.files.electroid.menu;

import com.lenin.files.electroid.effects.Slideable;
import com.lenin.files.electroid.menu.Menu;
import com.lenin.files.electroid.menu.MenuItem;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class InfoScreen
extends Menu
implements Slideable {
    public static final int ITEM_COUNT = 2;
    public static final int LINK = 0;
    public static final int BACK = 1;
    public final int OUT_CX;
    public final int IN_CX;
    private int x;
    private int y;
    private int height;
    private int cornerY;
    private Image info;

    public InfoScreen(int cornerX, int cornerY, int width, int height, Menu.Listener l, double scaling) {
        super(2, l);
        this.height = height;
        this.cornerY = cornerY;
        this.IN_CX = cornerX + width / 2;
        this.OUT_CX = this.IN_CX + width;
        this.info = this.loadImage("/info_text.png", 1, scaling);
        this.x = this.OUT_CX;
        this.y = cornerY + (int)((double)height * 0.8);
        MenuItem item = new MenuItem(this.loadSprite("/link.png", 2, scaling));
        this.setItem(0, item);
        item.setCenter(this.x, this.y);
        this.y += item.getHeight();
        item = new MenuItem(this.loadSprite("/back.png", 2, scaling));
        this.setItem(1, item);
        item.setCenter(this.x, this.y);
        this.selectItem(1);
    }

    public void paint(Graphics g) {
        super.paint(g);
        g.drawImage(this.info, this.x, this.cornerY + this.height / 2, 3);
    }

    public boolean slideIn() {
        int distance = this.x - this.IN_CX;
        distance = (int)((double)distance * 0.8);
        this.x = this.IN_CX + distance;
        this.positionMenuItems();
        return distance != 0;
    }

    public boolean slideOut() {
        int distance = this.x - this.OUT_CX;
        distance = (int)((double)distance * 0.8);
        this.x = this.OUT_CX + distance;
        this.positionMenuItems();
        return distance != 0;
    }

    public void positionMenuItems() {
        MenuItem item = this.getItem(0);
        item.setHorizontalCenter(this.x);
        item = this.getItem(1);
        item.setHorizontalCenter(this.x);
    }
}

