/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.efw.text;

import com.jarbull.efw.controller.ImageHandler;
import com.jarbull.efw.text.EFont;
import com.jarbull.efw.text.HexWriter;
import com.jarbull.efw.text.StringWriter;
import com.jarbull.efw.text.WexWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class TextWriter {
    public static final int WRITER_TYPE_HEX = 0;
    public static final int WRITER_TYPE_WEX = 1;
    public static final int WRITER_TYPE_STRING = 2;
    public static final int WRITER_ORIENTATION_NONE = 0;
    public static final int WRITER_ORIENTATION_ROT90 = 5;
    public static final int WRITER_ORIENTATION_ROT180 = 3;
    public static final int WRITER_ORIENTATION_ROT270 = 6;
    private static final TextWriter a = new TextWriter();
    private int a;
    private int b;
    private Hashtable a;
    private String a;
    private Font a = new Hashtable();
    private Hashtable b = new Hashtable();

    private TextWriter() {
        this.a = Font.getFont((int)32, (int)0, (int)8);
    }

    public static TextWriter getInstance() {
        return a;
    }

    public void drawText(Graphics graphics, String string, int n, int n2) {
        switch (this.a) {
            case 0: {
                HexWriter.getInstance().a(graphics, string, n, n2, 0, (EFont)this.a.get(this.a));
                return;
            }
            case 1: {
                WexWriter.getInstance();
                WexWriter.a(graphics, string, n, n2, 0, (EFont)this.a.get(this.a));
                return;
            }
            case 2: {
                StringWriter.getInstance();
                StringWriter.a(graphics, string, n, n2, 0, this.a);
            }
        }
    }

    public int getTextWidth(String string) {
        switch (this.a) {
            case 0: {
                return HexWriter.getInstance().a(string, (EFont)this.a.get(this.a));
            }
            case 1: {
                WexWriter.getInstance();
                return WexWriter.a(string, (EFont)this.a.get(this.a));
            }
            case 2: {
                StringWriter.getInstance();
                return StringWriter.a(string, this.a);
            }
        }
        return 0;
    }

    public int getTextHeight(String string) {
        switch (this.a) {
            case 0: {
                return HexWriter.getInstance().b(string, (EFont)this.a.get(this.a));
            }
            case 1: {
                WexWriter.getInstance();
                return WexWriter.b(string, (EFont)this.a.get(this.a));
            }
            case 2: {
                StringWriter.getInstance();
                return StringWriter.a(this.a);
            }
        }
        return 0;
    }

    public void setWriterType(int n) {
        this.a = n;
    }

    public int getWriterType() {
        return this.a;
    }

    public void setFont(EFont eFont) {
        this.a = eFont.getFontName();
    }

    public EFont getFont() {
        return (EFont)this.a.get(this.a);
    }

    public EFont getFont(String string) {
        return (EFont)this.a.get(string);
    }

    public void clearFont(EFont eFont) {
        ImageHandler.getInstance().clear(eFont.getFontImagePath());
        this.a.remove(eFont.getFontName());
    }

    public void clearAllFonts() {
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            ImageHandler.getInstance().clear(((EFont)enumeration.nextElement()).getFontImagePath());
        }
        this.a.clear();
    }

    public void loadFonts(EFont[] eFontArray) {
        for (int i = 0; i < eFontArray.length; ++i) {
            if (this.a.containsKey(eFontArray[i].getFontName())) continue;
            ImageHandler.getInstance().load(eFontArray[i].getFontImagePath());
            this.a.put(eFontArray[i].getFontName(), eFontArray[i]);
        }
    }

    public void loadFont(EFont eFont) {
        if (!this.a.containsKey(eFont.getFontName())) {
            ImageHandler.getInstance().load(eFont.getFontImagePath());
            this.a.put(eFont.getFontName(), eFont);
        }
        if (this.a.size() == 1) {
            this.setFont(eFont);
            this.setWriterType(eFont.getFontType() == 0 ? 0 : 1);
        }
    }

    public void setSystemFont(Font font) {
        this.a = font;
    }

    public Font getSystemFont() {
        return this.a;
    }

    public int getOrientation() {
        return this.b;
    }

    public void setOrientation(int n) {
        this.b = n;
    }

    public void saveState() {
        this.b.put("writerType", new Integer(this.a));
        this.b.put("orientation", new Integer(this.b));
        if (this.a != null) {
            this.b.put("currentFontName", this.a);
        }
    }

    public void restoreState() {
        Object v = this.b.get("writerType");
        this.a = v != null ? Integer.parseInt(v.toString()) : 2;
        this.b = Integer.parseInt(this.b.get("orientation").toString());
        v = this.b.get("currentFontName");
        if (v != null) {
            this.a = v.toString();
            return;
        }
        this.a = null;
    }
}

