/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.mp.color_game;

import com.siemens.mp.color_game.Layer;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class LayerManager {
    private Vector layers;
    private int viewX;
    private int viewY;
    private int viewWidth;
    private int viewHeight;

    public LayerManager() {
        this.setViewWindow(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
        this.layers = new Vector();
    }

    public void append(Layer l) {
        this.layers.addElement(l);
    }

    public void insert(Layer l, int index) {
        this.layers.insertElementAt(l, index);
    }

    public Layer getLayerAt(int index) {
        return (Layer)this.layers.elementAt(index);
    }

    public int getSize() {
        return this.layers.size();
    }

    public void remove(Layer l) {
        this.layers.removeElement(l);
    }

    public void paint(Graphics g, int x, int y) {
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipW = g.getClipWidth();
        int clipH = g.getClipHeight();
        g.translate(x - this.viewX, y - this.viewY);
        g.setClip(this.viewX, this.viewY, this.viewWidth, this.viewHeight);
        int i = this.layers.size();
        while (--i >= 0) {
            Layer comp = (Layer)this.layers.elementAt(i);
            if (!comp.visible || comp.x + comp.width < this.viewX || comp.x > this.viewX + clipW || comp.y + comp.height < this.viewY || comp.y > this.viewY + clipH) continue;
            comp.paint(g);
        }
        g.translate(-x + this.viewX, -y + this.viewY);
        g.setClip(clipX, clipY, clipW, clipH);
    }

    public void setViewWindow(int x, int y, int width, int height) {
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException();
        }
        this.viewX = x;
        this.viewY = y;
        this.viewWidth = width;
        this.viewHeight = height;
    }
}

