/*
 * Decompiled with CFR 0.152.
 */
package main;

import com.jarbull.efw.controller.ImageHandler;
import com.jarbull.efw.game.EFLayerManager;
import java.util.Vector;
import main.Particle;

public class ParticleEffect {
    public static final int TYPE_BOX = 0;
    public static final int TYPE_SNEJOK = 1;
    public static final int TYPE_ROCKET = 2;
    public static final int TYPE_DROP_ENEMY = 3;
    public static final int TYPE_NARC = 4;
    Vector vecParticles;
    private final int[][][] arrImpulses = new int[][][]{new int[][]{{4, -180}, {4, -80}, {5, 0}, {5, 30}, {3, 80}, {3, 150}}, new int[][]{{2, -180}, {3, -80}, {2, 0}, {2, 30}, {1, 80}, {2, 150}}, new int[][]{{1, -180}, {1, -80}, {0, 0}, {1, 30}, {0, 80}, {1, 150}}};
    private int[][] arrImpulse;
    private int currNumParticle;
    private EFLayerManager lmEF;
    private int numPackage;

    public ParticleEffect(EFLayerManager lmEF, int numPackage) {
        this.vecParticles = new Vector();
        this.lmEF = lmEF;
        this.arrImpulse = this.arrImpulses[0];
        this.numPackage = numPackage;
    }

    public void create(int x, int y, int bottomBound, int type) {
        if (!this.vecParticles.isEmpty()) {
            return;
        }
        this.currNumParticle = 0;
        String pathImg = null;
        switch (type) {
            case 0: {
                pathImg = "/res/game/images/location" + this.numPackage + "/particleBox.png";
                this.arrImpulse = this.arrImpulses[0];
                break;
            }
            case 1: {
                pathImg = "/res/game/images/location" + this.numPackage + "/particleSnejok.png";
                this.arrImpulse = this.arrImpulses[1];
                break;
            }
            case 2: {
                pathImg = "/res/project/images/rocketParticle.png";
                this.arrImpulse = this.arrImpulses[0];
                break;
            }
            case 3: {
                pathImg = "/res/project/images/enemyDropParticle.png";
                this.arrImpulse = this.arrImpulses[0];
                break;
            }
            case 4: {
                pathImg = "/res/project/images/enemyNarcParticle.png";
                this.arrImpulse = this.arrImpulses[0];
            }
        }
        int frameWidth = ImageHandler.getInstance().getImage(pathImg).getWidth() / 2;
        int frameHeight = ImageHandler.getInstance().getImage(pathImg).getHeight() / 4;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 3; ++j) {
                Particle particle = new Particle(pathImg, frameWidth, frameHeight);
                particle.setFrame(this.currNumParticle);
                particle.setPosition(x + i * frameWidth, y + j * frameHeight);
                particle.setBottomBound(bottomBound);
                particle.setImpulse(this.arrImpulse[this.currNumParticle][0], this.arrImpulse[this.currNumParticle][1]);
                ++this.currNumParticle;
                this.vecParticles.addElement(particle);
                this.lmEF.append(particle);
                this.lmEF.insert(particle, 0);
            }
        }
    }

    public void moving() {
        for (int i = this.vecParticles.size() - 1; i >= 0; --i) {
            Particle currParticle = (Particle)this.vecParticles.elementAt(i);
            currParticle.moving();
            if (!currParticle.getIsRemove()) continue;
            this.vecParticles.removeElement(currParticle);
            this.lmEF.remove(currParticle);
            Object var2_2 = null;
        }
    }

    public void removeAllParticles() {
        if (this.vecParticles != null) {
            for (int i = this.vecParticles.size() - 1; i >= 0; --i) {
                Particle currParticle = (Particle)this.vecParticles.elementAt(i);
                this.vecParticles.removeElement(currParticle);
                this.lmEF.remove(currParticle);
                Object var2_2 = null;
            }
        }
    }
}

