/*
 * Decompiled with CFR 0.152.
 */
package com.pipogame.fad.scen;

import com.pipogame.GameScreen;
import com.pipogame.Input;
import com.pipogame.Store;
import com.pipogame.fad.MenuScreen;
import com.pipogame.fad.scen.NarratorScreen;
import com.pipogame.fad.scen.TalkIntroScreen;
import com.pipogame.fad.stag.Lands;
import com.pipogame.fad.strings;
import com.pipogame.util.Drawer;
import com.pipogame.util.ImageTool;
import com.pipogame.util.MathExt;
import com.pipogame.util.PFont;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ChooseCharacterScreen
extends GameScreen {
    Image bgrImage;
    Image piImage;
    Image poImage;
    Image shadowImage;
    Image piName;
    Image poName;
    Image selectedImage;
    Image backBtnImage;
    private boolean selected;
    private int character;
    public static final int PI_SELECTED = 1;
    public static final int PO_SELECTED = 2;
    private int counter;
    private int foot_y = 271;
    byte[] text;
    boolean dir;
    private int piX = GameScreen._width * 2 / 3;
    private int poX = GameScreen._width / 3;

    public void loadContent() throws Exception {
        switch (this.screenManager.screenType) {
            case 2: {
                this.foot_y = 200;
            }
        }
        this.transitionOffTime = 500;
        this.transitionOnTime = 500;
        this.asset = Store.loadJar(strings.SHARE_FILE);
        this.bgrImage = Lands.getIntroBgrImage(this.screenManager.screenType);
        this.piImage = this.loadImage(35);
        this.poImage = this.loadImage(36);
        this.shadowImage = this.loadImage(39);
        this.backBtnImage = ImageTool.getImageByFrame(this.loadImage(29), 4, 1, 0);
        this.piName = this.loadImage(38);
        this.poName = ImageTool.getImageByFrame(this.piName, 3, 1, 1);
        this.selectedImage = ImageTool.getImageByFrame(this.piName, 3, 1, 2);
        this.piName = ImageTool.getImageByFrame(this.piName, 3, 1, 0);
        this.text = PFont.toBytesIndex(this.asset.getString(37), null);
        Graphics g = this.bgrImage.getGraphics();
        int y = this.foot_y - this.piImage.getHeight();
        Drawer.drawAtCenterX(g, this.piImage, this.piX, y);
        Drawer.drawAtCenterX(g, this.piName, this.piX, y - this.piName.getHeight());
        Drawer.drawCenter(g, this.shadowImage, this.piX, this.foot_y - 5);
        y = this.foot_y - this.poImage.getHeight();
        Drawer.drawAtCenterX(g, this.poImage, this.poX, y);
        Drawer.drawAtCenterX(g, this.poName, this.poX, y - this.poName.getHeight());
        Drawer.drawCenter(g, this.shadowImage, this.poX, this.foot_y - 5);
    }

    public void finalize() {
        this.text = null;
        super.finalize();
    }

    public void handleInput(Input input, int frameTime) {
        if (input.isRightPrd() || input.isUpPrd()) {
            this.selected = true;
            this.character = 1;
        } else if (input.isLeftPrd() || input.isDownPrd()) {
            this.selected = true;
            this.character = 2;
        } else if (this.selected && !this.isExiting() && input.isFirePrd()) {
            this.screenManager.store.set(strings.CHAR_SLTD, this.character);
            this.screenManager.store.set(strings.STAGE, 1);
            try {
                this.screenManager.addScreen(new NarratorScreen(40, new TalkIntroScreen(this.screenManager.screenType)));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.exitScreen();
        } else if (input.isSoftLeftPrd()) {
            this.screenManager.addScreen(new MenuScreen());
            this.exitScreen();
        }
    }

    public void draw(Graphics g, int frameTime) {
        g.drawImage(this.bgrImage, 0, 0, 0);
        g.drawImage(this.backBtnImage, 0, _height - this.backBtnImage.getHeight(), 0);
        PFont.drawCenterString(g, _width / 2, _height - 17, this.text, this.counter / 2 << 24 | 0xFFFF00);
        if (this.selected) {
            switch (this.character) {
                case 1: {
                    Drawer.drawAtCenterX(g, this.selectedImage, this.piX, this.foot_y + this.counter / 51);
                    break;
                }
                case 2: {
                    Drawer.drawAtCenterX(g, this.selectedImage, this.poX, this.foot_y + this.counter / 51);
                }
            }
        }
        switch (this.screenState) {
            case 1: 
            case 4: {
                int delta = (int)(MathExt.sqr(this.transitionPos) * 255.0f);
                Drawer.drawBg(g, 0, 0, _width, _height, delta << 24);
            }
        }
    }

    public void update(int frameTime, boolean covered) {
        this.counter = this.dir ? (this.counter += frameTime) : (this.counter -= frameTime);
        if (this.counter < 0) {
            this.counter = 0;
            this.dir = true;
        } else if (this.counter > 511) {
            this.counter = 511;
            this.dir = false;
        }
    }
}

