/*
 * Decompiled with CFR 0.152.
 */
package game;

import MovingBall.CommanFunctions;
import game.MainGameCanvas;
import game.ObjectTemplates;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class User
implements ObjectTemplates {
    private int xCord;
    private int yCord;
    Sprite sprite;
    private int spriteIndex = 0;
    private int itemWidth;
    private int itemHeight;
    private boolean isManualMngDirection = false;
    public static boolean isCrash = false;
    private int speed = 2;
    private boolean touchWithUser = false;

    public User() {
        this.loadImage();
    }

    public void loadImage() {
        try {
            Image img = Image.createImage((String)"/helicopter_sprite_300x225.png");
            this.itemWidth = img.getWidth() / 3;
            this.itemHeight = img.getHeight() / 3;
            this.sprite = new Sprite(img, this.itemWidth, this.itemHeight);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setCordinates(int x, int y) {
        this.xCord = x;
        this.yCord = y;
    }

    public void paint(Graphics g) {
        if (this.sprite != null) {
            this.sprite.setFrame(this.getSpriteIndex());
            this.sprite.setRefPixelPosition(this.xCord, this.yCord);
            this.sprite.paint(g);
            if (this.getSpriteIndex() == 0) {
                this.setSpriteIndex(1);
            } else if (this.getSpriteIndex() == 1) {
                this.setSpriteIndex(2);
            } else if (this.getSpriteIndex() == 2) {
                this.setSpriteIndex(0);
            } else if (this.getSpriteIndex() == 3) {
                this.setSpriteIndex(4);
            } else if (this.getSpriteIndex() == 4) {
                this.setSpriteIndex(5);
            } else if (this.getSpriteIndex() != 5) {
                if (this.getSpriteIndex() == 6) {
                    this.setSpriteIndex(7);
                } else if (this.getSpriteIndex() == 7) {
                    this.setSpriteIndex(8);
                } else if (this.getSpriteIndex() == 8) {
                    // empty if block
                }
            }
        }
        if (this.yCord < MainGameCanvas.screenHeight + this.itemHeight && !this.isManualMngDirection) {
            this.yCord += 2;
        }
        if (isCrash) {
            this.yCord += 5;
        }
        if (this.yCord > MainGameCanvas.screenHeight - MainGameCanvas.bottamAddHeight) {
            MainGameCanvas.mainGameCanvas.isGameOver = true;
        }
    }

    public void scrollLeft() {
        if (this.xCord > 2 && !isCrash) {
            this.xCord -= this.speed;
        }
        this.isManualMngDirection = true;
    }

    public void scrollRight() {
        if (!isCrash) {
            if (this.xCord < CommanFunctions.getPercentage(MainGameCanvas.screenWidth, 70)) {
                this.xCord += this.speed;
            }
            this.isManualMngDirection = true;
        }
    }

    public int getSpriteIndex() {
        return this.spriteIndex;
    }

    public void setSpriteIndex(int spriteIndex) {
        this.spriteIndex = spriteIndex;
    }

    public Sprite getSprite() {
        return this.sprite;
    }

    public void scrollUp() {
        if (!isCrash) {
            if (this.yCord > MainGameCanvas.topAddHeight + 4) {
                this.yCord -= 4;
            }
            if (this.getSpriteIndex() < 3 || this.getSpriteIndex() > 5) {
                this.setSpriteIndex(3);
                System.out.println("set up index");
            }
            this.isManualMngDirection = true;
        }
    }

    public void scrollUpOKKey() {
        if (!isCrash) {
            if (this.yCord > 2) {
                this.yCord -= 2;
            }
            if (this.getSpriteIndex() != 0) {
                this.setSpriteIndex(0);
                System.out.println("scrollUpOKKey set up index");
            }
            this.isManualMngDirection = true;
        }
    }

    public void scrollDown() {
        if (!isCrash) {
            if (this.yCord < MainGameCanvas.screenHeight - (MainGameCanvas.bottamAddHeight + 4 + this.itemHeight)) {
                this.yCord += 4;
            }
            if (this.getSpriteIndex() < 6) {
                this.setSpriteIndex(6);
                System.out.println("set up index");
            }
            this.isManualMngDirection = true;
        }
    }

    protected void pointerDragged(int x, int y) {
        if (this.touchWithUser) {
            this.xCord = x;
            this.yCord = y;
            this.scrollUpOKKey();
        }
    }

    protected void pointerReleased(int x, int y) {
        this.touchWithUser = false;
    }

    protected void pointerPressed(int x, int y) {
        if (x > this.xCord && x < this.xCord + this.itemWidth && y > this.yCord && y < this.yCord + this.itemHeight) {
            this.touchWithUser = true;
        }
    }

    public void setIsManualMngDirection(boolean isManualMngDirection) {
        this.isManualMngDirection = isManualMngDirection;
    }

    public int getxCord() {
        return this.xCord;
    }

    public int getyCord() {
        return this.yCord;
    }

    public int getitemHeight() {
        return this.itemHeight;
    }
}

