/*
 * Decompiled with CFR 0.152.
 */
package game;

import InneractiveSDK.IADView;
import MovingBall.ApplicationMidlet;
import MovingBall.CommanFunctions;
import MovingBall.ConfigValue;
import MovingBall.Constants;
import MovingBall.MainCanvas;
import com.sm.adslib.AdsObserver;
import com.sm.adslib.GetAds;
import game.Blast;
import game.GameTimer;
import game.HadleObjects;
import game.ObjectTemplates;
import game.RMSGameScores;
import game.User;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;

public class MainGameCanvas
extends Canvas
implements CommandListener,
AdsObserver {
    public static int screenWidth;
    public static int screenHeight;
    private ObjectTemplates objectTemplates;
    private Image background;
    private Image backButton;
    private int backXCord;
    private int backYCord;
    private final int MAXENEMY;
    private HadleObjects[] hadleObjects;
    private int keyPressNumber = -1;
    private Timer t;
    private Font smallFont;
    private int smallFontHeight = 0;
    public static MainGameCanvas mainGameCanvas;
    public boolean isGameOver = false;
    public final int gameOverScreen;
    public final int gameScreen;
    public final int pauseScreen;
    public int screen = 1;
    private Blast blast;
    private int score = 0;
    private int speed = 10;
    private int collisionFoundCount = 0;
    private int life = 3;
    private Image pause = null;
    private static int genrateEnemyTime;
    private int genrateCounter = 0;
    private boolean speedIncTime = false;
    boolean isTopSelected;
    boolean isBottamSelected;
    public static Image topAdd;
    public static Image bottomAdd;
    public static Image messageBox1;
    public static String topAddURL;
    public static String bottomAddURL;
    public static int topAddHeight;
    public static int bottamAddHeight;
    public GetAds getAds = null;
    private int count = 1;
    static int cord;
    static int cord1;
    TextField t1;
    private Command cmdSave;
    private Command cmdBack;

    public MainGameCanvas() {
        this.MAXENEMY = 20;
        this.gameOverScreen = 4;
        this.gameScreen = 1;
        this.pauseScreen = 2;
        this.setFullScreenMode(true);
        mainGameCanvas = this;
        screenWidth = this.getWidth();
        screenHeight = this.getHeight();
        this.hadleObjects = new HadleObjects[20];
        this.getAds = new GetAds(ApplicationMidlet.midlet, ConfigValue.SmIdint, screenWidth, screenHeight, ConfigValue.OnOffPath, this);
        this.smallFont = Font.getFont((int)0, (int)0, (int)8);
        this.smallFontHeight = this.smallFont.getHeight() + 2;
        try {
            this.background = Image.createImage((String)"/bacground.png");
            if (screenWidth != 240 && screenHeight != 400) {
                this.background = CommanFunctions.scale(this.background, screenWidth * 2, screenHeight);
            }
            this.backButton = Image.createImage((String)"/back.png");
            if (screenWidth <= 128) {
                this.backButton = CommanFunctions.scale(this.backButton, this.backButton.getWidth(), 30);
            }
            this.pause = Image.createImage((String)"/paused.png");
            if (screenWidth > 128) {
                int tenPer = CommanFunctions.getPercentage(screenHeight, 10);
                topAdd = Image.createImage((String)"/topadd.png");
                topAdd = CommanFunctions.scale(topAdd, screenWidth - 40, tenPer);
                bottomAdd = Image.createImage((String)"/bottamad.png");
                bottomAdd = CommanFunctions.scale(bottomAdd, screenWidth - 40, tenPer);
                bottamAddHeight = topAddHeight = tenPer;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.backXCord = 0;
        this.backYCord = 0;
        this.objectTemplates = new User();
        this.objectTemplates.setCordinates(50, 50);
        this.genrateEnemy();
        this.getAdd();
        this.advertisementTimer();
    }

    private void advertisementTimer() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    while (true) {
                        Thread.sleep(30000L);
                        MainGameCanvas.this.getAdd();
                    }
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                    return;
                }
            }
        }).start();
    }

    private void getAdd() {
        if (ApplicationMidlet.isRFWP.equalsIgnoreCase(ApplicationMidlet.pasString)) {
            this.getAds.getAdsBannerInThread();
        } else {
            this.getAddFromInner();
        }
    }

    private void getAddFromInner() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Vector v2;
                    Vector v1 = IADView.getBannerAdData(ApplicationMidlet.midlet);
                    if (v1 != null) {
                        topAdd = (Image)v1.elementAt(0);
                        System.out.println("topAdd  " + topAdd.getHeight());
                        topAddURL = (String)v1.elementAt(1);
                    }
                    if ((v2 = IADView.getBannerAdData(ApplicationMidlet.midlet)) != null) {
                        bottomAdd = (Image)v2.elementAt(0);
                        bottomAddURL = (String)v2.elementAt(1);
                    }
                    MainGameCanvas.this.myPaint();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
    }

    public void adsReceived(Vector vector) {
        try {
            System.out.println("adsReceived " + vector);
            if (vector != null && vector.size() >= 2) {
                if (this.count % 2 != 0) {
                    topAdd = (Image)vector.elementAt(0);
                    topAddURL = (String)vector.elementAt(1);
                    System.out.println("topAddURL recive " + topAddURL);
                } else {
                    bottomAdd = (Image)vector.elementAt(0);
                    bottomAddURL = (String)vector.elementAt(1);
                    System.out.println("bottomAddURL recive " + bottomAddURL);
                }
            }
            this.myPaint();
            ++this.count;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void adsReceivedError(int i) {
    }

    public void startTimer() {
        if (this.t == null) {
            this.t = new Timer();
            this.t.schedule((TimerTask)new GameTimer(this), 0L, 100L);
        }
    }

    private void genrateEnemy() {
        ++this.genrateCounter;
        if (this.screen == 1 && this.genrateCounter % genrateEnemyTime == 0) {
            for (int i = 0; i < 20; ++i) {
                if (this.hadleObjects[i] != null) continue;
                this.hadleObjects[i] = new HadleObjects();
                this.hadleObjects[i].setSpriteIndex(CommanFunctions.randam(0, 4));
                this.hadleObjects[i].setCordinates(screenWidth + 5, CommanFunctions.randam(50, screenHeight - 50));
                break;
            }
        }
    }

    public void endTimer() {
        if (this.t != null) {
            this.t.cancel();
            this.t = null;
        }
    }

    protected void paint(Graphics g) {
        this.drawBackground(g);
        if (this.screen == 1) {
            this.drawUser(g);
            this.drawEnemy(g);
            this.drawGameInfo(g);
            this.drawBlast(g);
            if (this.speedIncTime) {
                g.setColor(0xFFFFFF);
                g.drawString("Increasing speed", screenWidth / 2, screenHeight / 2, 17);
            }
        } else if (this.screen == 4) {
            this.drawGameOver(g);
        } else if (this.screen == 2) {
            this.drawPause(g);
        }
        if (this.isGameOver) {
            this.screen = 4;
        }
        if (this.screen == 1) {
            this.drawBottom(g, 0);
            if (MainCanvas.isTouchEnable) {
                g.drawImage(this.backButton, screenWidth, screenHeight, 40);
            }
        } else {
            this.drawBottom(g, this.smallFontHeight);
        }
    }

    private void drawPause(Graphics g) {
        g.drawImage(this.pause, screenWidth / 2, screenHeight / 2, 3);
        this.drawBottomText(g, "Back", "Resume");
    }

    private void drawUser(Graphics g) {
        if (this.objectTemplates != null) {
            User user = (User)this.objectTemplates;
            user.paint(g);
        }
    }

    private void drawBlast(Graphics g) {
        User user = (User)this.objectTemplates;
        if (this.blast != null) {
            this.blast.paint(g);
        }
        if (Blast.isBlastEnd) {
            this.blast = null;
            Blast.isBlastEnd = false;
        }
    }

    public void resetGame() {
        User user = (User)this.objectTemplates;
        user.setSpriteIndex(0);
        user.setCordinates(0, CommanFunctions.randam(50, 100));
        this.isGameOver = false;
        this.screen = 1;
        User.isCrash = false;
        this.life = 3;
        this.startTimer();
        genrateEnemyTime = 20;
        System.out.println("resetGame");
        this.destoryAllEnymy();
    }

    private void destoryAllEnymy() {
        for (int i = 0; i < 20; ++i) {
            if (this.hadleObjects[i] == null) continue;
            this.hadleObjects[i] = null;
        }
    }

    private void drawGameInfo(Graphics g) {
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, screenWidth, this.smallFontHeight);
        g.setColor(0);
        ++this.count;
        if (this.speedIncTime && this.count % 10 == 0) {
            this.speedIncTime = false;
        }
        if (this.count % 10 == 0) {
            this.score += 5;
            if (this.count % 200 == 0) {
                ++this.speed;
                this.speedIncTime = true;
                this.increseESpeed();
                if (genrateEnemyTime > 5) {
                    genrateEnemyTime -= 2;
                }
            }
        }
        g.drawString("Score :" + this.score, 1, 1, 0);
        g.drawString("Life : " + this.life, screenWidth, 1, 24);
    }

    private void drawTop(Graphics g, int ycord) {
        if (topAdd != null) {
            if (this.isTopSelected) {
                g.setColor(Constants.selectedAdsColorCode);
                g.fillRect(0, ycord + 1, screenWidth, topAdd.getHeight() + 5);
            }
            g.drawImage(topAdd, screenWidth / 2, ycord + 2, 17);
        }
    }

    public void drawBottom(Graphics g, int cord) {
        cord1 = cord;
        if (bottomAdd != null) {
            if (this.isBottamSelected) {
                g.setColor(150, 200, 0);
                g.fillRect(0, screenHeight - (bottomAdd.getHeight() + cord + 2), screenWidth, bottomAdd.getHeight() + 4);
            }
            g.drawImage(bottomAdd, screenWidth / 2, screenHeight - cord, 33);
        }
    }

    private void drawGameOver(Graphics g) {
        g.drawString("Game Over", screenWidth / 2, screenHeight / 2, 17);
        this.drawBottomText(g, "Back", "Submit Scroe");
    }

    private void drawBottomText(Graphics g, String lText, String rText) {
        g.setColor(0xFFFFFF);
        g.fillRect(0, screenHeight - this.smallFontHeight, screenWidth, this.smallFontHeight);
        g.setColor(0);
        g.drawString(lText, screenWidth, screenHeight, 40);
        g.drawString(rText, 1, screenHeight, 36);
    }

    private void increseESpeed() {
        for (int i = 0; i < 20; ++i) {
            if (this.hadleObjects[i] == null) continue;
            int speed = HadleObjects.speed;
            this.hadleObjects[i].setSpeed(++speed);
        }
    }

    private void drawEnemy(Graphics g) {
        for (int i = 0; i < 20; ++i) {
            if (this.hadleObjects[i] == null) continue;
            this.hadleObjects[i].paint(g);
            if (!this.hadleObjects[i].isToBeNull()) continue;
            this.hadleObjects[i] = null;
        }
        this.checkCollision();
    }

    private void checkCollision() {
        User user = (User)this.objectTemplates;
        for (int i = 0; i < 20; ++i) {
            if (this.hadleObjects[i] == null || !this.hadleObjects[i].getSprite().collidesWith(this.objectTemplates.getSprite(), true)) continue;
            ++this.collisionFoundCount;
            if (this.life > 0) {
                --this.life;
            }
            this.blast = new Blast(user.getxCord(), user.getyCord());
            this.hadleObjects[i].setCordinates(-50, 0);
            if (this.collisionFoundCount != 3) continue;
            User.isCrash = true;
        }
    }

    private void drawBackground(Graphics g) {
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, screenWidth, screenHeight);
        if (this.background != null) {
            g.drawImage(this.background, this.backXCord, this.backYCord, 20);
            if (!this.isGameOver && this.screen != 2) {
                this.backXCord -= this.speed;
            }
            if (this.background.getWidth() + this.backXCord <= this.getWidth()) {
                this.backXCord = 0;
            }
        }
    }

    private void enterName() {
        Form form = new Form("Enter Name");
        this.t1 = new TextField("Enter Name", "", 50, 0);
        this.cmdSave = new Command("Save", 4, 1);
        this.cmdBack = new Command("Back", 2, 2);
        form.append((Item)this.t1);
        form.addCommand(this.cmdSave);
        form.addCommand(this.cmdBack);
        form.setCommandListener((CommandListener)this);
        ApplicationMidlet.display.setCurrent((Displayable)form);
    }

    protected void keyPressed(int keyCode) {
        switch (keyCode) {
            case -6: {
                if (this.screen == 1) break;
                if (this.screen == 4) {
                    this.enterName();
                    break;
                }
                if (this.screen != 2) break;
                this.startTimer();
                this.screen = 1;
                break;
            }
            case -7: {
                if (this.screen == 1) {
                    this.endTimer();
                    this.screen = 2;
                    break;
                }
                if (this.screen == 2) {
                    ApplicationMidlet.midlet.callMainCanvas();
                    break;
                }
                if (this.screen != 4) break;
                this.score = 0;
                ApplicationMidlet.midlet.callMainCanvas();
                break;
            }
            case -3: {
                this.keyPressNumber = 1;
                this.objectTemplates.scrollLeft();
                break;
            }
            case -4: {
                this.keyPressNumber = 2;
                this.objectTemplates.scrollRight();
                break;
            }
            case -1: {
                this.keyPressNumber = 3;
                this.objectTemplates.scrollUp();
                this.isBottamSelected = false;
                this.isTopSelected = false;
                break;
            }
            case -2: {
                this.keyPressNumber = 4;
                this.objectTemplates.scrollDown();
                this.isBottamSelected = true;
                this.isTopSelected = false;
                break;
            }
            case -5: {
                User user = (User)this.objectTemplates;
                user.scrollUpOKKey();
                if (!this.isBottamSelected) break;
                ApplicationMidlet.midlet.iOpenUrl(bottomAddURL);
            }
        }
        this.myPaint();
    }

    protected void keyReleased(int keyCode) {
        this.keyPressNumber = -1;
        User user = (User)this.objectTemplates;
        user.setSpriteIndex(0);
        user.setIsManualMngDirection(false);
    }

    private void userMovement() {
        if (this.keyPressNumber == 1) {
            this.objectTemplates.scrollLeft();
        } else if (this.keyPressNumber == 2) {
            this.objectTemplates.scrollRight();
        } else if (this.keyPressNumber == 3) {
            this.objectTemplates.scrollUp();
        } else if (this.keyPressNumber == 4) {
            this.objectTemplates.scrollDown();
        }
    }

    protected void pointerPressed(int x, int y) {
        User user = (User)this.objectTemplates;
        user.pointerPressed(x, y);
        if (bottomAdd != null && y > screenHeight - (bottomAdd.getHeight() + cord1) && y < screenHeight - cord1 && x < screenWidth - this.backButton.getWidth()) {
            ApplicationMidlet.midlet.iOpenUrl(bottomAddURL);
        }
        if (x < this.smallFont.stringWidth("privacy policy") && y > screenHeight - this.backButton.getHeight()) {
            System.out.println(" Touch On privacy policy ");
            if (this.screen == 2) {
                this.keyPressed(-6);
            }
        }
        if (x > screenWidth - this.backButton.getWidth() && y > screenHeight - this.backButton.getHeight()) {
            System.out.println(" Touch On Back Button ");
            this.keyPressed(-7);
        }
    }

    protected void pointerDragged(int x, int y) {
        User user = (User)this.objectTemplates;
        user.pointerDragged(x, y);
    }

    protected void pointerReleased(int x, int y) {
        this.keyPressNumber = -1;
        User user = (User)this.objectTemplates;
        user.setSpriteIndex(0);
        user.setIsManualMngDirection(false);
        user.pointerReleased(x, y);
    }

    public void myPaint() {
        this.repaint();
        this.userMovement();
        this.genrateEnemy();
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.cmdBack) {
            ApplicationMidlet.display.setCurrent((Displayable)this);
        } else if (c == this.cmdSave) {
            this.addScore(this.score, this.t1.getString(), this.t1.getString());
            ApplicationMidlet.midlet.callMainCanvas();
        }
        this.score = 0;
    }

    private void addScore(long iScore, String iFName, String iSName) {
        RMSGameScores iHSData = new RMSGameScores(ApplicationMidlet.midlet.mainCanvas);
        iHSData.addScore(iScore, iFName, iSName);
    }

    static {
        genrateEnemyTime = 20;
        topAddURL = "";
        bottomAddURL = "";
    }
}

