/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.core_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIAnimatedButtonV;
import baltorogames.core_gui.UIButton;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.system.ObjectsCache;
import java.util.Vector;

public class UITextBoxWithImage
extends UIScreen {
    private final int UP_ARROW_ID;
    private final int DOWN_ARROW_ID;
    protected boolean smallHeight = false;
    protected Vector textLines = new Vector();
    protected int textHeight = 0;
    protected int scrollOffset = 0;
    protected boolean scrollable = false;
    private final int SCROLL_SPEED;
    protected int fontID = 0;
    private boolean isUp = false;
    private boolean isDown = false;
    CGTexture m_BitmapTexture = null;

    private void AddArrows() {
        if (this.findByID(100) != null) {
            this.removeByID(100);
        }
        if (this.findByID(101) != null) {
            this.removeByID(101);
        }
        int n = ApplicationData.screenWidth / 2 - ObjectsCache.arrowUp.GetWidth() / 2;
        int n2 = this.positionY - ObjectsCache.arrowUp.GetWidth() - ObjectsCache.arrowUp.GetWidth() / 5;
        UIAnimatedButtonV uIAnimatedButtonV = new UIAnimatedButtonV(n, n2, ObjectsCache.arrowUp, ObjectsCache.arrowUp_a, 100);
        uIAnimatedButtonV.setScreen(this);
        uIAnimatedButtonV.setAnimDir(1);
        this.addButton(uIAnimatedButtonV);
        uIAnimatedButtonV.setVisible(false);
        n2 = this.positionY + this.height + ObjectsCache.arrowUp.GetWidth() / 5;
        UIAnimatedButtonV uIAnimatedButtonV2 = new UIAnimatedButtonV(n, n2, ObjectsCache.arrowDown, ObjectsCache.arrowDown_a, 101);
        uIAnimatedButtonV2.setScreen(this);
        uIAnimatedButtonV2.setAnimDir(-1);
        this.addButton(uIAnimatedButtonV2);
        uIAnimatedButtonV2.setVisible(false);
    }

    public UITextBoxWithImage() {
        this.UP_ARROW_ID = 100;
        this.DOWN_ARROW_ID = 101;
        this.SCROLL_SPEED = 1;
    }

    public void Configure(String string) {
        this.m_BitmapTexture = TextureManager.AddTexture(string);
        this.scrollable = true;
        this.showScrollbars(this.scrollable);
        this.fontID = 0;
        if (this.m_BitmapTexture != null) {
            this.userPositionX = 0;
            this.userPositionY = this.m_BitmapTexture.GetHeight() + ObjectsCache.arrowUp.GetHeight() / 4;
            this.userWidth = ApplicationData.screenWidth;
            this.userHeight = ApplicationData.screenHeight - ObjectsCache.menuSbBACK.GetHeight() - ObjectsCache.arrowUp.GetHeight() - this.userPositionY;
        } else {
            this.userPositionX = 0;
            this.userPositionY = ObjectsCache.menuSbBACK.GetHeight() + ObjectsCache.arrowUp.GetHeight() / 4;
            this.userWidth = ApplicationData.screenWidth;
            this.userHeight = ApplicationData.screenHeight - ObjectsCache.menuSbBACK.GetHeight() - ObjectsCache.arrowUp.GetHeight() - this.userPositionY;
        }
        this.setupDrawingArea();
        if (this.scrollable) {
            this.AddArrows();
        }
    }

    public void Configure(CGTexture cGTexture) {
        this.m_BitmapTexture = cGTexture;
        this.scrollable = true;
        this.showScrollbars(this.scrollable);
        this.fontID = 0;
        if (this.m_BitmapTexture != null) {
            this.userPositionX = 0;
            this.userPositionY = this.m_BitmapTexture.GetHeight() + ObjectsCache.arrowUp.GetHeight();
            this.userWidth = ApplicationData.screenWidth;
            this.userHeight = ApplicationData.screenHeight - ObjectsCache.menuSbBACK.GetHeight() - ObjectsCache.arrowUp.GetHeight() - this.userPositionY;
        } else {
            this.userPositionX = 0;
            this.userPositionY = ObjectsCache.menuSbBACK.GetHeight() + ObjectsCache.arrowUp.GetHeight();
            this.userWidth = ApplicationData.screenWidth;
            this.userHeight = ApplicationData.screenHeight - ObjectsCache.menuSbBACK.GetHeight() - ObjectsCache.arrowUp.GetHeight() - this.userPositionY;
        }
        this.setupDrawingArea();
        if (this.scrollable) {
            this.AddArrows();
        }
    }

    protected void setupDrawingArea() {
        this.positionX = this.userPositionX;
        this.positionY = this.userPositionY;
        this.width = this.userWidth;
        this.height = this.userHeight;
    }

    public void onUpdate(int n) {
        super.onUpdate(n);
        if (this.scrollable) {
            UIButton uIButton = this.findByID(100);
            if (uIButton != null && !uIButton.isVisible && this.scrollOffset < 0) {
                uIButton.setVisible(true);
            }
            if (uIButton != null && uIButton.isActive && uIButton.isVisible && uIButton.isSelected) {
                if (this.scrollOffset < 0) {
                    this.scrollOffset += n * 1 / 10;
                    if (this.scrollOffset > 0) {
                        this.scrollOffset = 0;
                    }
                } else {
                    uIButton.setVisible(false);
                    uIButton.setSelect(false);
                }
            }
            int n2 = -ApplicationData.getFontByID(this.fontID).getFontHeight() * (this.textLines.size() - this.height / ApplicationData.getFontByID(this.fontID).getFontHeight());
            uIButton = this.findByID(101);
            if (uIButton != null && !uIButton.isVisible && this.scrollOffset > n2) {
                uIButton.setVisible(true);
            }
            if (uIButton != null && uIButton.isActive && uIButton.isVisible && uIButton.isSelected) {
                if (this.scrollOffset > n2) {
                    this.scrollOffset -= n * 1 / 10;
                    if (this.scrollOffset < n2) {
                        this.scrollOffset = n2;
                    }
                } else {
                    uIButton.setVisible(false);
                    uIButton.setSelect(false);
                }
            }
        }
    }

    public void setText(String string, String string2) {
        this.textLines = Utils.splitText(string, string2, this.width);
        this.textHeight = this.textLines.size() * ApplicationData.getFontByID(this.fontID).getFontHeight() - ApplicationData.getFontByID(this.fontID).getFontSpacing();
        if (this.checkIfScrollsAreNeeded()) {
            this.textLines = Utils.splitText(string, string2, this.width);
            this.textHeight = this.textLines.size() * ApplicationData.getFontByID(this.fontID).getFontHeight();
        }
    }

    public void setText(String string) {
        this.setText(string, "+");
    }

    private boolean checkIfScrollsAreNeeded() {
        this.showScrollbars = this.scrollable = this.textHeight > this.height;
        return this.scrollable;
    }

    public void drawWindowBackground() {
    }

    public void drawWindowForeground() {
    }

    public void draw() {
        if (this.m_BitmapTexture != null) {
            Graphic2D.DrawImage(this.m_BitmapTexture, ApplicationData.screenWidth / 2, 0, 17);
        }
        int n = ApplicationData.getFontByID(this.fontID).getFontHeight();
        int n2 = 0;
        if (!this.scrollable) {
            n2 = (this.height - n * this.textLines.size()) / 2;
        }
        Graphic2D.SetClip(this.positionX, this.positionY, this.width, this.height);
        for (int i = 0; i < this.textLines.size(); ++i) {
            int n3 = this.positionY + i * n + this.scrollOffset + n2;
            if (n3 < 0 || n3 > ApplicationData.screenHeight) continue;
            if (!this.showScrollbars) {
                Utils.drawString((String)this.textLines.elementAt(i), this.positionX + this.width / 2, n3, 17, this.fontID);
                continue;
            }
            Utils.drawString((String)this.textLines.elementAt(i), this.positionX + this.width / 2, n3, 17, this.fontID);
        }
        Graphic2D.SetClip(0, 0, ApplicationData.screenWidth, ApplicationData.screenHeight);
    }

    public boolean actionSoftButton(int n) {
        return false;
    }

    public boolean rightSoftButton() {
        if (this.findByID(UIScreen.ID_BUTTON_CANCEL) != null && this.parentScreen != null) {
            this.readyForClose = true;
            return true;
        }
        return false;
    }

    public boolean leftSoftButton() {
        if (this.findByID(UIScreen.ID_BUTTON_OK) != null && this.parentScreen != null) {
            this.readyForClose = true;
            return true;
        }
        return false;
    }

    public boolean onFireAction() {
        return this.leftSoftButton();
    }

    public boolean selectDownAction() {
        if (this.scrollable) {
            UIButton uIButton = this.findByID(101);
            if (uIButton != null) {
                uIButton.setSelect(true);
            }
            this.isUp = false;
            this.isDown = true;
            return true;
        }
        return false;
    }

    public boolean onDownAction() {
        if (this.scrollable) {
            this.isDown = false;
            return true;
        }
        return false;
    }

    public boolean selectUpAction() {
        if (this.scrollable) {
            UIButton uIButton = this.findByID(100);
            if (uIButton != null) {
                uIButton.setSelect(true);
            }
            this.isUp = true;
            this.isDown = false;
            return true;
        }
        return false;
    }

    public boolean onUpAction() {
        if (this.scrollable) {
            this.isUp = false;
            return true;
        }
        return false;
    }

    public void updateSize() {
    }

    public void autoSize() {
    }

    public void onFocusBack() {
        super.onFocusBack();
    }
}

