/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIButton;
import baltorogames.core_gui.UICheckButton;
import baltorogames.project_gui.MainScreen;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Platform;

public class EditNickScreen
extends MainScreen {
    private final int START_BUTTON_ID;
    private final int DEFAULT_EDIT_TEXT_LENGTH;
    private int editTextMaxLength = 7;
    public static int cellSize = 20;
    protected String editableText;
    private int currentX = 0;
    private int currentY = 0;
    private boolean firstTime = true;
    private long lastKeyPressedTime = 0L;
    private static boolean qwertyEncoded = false;
    private static String[][] qwerty = new String[][]{{"A", "B", "C", "D", "E", "F", "G"}, {"H", "I", "J", "K", "L", "M", "N"}, {"O", "P", "Q", "R", "S", "T", "U"}, {"V", "W", "X", "Y", "Z", " ", "#"}};
    int lastKeyPressed = -1;
    int numPresses = 0;
    long timeOfLastPress = 0L;
    String previewChar = "";
    boolean flash = true;

    public EditNickScreen(String string) {
        this.START_BUTTON_ID = 1000;
        this.DEFAULT_EDIT_TEXT_LENGTH = 7;
        this.editableText = string;
        if (!qwertyEncoded) {
            qwertyEncoded = true;
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 7; ++j) {
                    EditNickScreen.qwerty[i][j] = ApplicationData.defaultFont.encodeDynamicString(qwerty[i][j]);
                }
            }
        }
        this.createButtons();
        this.currentX = 0;
        this.currentY = 0;
        this.uncheckAllButtons();
        UIButton uIButton = this.findByID(1000 + this.currentY * 7 + this.currentX);
        if (uIButton != null) {
            uIButton.setCheck(true);
        }
    }

    private void createButtons() {
        int n = ApplicationData.screenWidth / 2 - 120;
        int n2 = 3 * ObjectsCache.keyboard_std.GetHeight() / 2;
        int n3 = ApplicationData.screenHeight - 64 - 5 * n2;
        int n4 = 1000;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 7; ++j) {
                int n5 = n + j * 34 + ObjectsCache.keyboard_std.GetWidth() / 2;
                int n6 = n3 + i * n2;
                UICheckButton uICheckButton = new UICheckButton(n5, n6, ObjectsCache.keyboard_std, ObjectsCache.keyboard_hgh, ObjectsCache.keyboard_std, n4);
                uICheckButton.setCaption(qwerty[i][j]);
                this.addButton(uICheckButton);
                ++n4;
            }
        }
    }

    public void autoSize() {
        this.clientAreaX = Platform.WND_MARGIN_LEFT;
        this.clientAreaWidth = this.width - Platform.WND_MARGIN_LEFT - Platform.WND_MARGIN_RIGHT;
        this.clientAreaY = Platform.WND_MARGIN_TOP;
        this.clientAreaHeight = this.height - Platform.WND_MARGIN_TOP - Platform.WND_MARGIN_BOTTOM;
    }

    public void draw() {
        int n = this.lifeTime % 2;
        String string = this.editableText + ApplicationData.defaultFont.encodeDynamicString(n == 0 ? " " : "_");
        int n2 = ObjectsCache.keyboard_std.GetHeight();
        int n3 = ApplicationData.screenHeight - 64 - n2;
        Utils.drawString(string, ApplicationData.screenWidth / 3, n3, 36, 0);
    }

    private void addChar(String string) {
        if (this.editableText.length() < this.editTextMaxLength) {
            this.editableText = this.editableText + string;
        }
    }

    public boolean actionSoftButton(int n, boolean bl) {
        if (super.actionSoftButton(n, bl)) {
            if (n >= 1000) {
                if (ApplicationData.getAppTime() - this.lastKeyPressedTime < 400L) {
                    return false;
                }
                int n2 = n - 1000;
                this.currentX = n2 % 7;
                this.currentY = n2 / 7;
                if (this.currentX == 6 && this.currentY == 3) {
                    this.lastKeyPressed = -1;
                    this.numPresses = 0;
                    if (this.firstTime) {
                        this.editableText = "";
                    } else if (this.editableText.length() > 0) {
                        this.editableText = this.editableText.substring(0, this.editableText.length() - 1);
                    }
                    this.lastKeyPressedTime = ApplicationData.getAppTime();
                } else {
                    this.addChar(qwerty[this.currentY][this.currentX]);
                    this.lastKeyPressedTime = ApplicationData.getAppTime();
                }
                this.uncheckAllButtons();
                UIButton uIButton = this.findByID(n);
                if (uIButton != null) {
                    uIButton.setCheck(true);
                }
                this.firstTime = false;
            }
            return true;
        }
        return false;
    }

    public boolean onLeftAction() {
        --this.currentX;
        if (this.currentX < 0) {
            this.currentX = 6;
        }
        this.uncheckAllButtons();
        UIButton uIButton = this.findByID(1000 + this.currentY * 7 + this.currentX);
        if (uIButton != null) {
            uIButton.setCheck(true);
        }
        return true;
    }

    public boolean onRightAction() {
        ++this.currentX;
        if (this.currentX > 6) {
            this.currentX = 0;
        }
        this.uncheckAllButtons();
        UIButton uIButton = this.findByID(1000 + this.currentY * 7 + this.currentX);
        if (uIButton != null) {
            uIButton.setCheck(true);
        }
        return true;
    }

    public boolean onUpAction() {
        --this.currentY;
        if (this.currentY < 0) {
            this.currentY = 3;
        }
        this.uncheckAllButtons();
        UIButton uIButton = this.findByID(1000 + this.currentY * 7 + this.currentX);
        if (uIButton != null) {
            uIButton.setCheck(true);
        }
        return true;
    }

    public boolean onDownAction() {
        ++this.currentY;
        if (this.currentY > 3) {
            this.currentY = 0;
        }
        this.uncheckAllButtons();
        UIButton uIButton = this.findByID(1000 + this.currentY * 7 + this.currentX);
        if (uIButton != null) {
            uIButton.setCheck(true);
        }
        return true;
    }

    public boolean selectFireAction() {
        return false;
    }

    public boolean onFireAction() {
        if (this.currentX == 6 && this.currentY == 3) {
            this.lastKeyPressed = -1;
            this.numPresses = 0;
            if (this.firstTime) {
                this.editableText = "";
            } else if (this.editableText.length() > 0) {
                this.editableText = this.editableText.substring(0, this.editableText.length() - 1);
            }
        } else {
            this.addChar(qwerty[this.currentY][this.currentX]);
        }
        this.firstTime = false;
        return true;
    }
}

