/*
 * Decompiled with CFR 0.152.
 */
package BTConnect;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DataElement;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;

public class BTClient
implements DiscoveryListener {
    private DiscoveryAgent discoveryAgent;
    private RemoteDevice[] remoteDevices;
    private UUID[] uuidSet;
    public String serviceUrl = null;
    public DataInputStream input = null;
    public DataOutputStream output;
    private StreamConnection conn = null;
    private static final String myServiceUUID = "2d26618601fb47c28d9f10b8ec891363";
    public static final UUID RFCOMM_UUID = new UUID("2d26618601fb47c28d9f10b8ec891363", false);
    public boolean iConnected = false;
    public boolean inqCompleate = false;
    public boolean ssRunning = false;
    public Vector discoveredDevices;

    public BTClient() {
        this.init();
    }

    private void init() {
        this.discoveredDevices = new Vector();
        try {
            LocalDevice localDevice = LocalDevice.getLocalDevice();
            this.discoveryAgent = localDevice.getDiscoveryAgent();
            this.discoveryAgent.startInquiry(10390323, (DiscoveryListener)this);
        }
        catch (BluetoothStateException ex) {
            this.init();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void deviceDiscovered(RemoteDevice btDevice, DeviceClass cod) {
        try {
            this.discoveredDevices.addElement(btDevice);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void inquiryCompleted(int discType) {
        this.inqCompleate = true;
    }

    public void discoverService() {
        this.ssRunning = true;
        this.uuidSet = new UUID[1];
        this.uuidSet[0] = RFCOMM_UUID;
        try {
            if (this.discoveredDevices.size() > 0) {
                this.discoveryAgent.searchServices(null, this.uuidSet, (RemoteDevice)this.discoveredDevices.elementAt(0), (DiscoveryListener)this);
            }
        }
        catch (BluetoothStateException e) {
            e.printStackTrace();
        }
    }

    public void servicesDiscovered(int transID, ServiceRecord[] servRecord) {
        this.serviceUrl = servRecord[0].getConnectionURL(0, false);
        if (this.serviceUrl == null || this.serviceUrl.equals(null)) {
            ServiceRecord record = servRecord[0];
            DataElement protocolDescriptorList = record.getAttributeValue(4);
            Enumeration e = (Enumeration)protocolDescriptorList.getValue();
            e.nextElement();
            DataElement protocolDescriptorRFCOMM = (DataElement)e.nextElement();
            e = (Enumeration)protocolDescriptorRFCOMM.getValue();
            e.nextElement();
            DataElement channelRFCOMM = (DataElement)e.nextElement();
            long channel = channelRFCOMM.getLong();
            StringBuffer nameBuffer = new StringBuffer(69);
            nameBuffer.append("btspp");
            nameBuffer.append("://");
            nameBuffer.append(record.getHostDevice().getBluetoothAddress());
            nameBuffer.append(":");
            nameBuffer.append(channel);
            nameBuffer.append(";authenticate=false");
            nameBuffer.append(";encrypt=false");
            nameBuffer.append(";master=false");
            this.serviceUrl = nameBuffer.toString();
        }
    }

    public void serviceSearchCompleted(int transID, int responseCode) {
        if (responseCode == 3) {
            // empty if block
        }
        if (responseCode == 2) {
            // empty if block
        }
        if (responseCode == 4) {
            // empty if block
        }
        if (responseCode == 6) {
            // empty if block
        }
        if (responseCode == 1 && this.serviceUrl != null) {
            this.ssRunning = false;
            return;
        }
        if (this.discoveredDevices.size() > 0) {
            this.discoveredDevices.removeElementAt(0);
        }
        this.ssRunning = false;
    }

    public void connect() {
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        try {
            this.conn = (StreamConnection)Connector.open((String)this.serviceUrl);
            this.output = this.conn.openDataOutputStream();
            this.input = this.conn.openDataInputStream();
            this.iConnected = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

