/*
 * Decompiled with CFR 0.152.
 */
package GameEngine;

import Audio.BackgroundMusic;
import BTConnect.BTClient;
import BTConnect.BTServer;
import GameEngine.ImageResizer;
import GameEngine.SpriteProcessor;
import MIDlet.GrizzleDizzleMIDlet;
import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.media.MediaException;

public class GameEngine
extends GameCanvas
implements Runnable,
CommandListener {
    private GrizzleDizzleMIDlet iMidlet;
    private Command cmdExit;
    private int iMenuState;
    private int iGameState;
    private boolean iShotFired;
    private boolean iExit;
    private Random iRandom = new Random();
    private int iWhoHasWonGame = 0;
    private boolean iIsActive = false;
    private int iHeight;
    private int iWidth;
    private BTClient btClient = null;
    private BTServer btServer = null;
    private SpriteProcessor spriteContainer;
    private BackgroundMusic iMusic;
    private int iBlinkRestrictor;
    public boolean iIsSinglePlayer;

    public GameEngine(GrizzleDizzleMIDlet aMidlet) {
        super(true);
        this.setFullScreenMode(true);
        this.iMidlet = aMidlet;
        this.cmdExit = new Command("Exit", 7, 0);
        this.addCommand(this.cmdExit);
        this.setCommandListener(this);
    }

    public void init() {
        this.iWidth = this.getWidth();
        this.iHeight = this.getHeight();
        this.iIsActive = true;
        Thread t = new Thread(this);
        t.start();
    }

    public void run() {
        try {
            this.iMusic = new BackgroundMusic();
        }
        catch (MediaException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this.iMidlet.exit();
        }
        this.showStartScreen();
        this.spriteContainer = new SpriteProcessor(this.iHeight, this.iWidth);
        while (this.iIsActive) {
            if (this.iGameState == 0) {
                this.iMusic.playTitleSong();
                this.processMenuKeys(this.getKeyStates());
                this.rabbitBlinks(this.spriteContainer.iMenuBackground, 50);
                this.drawLayers();
            }
            if (this.iGameState == 1) {
                this.processGameKeys(this.getKeyStates());
                this.processMovement();
            }
            if (this.iGameState == 4) {
                this.rabbitBlinks(this.spriteContainer.iAbout, 200000);
            }
            if (this.iGameState == 5 || this.iGameState == 6) {
                if (this.btServer != null || this.iIsSinglePlayer) {
                    this.processGameKeys(this.getKeyStates());
                }
                if (this.iWhoHasWonGame == 0) {
                    this.iGameState = 1;
                    this.spriteContainer.resetGame();
                }
            }
            this.btExchange();
            this.checkGameOver();
        }
    }

    private void processMenuKeys(int aKeyStates) {
        switch (aKeyStates) {
            case 4: {
                break;
            }
            case 32: {
                break;
            }
            case 64: {
                if (this.iMenuState >= 4) break;
                ++this.iMenuState;
                this.spriteContainer.moveSelector(this.iMenuState);
                break;
            }
            case 2: {
                if (this.iMenuState <= 0) break;
                --this.iMenuState;
                this.spriteContainer.moveSelector(this.iMenuState);
                break;
            }
            case 256: {
                this.select();
            }
        }
    }

    private void processGameKeys(int aKeyStates) {
        switch (aKeyStates) {
            case 4: {
                if (this.btServer != null || this.iIsSinglePlayer) {
                    this.spriteContainer.moveServerLeft();
                    break;
                }
                if (this.btClient == null) break;
                this.spriteContainer.moveClientLeft();
                break;
            }
            case 32: {
                if (this.btServer != null || this.iIsSinglePlayer) {
                    this.spriteContainer.moveServerRight();
                    break;
                }
                if (this.btClient == null) break;
                this.spriteContainer.moveClientRight();
                break;
            }
            case 64: {
                this.iMusic.stopTitleSong();
                break;
            }
            case 2: {
                this.iMusic.playTitleSong();
                break;
            }
            case 256: {
                if (!this.iShotFired) {
                    if (this.btClient != null && this.spriteContainer.iClientShot.getY() < 0) {
                        this.iShotFired = true;
                    }
                    if ((this.btServer != null || this.iIsSinglePlayer) && !this.spriteContainer.iIsServerShotActive) {
                        this.spriteContainer.releaseShotServer(true);
                    }
                    this.spriteContainer.iSFX.playWuidSound();
                }
                if (this.iGameState != 5 && this.iGameState != 6) break;
                this.iGameState = 1;
                this.iWhoHasWonGame = 0;
                if (!this.iIsSinglePlayer) break;
                this.spriteContainer.resetGame();
            }
        }
    }

    private void select() {
        Graphics g = this.getGraphics();
        g.setColor(0, 0, 0);
        g.setFont(Font.getFont((int)32, (int)1, (int)8));
        this.spriteContainer.iSFX.playDoingSound();
        switch (this.iMenuState) {
            case 0: {
                System.out.println("### START SERVER");
                this.iGameState = 2;
                this.drawLayers();
                try {
                    this.spriteContainer.iWait.nextFrame();
                    Thread.sleep(1000L);
                    this.drawLayers();
                    this.spriteContainer.iWait.nextFrame();
                    Thread.sleep(1000L);
                    this.drawLayers();
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
                g.drawString("    waiting for player...", 10, 10, 20);
                this.flushGraphics();
                this.btServer = new BTServer();
                this.iMusic.stopTitleSong();
                break;
            }
            case 1: {
                System.out.println("### START CLIENT");
                this.iGameState = 2;
                this.drawLayers();
                this.btClient = new BTClient();
                g.drawString("searching devices", 10, 10, 20);
                this.flushGraphics();
                try {
                    this.spriteContainer.iWait.nextFrame();
                    Thread.sleep(1000L);
                    this.drawLayers();
                    this.spriteContainer.iWait.nextFrame();
                    Thread.sleep(1000L);
                    this.drawLayers();
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
                while (!this.btClient.inqCompleate) {
                }
                g.drawString("found (" + this.btClient.discoveredDevices.size() + ") devices", 10, 30, 20);
                this.flushGraphics();
                int maxDevices = this.btClient.discoveredDevices.size();
                for (int i = 0; i < maxDevices; ++i) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                    this.btClient.discoverService();
                    this.drawLayers();
                    g.drawString("service search on (" + (i + 1) + ")", 10, 10, 20);
                    this.flushGraphics();
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                    while (this.btClient.ssRunning) {
                    }
                    if (this.btClient.serviceUrl == null) continue;
                    g.drawString("Connecting!", 10, 30, 20);
                    this.btClient.connect();
                    this.iMusic.stopTitleSong();
                    return;
                }
                break;
            }
            case 2: {
                this.iGameState = 1;
                this.iIsSinglePlayer = true;
                this.iMusic.stopTitleSong();
                return;
            }
            case 3: {
                this.iGameState = 4;
                break;
            }
            case 4: {
                this.stop();
                this.iMidlet.exit();
            }
        }
    }

    private void rabbitBlinks(Sprite _spr, int spastic) {
        ++this.iBlinkRestrictor;
        if (this.iBlinkRestrictor > 1000000) {
            this.iBlinkRestrictor = 0;
        }
        if (this.iRandom.nextInt(100) == 50 && this.iBlinkRestrictor > spastic) {
            _spr.nextFrame();
            this.drawLayers();
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            _spr.nextFrame();
            this.drawLayers();
            this.iBlinkRestrictor = 0;
        }
    }

    private void drawLayers() {
        Graphics g = this.getGraphics();
        if (this.iGameState == 0) {
            this.spriteContainer.getMenuLayer().paint(g, 0, 0);
        }
        if (this.iGameState == 1 || this.iGameState == 10) {
            this.spriteContainer.getGameLayer().paint(g, 0, 0);
            this.spriteContainer.getLevelLayer().paint(g, 0, 0);
            this.spriteContainer.iSmashRabbit.paint(g);
        }
        if (this.iGameState == 2) {
            this.spriteContainer.getWaitLayer().paint(g, 0, 0);
        }
        if (this.iGameState == 4) {
            this.spriteContainer.getInfoLayer().paint(g, 0, 0);
        }
        if (this.iGameState == 5) {
            this.spriteContainer.getGameLayer().getLayerAt(6).paint(g);
            if (this.spriteContainer.iLooser.getFrame() == 0) {
                this.spriteContainer.iLooser.paint(g);
                this.flushGraphics();
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
            this.spriteContainer.iLooser.setFrame(1);
            this.spriteContainer.iLooser.paint(g);
        }
        if (this.iGameState == 6) {
            this.spriteContainer.getGameLayer().getLayerAt(6).paint(g);
            if (this.btServer != null || this.iIsSinglePlayer) {
                this.spriteContainer.iWinnerServer.paint(g);
                this.spriteContainer.iWinnerServer.nextFrame();
            } else {
                this.spriteContainer.iWinnerClient.paint(g);
                this.spriteContainer.iWinnerClient.nextFrame();
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        this.flushGraphics();
    }

    private void btExchange() {
        if (this.btServer == null && this.btClient == null && !this.iIsSinglePlayer) {
            return;
        }
        if (this.iGameState == 2 && (this.btServer != null && this.btServer.iConnected || this.btClient != null && this.btClient.iConnected)) {
            this.iGameState = 1;
            this.drawLayers();
            return;
        }
        if (this.btClient != null && this.btClient.iConnected) {
            try {
                this.bluetoothSend();
                this.bluetoothReceive();
                if (this.iExit) {
                    this.exitGame();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            long tx = System.currentTimeMillis();
            this.drawLayers();
            long delta_t1 = System.currentTimeMillis();
            this.spriteContainer.clientGameLogic();
            return;
        }
        if (this.btServer != null && this.btServer.iConnected) {
            try {
                this.bluetoothReceive();
                this.bluetoothSend();
                if (this.iExit) {
                    this.exitGame();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.drawLayers();
            this.spriteContainer.serverGameLogic();
            this.serverCheckGameplay();
            return;
        }
        if (this.iIsSinglePlayer) {
            this.spriteContainer.singlePlayerGameLogic();
            this.spriteContainer.moveEnemySinglePlayerMode();
            this.serverCheckGameplay();
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        this.drawLayers();
    }

    private void bluetoothSend() throws IOException {
        if (this.btServer == null && this.btClient == null) {
            return;
        }
        if (this.btClient != null && this.btClient.iConnected) {
            this.btClient.output.writeShort((int)((double)(this.spriteContainer.iClient.getRefPixelX() - (this.iWidth - this.spriteContainer.iGameBackgroundWidth) / 2) * this.spriteContainer.scaleWidth * 1000.0));
            this.btClient.output.writeBoolean(this.iShotFired);
            this.btClient.output.writeBoolean(this.iExit);
            this.iShotFired = false;
            this.btClient.output.flush();
        }
        if (this.btServer != null && this.btServer.iConnected) {
            this.btServer.output.writeShort((int)((double)(this.spriteContainer.iServer.getRefPixelX() - (this.iWidth - this.spriteContainer.iGameBackgroundWidth) / 2) * this.spriteContainer.scaleWidth * 1000.0));
            this.btServer.output.writeShort((int)((double)(this.spriteContainer.iBall.getRefPixelX() - (this.iWidth - this.spriteContainer.iGameBackgroundWidth) / 2) * this.spriteContainer.scaleWidth * 1000.0));
            this.btServer.output.writeShort((int)((double)this.spriteContainer.iBall.getRefPixelY() / (double)this.iHeight * 1000.0));
            this.btServer.output.writeShort((int)((double)(this.spriteContainer.getLevelLayer().getLayerAt(0).getX() - (this.iWidth - this.spriteContainer.iGameBackgroundWidth) / 2) * this.spriteContainer.scaleWidth * 1000.0));
            this.btServer.output.writeShort((int)((double)this.spriteContainer.getLevelLayer().getLayerAt(0).getY() / (double)this.iHeight * 1000.0));
            this.btServer.output.writeShort((int)((double)(this.spriteContainer.getLevelLayer().getLayerAt(1).getX() - (this.iWidth - this.spriteContainer.iGameBackgroundWidth) / 2) * this.spriteContainer.scaleWidth * 1000.0));
            this.btServer.output.writeShort((int)((double)this.spriteContainer.getLevelLayer().getLayerAt(1).getY() / (double)this.iHeight * 1000.0));
            this.btServer.output.writeShort((int)((double)(this.spriteContainer.iServerShot.getRefPixelX() - (this.iWidth - this.spriteContainer.iGameBackgroundWidth) / 2) * this.spriteContainer.scaleWidth * 1000.0));
            this.btServer.output.writeShort((int)((double)this.spriteContainer.iServerShot.getRefPixelY() / (double)this.iHeight * 1000.0));
            this.btServer.output.writeShort((int)((double)(this.spriteContainer.iClientShot.getRefPixelX() - (this.iWidth - this.spriteContainer.iGameBackgroundWidth) / 2) * this.spriteContainer.scaleWidth * 1000.0));
            this.btServer.output.writeShort((int)((double)this.spriteContainer.iClientShot.getRefPixelY() / (double)this.iHeight * 1000.0));
            this.btServer.output.writeShort(this.iWhoHasWonGame);
            this.btServer.output.writeBoolean(this.spriteContainer.iShowRabbitOnClient);
            this.spriteContainer.iShowRabbitOnClient = false;
            this.btServer.output.writeBoolean(this.iExit);
            this.btServer.output.flush();
        }
    }

    private void bluetoothReceive() throws IOException {
        if (this.btServer == null && this.btClient == null) {
            return;
        }
        if (this.btServer != null && this.btServer.iConnected) {
            this.spriteContainer.iClient.setRefPixelPosition((int)((double)((this.iWidth - this.spriteContainer.iGameBackgroundWidth) / 2) + (double)this.spriteContainer.iGameBackgroundWidth * ((double)this.btServer.input.readShort() / 1000.0)), this.spriteContainer.iClient.getRefPixelY());
            if (this.btServer.input.readBoolean()) {
                this.spriteContainer.releaseShotClient(true);
            }
            if (this.btServer.input.readBoolean()) {
                this.exitGame();
            }
        }
        if (this.btClient != null && this.btClient.iConnected) {
            this.spriteContainer.iServer.setRefPixelPosition((int)((double)(this.iWidth - this.spriteContainer.iGameBackgroundWidth >> 1) + (double)this.spriteContainer.iGameBackgroundWidth * ((double)this.btClient.input.readShort() / 1000.0)), this.spriteContainer.iServer.getRefPixelY());
            this.spriteContainer.iBall.setRefPixelPosition((int)((double)(this.iWidth - this.spriteContainer.iGameBackgroundWidth >> 1) + (double)this.spriteContainer.iGameBackgroundWidth * ((double)this.btClient.input.readShort() / 1000.0)), (int)((double)this.iHeight * ((double)this.btClient.input.readShort() / 1000.0)));
            this.spriteContainer.getLevelLayer().getLayerAt(0).setPosition((int)((double)(this.iWidth - this.spriteContainer.iGameBackgroundWidth >> 1) + (double)this.spriteContainer.iGameBackgroundWidth * ((double)this.btClient.input.readShort() / 1000.0)), (int)((double)this.iHeight * ((double)this.btClient.input.readShort() / 1000.0)));
            this.spriteContainer.getLevelLayer().getLayerAt(1).setPosition((int)((double)(this.iWidth - this.spriteContainer.iGameBackgroundWidth >> 1) + (double)this.spriteContainer.iGameBackgroundWidth * ((double)this.btClient.input.readShort() / 1000.0)), (int)((double)this.iHeight * ((double)this.btClient.input.readShort() / 1000.0)));
            this.spriteContainer.iServerShot.setRefPixelPosition((int)((double)(this.iWidth - this.spriteContainer.iGameBackgroundWidth >> 1) + (double)this.spriteContainer.iGameBackgroundWidth * ((double)this.btClient.input.readShort() / 1000.0)), (int)((double)this.iHeight * ((double)this.btClient.input.readShort() / 1000.0)));
            this.spriteContainer.iClientShot.setRefPixelPosition((int)((double)(this.iWidth - this.spriteContainer.iGameBackgroundWidth >> 1) + (double)this.spriteContainer.iGameBackgroundWidth * ((double)this.btClient.input.readShort() / 1000.0)), (int)((double)this.iHeight * ((double)this.btClient.input.readShort() / 1000.0)));
            this.iWhoHasWonGame = this.btClient.input.readShort();
            this.spriteContainer.iShowRabbitOnClient = this.btClient.input.readBoolean();
            if (this.btClient.input.readBoolean()) {
                this.exitGame();
            }
        }
    }

    private void processMovement() {
        if (this.btServer != null && this.btServer.iConnected) {
            this.spriteContainer.processServerMovement();
        } else if (this.btClient != null && this.btClient.iConnected) {
            this.spriteContainer.processClientMovement();
        } else if (this.iIsSinglePlayer) {
            this.spriteContainer.processServerMovement();
        }
    }

    public void stop() {
        this.iIsActive = false;
    }

    private void showStartScreen() {
        Graphics g = this.getGraphics();
        ImageResizer resizer = new ImageResizer(this.iWidth, this.iHeight);
        Sprite startScreen = null;
        Object imageBounce = null;
        Sprite dance = null;
        this.iMusic.playTitleSong();
        try {
            startScreen = new Sprite(resizer.fixBackgroundImageToScreen(Image.createImage((String)"/resGFX/start.png")));
            int[] frameSequece = new int[]{0, 1, 2, 1};
            dance = resizer.scaleAnimatedSpriteInAutoRatioToScreen(Image.createImage((String)"/resGFX/mov.png"), 3);
            dance.defineReferencePixel(dance.getWidth() / 2, dance.getHeight() / 2);
            dance.setRefPixelPosition(this.iWidth / 2, this.iHeight / 2);
            dance.setFrameSequence(frameSequece);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        for (int i = 0; i < 40; ++i) {
            startScreen.paint(g);
            dance.paint(g);
            this.flushGraphics();
            dance.nextFrame();
            try {
                Thread.sleep(40L);
                continue;
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        g.setColor(0, 0, 0);
        g.setFont(Font.getFont((int)64, (int)1, (int)16));
        g.drawString("Loading ...", this.iWidth / 2, this.iHeight * 2 / 3, 17);
        this.flushGraphics();
    }

    private void checkGameOver() {
        if (this.iIsSinglePlayer) {
            if (this.iWhoHasWonGame == 1) {
                this.displayGameOutcome(false);
            }
            if (this.iWhoHasWonGame == 2) {
                this.displayGameOutcome(true);
            }
        }
        if (this.btClient != null) {
            if (this.iWhoHasWonGame == 1) {
                this.displayGameOutcome(false);
            }
            if (this.iWhoHasWonGame == 2) {
                this.displayGameOutcome(true);
            }
        }
        if (this.btServer != null) {
            if (this.iWhoHasWonGame == 2) {
                this.displayGameOutcome(false);
            }
            if (this.iWhoHasWonGame == 1) {
                this.displayGameOutcome(true);
            }
        }
    }

    private void displayGameOutcome(boolean isWinner) {
        this.iGameState = isWinner ? 5 : 6;
    }

    private void serverCheckGameplay() {
        for (int i = 0; i < this.spriteContainer.getLevelLayer().getSize(); ++i) {
            Sprite temp = (Sprite)this.spriteContainer.getLevelLayer().getLayerAt(i);
            if (temp.getRefPixelY() < this.iHeight / 6) {
                this.iWhoHasWonGame = this.btServer != null ? 2 : 1;
            }
            if (temp.getRefPixelY() <= this.iHeight - this.iHeight / 6) continue;
            this.iWhoHasWonGame = this.btClient != null ? 1 : 2;
        }
    }

    private void exitGame() {
        this.btServer = null;
        this.btClient = null;
        this.iIsSinglePlayer = false;
        this.iGameState = 0;
        this.iMusic.playTitleSong();
        this.spriteContainer.resetGame();
        this.iExit = false;
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.cmdExit) {
            if (this.iGameState == 0) {
                this.stop();
                this.iMidlet.exit();
            } else if (this.iGameState == 1 && this.btServer == null && this.btClient == null) {
                this.iGameState = 0;
                this.spriteContainer.resetGame();
            } else if (this.iGameState == 2) {
                this.iGameState = 0;
                this.btServer = null;
                this.btClient = null;
            } else if (this.iGameState == 4) {
                this.iGameState = 0;
            } else {
                this.iExit = true;
            }
        }
    }
}

