/*
 * Decompiled with CFR 0.152.
 */
package com.george.games.menus;

import com.george.games.Drawable;
import com.george.games.Tasks;
import com.george.headfall.AD;
import com.george.headfall.Ads;
import com.george.headfall.HeadFallRes;
import com.george.headfall.Main;
import com.george.headfall.Viewport;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class ADSScreen
implements Drawable {
    private Tasks skipTask;
    private Sprite go;
    private Sprite skip;
    private Sprite spAD;
    private AD ad;
    private Sprite pointer;
    private Vector vecSprites;
    private int selectedIndex;

    public static ADSScreen getADSScreen(Tasks skipTask) {
        if (!Main.WITHADDS) {
            return null;
        }
        AD d = Ads.getInstance().getAD();
        if (d == null) {
            return null;
        }
        return new ADSScreen(d, skipTask);
    }

    private ADSScreen(AD ad, Tasks skipTask) {
        this.ad = ad;
        this.skipTask = skipTask;
        this.go = new Sprite(HeadFallRes.GO);
        this.skip = new Sprite(HeadFallRes.SKIP);
        this.go.setPosition(Viewport.WIDTH - this.go.getWidth() - 10, Viewport.HEIGHT - this.go.getHeight() - 10);
        this.skip.setPosition(10, Viewport.HEIGHT - this.skip.getHeight() - 10);
        this.pointer = new Sprite(Image.createImage((int)5, (int)5));
        this.spAD = new Sprite(ad.getImage());
        this.spAD.setPosition(Viewport.WIDTH / 2 - this.spAD.getWidth() / 2, Viewport.HEIGHT / 2 - this.spAD.getHeight() / 2);
        this.vecSprites = new Vector();
        this.vecSprites.addElement(this.spAD);
        this.vecSprites.addElement(this.go);
        this.vecSprites.addElement(this.skip);
    }

    public void cycle() {
    }

    public void draw(Graphics g) {
        g.drawImage(HeadFallRes.ADBG, 0, 0, 0);
        this.spAD.paint(g);
        this.go.paint(g);
        this.skip.paint(g);
        this.drawSelected(g);
    }

    public void pointerPressed(int x, int y) {
    }

    public void pointerReleased(int x, int y) {
        this.pointer.setPosition(x, y);
        if (this.pointer.collidesWith(this.go, false)) {
            try {
                Main.midlet.platformRequest(this.ad.getUrl());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.skipTask.execute();
        } else if (this.pointer.collidesWith(this.spAD, false)) {
            try {
                Main.midlet.platformRequest(this.ad.getUrl());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.skipTask.execute();
        } else if (this.pointer.collidesWith(this.skip, false)) {
            this.skipTask.execute();
        }
        this.pointer.setPosition(-5, -5);
    }

    public void pointerDragged(int x, int y) {
    }

    public void keyPressed(int keyCode) {
        int k = Main.container.getGameAction(keyCode);
        if (k == 6) {
            this.selectedIndex = (this.selectedIndex + 1) % this.vecSprites.size();
        } else if (k == 1) {
            --this.selectedIndex;
            if (this.selectedIndex < 0) {
                this.selectedIndex = this.vecSprites.size() - 1;
            }
        } else if (k == 8) {
            Sprite sp = (Sprite)this.vecSprites.elementAt(this.selectedIndex);
            this.pointerReleased(sp.getX(), sp.getY());
        }
        Main.container.repaint();
    }

    public void input(int keyStates) {
    }

    private void drawSelected(Graphics g) {
        if (Main.TOUCH_SUPPORT) {
            return;
        }
        Sprite sp = (Sprite)this.vecSprites.elementAt(this.selectedIndex);
        g.setColor(16253967);
        g.drawRect(sp.getX(), sp.getY(), sp.getWidth() - 2, sp.getHeight() - 2);
        g.drawRect(sp.getX() + 1, sp.getY() + 1, sp.getWidth() - 4, sp.getHeight() - 4);
    }
}

