/*
 * Decompiled with CFR 0.152.
 */
package com.george.headfall;

import com.george.games.Container;
import com.george.games.Drawable;
import com.george.games.Point;
import com.george.games.Tasks;
import com.george.games.menus.OverMenu;
import com.george.games.menus.PauseMenu;
import com.george.games.menus.SuccessMenu;
import com.george.games.menus.TrailMenu;
import com.george.headfall.Bar;
import com.george.headfall.Loader;
import com.george.headfall.Main;
import com.george.headfall.SoundsPlayer;
import com.george.headfall.Viewport;
import com.george.headfall.objects.BackGround;
import com.george.headfall.objects.Clouds;
import com.george.headfall.objects.Controller;
import com.george.headfall.objects.Effect;
import com.george.headfall.objects.Player;
import javax.microedition.lcdui.Graphics;

public abstract class Game
implements Runnable,
Drawable {
    public static final byte LEVEL1 = 1;
    public static final byte LEVEL2 = 2;
    public static final byte LEVEL3 = 3;
    public static final byte LEVEL4 = 4;
    public static final byte LEVEL5 = 5;
    private long TickTime;
    private final int targetCycleTime;
    private long startTime;
    private long endtime;
    protected long cycleTime;
    private boolean running;
    private boolean paused;
    private boolean finished;
    private Tasks endTask;
    protected int levelNumber;
    private long time;
    protected Drawable drawable;
    protected Container container = Main.container;
    protected BackGround backGround;
    protected Player player;
    protected Bar bar;
    protected Controller controller;
    protected int backGroundSP = 10;
    protected Effect effect;
    protected Clouds clouds;
    public static String debug = "";
    public static int LLLLLLL = 0;
    public static int RRRRRRR = 0;
    private boolean soundGameOver;
    private boolean success;
    private Point lastPoint;
    String cycle = "";
    String render = "";
    private int notInFrontCounter;

    public Game(int levelNumber) {
        this.targetCycleTime = 100;
        this.levelNumber = levelNumber;
        switch (levelNumber % 5) {
            case 0: {
                LLLLLLL = 0;
                RRRRRRR = 0;
                break;
            }
            case 1: {
                LLLLLLL = -2;
                RRRRRRR = 2;
                break;
            }
            case 2: {
                LLLLLLL = -2;
                RRRRRRR = 2;
                break;
            }
            case 3: {
                LLLLLLL = -2;
                RRRRRRR = 2;
                break;
            }
            case 4: {
                LLLLLLL = -2;
                RRRRRRR = 2;
            }
        }
        switch (levelNumber) {
            case 0: {
                this.backGroundSP = 20;
                break;
            }
            case 1: {
                this.backGroundSP = 22;
                break;
            }
            case 2: {
                this.backGroundSP = 24;
                break;
            }
            case 3: {
                this.backGroundSP = 26;
                break;
            }
            case 4: {
                this.backGroundSP = 28;
                break;
            }
            case 5: {
                this.backGroundSP = 30;
                break;
            }
            case 6: {
                this.backGroundSP = 30;
                break;
            }
            case 7: {
                this.backGroundSP = 30;
                break;
            }
            case 8: {
                this.backGroundSP = 30;
                break;
            }
            default: {
                this.backGroundSP = 30;
            }
        }
    }

    public int getBackGroundSP() {
        return this.backGroundSP;
    }

    public void setBackGroundSP(int backGroundSP) {
        this.backGroundSP = backGroundSP;
    }

    public void startEffect() {
        this.effect.start();
    }

    public void showTopScore() {
        if (this.finished) {
            return;
        }
        this.paused = true;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void runSoundGameOver() {
        if (this.soundGameOver) {
            return;
        }
        SoundsPlayer.getInstance().runGameOver();
        this.soundGameOver = true;
    }

    public void gameOver() {
        if (this.finished) {
            return;
        }
        this.finished = true;
        this.paused = true;
        this.drawable = new OverMenu(this);
    }

    public void setSuccess(boolean success) {
        if (this.finished) {
            return;
        }
        this.success = success;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void success() {
        if (this.finished) {
            return;
        }
        this.finished = true;
        this.paused = true;
        this.drawable = !Main.TRIAL ? new SuccessMenu(this) : new TrailMenu(this);
    }

    public void showBonusScore() {
        if (this.finished) {
            return;
        }
        this.paused = true;
        this.finished = true;
    }

    public void playerPowerFinished() {
    }

    public void input(int keyStates) {
        if ((keyStates & 0x100) != 0) {
            this.player.changePosition();
            return;
        }
        if ((keyStates & 2) != 0) {
            // empty if block
        }
        if ((keyStates & 0x40) != 0) {
            // empty if block
        }
        if ((keyStates & 4) != 0) {
            this.player.toLeft();
        }
        if ((keyStates & 0x20) != 0) {
            this.player.toRigth();
        }
    }

    public void keyPressed(int keyCode) {
        if (this.drawable != null) {
            this.drawable.keyPressed(keyCode);
            return;
        }
        if (keyCode == -7 || keyCode == -6) {
            this.pause();
        }
    }

    public void pointerDragged(int x, int y) {
        if (this.drawable != null) {
            this.drawable.pointerDragged(x, y);
            return;
        }
        if (this.lastPoint == null) {
            this.lastPoint = new Point(x, y);
            return;
        }
        if (x < this.lastPoint.getX() - 2) {
            this.player.toLeft();
            this.lastPoint = new Point(x, y);
        } else if (x > this.lastPoint.getX() + 2) {
            this.player.toRigth();
            this.lastPoint = new Point(x, y);
        }
    }

    public void pointerPressed(int x, int y) {
        if (this.drawable == null) {
            this.player.changePosition();
        } else {
            this.drawable.pointerPressed(x, y);
        }
    }

    public void pointerReleased(int x, int y) {
        if (this.drawable != null) {
            this.drawable.pointerReleased(x, y);
        } else if (this.bar.contains(y)) {
            this.bar.pointerReleased(x, y);
        }
    }

    public void start() {
        this.running = true;
        new Thread(this).start();
    }

    public void stop() {
        this.running = false;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void pause() {
        this.paused = true;
        this.drawable = new PauseMenu(this);
    }

    public void continueCurrent() {
        this.paused = false;
        this.drawable = null;
    }

    public void restart() {
        this.drawable = null;
        this.paused = false;
    }

    public long getTime() {
        return this.time / 1000L;
    }

    public int getLevelNumber() {
        return this.levelNumber;
    }

    public void decrementTime(int secs) {
        this.time -= (long)(1000 * secs);
    }

    public void run() {
        Graphics g = this.container.getGraphics();
        while (this.running) {
            this.startTime = System.currentTimeMillis();
            if (this.drawable == null) {
                this.input(Main.container.getKeyStates());
            } else {
                this.drawable.input(Main.container.getKeyStates());
            }
            if (!this.paused && !this.finished) {
                this.cycle();
            }
            if (this.drawable != null) {
                this.drawable.cycle();
            }
            this.draw(g);
            this.container.flushGraphics();
            this.endtime = System.currentTimeMillis();
            this.cycleTime = this.endtime - this.startTime;
            this.TickTime = 100L - this.cycleTime;
            try {
                if (this.TickTime > 15L) {
                    Thread.sleep(this.TickTime);
                } else {
                    Thread.sleep(15L);
                }
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            if (!Main.isForeground()) {
                ++this.notInFrontCounter;
                if (this.notInFrontCounter > 5 && !this.finished && !this.paused) {
                    this.pause();
                    System.gc();
                    this.notInFrontCounter = 0;
                }
            } else {
                this.notInFrontCounter = 0;
            }
            if (this.paused || this.finished) continue;
            this.time += System.currentTimeMillis() - this.startTime;
        }
        this.draw(g);
        Loader.sprite.setPosition(Viewport.WIDTH / 2 - Loader.sprite.getWidth() / 2, 300);
        Loader.sprite.paint(g);
        this.container.flushGraphics();
        this.clean();
        if (this.endTask != null) {
            this.endTask.execute();
        }
    }

    public void setDrawable(Drawable drawable) {
        this.drawable = drawable;
    }

    public void setEndTask(Tasks endTask) {
        this.endTask = endTask;
    }

    public abstract void cycle();

    public abstract void draw(Graphics var1);

    public abstract void clean();

    public abstract void create();
}

