/*
 * Decompiled with CFR 0.152.
 */
package com.george.headfall;

import com.george.games.Container;
import com.george.games.Drawable;
import com.george.games.Tasks;
import com.george.headfall.HeadFallRes;
import com.george.headfall.Main;
import com.george.headfall.Setting;
import com.george.headfall.SoundsPlayer;
import com.george.headfall.Viewport;
import com.george.headfall.res.ResMenu;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class Loader
implements Runnable,
Drawable {
    private Image offline = Image.createImage((int)Viewport.WIDTH, (int)Viewport.HEIGHT);
    public static Sprite sprite;
    private Tasks endTask;
    private Container container;
    private boolean running;
    private int levelNumber;

    public void setContainer(Container container) {
        this.container = container;
    }

    public void setEndTask(Tasks endTask) {
        this.endTask = endTask;
    }

    public Loader() {
        try {
            Image image = null;
            HeadFallRes.MENU_BACKGROUND = image = Image.createImage((String)"/load.png");
            image = Image.createImage((String)"/loading.png");
            sprite = new Sprite(image, image.getWidth() / 4, image.getHeight());
            sprite.setPosition(Viewport.WIDTH - 25 - sprite.getWidth(), Viewport.HEIGHT - sprite.getHeight() - 25);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Loader(boolean dontLoad) {
        HeadFallRes.MENU_BACKGROUND = ResMenu.MainBack;
        sprite.setPosition(Viewport.WIDTH - 25 - sprite.getWidth(), Viewport.HEIGHT - sprite.getHeight() - 25);
    }

    public void loadMainEntities() {
        this.running = true;
        this.setEndTask(Tasks.ViewMainMenu());
        new Thread(this).start();
        new LL().start();
    }

    public void loadLevel(int number) {
        this.running = true;
        this.levelNumber = number % 5;
        this.setEndTask(Tasks.startLevel(number));
        new Thread(this).start();
        new LevelLoader().start();
    }

    public void run() {
        Graphics g = this.container.getGraphics();
        while (this.running) {
            this.draw(g);
            sprite.nextFrame();
            try {
                Thread.sleep(200L);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        try {
            this.endTask.execute();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void draw(Graphics gg) {
        Graphics g = this.offline.getGraphics();
        g.drawImage(HeadFallRes.MENU_BACKGROUND, 0, 0, 0);
        sprite.paint(g);
        if (Main.container.getWidth() < Main.container.getHeight()) {
            gg.drawImage(this.offline, 0, 0, 0);
        } else {
            gg.drawImage(Image.createImage((Image)this.offline, (int)0, (int)0, (int)Viewport.WIDTH, (int)Viewport.HEIGHT, (int)6), 0, 0, 0);
        }
        this.container.flushGraphics();
    }

    public void keyPressed(int keyCode) {
    }

    public void input(int keyStates) {
    }

    public void cycle() {
    }

    public void pointerPressed(int x, int y) {
    }

    public void pointerReleased(int x, int y) {
    }

    public void pointerDragged(int x, int y) {
    }

    class LevelLoader
    extends Thread {
        LevelLoader() {
        }

        public void run() {
            try {
                Object image = null;
                HeadFallRes.CACTUS_LEFT = Image.createImage((String)("/level" + Loader.this.levelNumber + "/cactus-left.png"));
                HeadFallRes.CACTUS_RIGHT = Image.createImage((String)("/level" + Loader.this.levelNumber + "/cactus-right.png"));
                HeadFallRes.STONE = Image.createImage((String)("/level" + Loader.this.levelNumber + "/stone.png"));
                HeadFallRes.STONE_BREAK = Image.createImage((String)("/level" + Loader.this.levelNumber + "/stone-break.png"));
                HeadFallRes.JEWEL = Image.createImage((String)("/level" + Loader.this.levelNumber + "/jewel.png"));
                HeadFallRes.L1BG = Image.createImage((String)("/level" + Loader.this.levelNumber + "/bg.png"));
                HeadFallRes.L1BG1 = Image.createImage((String)("/level" + Loader.this.levelNumber + "/10001.png"));
                HeadFallRes.CLOUD1 = Image.createImage((String)("/level" + Loader.this.levelNumber + "/clouds/1.png"));
                HeadFallRes.CLOUD2 = Image.createImage((String)("/level" + Loader.this.levelNumber + "/clouds/2.png"));
                HeadFallRes.CLOUD3 = Image.createImage((String)("/level" + Loader.this.levelNumber + "/clouds/3.png"));
                image = null;
                Loader.this.running = false;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    class LL
    extends Thread {
        LL() {
        }

        public void run() {
            try {
                Setting.getInstance();
                HeadFallRes.RFLAG = Image.createImage((String)"/flag.png");
                HeadFallRes.LEFT = Image.createImage((String)"/player/left.png");
                HeadFallRes.RIGHT = Image.createImage((String)"/player/right.png");
                HeadFallRes.TURN = Image.createImage((String)"/player/turn.png");
                HeadFallRes.DEAD = Image.createImage((String)"/player/dead.png");
                HeadFallRes.EFFECT_RIGHT = Image.createImage((String)"/player/effect-right.png");
                HeadFallRes.EFFECT_LEFT = Image.createImage((String)"/player/effect-left.png");
                Image image = null;
                HeadFallRes.SPIDER_LEFT = image = Image.createImage((String)"/spider-left.png");
                HeadFallRes.SPIDER_RIGHT = image = Image.createImage((String)"/spider-right.png");
                HeadFallRes.CACTUS_LEFT = Image.createImage((String)"/level1/cactus-left.png");
                HeadFallRes.CACTUS_RIGHT = Image.createImage((String)"/level1/cactus-right.png");
                HeadFallRes.STONE = Image.createImage((String)"/level1/stone.png");
                HeadFallRes.STONE_BREAK = Image.createImage((String)"/level1/stone-break.png");
                HeadFallRes.JEWEL = Image.createImage((String)"/level1/jewel.png");
                HeadFallRes.L1BG = Image.createImage((String)"/level1/bg.png");
                HeadFallRes.L1BG1 = Image.createImage((String)"/level1/10001.png");
                HeadFallRes.DOLLAR = Image.createImage((String)"/dollar.png");
                HeadFallRes.SAFETY_ICON = Image.createImage((String)"/safety.png");
                HeadFallRes.COVER = Image.createImage((String)"/player/cover.png");
                HeadFallRes.BAR_BACK = Image.createImage((String)"/bar/bar-back.png");
                HeadFallRes.HEALTH = Image.createImage((String)"/bar/health.png");
                HeadFallRes.HEALTH2 = Image.createImage((String)"/bar/health2.png");
                HeadFallRes.NUMBERS = Image.createImage((String)"/bar/numbers.png");
                HeadFallRes.PAUSE = Image.createImage((String)"/bar/pause.png");
                HeadFallRes.SCORE_BACK = Image.createImage((String)"/bar/score-back.png");
                HeadFallRes.BOTTLE = Image.createImage((String)"/bottle.png");
                HeadFallRes.TOP_SCORE = Image.createImage((String)"/top.png");
                HeadFallRes.PROG1 = Image.createImage((String)"/prog1.png");
                HeadFallRes.PROG2 = Image.createImage((String)"/prog2.png");
                image = Image.createImage((String)"/full.png");
                HeadFallRes.FULL_VERSION = new Sprite(image, image.getWidth(), image.getHeight());
                image = Image.createImage((String)"/facebook.png");
                HeadFallRes.FACEBOOK = new Sprite(image, image.getWidth(), image.getHeight());
                image = Image.createImage((String)"/twitter.png");
                HeadFallRes.TWITTER = new Sprite(image, image.getWidth(), image.getHeight());
                HeadFallRes.GO = Image.createImage((String)"/go.png");
                HeadFallRes.SKIP = Image.createImage((String)"/skip.png");
                HeadFallRes.ADBG = Image.createImage((String)"/ad.png");
                ResMenu.load();
                SoundsPlayer.getInstance().start();
                image = null;
                Loader.this.running = false;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

