/*
 * Decompiled with CFR 0.152.
 */
package com.george.headfall.objects;

import com.george.headfall.Game;
import com.george.headfall.objects.Bottle;
import com.george.headfall.objects.Cactus;
import com.george.headfall.objects.DollarController;
import com.george.headfall.objects.FallingObject;
import com.george.headfall.objects.Jewel;
import com.george.headfall.objects.Player;
import com.george.headfall.objects.SafetyIcon;
import com.george.headfall.objects.Spider;
import com.george.headfall.objects.Stone;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class Controller {
    public int OBJECTS_TIME = 0;
    private Vector vecObjects;
    private Game game;
    private int enemyCounter = 30;
    private int scorCounter = 50;
    private int bonusCounter = 150;
    private int sp;
    private Random rEnemy = new Random();
    private Random rSC = new Random();
    private Random rBonus = new Random();
    private DollarController dollarController;
    private Player player = Player.getInstance();

    public Controller(Game game) {
        this.game = game;
        this.sp = game.getBackGroundSP() + 5;
        this.vecObjects = new Vector();
        this.dollarController = new DollarController();
    }

    public void cycle() {
        if (!this.game.isSuccess()) {
            this.generateEnemy();
            this.generateSC();
            this.generateBonus();
        } else if (this.getNumberOfObjects() == 0) {
            this.player.goTop();
        }
        FallingObject fallingObject = null;
        for (int j = this.vecObjects.size() - 1; j >= 0; --j) {
            fallingObject = (FallingObject)this.vecObjects.elementAt(j);
            fallingObject.cycle();
            if (!fallingObject.isLegalForRemove()) continue;
            this.vecObjects.removeElementAt(j);
        }
    }

    public void draw(Graphics g) {
        FallingObject fallingObject = null;
        for (int j = this.vecObjects.size() - 1; j >= 0; --j) {
            fallingObject = (FallingObject)this.vecObjects.elementAt(j);
            if (fallingObject instanceof Cactus) continue;
            fallingObject.draw(g);
        }
    }

    public void drawCactus(Graphics g) {
        FallingObject fallingObject = null;
        for (int j = this.vecObjects.size() - 1; j >= 0; --j) {
            fallingObject = (FallingObject)this.vecObjects.elementAt(j);
            if (!(fallingObject instanceof Cactus)) continue;
            fallingObject.draw(g);
        }
    }

    private void generateEnemy() {
        if (this.enemyCounter > 0) {
            --this.enemyCounter;
            return;
        }
        int n = this.rEnemy.nextInt(10);
        switch (n) {
            case 0: {
                this.vecObjects.addElement(new Spider(this.sp, 0));
                break;
            }
            case 1: {
                this.vecObjects.addElement(new Spider(this.sp, 1));
                break;
            }
            case 2: {
                this.vecObjects.addElement(new Cactus(this.game.getBackGroundSP(), 1));
                break;
            }
            case 3: {
                this.vecObjects.addElement(new Cactus(this.game.getBackGroundSP(), 0));
                break;
            }
            case 4: {
                this.vecObjects.addElement(new Stone(this.sp + this.sp / 3, 1));
                break;
            }
            case 5: {
                this.vecObjects.addElement(new Stone(this.sp + this.sp / 3, 0));
                break;
            }
            case 6: {
                this.vecObjects.addElement(new Spider(this.sp, 1));
                break;
            }
            case 7: {
                this.vecObjects.addElement(new Spider(this.sp, 1));
                break;
            }
            case 8: {
                this.vecObjects.addElement(new Spider(this.sp, 1));
                break;
            }
            case 9: {
                this.vecObjects.addElement(new Spider(this.sp, 1));
            }
        }
        this.enemyCounter = this.OBJECTS_TIME;
    }

    private void generateSC() {
        if (this.scorCounter > 0) {
            --this.scorCounter;
            return;
        }
        int n = this.rSC.nextInt(9);
        switch (n) {
            case 0: {
                this.dollarController.generate(this, this.sp);
                break;
            }
            case 1: {
                this.dollarController.generate(this, this.sp);
                break;
            }
            case 2: {
                this.dollarController.generate(this, this.sp);
                break;
            }
            case 3: {
                this.vecObjects.addElement(new Jewel(this.sp - this.sp / 3, 2));
                break;
            }
            case 4: {
                this.vecObjects.addElement(new Jewel(this.sp - this.sp / 3, 2));
                break;
            }
            case 5: {
                this.vecObjects.addElement(new Jewel(this.sp - this.sp / 3, 2));
                break;
            }
            case 6: {
                this.dollarController.generate(this, this.sp);
                break;
            }
            case 7: {
                this.dollarController.generate(this, this.sp);
                break;
            }
            case 8: {
                this.dollarController.generate(this, this.sp);
            }
        }
        this.scorCounter = 30;
    }

    private void generateBonus() {
        if (this.bonusCounter > 0) {
            --this.bonusCounter;
            return;
        }
        int n = this.rBonus.nextInt(3);
        switch (n) {
            case 0: {
                this.vecObjects.addElement(new SafetyIcon(this.sp - this.sp / 3));
                break;
            }
            case 1: {
                this.vecObjects.addElement(new Bottle(this.sp - this.sp / 3));
                break;
            }
            case 2: {
                this.vecObjects.addElement(new Bottle(this.sp - this.sp / 3));
            }
        }
        this.bonusCounter = 80 + this.rBonus.nextInt(100);
    }

    public void addObject(FallingObject fallingObject) {
        this.vecObjects.addElement(fallingObject);
    }

    public int getNumberOfObjects() {
        return this.vecObjects.size();
    }
}

