/*
 * Decompiled with CFR 0.152.
 */
package com.george.headfall.objects;

import com.george.headfall.Game;
import com.george.headfall.HeadFallRes;
import com.george.headfall.Setting;
import com.george.headfall.SoundsPlayer;
import com.george.headfall.Viewport;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;

public class Player {
    private Sprite sprite;
    private int sp = -5;
    private static Player player;
    private boolean inDefaultPlace;
    private Sprite left;
    private Sprite right;
    private Sprite turn;
    private Sprite dead;
    private boolean movingLeft;
    private boolean movingRight;
    private final int maxHitCounter;
    private int hitCounter;
    private Sprite hitSprite;
    private Sprite cover;
    private Sprite effectRight;
    private Sprite effectLeft;
    private int health;
    private int safeCounter;
    private int score;
    boolean succeeded;
    public static final int MAX_HEALTH = 5;
    private Game game;
    private int defaultY = 200;

    public static void create(Game game) {
        player = new Player(game);
    }

    public static Player getInstance() {
        return player;
    }

    private Player(Game game) {
        this.maxHitCounter = 20;
        this.setScore(Setting.getInstance().getPlayerScore());
        this.health = 5;
        this.game = game;
        this.left = new Sprite(HeadFallRes.LEFT, HeadFallRes.LEFT.getWidth() / 19, HeadFallRes.LEFT.getHeight());
        this.right = new Sprite(HeadFallRes.RIGHT, HeadFallRes.RIGHT.getWidth() / 19, HeadFallRes.RIGHT.getHeight());
        this.turn = new Sprite(HeadFallRes.TURN, HeadFallRes.TURN.getWidth() / 4, HeadFallRes.TURN.getHeight());
        this.right.setPosition(Viewport.WIDTH - 30 - this.right.getWidth() + Game.RRRRRRR, this.defaultY);
        this.dead = new Sprite(HeadFallRes.DEAD, HeadFallRes.DEAD.getWidth() / 2, HeadFallRes.DEAD.getHeight());
        this.cover = new Sprite(HeadFallRes.COVER, HeadFallRes.COVER.getWidth(), HeadFallRes.COVER.getHeight());
        this.effectRight = new Sprite(HeadFallRes.EFFECT_RIGHT, HeadFallRes.EFFECT_RIGHT.getWidth() / 4, HeadFallRes.EFFECT_RIGHT.getHeight());
        this.effectLeft = new Sprite(HeadFallRes.EFFECT_LEFT, HeadFallRes.EFFECT_LEFT.getWidth() / 4, HeadFallRes.EFFECT_LEFT.getHeight());
        this.left.setPosition(25 + Game.LLLLLLL, Viewport.HEIGHT - this.left.getHeight());
        this.sprite = this.left;
    }

    public void paint(Graphics g) {
        this.sprite.paint(g);
        if (this.safeCounter > 0) {
            this.cover.paint(g);
        }
        if (this.hitCounter > 16 && this.health > 0) {
            if (this.sprite == this.right) {
                this.effectRight.paint(g);
            } else {
                this.effectLeft.paint(g);
            }
        }
    }

    public void safe() {
        if (this.health == 0) {
            return;
        }
        this.safeCounter = 100;
    }

    public void cycle() {
        if (this.hitCounter > 0) {
            --this.hitCounter;
        }
        if (this.safeCounter > 0) {
            --this.safeCounter;
        }
        this.cover.setPosition(this.sprite.getX() + this.sprite.getWidth() / 2 - this.cover.getWidth() / 2, this.sprite.getY() + this.sprite.getHeight() / 2 - this.cover.getHeight() / 2);
        this.effectRight.setPosition(this.sprite.getX() - 10, this.sprite.getY());
        this.effectLeft.setPosition(this.sprite.getX() + 30, this.sprite.getY());
        this.cover.nextFrame();
        if (this.hitCounter > 16) {
            this.effectRight.nextFrame();
            this.effectLeft.nextFrame();
        }
        this.sprite.setFrame((this.sprite.getFrame() + 2) % this.sprite.getFrameSequenceLength());
        if (this.health == 0 && !this.succeeded) {
            this.game.runSoundGameOver();
            this.sprite.setPosition(this.sprite.getX(), this.sprite.getY() + 20);
            if (this.hitCounter == 15) {
                this.game.gameOver();
            }
            return;
        }
        if (this.hitCounter == 0 && this.game.getTime() >= 120L) {
            this.game.setSuccess(true);
        }
        if (this.movingLeft) {
            this.sprite.setPosition(this.sprite.getX() - 40, this.sprite.getY());
            if (this.sprite.getX() <= this.left.getX()) {
                this.arrivedLeft();
            }
        } else if (this.movingRight) {
            this.sprite.setPosition(this.sprite.getX() + 40, this.sprite.getY());
            if (this.sprite.getX() >= this.right.getX()) {
                this.arrivedRight();
            }
        } else if (!this.inDefaultPlace || this.sprite.getY() > this.defaultY) {
            this.sprite.setPosition(this.sprite.getX(), this.sprite.getY() + this.sp);
        }
        if (this.sprite.getY() <= this.defaultY) {
            this.inDefaultPlace = true;
        }
        if (this.sprite.getY() <= 90) {
            this.game.success();
        }
    }

    public void setDefaultY(int defaultY) {
        this.defaultY = defaultY;
    }

    public int getHeight() {
        return this.left.getHeight();
    }

    public boolean isInDefaultPlace() {
        return this.inDefaultPlace;
    }

    public void changePosition() {
        if (this.sprite == this.left || this.movingLeft) {
            this.toRigth();
        } else {
            this.toLeft();
        }
    }

    public void toLeft() {
        if (this.movingLeft || this.sprite == this.left) {
            return;
        }
        SoundsPlayer.getInstance().runjump();
        this.movingRight = false;
        this.movingLeft = true;
        this.turn.setPosition(this.sprite.getX(), this.sprite.getY());
        this.sprite = this.turn;
    }

    public void toRigth() {
        if (this.movingRight || this.sprite == this.right) {
            return;
        }
        SoundsPlayer.getInstance().runjump();
        this.movingRight = true;
        this.movingLeft = false;
        this.turn.setPosition(this.sprite.getX(), this.sprite.getY());
        this.sprite = this.turn;
    }

    private void arrivedLeft() {
        this.movingLeft = false;
        this.left.setPosition(this.left.getX(), this.sprite.getY());
        this.sprite = this.left;
    }

    private void arrivedRight() {
        this.movingRight = false;
        this.right.setPosition(this.right.getX(), this.sprite.getY());
        this.sprite = this.right;
    }

    public void setHealth(int health) {
        this.health = health;
    }

    public boolean collides(Sprite sp, boolean pixel) {
        return this.sprite.collidesWith(sp, false);
    }

    public boolean hit(int effect) {
        if (this.safeCounter > 0) {
            return false;
        }
        this.sprite.setPosition(this.sprite.getX(), this.sprite.getY() + 30);
        this.hitCounter = 20;
        this.health -= effect;
        if (this.health <= 0) {
            this.dead.setPosition(Viewport.WIDTH / 2 - this.dead.getWidth() / 2, this.sprite.getY());
            this.sprite = this.dead;
            this.health = 0;
        }
        return true;
    }

    public int getWidth() {
        return this.sprite.getWidth();
    }

    public int getX() {
        return this.sprite.getX();
    }

    public void bonus() {
    }

    public int getHealth() {
        return this.health;
    }

    public void setScore(int score) {
        this.score = score;
    }

    public int getScore() {
        return this.score;
    }

    public void addScore(int s) {
        this.score += s;
    }

    public void goTop() {
        this.succeeded = true;
        if (this.sp != -11 && !this.game.isFinished()) {
            SoundsPlayer.getInstance().runSuccess();
        }
        this.defaultY = -this.getHeight();
        this.sp = -11;
    }
}

