/*
 * Decompiled with CFR 0.152.
 */
package src.json.me;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import src.json.me.JSONArray;
import src.json.me.JSONException;
import src.json.me.JSONString;
import src.json.me.JSONTokener;
import src.json.me.a;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class JSONObject {
    private Hashtable a = new Hashtable();
    public static final Object NULL = new a();

    public JSONObject() {
    }

    public JSONObject(JSONTokener jSONTokener) {
        this();
        if (jSONTokener.nextClean() != '{') {
            throw jSONTokener.syntaxError("A JSONObject text must begin with '{'");
        }
        block8: while (true) {
            switch (jSONTokener.nextClean()) {
                case '\u0000': {
                    throw jSONTokener.syntaxError("A JSONObject text must end with '}'");
                }
                case '}': {
                    return;
                }
            }
            jSONTokener.back();
            String string = jSONTokener.nextValue().toString();
            char c2 = jSONTokener.nextClean();
            if (c2 == '=') {
                if (jSONTokener.next() != '>') {
                    jSONTokener.back();
                }
            } else if (c2 != ':') {
                throw jSONTokener.syntaxError("Expected a ':' after a key");
            }
            this.put(string, jSONTokener.nextValue());
            switch (jSONTokener.nextClean()) {
                case ',': 
                case ';': {
                    if (jSONTokener.nextClean() == '}') {
                        return;
                    }
                    jSONTokener.back();
                    continue block8;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw jSONTokener.syntaxError("Expected a ',' or '}'");
    }

    public JSONObject(String string) {
        this(new JSONTokener(string));
    }

    public JSONObject accumulate(String string, Object object) {
        JSONObject.a(object);
        Object object2 = this.opt(string);
        if (object2 == null) {
            this.put(string, object);
        } else if (object2 instanceof JSONArray) {
            ((JSONArray)object2).put(object);
        } else {
            this.put(string, new JSONArray().put(object2).put(object));
        }
        return this;
    }

    public static String doubleToString(double d2) {
        if (Double.isInfinite(d2) || Double.isNaN(d2)) {
            return "null";
        }
        String string = Double.toString(d2);
        if (string.indexOf(46) > 0 && string.indexOf(101) < 0 && string.indexOf(69) < 0) {
            while (string.endsWith("0")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.endsWith(".")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    public Object get(String string) {
        Object object = this.opt(string);
        if (object == null) {
            throw new JSONException("JSONObject[" + JSONObject.quote(string) + "] not found.");
        }
        return object;
    }

    public boolean getBoolean(String string) {
        Object object = this.get(string);
        if (object.equals(Boolean.FALSE) || object instanceof String && ((String)object).toLowerCase().equals("false")) {
            return false;
        }
        if (object.equals(Boolean.TRUE) || object instanceof String && ((String)object).toLowerCase().equals("true")) {
            return true;
        }
        throw new JSONException("JSONObject[" + JSONObject.quote(string) + "] is not a Boolean.");
    }

    public double getDouble(String string) {
        Object object = this.get(string);
        if (object instanceof Byte) {
            return ((Byte)object).byteValue();
        }
        if (object instanceof Short) {
            return ((Short)object).shortValue();
        }
        if (object instanceof Integer) {
            return ((Integer)object).intValue();
        }
        if (object instanceof Long) {
            return ((Long)object).longValue();
        }
        if (object instanceof Float) {
            return ((Float)object).floatValue();
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof String) {
            try {
                return Double.valueOf((String)object);
            }
            catch (Exception exception) {
                throw new JSONException("JSONObject[" + JSONObject.quote(string) + "] is not a number.");
            }
        }
        throw new JSONException("JSONObject[" + JSONObject.quote(string) + "] is not a number.");
    }

    public int getInt(String string) {
        Object object = this.get(string);
        if (object instanceof Byte) {
            return ((Byte)object).byteValue();
        }
        if (object instanceof Short) {
            return ((Short)object).shortValue();
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof Long) {
            return (int)((Long)object).longValue();
        }
        if (object instanceof Float) {
            return (int)((Float)object).floatValue();
        }
        if (object instanceof Double) {
            return (int)((Double)object).doubleValue();
        }
        if (object instanceof String) {
            return (int)this.getDouble(string);
        }
        throw new JSONException("JSONObject[" + JSONObject.quote(string) + "] is not a number.");
    }

    public JSONArray getJSONArray(String string) {
        Object object = this.get(string);
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        throw new JSONException("JSONObject[" + JSONObject.quote(string) + "] is not a JSONArray.");
    }

    public JSONObject getJSONObject(String string) {
        Object object = this.get(string);
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        throw new JSONException("JSONObject[" + JSONObject.quote(string) + "] is not a JSONObject.");
    }

    public long getLong(String string) {
        Object object = this.get(string);
        if (object instanceof Byte) {
            return ((Byte)object).byteValue();
        }
        if (object instanceof Short) {
            return ((Short)object).shortValue();
        }
        if (object instanceof Integer) {
            return ((Integer)object).intValue();
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof Float) {
            return (long)((Float)object).floatValue();
        }
        if (object instanceof Double) {
            return (long)((Double)object).doubleValue();
        }
        if (object instanceof String) {
            return (long)this.getDouble(string);
        }
        throw new JSONException("JSONObject[" + JSONObject.quote(string) + "] is not a number.");
    }

    public String getString(String string) {
        return this.get(string).toString();
    }

    public boolean has(String string) {
        return this.a.containsKey(string);
    }

    public boolean isNull(String string) {
        return NULL.equals(this.opt(string));
    }

    public Enumeration keys() {
        return this.a.keys();
    }

    public int length() {
        return this.a.size();
    }

    public JSONArray names() {
        JSONArray jSONArray = new JSONArray();
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            jSONArray.put(enumeration.nextElement());
        }
        if (jSONArray.length() == 0) {
            return null;
        }
        return jSONArray;
    }

    public static String trimNumber(String string) {
        if (string.indexOf(46) > 0 && string.indexOf(101) < 0 && string.indexOf(69) < 0) {
            while (string.endsWith("0")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.endsWith(".")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    public static String numberToString(Object object) {
        if (object == null) {
            throw new JSONException("Null pointer");
        }
        JSONObject.a(object);
        return JSONObject.trimNumber(object.toString());
    }

    public Object opt(String string) {
        if (string == null) {
            return null;
        }
        return this.a.get(string);
    }

    public boolean optBoolean(String string) {
        return this.optBoolean(string, false);
    }

    public boolean optBoolean(String string, boolean bl) {
        try {
            return this.getBoolean(string);
        }
        catch (Exception exception) {
            return bl;
        }
    }

    public JSONObject put(String string, Vector vector) {
        this.put(string, new JSONArray(vector));
        return this;
    }

    public double optDouble(String string) {
        return this.optDouble(string, Double.NaN);
    }

    public double optDouble(String string, double d2) {
        try {
            return Double.parseDouble((String)this.opt(string));
        }
        catch (Exception exception) {
            return d2;
        }
    }

    public int optInt(String string) {
        return this.optInt(string, 0);
    }

    public int optInt(String string, int n) {
        try {
            return this.getInt(string);
        }
        catch (Exception exception) {
            return n;
        }
    }

    public JSONArray optJSONArray(String object) {
        if ((object = this.opt((String)object)) instanceof JSONArray) {
            return (JSONArray)object;
        }
        return null;
    }

    public JSONObject optJSONObject(String object) {
        if ((object = this.opt((String)object)) instanceof JSONObject) {
            return (JSONObject)object;
        }
        return null;
    }

    public long optLong(String string) {
        return this.optLong(string, 0L);
    }

    public long optLong(String string, long l) {
        try {
            return this.getLong(string);
        }
        catch (Exception exception) {
            return l;
        }
    }

    public String optString(String string) {
        try {
            return this.optString(string, "");
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.out.println("OutOfMemoryError in optString = " + outOfMemoryError);
            return "";
        }
    }

    public String optString(String object, String string) {
        if ((object = this.opt((String)object)) != null) {
            return object.toString();
        }
        return string;
    }

    public JSONObject put(String string, boolean bl) {
        this.put(string, bl ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public JSONObject put(String string, double d2) {
        this.put(string, new Double(d2));
        return this;
    }

    public JSONObject put(String string, int n) {
        this.put(string, new Integer(n));
        return this;
    }

    public JSONObject put(String string, long l) {
        this.put(string, new Long(l));
        return this;
    }

    public JSONObject put(String string, Object object) {
        if (string == null) {
            throw new JSONException("Null key.");
        }
        if (object != null) {
            JSONObject.a(object);
            this.a.put(string, object);
        } else {
            this.remove(string);
        }
        return this;
    }

    public JSONObject putOpt(String string, Object object) {
        if (string != null && object != null) {
            this.put(string, object);
        }
        return this;
    }

    public static String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c2 = '\u0000';
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n + 4);
        stringBuffer.append('\"');
        block9: for (int i = 0; i < n; ++i) {
            char c3 = c2;
            c2 = string.charAt(i);
            switch (c2) {
                case '\"': 
                case '\\': {
                    stringBuffer.append('\\');
                    stringBuffer.append(c2);
                    continue block9;
                }
                case '/': {
                    if (c3 == '<') {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(c2);
                    continue block9;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    continue block9;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block9;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block9;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block9;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block9;
                }
                default: {
                    if (c2 < ' ') {
                        String string2 = "000" + Integer.toHexString(c2);
                        stringBuffer.append("\\u" + string2.substring(string2.length() - 4));
                        continue block9;
                    }
                    stringBuffer.append(c2);
                }
            }
        }
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    public Object remove(String string) {
        return this.a.remove(string);
    }

    static void a(Object object) {
        if (object != null) {
            if (object instanceof Double) {
                if (((Double)object).isInfinite() || ((Double)object).isNaN()) {
                    throw new JSONException("JSON does not allow non-finite numbers");
                }
            } else if (object instanceof Float && (((Float)object).isInfinite() || ((Float)object).isNaN())) {
                throw new JSONException("JSON does not allow non-finite numbers.");
            }
        }
    }

    public JSONArray toJSONArray(JSONArray jSONArray) {
        if (jSONArray == null || jSONArray.length() == 0) {
            return null;
        }
        JSONArray jSONArray2 = new JSONArray();
        for (int i = 0; i < jSONArray.length(); ++i) {
            jSONArray2.put(this.opt(jSONArray.getString(i)));
        }
        return jSONArray2;
    }

    public String toString() {
        try {
            Enumeration enumeration = this.keys();
            StringBuffer stringBuffer = new StringBuffer("{");
            while (enumeration.hasMoreElements()) {
                if (stringBuffer.length() > 1) {
                    stringBuffer.append(',');
                }
                Object e2 = enumeration.nextElement();
                stringBuffer.append(JSONObject.quote(e2.toString()));
                stringBuffer.append(':');
                stringBuffer.append(JSONObject.a(this.a.get(e2)));
            }
            stringBuffer.append('}');
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String toString(int n) {
        return this.a(n, 0);
    }

    private String a(int n, int n2) {
        int n3 = this.length();
        if (n3 == 0) {
            return "{}";
        }
        Enumeration enumeration = this.keys();
        StringBuffer stringBuffer = new StringBuffer("{");
        int n4 = n2 + n;
        if (n3 == 1) {
            Object e2 = enumeration.nextElement();
            stringBuffer.append(JSONObject.quote(e2.toString()));
            stringBuffer.append(": ");
            stringBuffer.append(JSONObject.a(this.a.get(e2), n, n2));
        } else {
            while (enumeration.hasMoreElements()) {
                Object e3 = enumeration.nextElement();
                if (stringBuffer.length() > 1) {
                    stringBuffer.append(",\n");
                } else {
                    stringBuffer.append('\n');
                }
                for (n3 = 0; n3 < n4; ++n3) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(JSONObject.quote(e3.toString()));
                stringBuffer.append(": ");
                stringBuffer.append(JSONObject.a(this.a.get(e3), n, n4));
            }
            if (stringBuffer.length() > 1) {
                stringBuffer.append('\n');
                for (n3 = 0; n3 < n2; ++n3) {
                    stringBuffer.append(' ');
                }
            }
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    static String a(Object object) {
        if (object == null || object.equals(null)) {
            return "null";
        }
        if (object instanceof JSONString) {
            try {
                object = ((JSONString)object).toJSONString();
            }
            catch (Exception exception) {
                throw new JSONException(exception);
            }
            if (object instanceof String) {
                return (String)object;
            }
            throw new JSONException("Bad value from toJSONString: " + object);
        }
        if (object instanceof Float || object instanceof Double || object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long) {
            return JSONObject.numberToString(object);
        }
        if (object instanceof Boolean || object instanceof JSONObject || object instanceof JSONArray) {
            return object.toString();
        }
        return JSONObject.quote(object.toString());
    }

    static String a(Object object, int n, int n2) {
        if (object == null || object.equals(null)) {
            return "null";
        }
        try {
            String string;
            if (object instanceof JSONString && (string = ((JSONString)object).toJSONString()) instanceof String) {
                return string;
            }
        }
        catch (Exception exception) {}
        if (object instanceof Float || object instanceof Double || object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long) {
            return JSONObject.numberToString(object);
        }
        if (object instanceof Boolean) {
            return object.toString();
        }
        if (object instanceof JSONObject) {
            return ((JSONObject)object).a(n, n2);
        }
        if (object instanceof JSONArray) {
            return ((JSONArray)object).a(n, n2);
        }
        return JSONObject.quote(object.toString());
    }

    public Writer write(Writer writer) {
        try {
            boolean bl = false;
            Enumeration enumeration = this.keys();
            writer.write(123);
            while (enumeration.hasMoreElements()) {
                if (bl) {
                    writer.write(44);
                }
                Object object = enumeration.nextElement();
                writer.write(JSONObject.quote(object.toString()));
                writer.write(58);
                object = this.a.get(object);
                if (object instanceof JSONObject) {
                    ((JSONObject)object).write(writer);
                } else if (object instanceof JSONArray) {
                    ((JSONArray)object).write(writer);
                } else {
                    writer.write(JSONObject.a(object));
                }
                bl = true;
            }
            writer.write(125);
            return writer;
        }
        catch (IOException iOException) {
            throw new JSONException(iOException);
        }
    }
}

