/*
 * Decompiled with CFR 0.152.
 */
import java.util.Hashtable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class DrawFont {
    private Image img;
    private int[] charsWidth;
    private int[] globalCordsChars;
    private Hashtable fontsHeshTable = new Hashtable();
    public static final String fontCharsStr = new String("acdegimorstuw:,.! 0123456789AGS\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f0\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f7\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u00fe\u00ff\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d7\u00d8\u00d9\u00da\u00db\u00dc\u00dd\u00de\u00df()\"-*#<?/");
    private char[] fontChars;
    private final byte INDEX_GLOBAL_CORDS;
    private final byte INDEX_CHARS_WIDTH;
    private int startX = 0;
    private int startY = 0;
    public static final byte BRAUWN = 1;
    public static final byte WHITE = 0;
    private final byte CHARS_SPACING;
    private String fontFilePath;
    Integer[] para;

    public DrawFont(String nameFileFont, int[] charsWidth, byte _color) {
        int i;
        this.INDEX_GLOBAL_CORDS = 0;
        this.INDEX_CHARS_WIDTH = 1;
        this.CHARS_SPACING = 1;
        System.out.println("LENGTH >>> " + fontCharsStr.length());
        this.fontChars = fontCharsStr.toCharArray();
        this.fontFilePath = nameFileFont;
        this.loadImageDat(nameFileFont, _color);
        this.charsWidth = new int[charsWidth.length];
        this.globalCordsChars = new int[charsWidth.length];
        for (i = 0; i < charsWidth.length; ++i) {
            this.charsWidth[i] = charsWidth[i];
            if (i == 0) continue;
            this.globalCordsChars[i] = this.globalCordsChars[i - 1] + this.charsWidth[i - 1];
        }
        for (i = 0; i < charsWidth.length; ++i) {
            this.fontsHeshTable.put(String.valueOf(this.fontChars[i]), new Integer[]{new Integer(this.globalCordsChars[i]), new Integer(this.charsWidth[i])});
        }
    }

    public int getHeight() {
        return this.img.getHeight();
    }

    public void paint(Graphics _g, String _str, int _startX, int _startY, int _anchor) {
        if (_str == null) {
            return;
        }
        int clipX = _g.getClipX();
        int clipY = _g.getClipY();
        int clipWidth = _g.getClipWidth();
        int clipHeight = _g.getClipHeight();
        char[] masChar = _str.toCharArray();
        this.startX = _startX;
        this.startY = _startY;
        switch (_anchor) {
            case 17: {
                this.startX -= this.getStringWidth(_str) >> 1;
                break;
            }
            case 33: {
                this.startX -= this.getStringWidth(_str) >> 1;
                this.startY -= this.getStrHeigth();
                break;
            }
            case 24: {
                this.startX -= this.getStringWidth(_str);
                break;
            }
            case 40: 
            case 72: {
                this.startX -= this.getStringWidth(_str);
                this.startY -= this.getStrHeigth();
                break;
            }
            case 36: 
            case 68: {
                this.startY -= this.getStrHeigth();
            }
        }
        for (int i = 0; i < masChar.length; ++i) {
            if (!this.fontsHeshTable.containsKey(String.valueOf(masChar[i]))) continue;
            _g.setClip(clipX, clipY, clipWidth, clipHeight);
            this.drawChar(_g, masChar[i], this.startX, this.startY, 20);
            Integer[] para = (Integer[])this.fontsHeshTable.get(String.valueOf(masChar[i]));
            this.startX += para[1] + 1;
        }
    }

    public void drawChar(Graphics _g, char _cimp, int _startX, int _startY, int _anchor) {
        this.para = (Integer[])this.fontsHeshTable.get(String.valueOf(_cimp));
        DrawFont.renderSubImage(_g, this.img, this.para[0], 0, this.para[1], this.img.getHeight(), _startX, _startY, _anchor);
    }

    public static void renderSubImage(Graphics _g, Image _img, int _bx, int _by, int _bw, int _bh, int _iX, int _iY, int _iAnchor) {
        if (_img == null) {
            return;
        }
        _g.clipRect(_iX += DrawFont.getAnchorX(_bw, _iAnchor), _iY += DrawFont.getAnchorY(_bh, _iAnchor), _bw, _bh);
        if ((_g.getClipWidth() | _g.getClipWidth()) > 0) {
            _g.drawImage(_img, _iX - _bx, _iY - _by, 0);
        }
        _g.setClip(0, 0, 240, 540);
    }

    private static int getAnchorX(int _subImgWidth, int a_iAnchor) {
        if ((a_iAnchor & 1) == 1) {
            return -(_subImgWidth >>> 1);
        }
        if ((a_iAnchor & 8) == 8) {
            return -_subImgWidth;
        }
        return 0;
    }

    private static int getAnchorY(int _subImgHeight, int a_iAnchor) {
        if ((a_iAnchor & 2) == 2) {
            return -(_subImgHeight >>> 1);
        }
        if ((a_iAnchor & 0x20) == 32) {
            return -_subImgHeight;
        }
        return 0;
    }

    private void loadImageDat(String _nameFail, byte _color) {
        try {
            this.img = Image.createImage((String)_nameFail);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("image creation error");
        }
        System.gc();
    }

    public void setColor(byte _color) {
        this.loadImageDat(this.fontFilePath, _color);
    }

    public int getStringWidth(String _str) {
        if (_str == null) {
            return 0;
        }
        int longStr = 0;
        char[] masChar = new char[_str.length()];
        masChar = _str.toCharArray();
        for (int i = 0; i < _str.length(); ++i) {
            if (!this.fontsHeshTable.containsKey(String.valueOf(masChar[i]))) continue;
            Integer[] para = (Integer[])this.fontsHeshTable.get(String.valueOf(masChar[i]));
            longStr += para[1] + 1;
        }
        return longStr;
    }

    public int getStrHeigth() {
        return this.img.getHeight();
    }
}

