/*
 * Decompiled with CFR 0.152.
 */
package com.apr.game.buttons;

import com.apr.game.buttons.Button;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class ButtonMultipleShadowText
extends Button {
    protected byte value;
    protected String attribute;
    protected String name;
    protected String[] values;
    protected static Image button;

    public ButtonMultipleShadowText(String name, String attribute, String[] values, Image image) throws IOException {
        super(image, name);
        if (button == null) {
            button = image;
        }
        this.name = name;
        this.attribute = attribute;
        this.values = values;
        this.value = 0;
    }

    public void right() {
        this.value = (byte)(this.value + 1);
        if (this.value >= this.values.length) {
            this.value = 0;
        }
        this.setStringValue();
        this.saveValue();
        this.setSetting();
    }

    public void left() {
        this.value = (byte)(this.value - 1);
        if (this.value < 0) {
            this.value = (byte)(this.values.length - 1);
        }
        this.setStringValue();
        this.saveValue();
        this.setSetting();
    }

    public void setStringValue() {
    }

    public void fire() {
        this.right();
    }

    public void render(Graphics g) {
        if (this.getFrame() == 1) {
            g.drawImage(button, this.sx - button.getWidth() / 2, this.sy, 0);
        }
        fontSmall.print(g, this.sx, this.sy, this.text, (byte)0);
        font.print(g, this.sx, this.sy + fontSmall.getH(), this.values[this.value], (byte)0);
    }

    public abstract void loadValue();

    public abstract void setSetting();

    public abstract void saveValue();
}

