/*
 * Decompiled with CFR 0.152.
 */
package com.apr.game.displayable;

import com.apr.game.buttons.Buttons;
import com.apr.game.displayable.ActionButton;
import com.apr.game.displayable.Background;
import com.apr.game.displayable.Displayable;
import com.apr.game.displayable.Title;
import com.apr.game.states.State;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public final class MenuPopup
extends Displayable {
    private static final String TITLE_PATH = "/images/title_pause.png";
    protected static int MAX_OFFSET = 0;
    protected static final byte INCREASE_X = 30;
    protected static final byte STATE_NORMAL = 0;
    protected static final byte STATE_MOVING = 1;
    protected static final byte STATE_EXITING = 2;
    protected int offset = 0;
    protected byte state = 0;
    private boolean isShow = false;
    private Background background;
    private Title title;
    private ActionButton backButton;
    private Buttons buttons;

    public MenuPopup(Buttons buttons, Background background) throws IOException {
        this.background = background;
        this.title = new Title(TITLE_PATH);
        this.backButton = new ActionButton(1, 1);
        this.buttons = buttons;
        this.isShow = false;
    }

    public void enter() throws IOException {
        this.isShow = false;
        this.title.enter();
        this.backButton.enter();
        this.buttons.enter(-State.W, this.title.getH() * 2);
    }

    public void init() {
        this.offset = 0;
        this.state = 1;
        this.offset = -State.W;
        MAX_OFFSET = 0;
        this.buttons.setPosition(-State.W, this.title.getH() * 2);
        this.backButton.drop();
    }

    public void exit() {
        this.title.exit();
        this.backButton.exit();
        this.buttons.exit();
    }

    public void update() throws IOException {
        if (this.state != 0) {
            this.buttons.updatePosition(30, 0);
            this.offset += 30;
            if (this.offset >= MAX_OFFSET) {
                if (this.state == 1) {
                    this.state = 0;
                } else {
                    this.isShow = false;
                }
            }
        }
    }

    public void render(Graphics g) {
        this.background.render(g);
        this.title.render(g);
        this.buttons.render(g);
        this.backButton.render(g);
    }

    public void show() {
        this.isShow = true;
        this.init();
    }

    public void hide() {
        this.isShow = false;
    }

    public boolean isShown() {
        return this.isShow;
    }

    public void up() {
        this.buttons.moveUp();
    }

    public void down() {
        this.buttons.moveDown();
    }

    public void fire() {
        this.buttons.fire();
    }

    public byte getCurOption() {
        return this.buttons.getCurOption();
    }

    public void startEnding() {
        this.state = (byte)2;
        MAX_OFFSET = State.W;
        this.backButton.press();
    }

    public boolean checkClick(int x, int y) {
        return this.buttons.checkButton(x, y);
    }
}

