/*
 * Decompiled with CFR 0.152.
 */
package com.apr.game.states;

import com.apr.game.states.State;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.media.MediaException;

public class StateMachine
extends State {
    protected static final byte STATE_END = -1;
    private State[] states;
    private State currentState;
    private State defaultState;
    private State goalState;
    private byte goalID;
    private byte nextState;

    public StateMachine(byte type, byte nextState) {
        super(type);
        this.nextState = nextState;
    }

    public StateMachine(byte type, byte nextState, State[] states, State state) throws IOException, MediaException {
        super(type);
        this.nextState = nextState;
        this.addStates(states);
        this.setDefaultState(state);
    }

    public boolean isDone() {
        return this.goalID == -1;
    }

    public void addStates(State[] states) {
        this.states = states;
    }

    public void setDefaultState(State state) throws IOException, MediaException {
        this.defaultState = state;
    }

    private void stateTransition(byte id) {
        for (int i = 0; i < this.states.length; ++i) {
            if (this.states[i].type != id) continue;
            this.goalState = this.states[i];
            return;
        }
        this.goalState = null;
    }

    public void updateMachine(int time) throws IOException, MediaException {
        if (this.states.length == 0) {
            return;
        }
        if (this.currentState == null) {
            this.currentState = this.defaultState;
            this.currentState.enter();
        }
        if (this.currentState == null) {
            return;
        }
        if (this.currentState.isDone()) {
            this.goalID = this.currentState.nextState();
            if (this.goalID == -1) {
                this.done = true;
                return;
            }
            this.stateTransition(this.goalID);
            this.currentState.exit();
            this.currentState = this.goalState;
            this.currentState.enter();
        }
        this.currentState.update(time);
    }

    public void enter() throws IOException, MediaException {
        this.done = false;
        this.currentState = this.defaultState;
        this.currentState.enter();
        this.goalID = 0;
    }

    public void exit() throws MediaException {
        this.currentState.exit();
    }

    public void update(int time) throws IOException, MediaException {
        this.updateMachine(time);
    }

    public byte nextState() {
        return this.nextState;
    }

    public void render(Graphics g) {
        this.currentState.render(g);
    }

    public byte getCurrent() {
        return this.currentState.type;
    }
}

