/*
 * Decompiled with CFR 0.152.
 */
package com.apr.game.buttons;

import com.apr.game.Utils;
import com.apr.game.buttons.Action;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public abstract class Button
extends Utils
implements Action {
    public static final String DOUBLE_DOTS = ":";
    protected String text;
    protected int sx;
    protected int sy;
    private Sprite sprite;

    public Button(Image image, String text) {
        this.sprite = new Sprite(image, image.getWidth() / 2, image.getHeight());
        this.text = text;
    }

    public void updatePosition(int dx, int dy) {
        this.sprite.setPosition(this.sprite.getX() + dx, this.sprite.getY() + dy);
        this.sx += dx;
        this.sy += dy;
    }

    public void setPos(int x, int y) {
        this.sprite.setPosition(x, y);
        this.sx = x + HALF_W - (HALF_W - this.sprite.getWidth() / 2);
        this.sy = y;
    }

    public void render(Graphics g) {
        this.sprite.paint(g);
        font.print(g, this.sx, this.sy, this.text, (byte)0);
    }

    public void setText(String text) {
        this.text = text;
    }

    public void exit() {
        this.text = null;
    }

    public void setStringValue() {
    }

    public void fire() {
    }

    public int getWidth() {
        return this.sprite.getWidth();
    }

    public int getHeight() {
        return this.sprite.getHeight();
    }

    public void setFrame(int frame) {
        this.sprite.setFrame(frame);
    }

    public int getFrame() {
        return this.sprite.getFrame();
    }

    public int getX() {
        return this.sprite.getX();
    }

    public int getY() {
        return this.sprite.getY();
    }

    public int getSX() {
        return this.sprite.getX();
    }

    public int getSY() {
        return this.sprite.getY();
    }

    public abstract void loadValue();

    public abstract void saveValue();

    public abstract void left();

    public abstract void right();

    public abstract void setSetting();
}

