/*
 * Decompiled with CFR 0.152.
 */
package com.apr.game.font;

import com.apr.game.font.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class BitmapFont
implements Font {
    protected int w;
    protected int h;
    protected int spaceW;
    protected int spaceH;
    protected boolean upperCase;
    protected Image img;
    protected int offset;

    public BitmapFont(int w, int h, int spaceW, int spaceH, Image img, boolean upperCase) {
        this.w = w;
        this.h = h;
        this.spaceW = spaceW;
        this.spaceH = spaceH;
        this.img = img;
        this.upperCase = upperCase;
        this.offset = upperCase ? 64 : 32;
    }

    public void print(Graphics g, int x, int y, String text, byte centered) throws IllegalArgumentException {
        for (int i = 0; i < text.length(); ++i) {
            int val = text.charAt(i) - this.offset;
            int px = val % 16;
            int py = val / 16;
            g.drawRegion(this.img, px * this.w + this.spaceW, py * this.w + this.spaceW, this.w - this.spaceW, this.h - this.spaceH, 0, x + i * (this.w - this.spaceW), y, 20);
        }
    }

    public void print(Graphics g, int x, int y, char[] txtArr) throws IllegalArgumentException {
        for (int i = 0; i < txtArr.length; ++i) {
            int val = txtArr[i] - this.offset;
            int px = val % 16;
            int py = val / 16;
            g.drawRegion(this.img, px * this.w + this.spaceW, py * this.w + this.spaceW, this.w - this.spaceW, this.h - this.spaceH, 0, x + i * (this.w - this.spaceW), y, 20);
        }
    }

    public int getW() {
        return this.w - this.spaceW;
    }

    public int getH() {
        return this.h - this.spaceH;
    }
}

