/*
 * Decompiled with CFR 0.152.
 */
package com.apr.game.font;

import com.apr.game.font.Font;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class BitmapFontLinear
implements Font {
    private byte[] WIDTH;
    private int w;
    private int h;
    private int offset;
    private Image img;

    public BitmapFontLinear(int w, int h, Image img, String text, int offset) {
        this.w = w;
        this.h = h;
        this.offset = offset;
        this.img = img;
        InputStream is = this.getClass().getResourceAsStream(text);
        this.WIDTH = new byte[223];
        try {
            int chr;
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while ((chr = is.read()) != -1) {
                if (chr == 10) {
                    this.WIDTH[i] = (byte)Integer.parseInt(sb.toString());
                    sb.delete(0, sb.length());
                    ++i;
                    continue;
                }
                if (chr == 13) continue;
                sb.append((char)chr);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void print(Graphics g, int x, int y, String text, byte position) throws IllegalArgumentException {
        int val;
        int i;
        int px = x;
        int SIZE = 0;
        if (text == null) {
            return;
        }
        for (i = 0; i < text.length(); ++i) {
            val = text.charAt(i) - this.offset;
            System.out.println(val);
            SIZE += this.WIDTH[val];
        }
        switch (position) {
            case 0: {
                SIZE /= 2;
                break;
            }
            case 1: {
                SIZE = 0;
            }
        }
        for (i = 0; i < text.length(); ++i) {
            val = text.charAt(i) - this.offset;
            g.drawRegion(this.img, val * this.w, 0, this.WIDTH[val] + 2, this.h, 0, px - SIZE, y, 20);
            px += this.WIDTH[val];
        }
    }

    public int getW() {
        return this.w;
    }

    public int getH() {
        return this.h;
    }
}

