/*
 * Decompiled with CFR 0.152.
 */
package logic;

import com.apr.game.Utils;
import com.apr.game.animations.Animation;
import com.apr.game.animations.Composed;
import com.apr.game.animations.Point;
import com.apr.game.displayable.ActionButton;
import com.apr.game.displayable.Background;
import com.apr.game.sound.SoundClass;
import game.Locale;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.MediaException;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import logic.Board;
import logic.MovingText;
import logic.StaticText;
import logic.TTTConstants;
import logic.TTTRules;

public final class GameState
extends TTTConstants {
    public static final String RECORD = "save";
    public static final byte MAX_GAME_POINTS = 32;
    public static int START_X = 16;
    public static int START_Y = 57;
    public static int[] SQUARE_SIZES = new int[]{60, 44, 36};
    public static int[] BAR_SIZES = new int[]{10, 8, 5};
    public static int NUM_ANIMS = 10;
    public static int SQUARE_SIZE = 60;
    public static int BAR_SIZE = 10;
    public static byte currentMove;
    public static Point[] points;
    protected static byte WHO_STARTED_PREV_GAME;
    public static byte BOARD_TYPE;
    public static Board board;
    public static byte X_POINTS;
    public static byte O_POINTS;
    public static byte CURRENT_TIME;
    public static byte CURRENT_POINTS;
    public static byte WHO_WON;
    public static byte CURRENT_STATE;
    private static StringBuffer score;
    private static StringBuffer strGamePoints;
    private static StringBuffer strTotalGamePoints;
    private static StringBuffer strXPoints;
    private static StringBuffer strOPoints;
    protected static Image imgHor;
    protected static Image imgVer;
    protected static Image imgX;
    protected static Image imgO;
    protected static Image imgXSmall;
    protected static Image imgOSmall;
    protected static Image imgShadow;
    protected static Image imgRotation;
    public static Image imgBottomBar;
    public static Image[] imgXsCW;
    public static Image[] imgXsCC;
    public static Image[] imgOsCW;
    public static Image[] imgOsCC;
    public static ActionButton pauseButton;
    protected static Background background;
    public static SoundClass soundWin;
    public static SoundClass soundLoose;
    public static SoundClass soundTie;
    protected static Composed animation;
    protected static StaticText animGamePoints;
    protected static StaticText animTotalGamePoints;
    protected static MovingText movGamePointsIn;
    protected static MovingText movGamePointsOut;
    protected static MovingText movTotalGamePointsIn;
    protected static MovingText movTotalGamePointsOut;
    public static int COMPUTER_SCORE;

    public static void setBackground(Background background) {
        GameState.background = background;
    }

    public static void init() throws IOException, MediaException {
        CURRENT_STATE = 0;
        X_POINTS = 0;
        O_POINTS = 0;
        score = new StringBuffer();
        strGamePoints = new StringBuffer();
        strTotalGamePoints = new StringBuffer();
        strXPoints = new StringBuffer();
        strOPoints = new StringBuffer();
        GameState.setScore();
        if (PLAYER_PIECE == 0) {
            if (COMPUTER_OPONENT) {
                X_NAME = Locale.getString("Game.Player");
                O_NAME = Locale.getString("Game.Computer");
            } else {
                X_NAME = Locale.getString("Game.Player1");
                O_NAME = Locale.getString("Game.Player2");
            }
        } else if (COMPUTER_OPONENT) {
            X_NAME = Locale.getString("Game.Computer");
            O_NAME = Locale.getString("Game.Player");
        } else {
            X_NAME = Locale.getString("Game.Player1");
            O_NAME = Locale.getString("Game.Player2");
        }
        BOARD_TYPE = BOARD_SIZES[BOARD_SIZE];
        SQUARE_SIZE = SQUARE_SIZES[BOARD_SIZE];
        BAR_SIZE = BAR_SIZES[BOARD_SIZE];
        WHO_STARTED_PREV_GAME = (byte)-1;
        points = new Point[BOARD_TYPE * BOARD_TYPE];
        GameState.startGame();
        imgBottomBar = Image.createImage((String)"/images/bottom_bar.png");
        imgHor = Image.createImage((String)("/images/game/hor_" + BOARD_TYPE + ".png"));
        imgVer = Image.createImage((String)("/images/game/ver_" + BOARD_TYPE + ".png"));
        imgShadow = Image.createImage((String)"/images/button_shadow.png");
        pauseButton = new ActionButton(Locale.getString("PauseImage"), 1);
        pauseButton.enter();
        soundWin = new SoundClass("/sounds/win");
        soundLoose = new SoundClass("/sounds/loose");
        soundTie = new SoundClass("/sounds/tie");
        GameState.setScreenPositions();
        GameState.setTotalGamePoints();
        animGamePoints = new StaticText(Locale.getString("Tournament.GamePoints"), strGamePoints.toString(), new Point(Utils.HALF_W, 0), 5000);
        animTotalGamePoints = new StaticText(Locale.getString("Tournament.Goal"), strTotalGamePoints.toString(), new Point(Utils.HALF_W, 0), 5000);
        movGamePointsIn = new MovingText(Locale.getString("Tournament.GamePoints"), strGamePoints.toString(), new Point(Utils.HALF_W, -Utils.font.getH()), new Point(Utils.HALF_W, 0), 500);
        movGamePointsOut = new MovingText(Locale.getString("Tournament.GamePoints"), strGamePoints.toString(), new Point(Utils.HALF_W, 0), new Point(Utils.HALF_W, -Utils.font.getH() - Utils.fontSmall.getH()), 500);
        movTotalGamePointsIn = new MovingText(Locale.getString("Tournament.Goal"), strTotalGamePoints.toString(), new Point(Utils.HALF_W, -Utils.font.getH()), new Point(Utils.HALF_W, 0), 500);
        movTotalGamePointsOut = new MovingText(Locale.getString("Tournament.Goal"), strTotalGamePoints.toString(), new Point(Utils.HALF_W, 0), new Point(Utils.HALF_W, -Utils.font.getH() - Utils.fontSmall.getH()), 500);
        animation = new Composed(new Animation[]{movGamePointsIn, animGamePoints, movGamePointsOut, movTotalGamePointsIn, animTotalGamePoints, movTotalGamePointsOut}, true);
    }

    public static void startGame() throws IOException {
        GameState.createBoard();
        GameState.setPieces();
        WHO_WON = 0;
        CURRENT_POINTS = 1;
        COMPUTER_SCORE = 0;
        GameState.setGamePoints();
        GameState.setScreenPositions();
    }

    private static void setPieces() throws IOException {
        int n;
        imgX = null;
        imgO = null;
        imgXSmall = null;
        imgOSmall = null;
        if (imgXsCW != null) {
            for (n = NUM_ANIMS - 1; n >= 0; --n) {
                GameState.imgXsCW[GameState.NUM_ANIMS - 1 - n] = null;
                GameState.imgOsCW[GameState.NUM_ANIMS - 1 - n] = null;
                GameState.imgXsCC[GameState.NUM_ANIMS - 1 - n] = null;
                GameState.imgOsCC[GameState.NUM_ANIMS - 1 - n] = null;
            }
            imgXsCW = null;
            imgOsCW = null;
            imgXsCC = null;
            imgOsCC = null;
        }
        n = 0;
        int n2 = 0;
        if (X_COLOR == 0 && O_COLOR == 0) {
            n = Utils.nextInt(4) + 1;
            n2 = Utils.nextInt(4) + 1;
            while (n == n2) {
                n2 = Utils.nextInt(4) + 1;
            }
        } else if (X_COLOR == 0 && O_COLOR > 0) {
            n2 = O_COLOR;
            n = Utils.nextInt(4) + 1;
            while (n == n2) {
                n = (byte)(Utils.nextInt(4) + 1);
            }
        } else if (X_COLOR > 0 && O_COLOR == 0) {
            n = X_COLOR;
            n2 = (byte)(Utils.nextInt(4) + 1);
            while (n == n2) {
                n2 = (byte)(Utils.nextInt(4) + 1);
            }
        } else {
            n = X_COLOR;
            n2 = O_COLOR;
        }
        imgX = Image.createImage((String)("/images/game/x_" + COLORS_STRING[n - 1] + "_" + BOARD_TYPE + ".png"));
        imgO = Image.createImage((String)("/images/game/o_" + COLORS_STRING[n2 - 1] + "_" + BOARD_TYPE + ".png"));
        imgXSmall = Image.createImage((String)("/images/x_" + COLORS_STRING[n - 1] + "_small.png"));
        imgOSmall = Image.createImage((String)("/images/o_" + COLORS_STRING[n2 - 1] + "_small.png"));
        imgXsCW = new Image[NUM_ANIMS];
        imgOsCW = new Image[NUM_ANIMS];
        imgXsCC = new Image[NUM_ANIMS];
        imgOsCC = new Image[NUM_ANIMS];
        for (int i = NUM_ANIMS - 1; i >= 0; --i) {
            GameState.imgXsCW[GameState.NUM_ANIMS - 1 - i] = GameState.rotateImage(imgX, 360 - i * 10);
            GameState.imgOsCW[GameState.NUM_ANIMS - 1 - i] = GameState.rotateImage(imgO, 360 - i * 10);
            GameState.imgXsCC[GameState.NUM_ANIMS - 1 - i] = GameState.rotateImage(imgX, i * 10);
            GameState.imgOsCC[GameState.NUM_ANIMS - 1 - i] = GameState.rotateImage(imgO, i * 10);
        }
        System.gc();
    }

    public static void setScore() {
        if (strXPoints.length() > 0) {
            strXPoints.delete(0, strXPoints.length());
        }
        if (strOPoints.length() > 0) {
            strOPoints.delete(0, strOPoints.length());
        }
        strXPoints.append(String.valueOf(X_POINTS));
        strOPoints.append(String.valueOf(O_POINTS));
    }

    private static void setScreenPositions() {
        for (int i = 0; i < points.length; ++i) {
            GameState.points[i] = new Point(START_X + i % BOARD_TYPE * SQUARE_SIZE + BAR_SIZE * (i % BOARD_TYPE), START_Y + i / BOARD_TYPE * SQUARE_SIZE + BAR_SIZE * (i / BOARD_TYPE));
        }
    }

    public static void setGamePoints() {
        if (strGamePoints.length() > 0) {
            strGamePoints.delete(0, strGamePoints.length());
        }
        strGamePoints.append(String.valueOf(CURRENT_POINTS));
        if (animation == null) {
            return;
        }
        animGamePoints.setText(strGamePoints.toString());
        movGamePointsIn.setText(strGamePoints.toString());
        movGamePointsOut.setText(strGamePoints.toString());
    }

    public static void setTotalGamePoints() {
        if (strTotalGamePoints.length() > 0) {
            strGamePoints.delete(0, strTotalGamePoints.length());
        }
        strTotalGamePoints.append(String.valueOf(GAME_POINTS));
    }

    private static void createBoard() {
        switch (WHO_STARTS + 1) {
            case 1: {
                board = new Board(BOARD_SIZES[BOARD_SIZE], true);
                WHO_STARTED_PREV_GAME = 1;
                break;
            }
            case 2: {
                board = new Board(BOARD_SIZES[BOARD_SIZE], false);
                WHO_STARTED_PREV_GAME = (byte)2;
                break;
            }
            case 3: {
                if (WHO_STARTED_PREV_GAME == 2) {
                    board = new Board(BOARD_SIZES[BOARD_SIZE], true);
                    WHO_STARTED_PREV_GAME = 1;
                    break;
                }
                board = new Board(BOARD_SIZES[BOARD_SIZE], false);
                WHO_STARTED_PREV_GAME = (byte)2;
                break;
            }
            case 4: {
                if (Utils.nextInt(2) == 0) {
                    board = new Board(BOARD_SIZES[BOARD_SIZE], true);
                    WHO_STARTED_PREV_GAME = 1;
                    break;
                }
                board = new Board(BOARD_SIZES[BOARD_SIZE], false);
                WHO_STARTED_PREV_GAME = (byte)2;
            }
        }
    }

    public static void update(int n) {
        animation.update(n);
    }

    public static void exit() {
        score = null;
        strGamePoints = null;
        strTotalGamePoints = null;
        strXPoints = null;
        strOPoints = null;
        imgHor = null;
        imgVer = null;
        imgX = null;
        imgO = null;
        imgXSmall = null;
        imgOSmall = null;
        imgBottomBar = null;
        imgShadow = null;
        pauseButton.exit();
        animation = null;
        animGamePoints = null;
        animTotalGamePoints = null;
        movGamePointsIn = null;
        movGamePointsOut = null;
        movTotalGamePointsIn = null;
        movTotalGamePointsOut = null;
        for (int i = NUM_ANIMS - 1; i >= 0; --i) {
            GameState.imgXsCW[GameState.NUM_ANIMS - 1 - i] = null;
            GameState.imgOsCW[GameState.NUM_ANIMS - 1 - i] = null;
            GameState.imgXsCC[GameState.NUM_ANIMS - 1 - i] = null;
            GameState.imgOsCC[GameState.NUM_ANIMS - 1 - i] = null;
        }
        imgXsCW = null;
        imgOsCW = null;
        imgXsCC = null;
        imgOsCC = null;
        soundWin.stop();
        soundLoose.stop();
        soundTie.stop();
    }

    public static void render(Graphics graphics) {
        if (background != null) {
            background.render(graphics);
        }
        if (board != null) {
            GameState.drawBoard(graphics);
        }
        graphics.drawImage(imgBottomBar, 0, H, 36);
        pauseButton.render(graphics);
        if (board.getTurn()) {
            graphics.drawImage(imgShadow, font.getW() - 10, 0, 0);
        } else {
            graphics.drawImage(imgShadow, W - font.getW() - imgOSmall.getWidth() - 10, 0, 0);
        }
        fontSmall.print(graphics, 0, 0, X_NAME, (byte)1);
        fontSmall.print(graphics, W, 0, O_NAME, (byte)2);
        graphics.drawImage(imgXSmall, font.getW(), fontSmall.getH(), 0);
        graphics.drawImage(imgOSmall, W - font.getW() - imgOSmall.getWidth(), fontSmall.getH(), 0);
        if (TOURNAMENT && score != null) {
            font.print(graphics, 0, fontSmall.getH(), strXPoints.toString(), (byte)1);
            font.print(graphics, W, fontSmall.getH(), strOPoints.toString(), (byte)2);
            animation.render(graphics);
        }
    }

    private static void drawBoard(Graphics graphics) {
        int n;
        for (n = 1; n < BOARD_TYPE; ++n) {
            graphics.drawImage(imgVer, GameState.points[n].x - BAR_SIZE, GameState.points[n].y, 0);
            graphics.drawImage(imgHor, START_X, GameState.points[n * GameState.BOARD_TYPE].y - BAR_SIZE, 0);
        }
        block5: for (n = 0; n < points.length; ++n) {
            switch (board.get(n)) {
                case 1: {
                    graphics.drawImage(imgX, GameState.points[n].x, GameState.points[n].y, 0);
                    continue block5;
                }
                case 2: {
                    graphics.drawImage(imgO, GameState.points[n].x, GameState.points[n].y, 0);
                }
            }
        }
    }

    public static Point getPosition(byte by) {
        return points[by];
    }

    public static boolean isValidMove(byte by) {
        return board.get(by) == 0;
    }

    public static void makeMove() {
        board.makeMove(currentMove);
    }

    public static byte isFinish() {
        if (FINISH_CRITERIA == 0) {
            return TTTRules.IS_FINISH(board, BOARD_TYPE, BOARD_TYPE);
        }
        switch (BOARD_TYPE) {
            case 3: {
                return TTTRules.IS_FINISH(board, BOARD_TYPE, 3);
            }
            case 4: {
                return TTTRules.IS_FINISH(board, BOARD_TYPE, 4);
            }
            case 5: {
                return TTTRules.IS_FINISH(board, BOARD_TYPE, 4);
            }
        }
        return TTTRules.IS_FINISH(board, BOARD_TYPE, BOARD_TYPE);
    }

    public static Vector getMoves() {
        return TTTRules.GET_MOVES(board);
    }

    public static void giveGamePoints(byte by) {
        if (by == -1) {
            return;
        }
        if (by == 1) {
            X_POINTS = (byte)(X_POINTS + CURRENT_POINTS);
        } else {
            O_POINTS = (byte)(O_POINTS + CURRENT_POINTS);
        }
        GameState.setScore();
    }

    public static boolean isTournamentWon() {
        if (X_POINTS >= GAME_POINTS) {
            return true;
        }
        return O_POINTS >= GAME_POINTS;
    }

    public static void undo(Board board) {
        GameState.board.copy(board);
    }

    public static Point getPoint(int n) {
        return points[n];
    }

    public static void fallPoints(int n) {
        for (int i = 0; i < points.length; ++i) {
            GameState.points[i].y += n;
        }
    }

    public static boolean isTurnX() {
        return board.getTurn();
    }

    public static boolean PLAYER_USES_X() {
        return PLAYER_PIECE == 0;
    }

    public static boolean IS_EMPTY_BOARD() {
        for (int i = 0; i < board.size(); ++i) {
            if (board.get(i) == 0) continue;
            return false;
        }
        return true;
    }

    public static int GET_EMPTY_POSITIONS() {
        int n = 0;
        for (int i = 0; i < board.size(); ++i) {
            if (board.get(i) != 0) continue;
            ++n;
        }
        return n;
    }

    public static byte GET_INDEX_BOARD(int n, int n2) {
        for (byte by = 0; by < points.length; by = (byte)(by + 1)) {
            if (!GameState.inBounds(n, n2, GameState.points[by].x, GameState.points[by].y, SQUARE_SIZE, SQUARE_SIZE)) continue;
            return by;
        }
        return -1;
    }

    public static boolean isLoaded() {
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)RECORD, (boolean)false);
            RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, false);
            if (recordEnumeration.numRecords() == 0) {
                recordEnumeration.destroy();
                recordStore.closeRecordStore();
                return false;
            }
            recordEnumeration.destroy();
            recordStore.closeRecordStore();
            return true;
        }
        catch (RecordStoreException recordStoreException) {
            return false;
        }
    }

    public static void deleteSettings() {
        try {
            RecordStore.deleteRecordStore((String)RECORD);
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    static {
        WHO_STARTED_PREV_GAME = (byte)-1;
    }
}

