/*
 * Decompiled with CFR 0.152.
 */
package states.play;

import com.apr.game.Game;
import com.apr.game.animations.Animation;
import com.apr.game.animations.Point;
import javax.microedition.lcdui.Graphics;
import net.jscience.math.kvm.MathFP;

public final class MovingText
extends Animation {
    private Point start;
    private int xFP;
    private int yFP;
    private Point destination;
    private int dxFP;
    private int dyFP;
    private int curTime;
    private int maxTime;
    private String line1;
    private String line2;

    public MovingText(String string, String string2, Point point, Point point2, int n) {
        this.line1 = string;
        this.line2 = string2;
        this.start = point;
        this.destination = point2;
        this.maxTime = n + 2 * Game.frameRate;
        this.enter();
    }

    public void enter() {
        this.xFP = MathFP.toFP(this.start.x);
        this.yFP = MathFP.toFP(this.start.y);
        this.dxFP = MathFP.div(MathFP.mul(MathFP.toFP(this.destination.x - this.start.x), MathFP.toFP(Game.frameRate)), MathFP.toFP(this.maxTime));
        this.dyFP = MathFP.div(MathFP.mul(MathFP.toFP(this.destination.y - this.start.y), MathFP.toFP(Game.frameRate)), MathFP.toFP(this.maxTime));
        this.done = false;
        this.curTime = 0;
    }

    public void update(int n) {
        this.curTime += n;
        if (this.curTime >= this.maxTime) {
            this.done = true;
            return;
        }
        this.xFP = MathFP.add(this.xFP, this.dxFP);
        this.yFP = MathFP.add(this.yFP, this.dyFP);
    }

    public void render(Graphics graphics) {
        fontSmall.print(graphics, MathFP.toInt(this.xFP), MathFP.toInt(this.yFP), this.line1, (byte)0);
        font.print(graphics, MathFP.toInt(this.xFP), MathFP.toInt(this.yFP) + fontSmall.getH(), this.line2, (byte)0);
    }

    public void setText(String string) {
        this.line2 = string;
    }
}

