/*
 * Decompiled with CFR 0.152.
 */
package states.play;

import com.apr.game.Utils;
import com.apr.game.displayable.ProgressBar;
import com.apr.game.states.State;
import game.Locale;
import game.TTTGame;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.media.MediaException;
import logic.Board;
import logic.GameState;
import logic.TTTRules;

public class StateComputer
extends State
implements Runnable {
    private static final int ONE_TO_FINISH = 10;
    private static final int TWO_TO_FINISH = 5;
    private static final int THREE_TO_FINISH = 2;
    private static final int MAX_STATES = 10000;
    private byte nextState;
    private byte piece;
    private static final int MAX_TIME = 5000;
    private int maxDepth;
    private int curTime;
    private Thread thread;
    private ProgressBar bar;
    private boolean showBar;
    private int board_size;
    private int win_size;
    private String strThinking;

    public StateComputer(byte by, byte by2, byte by3) {
        super(by);
        this.nextState = by2;
        this.piece = by3;
        this.bar = new ProgressBar(State.W - 50, 5, 50, 10, 5000 / TTTGame.frameRate);
        this.board_size = GameState.BOARD_TYPE;
        if (GameState.FINISH_CRITERIA == 0) {
            this.win_size = this.board_size;
        } else if (this.board_size == 4) {
            this.win_size = 4;
        } else if (this.board_size == 5) {
            this.win_size = 4;
        }
        this.strThinking = Locale.getString("Game.Thinking");
    }

    public void enter() throws IOException, MediaException {
        this.done = false;
        this.showBar = false;
        this.bar.enter();
        this.curTime = 0;
        if (GameState.COMPUTER_LEVEL == 0 || StateComputer.nextInt(10) == 0) {
            Vector vector = TTTRules.GET_MOVES(GameState.board);
            Byte by = (Byte)vector.elementAt(Utils.nextInt(vector.size()));
            GameState.currentMove = by;
            vector.removeAllElements();
            this.done = true;
            return;
        }
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void exit() throws MediaException {
    }

    public byte nextState() {
        return this.nextState;
    }

    public void update(int n) {
        this.curTime += n;
        this.bar.increase();
    }

    public void render(Graphics graphics) {
        GameState.render(graphics);
        font.print(graphics, HALF_W, HALF_H, this.strThinking, (byte)0);
        if (this.showBar) {
            this.bar.render(graphics);
        }
    }

    public void run() {
        int n = GameState.GET_EMPTY_POSITIONS();
        this.maxDepth = 1;
        int n2 = 1;
        while (n > 0 && n2 < 10000) {
            n2 *= n;
            ++this.maxDepth;
            --n;
        }
        if (GameState.COMPUTER_LEVEL == 1) {
            this.maxDepth /= 2;
        }
        Byte by = null;
        int n3 = Integer.MIN_VALUE;
        Vector vector = TTTRules.GET_MOVES(GameState.board);
        if (vector.size() == 1) {
            this.showBar = false;
            by = (Byte)vector.elementAt(0);
        } else {
            for (int i = 0; i < vector.size(); ++i) {
                Byte by2 = (Byte)vector.elementAt(i);
                Board board = new Board(GameState.board);
                board.makeMove(by2.byteValue());
                int n4 = this.min_move(board, 1, n3, Integer.MAX_VALUE);
                if (n4 <= n3) continue;
                n3 = n4;
                by = by2;
            }
        }
        vector.removeAllElements();
        vector = null;
        GameState.currentMove = by;
        this.done = true;
    }

    private int min_move(Board board, int n, int n2, int n3) {
        if (this.cutOffTest(board, n)) {
            return this.eval(board);
        }
        Vector vector = TTTRules.GET_MOVES(board);
        if (vector.isEmpty()) {
            return this.eval(board);
        }
        for (int i = 0; i < vector.size(); ++i) {
            Byte by = (Byte)vector.elementAt(i);
            Board board2 = new Board(board);
            board2.makeMove(by.byteValue());
            int n4 = this.max_move(board2, n + 1, n2, n3);
            if (n4 < n3) {
                n3 = n4;
            }
            if (n3 >= n2) continue;
            return n2;
        }
        vector.removeAllElements();
        return n3;
    }

    private int max_move(Board board, int n, int n2, int n3) {
        if (this.cutOffTest(board, n)) {
            return this.eval(board);
        }
        Vector vector = TTTRules.GET_MOVES(board);
        if (vector.isEmpty()) {
            return this.eval(board);
        }
        for (int i = 0; i < vector.size(); ++i) {
            Byte by = (Byte)vector.elementAt(i);
            Board board2 = new Board(board);
            board2.makeMove(by.byteValue());
            int n4 = this.min_move(board2, n + 1, n2, n3);
            if (n4 > n2) {
                n2 = n4;
            }
            if (n2 <= n3) continue;
            return n3;
        }
        vector.removeAllElements();
        return n2;
    }

    private boolean cutOffTest(Board board, int n) {
        return TTTRules.IS_FINISH(board, this.board_size, this.win_size) != 0 || n > this.maxDepth || Runtime.getRuntime().freeMemory() < 10000L || this.curTime >= 5000;
    }

    public int eval(Board board) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        byte by = this.piece == 1 ? (byte)2 : 1;
        byte[][] byArray = TTTRules.GET_COMBINATIONS(this.board_size, this.win_size);
        for (int i = 0; i < byArray.length; ++i) {
            n2 = 0;
            n3 = 0;
            n4 = 0;
            for (int j = 0; j < byArray[i].length; ++j) {
                if (board.get(byArray[i][j]) == this.piece) {
                    n2 = (byte)(n2 + 1);
                    continue;
                }
                if (board.get(byArray[i][j]) == by) {
                    n3 = (byte)(n3 + 1);
                    continue;
                }
                n4 = (byte)(n4 + 1);
            }
            if (n2 == this.win_size) {
                return 100;
            }
            if (n3 == this.win_size) {
                return -100;
            }
            if (n2 + 1 == this.win_size && n3 == 0) {
                n += 10;
            }
            if (n3 + 1 == this.win_size && n2 == 0) {
                n -= 10;
            }
            if (n2 + 2 == this.win_size && n3 == 0) {
                n += 5;
            }
            if (n3 + 2 == this.win_size && n2 == 0) {
                n -= 5;
            }
            if (n2 + 3 == this.win_size && n3 == 0) {
                n += 2;
            }
            if (n3 + 1 != this.win_size || n2 != 0) continue;
            n -= 2;
        }
        return n;
    }
}

