/*
 * Decompiled with CFR 0.152.
 */
package states.play;

import com.apr.game.states.State;
import game.Locale;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.MediaException;
import logic.Board;
import logic.GameState;
import logic.SaveSettings;
import states.play.DropDownMenu;

public class StatePlayer
extends State {
    private static final int MAX_TIME_SELECTON = 500;
    private static byte size_board;
    private static byte max_size;
    private SaveSettings saveSettings;
    private Thread thread;
    private byte nextState;
    private byte moveState;
    private byte endState;
    private Image imgSelection;
    private Image imgSelectionA;
    private byte selected;
    private int sx;
    private int sy;
    private int curTime;
    private int curTimeSeconds;
    private int maxTime;
    private StringBuffer strCurTime;
    private boolean pause;
    private DropDownMenu menu;
    private Board oldBoard;
    private boolean canUndo;
    private boolean canRestart;
    private byte piece;
    private byte state_index;
    private String strMove;
    private int curTimeSelection;
    private boolean showSelection;

    public StatePlayer(byte by, byte by2, byte by3, byte by4, byte by5, Image image, Image image2) throws IOException {
        super(by);
        max_size = (byte)GameState.board.size();
        size_board = GameState.BOARD_SIZES[GameState.BOARD_SIZE];
        this.moveState = by2;
        this.endState = by4;
        this.piece = by3;
        this.oldBoard = new Board(GameState.BOARD_TYPE, false);
        this.saveSettings = new SaveSettings();
        this.state_index = by5;
        this.imgSelection = image;
        this.imgSelectionA = image2;
        this.strCurTime = new StringBuffer();
        String[] stringArray = new String[]{Locale.getString("Menu.Continue"), Locale.getString("Menu.Undo"), Locale.getString("Menu.Restart"), Locale.getString("Menu.Exit"), Locale.getString("Menu.SaveExit")};
        this.menu = new DropDownMenu(stringArray);
        this.strMove = Locale.getString("Game.Move");
    }

    public void enter() throws IOException, MediaException {
        this.selected = 0;
        this.done = false;
        this.pause = false;
        this.showSelection = true;
        this.curTimeSelection = 0;
        GameState.CURRENT_STATE = this.state_index;
        if (GameState.TURN_TIME > 0) {
            this.maxTime = GameState.TIMES[GameState.TURN_TIME - 1] * 1000;
        }
        this.curTime = 0;
        this.setSelection();
        this.canUndo = true;
        this.canRestart = true;
        if (GameState.IS_EMPTY_BOARD()) {
            this.canUndo = false;
            this.canRestart = false;
        }
    }

    public void exit() throws MediaException {
    }

    public byte nextState() {
        return this.nextState;
    }

    public void update(int n) throws IOException, MediaException {
        super.update(n);
        if (this.pause) {
            this.menu.update();
            if (this.menu.isDone()) {
                this.pause = false;
                this.getAction(this.menu.getSelected());
            }
            return;
        }
        this.curTimeSelection += n;
        if (this.curTimeSelection > 500) {
            this.curTimeSelection = 0;
            this.showSelection = !this.showSelection;
        }
        GameState.update(n);
        if (GameState.TURN_TIME == 0) {
            return;
        }
        this.curTime += n;
        this.curTimeSeconds = (this.maxTime - this.curTime) / 1000;
        if (this.strCurTime.length() > 0) {
            this.strCurTime.delete(0, this.strCurTime.length());
        }
        this.strCurTime.append(this.curTimeSeconds);
        if (this.curTimeSeconds >= 8 || this.curTimeSeconds % 3 == 0) {
            // empty if block
        }
        if (this.curTime > this.maxTime) {
            this.nextState = this.endState;
            GameState.WHO_WON = this.piece == 1 ? (byte)2 : (byte)1;
            this.done = true;
        }
    }

    public void moveLeft() {
        if (this.pause) {
            return;
        }
        this.selected = (byte)(this.selected - 1);
        if ((this.selected + 1) % size_board == 0) {
            this.selected = (byte)(this.selected + size_board);
        }
        this.setSelection();
    }

    public void moveRight() {
        if (this.pause) {
            return;
        }
        this.selected = (byte)(this.selected + 1);
        if (this.selected % size_board == 0) {
            this.selected = (byte)(this.selected - size_board);
        }
        this.setSelection();
    }

    public void moveUp() {
        if (this.pause) {
            this.menu.up();
            return;
        }
        this.selected = (byte)(this.selected - size_board);
        if (this.selected < 0) {
            this.selected = (byte)(max_size + this.selected);
        }
        this.setSelection();
    }

    public void moveDown() {
        if (this.pause) {
            this.menu.down();
            return;
        }
        this.selected = (byte)(this.selected + size_board);
        if (this.selected >= max_size) {
            this.selected = (byte)(this.selected - max_size);
        }
        this.setSelection();
    }

    public void fire() {
        if (this.pause) {
            this.menu.startEnding();
            return;
        }
        this.oldBoard.copy(GameState.board);
        if (GameState.isValidMove(this.selected)) {
            this.nextState = this.moveState;
            GameState.currentMove = this.selected;
            this.done = true;
        }
    }

    public void moveLeftAction() {
    }

    public void moveRightAction() {
        if (this.pause) {
            this.menu.startEnding();
            return;
        }
        this.menu.init();
        if (!this.canUndo) {
            this.menu.setNotAvailable(1);
        }
        if (!this.canRestart) {
            this.menu.setNotAvailable(2);
        }
        this.pause = true;
    }

    public void checkClick(int n, int n2) {
        if (this.pause && this.menu.checkClick(n, n2)) {
            this.menu.startEnding();
            return;
        }
        byte by = GameState.GET_INDEX_BOARD(n, n2);
        if (by != -1) {
            this.selected = by;
            this.fire();
            return;
        }
        if (StatePlayer.inBounds(n, n2, GameState.pauseButton.getX(), GameState.pauseButton.getY(), GameState.pauseButton.getW(), GameState.pauseButton.getH())) {
            this.moveRightAction();
        }
    }

    private void setSelection() {
        this.sx = GameState.getPosition((byte)this.selected).x;
        this.sy = GameState.getPosition((byte)this.selected).y;
    }

    public void render(Graphics graphics) {
        GameState.render(graphics);
        if (this.pause) {
            this.menu.render(graphics);
            return;
        }
        if (GameState.TURN_TIME > 0) {
            font.print(graphics, HALF_W - font.getW(), GameState.START_Y - font.getH() + 5, this.strCurTime.toString(), (byte)1);
            font.print(graphics, HALF_W, GameState.START_Y - font.getH() + 5, ":", (byte)1);
            font.print(graphics, HALF_W + font.getW() / 2, GameState.START_Y - font.getH() + 5, Locale.getString("Tournament.Time"), (byte)1);
        }
        if (this.piece == 1) {
            boolean bl = true;
        } else {
            boolean bl = false;
        }
        font.print(graphics, HALF_W, H - GameState.imgBottomBar.getHeight() - font.getH() - 10, this.strMove, (byte)0);
        if (this.showSelection) {
            graphics.drawImage(this.imgSelection, this.sx, this.sy, 0);
        } else {
            graphics.drawImage(this.imgSelectionA, this.sx, this.sy, 0);
        }
    }

    private void getAction(byte by) throws IOException {
        switch (by) {
            case 0: {
                break;
            }
            case 1: {
                if (this.oldBoard != null) {
                    GameState.undo(this.oldBoard);
                }
                this.canUndo = false;
                break;
            }
            case 2: {
                GameState.startGame();
                this.canRestart = false;
                this.canUndo = false;
                break;
            }
            case 3: {
                GameState.deleteSettings();
                this.nextState = (byte)-1;
                this.done = true;
                break;
            }
            case 4: {
                this.thread = new Thread(this.saveSettings);
                this.thread.start();
                this.nextState = (byte)-1;
                this.done = true;
            }
        }
    }
}

